
#include "pss_subproc_connect_wifi.h"


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


//--------------------------------------------------------------------------------------------
/**
* @brief   RXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcConnectWifi::PssSubProcConnectWifi( void ) : PssSubProcBase()
{
}


//--------------------------------------------------------------------------------------------
/**
* @brief   
*
* @param   isWifiConnecting      WifiڑԂȂtrueAڑԂȂfalsew
* @param   gameProgMgr           GameProcManagerւ̃|C^
* @param   iconMgr               PlayerIconManagerւ̃|C^
* @param   msgData               bZ[Wf[^
* @param   wordset               [hZbg
* @param   paramWork             Procp[^p̈
*
* @return  PssSubProcBaseւ̃|C^
*/
//--------------------------------------------------------------------------------------------
PssSubProcBase* PssSubProcConnectWifi::Init( bool isWifiConnecting,
                      gamesystem::GameProcManager *gameProgMgr,
                      xy_system::player_icon::PlayerIconManager* iconMgr,
                      gfl::str::MsgData* msgData, WordSet* wordset, void* paramWork )
{
  InitBase( gameProgMgr, NULL, paramWork );

  m_playerIconMgr = iconMgr;
  m_msgData       = msgData;
  m_wordset       = wordset;

  InitWifiStarting( isWifiConnecting );

  return this;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   XV
*
* @param   none
*
* @return  ANZXR[h
*/
//--------------------------------------------------------------------------------------------
field::subscreen::pss::E_PSS_PROC_RESULT PssSubProcConnectWifi::Update( void )
{
  if( !UpdateSubProc() )
  {
    if( E_WIFI_CON_SEQ_ASK == m_seq )
    {
      app::pss::pss_yesno_dialog::APP_PARAM *param = reinterpret_cast<app::pss::pss_yesno_dialog::APP_PARAM*>(m_paramWork);
      if( param->m_isSelectYes )
      {
        if( m_isWifiConnecting ){
          return RET_WIFI_CONNECTION_DISCONNECT;
        }
        else{
          InitWifiConnecting();
        }
      }
      else{
        return RET_WIFI_CONNECTION_CANCEL;
      }
    }
    else if( E_WIFI_CON_SEQ_CONNECTING == m_seq )
    {
      InitWifiFinishing();
    }
    else
    {
      return RET_WIFI_CONNECTION_CONNECT;
    }
  }

  return RET_NONE;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   WIFIڑJnʂ̏
*
 @param   isWifiConnecting WifiڑԂȂtrueAڑԂȂfalsew
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
void PssSubProcConnectWifi::InitWifiStarting( bool isWifiConnecting )
{
  app::pss::pss_yesno_dialog::APP_PARAM *param = reinterpret_cast<app::pss::pss_yesno_dialog::APP_PARAM*>(m_paramWork);
  param->m_layout       = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData  = m_msgData;
  param->m_wordset      = m_wordset;

  if( !isWifiConnecting )
  {
    param->m_messageId = msg_pss_50_01_02;  // C^[lbgɐڑ܂H
    m_isWifiConnecting = false;
  }
  else
  {
    param->m_messageId = msg_pss_50_01_03;  // C^[lbgؒf܂H
    m_isWifiConnecting = true;
  }

  m_subProc = dll::CreatePssYesNoDialog( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );

  m_seq = E_WIFI_CON_SEQ_ASK;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   WIFIڑʂ̏
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcConnectWifi::InitWifiConnecting( void )
{
  app::pss::pss_message_window::APP_PARAM *param = reinterpret_cast<app::pss::pss_message_window::APP_PARAM*>(m_paramWork);

  param->m_layout        = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData   = m_msgData;
  param->m_wordset       = m_wordset;
  param->m_type          = app::pss::pss_message_window::E_TYPE_MESSAGE;
  param->m_messageText   = msg_pss_50_01_01;  // C^[lbgɐڑ
  param->m_playerIconMgr = m_playerIconMgr;
  param->m_isDispLoading = true;
  param->m_inputLock     = false;

  m_subProc = dll::CreatePssMessageWindow( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );

  m_seq = E_WIFI_CON_SEQ_CONNECTING;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   WIFIڑʒmʂ̏
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcConnectWifi::InitWifiFinishing( void )
{
  app::pss::pss_message_window::APP_PARAM *param = reinterpret_cast<app::pss::pss_message_window::APP_PARAM*>(m_paramWork);

  param->m_layout        = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData   = m_msgData;
  param->m_wordset       = m_wordset;
  param->m_type          = app::pss::pss_message_window::E_TYPE_MESSAGE;
  param->m_messageText   = msg_pss_50_01_04;  // C^[lbgɐڑ܂
  param->m_playerIconMgr = m_playerIconMgr;
  param->m_isDispLoading = false;
  param->m_inputLock     = false;

  m_subProc = dll::CreatePssMessageWindow( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );

  m_seq = E_WIFI_CON_SEQ_FINISH;
}





}		// subproc
}		// pss
}		// subscreen
}		// field

