
#include "pss_subproc_charamenu.h"


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


//--------------------------------------------------------------------------------------------
/**
* @brief   RXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcCharaMenu::PssSubProcCharaMenu( void ) : PssSubProcBase()
{

}


//--------------------------------------------------------------------------------------------
/**
* @brief   
*
* @param   gameProgMgr GameProcManagerւ̃|C^
* @param   texSystem   LytTexReplaceSystemւ̃|C^
* @param   friendKey   \Ώۃ[U[̃thL[
* @param   iconMgr     PlayerIconManagerւ̃|C^
* @param   paramWork   Procp[^p̈
*
* @return  PssSubProcBaseւ̃|C^
*/
//--------------------------------------------------------------------------------------------
PssSubProcBase* PssSubProcCharaMenu::Init( gamesystem::GameProcManager *gameProgMgr, app::tool::LytTexReplaceSystem* texSystem,
                          gflnet::friends::FriendKey& friendKey, xy_system::player_icon::PlayerIconManager* iconMgr, void* paramWork )
{
  InitBase( gameProgMgr, NULL, paramWork );

  app::pss::pss_charamenu::APP_PARAM *param = static_cast<app::pss::pss_charamenu::APP_PARAM*>(m_paramWork);

  param->m_layout        = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_textureSystem = texSystem;
  param->m_messageData   = NULL;
  param->m_wordset       = NULL;
  param->m_targetPlayer  = friendKey;
  param->m_playerIconMgr = iconMgr;

  m_subProc = dll::CreatePssCharaMenuProc( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );

  return this;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   XV
*
* @param   none
*
* @return  ANZXR[h
*/
//--------------------------------------------------------------------------------------------
field::subscreen::pss::E_PSS_PROC_RESULT PssSubProcCharaMenu::Update( void )
{
  if( !UpdateSubProc() )
  {
    app::pss::pss_charamenu::APP_PARAM *param = static_cast<app::pss::pss_charamenu::APP_PARAM*>(m_paramWork);

    switch( param->m_resultCode )
    {
      case  app::pss::pss_charamenu::E_RET_CANCEL:
        return RET_CHAR_INFO_CANCEL;

      case  app::pss::pss_charamenu::E_RET_PROFILE:
        return RET_CHAR_INFO_PROFILE;

      case  app::pss::pss_charamenu::E_RET_BATTLE:
        return RET_CHAR_INFO_BATTLE;

      case  app::pss::pss_charamenu::E_RET_TRADE:
        return RET_CHAR_INFO_TRADE;
    }
  }

  return RET_NONE;
}






}		// subproc
}		// pss
}		// subscreen
}		// field

