#ifndef __PSS_SUBPROC_BATTLE_RECEIVE_H__
#define __PSS_SUBPROC_BATTLE_RECEIVE_H__


#include "pss_subproc_base.h"


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


class PssSubProcBattleReceive : public PssSubProcBase
{
public:
  //--------------------------------------------------------------------------------------------
  /**
  * @brief   RXgN^
  *
  * @param   none
  *
  * @return  none
  */
  //--------------------------------------------------------------------------------------------
  PssSubProcBattleReceive( void );

public:
  //--------------------------------------------------------------------------------------------
  /**
  * @brief   
  *
  * @param   gameProgMgr     GameProcManagerւ̃|C^
  * @param   beaconResponder PssBeaconResponderւ̃|C^
  * @param   iconMgr         PlayerIconManagerւ̃|C^
  * @param   msgData         bZ[Wf[^
  * @param   wordset         [hZbg
  * @param   paramWork       Procp[^p̈
  *
  * @return  PssSubProcBaseւ̃|C^
  */
  //--------------------------------------------------------------------------------------------
  PssSubProcBase* Init( gamesystem::GameProcManager *gameProgMgr,
                        netapp::pss::PssBeaconResponder* beaconResponder,
                        xy_system::player_icon::PlayerIconManager* iconMgr,
                        const gflnet::friends::FriendKey& friendKey,
                        gfl::str::MsgData* msgData, WordSet* wordset, void* paramWork );

  //--------------------------------------------------------------------------------------------
  /**
  * @brief   XV
  *
  * @param   none
  *
  * @return  sʃR[h
  */
  //--------------------------------------------------------------------------------------------
  virtual field::subscreen::pss::E_PSS_PROC_RESULT Update( void );

private:
  // ΐ󂯓ʃCV[PX
  typedef enum {
    BATTLE_RECIVE_MAINSEQ_CATCH = 0,
    BATTLE_RECIVE_MAINSEQ_CHECK_RULE,
    BATTLE_RECIVE_MAINSEQ_SAVE,
    BATTLE_RECIVE_MAINSEQ_MATCHING,
    BATTLE_RECIVE_MAINSEQ_STAND,
    BATTLE_RECIVE_MAINSEQ_CANCEL_ACTION,
    BATTLE_RECIVE_MAINSEQ_CANCEL,
    BATTLE_RECIVE_MAINSEQ_COLOSSEUM_BATTLE,
  }E_BATTLE_RECIVE_SEQUENCE;

private:

  E_BATTLE_RECIVE_SEQUENCE  MainSeq_BattleReceiveCatch(void);
  E_BATTLE_RECIVE_SEQUENCE  MainSeq_BattleReceiveCheckRule(void);
  E_BATTLE_RECIVE_SEQUENCE  MainSeq_BattleReceiveSave(void);
  E_BATTLE_RECIVE_SEQUENCE  MainSeq_BattleReceiveMatching(void);
  E_BATTLE_RECIVE_SEQUENCE  MainSeq_BattleReceiveStand(void);
  E_BATTLE_RECIVE_SEQUENCE  MainSeq_BattleReceiveCancelAction(void);
  bool InitBattleReceiveCatch(void);
  bool InitBattleReceiveCheckRule(void);
  void InitBattleReceiveSave(void);
  void InitBattleReceiveStand(void);
  void InitBattleReceiveCancelAction(void);

private:
  E_BATTLE_RECIVE_SEQUENCE                   m_seq;               // V[PX
  xy_system::player_icon::PlayerIconManager* m_playerIconMgr;     // vC[ACR}l[W
  gfl::str::MsgData*                         m_msgData;           //
  WordSet*                                   m_wordset;           //
  gflnet::friends::FriendKey                 m_InvitePlayer;      // ogҎ
};




}		// subproc
}		// pss
}		// subscreen
}		// field


#endif

