
#include "pss_subproc_battle_receive.h"


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


//--------------------------------------------------------------------------------------------
/**
* @brief   RXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcBattleReceive::PssSubProcBattleReceive( void ) : PssSubProcBase()
{
}


//--------------------------------------------------------------------------------------------
/**
* @brief   
*
* @param   gameProgMgr     GameProcManagerւ̃|C^
* @param   beaconResponder PssBeaconResponderւ̃|C^
* @param   iconMgr         PlayerIconManagerւ̃|C^
* @param   friendKey       ΐ\҂̃thL[
* @param   msgData         bZ[Wf[^
* @param   wordset         [hZbg
* @param   paramWork       Procp[^p̈
*
* @return  PssSubProcBaseւ̃|C^
*/
//--------------------------------------------------------------------------------------------
PssSubProcBase* PssSubProcBattleReceive::Init(
                      gamesystem::GameProcManager *gameProgMgr,
                      netapp::pss::PssBeaconResponder* beaconResponder,
                      xy_system::player_icon::PlayerIconManager* iconMgr,
                      const gflnet::friends::FriendKey& friendKey,
                      gfl::str::MsgData* msgData, WordSet* wordset, void* paramWork )
{
  InitBase( gameProgMgr, beaconResponder, paramWork );

  m_InvitePlayer  = friendKey;
  m_playerIconMgr = iconMgr;
  m_msgData       = msgData;
  m_wordset       = wordset;
  m_seq           = BATTLE_RECIVE_MAINSEQ_CATCH;

  InitBattleReceiveCatch();

  return this;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   XV
*
* @param   none
*
* @return  ANZXR[h
*/
//--------------------------------------------------------------------------------------------
field::subscreen::pss::E_PSS_PROC_RESULT PssSubProcBattleReceive::Update( void )
{
  switch( m_seq )
  {
    case BATTLE_RECIVE_MAINSEQ_CATCH:
      m_seq = MainSeq_BattleReceiveCatch();
      break;
    case BATTLE_RECIVE_MAINSEQ_CHECK_RULE:
      m_seq = MainSeq_BattleReceiveCheckRule();
      break;
    case BATTLE_RECIVE_MAINSEQ_SAVE:
      m_seq = MainSeq_BattleReceiveSave();
      break;
    case BATTLE_RECIVE_MAINSEQ_MATCHING:
      m_seq = MainSeq_BattleReceiveMatching();
      break;
    case BATTLE_RECIVE_MAINSEQ_STAND:
      m_seq = MainSeq_BattleReceiveStand();
      break;
    case BATTLE_RECIVE_MAINSEQ_CANCEL_ACTION:
      m_seq = MainSeq_BattleReceiveCancelAction();
      break;
  }

  if( m_seq == BATTLE_RECIVE_MAINSEQ_COLOSSEUM_BATTLE ){
    return RET_BATTLE_RECEIVE_COLOSSEUM_BATTLE;
  }
  if( m_seq == BATTLE_RECIVE_MAINSEQ_CANCEL ){
    return RET_BATTLE_RECEIVE_CANCEL;
  }

  return RET_NONE;
}




//--------------------------------------------------------------------------------------------
/**
 * @brief		ΐ󂯓ʃCV[PXF󂯂邩H
 *
 * @param		none
 *
 * @return	e
 */
//--------------------------------------------------------------------------------------------
PssSubProcBattleReceive::E_BATTLE_RECIVE_SEQUENCE PssSubProcBattleReceive::MainSeq_BattleReceiveCatch(void)
{
  if( !UpdateSubProc() )
  {
    app::pss::pss_user_notify::APP_PARAM *param = reinterpret_cast<app::pss::pss_user_notify::APP_PARAM*>(m_paramWork);

    if( param->m_isSelectYes )
    {
      if( InitBattleReceiveCheckRule() ){
        return BATTLE_RECIVE_MAINSEQ_CHECK_RULE;
      }
      else
      {
        gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
        return BATTLE_RECIVE_MAINSEQ_CANCEL;
      }
    }
    else
    {
      gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
      return BATTLE_RECIVE_MAINSEQ_CANCEL;
    }
  }

  return BATTLE_RECIVE_MAINSEQ_CATCH;
}



//--------------------------------------------------------------------------------------------
/**
 * @brief		ΐ󂯓ʃCV[PXF[mF
 *
 * @param		none
 *
 * @return	e
 */
//--------------------------------------------------------------------------------------------
PssSubProcBattleReceive::E_BATTLE_RECIVE_SEQUENCE PssSubProcBattleReceive::MainSeq_BattleReceiveCheckRule(void)
{
  if( !UpdateSubProc() )
  {
    app::pss::pss_battle_receive::APP_PARAM *param = reinterpret_cast<app::pss::pss_battle_receive::APP_PARAM*>(m_paramWork);

    if( param->m_resultCode == app::pss::pss_battle_receive::E_RESULT_CODE_CANCEL )
    {
      if( InitBattleReceiveCatch() )
      {
        return BATTLE_RECIVE_MAINSEQ_CATCH;
      }
      else
      {
        // ؒfĂ
        gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
        return BATTLE_RECIVE_MAINSEQ_CANCEL;
      }
    }
    else
    {
      //InitBattleReceiveSave();
      //return BATTLE_RECIVE_MAINSEQ_SAVE;

      // @TODO SROM̓Z[uȂ
      InitBattleReceiveStand();
      return BATTLE_RECIVE_MAINSEQ_MATCHING;
    }
  }

  return BATTLE_RECIVE_MAINSEQ_CHECK_RULE;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		ΐ󂯓ʃCV[PXFZ[u
 *
 * @param		none
 *
 * @return	e
 */
//--------------------------------------------------------------------------------------------
PssSubProcBattleReceive::E_BATTLE_RECIVE_SEQUENCE PssSubProcBattleReceive::MainSeq_BattleReceiveSave(void)
{
  if( !UpdateSubProc() )
  {
    app::report::APP_PARAM *param = reinterpret_cast<app::report::APP_PARAM*>(m_paramWork);

    if( param->m_isSaveSuccess )
    {
      InitBattleReceiveStand();
      return BATTLE_RECIVE_MAINSEQ_MATCHING;
    }
    else
    {
      if( InitBattleReceiveCheckRule() ){
        return BATTLE_RECIVE_MAINSEQ_CHECK_RULE;
      }
      else{
        gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
        return BATTLE_RECIVE_MAINSEQ_CANCEL;
      }
    }
  }

  return BATTLE_RECIVE_MAINSEQ_SAVE;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		ΐ󂯓ʃCV[PXFڑ҂
 *
 * @param		none
 *
 * @return	e
 */
//--------------------------------------------------------------------------------------------
PssSubProcBattleReceive::E_BATTLE_RECIVE_SEQUENCE PssSubProcBattleReceive::MainSeq_BattleReceiveStand(void)
{
  if(m_beaconResponder->GetEachOther())
  {
    // ڑmI
    if( m_beaconResponder->GetEachOther()->IsConnect() )
    {
      ReleaseProc( &m_subProc );

      m_beaconResponder->GetEachOther()->ResetConnect();
      m_beaconResponder->GetEachOther()->NetworkContinue();
      return BATTLE_RECIVE_MAINSEQ_COLOSSEUM_BATTLE;
    }
  }

  UpdateSubProc();

  // 30bԂŃ^CAEg
  if( IsTimeout( 30000 ) )
  {
    ReleaseProc( &m_subProc );
    InitBattleReceiveCancelAction();
    return BATTLE_RECIVE_MAINSEQ_CANCEL_ACTION;
  }

  return BATTLE_RECIVE_MAINSEQ_STAND;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		ΐ󂯓ʁFuJnv
 *
 * @param		none
 *
 * @return	ȂtrueAsȂfalseԋp
 */
//--------------------------------------------------------------------------------------------
bool PssSubProcBattleReceive::InitBattleReceiveCatch(void)
{
  u64 transferId = m_InvitePlayer.localFriendCode;
  GFL_ASSERT( (transferId != NN_FRIENDS_INVALID_LOCAL_FRIEND_CODE) );

  // r[RIDf[^{̂o
  netapp::beacon::GFEachOther* eachOther = m_beaconResponder->GetEachOther();
  DEFAULT_BEACON_SEND_DATA*    pBeacon   = static_cast<DEFAULT_BEACON_SEND_DATA*>(eachOther->GetBeacon(transferId));

  if( pBeacon == NULL ){
    return false;
  }

  // PROC
  app::pss::pss_user_notify::APP_PARAM *param = reinterpret_cast<app::pss::pss_user_notify::APP_PARAM*>(m_paramWork);
  param->m_layout          = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData     = m_msgData;
  param->m_wordset         = m_wordset;
  param->m_targetPlayer[0] = pBeacon->friendKey;
  param->m_execMode        = app::pss::pss_user_notify::E_MODE_BATTLE_NOTIFY;
  param->m_playerIconMgr   = m_playerIconMgr;
  // [ݒ
  param->m_ruleSetting.m_battleType = static_cast<app::pss::pss_rule_select::E_PSS_BATTLE_TYPE>(pBeacon->battle_type);
  param->m_ruleSetting.m_battleRule = static_cast<app::pss::pss_rule_select::E_PSS_BATTLE_RULE>(pBeacon->battle_rule);
  param->m_ruleSetting.m_isHandicap = pBeacon->battle_handicap;

  m_subProc = dll::CreatePssUserNotifyProc( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );

  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		ΐ󂯓ʁu[mFv
 *
 * @param		none
 *
 * @return  ȂtrueAsȂfalseԋp
 */
//--------------------------------------------------------------------------------------------
bool PssSubProcBattleReceive::InitBattleReceiveCheckRule(void)
{
  netapp::pss::PssPersonalDataManager* pssPersonalMgr = GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetPssPersonalDataManager();
  netapp::pss::PssPersonalData*        personal       = pssPersonalMgr->GetPersonalData( m_InvitePlayer );

  if( personal == NULL ){
    return false;
  }
  const DEFAULT_BEACON_SEND_DATA& packet = personal->GetPacketData();

  app::pss::pss_battle_receive::APP_PARAM *param = reinterpret_cast<app::pss::pss_battle_receive::APP_PARAM*>(m_paramWork);
  param->m_layout      = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData = m_msgData;
  param->m_wordset     = m_wordset;

  // [ݒ
  param->m_ruleSetting.m_battleType = static_cast<app::pss::pss_rule_select::E_PSS_BATTLE_TYPE>(packet.battle_type);
  param->m_ruleSetting.m_battleRule = static_cast<app::pss::pss_rule_select::E_PSS_BATTLE_RULE>(packet.battle_rule);
  param->m_ruleSetting.m_isHandicap = packet.battle_handicap;

  m_subProc = dll::CreatePssBattleReceiveProc( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );

  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		ΐ󂯓ʁFuZ[uʁv
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcBattleReceive::InitBattleReceiveSave(void)
{
  app::report::APP_PARAM *param = reinterpret_cast<app::report::APP_PARAM*>(m_paramWork);
  param->m_layout       = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_isEnableFade = false;

  m_subProc = dll::CreateReportMenuProc( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		ΐ󂯓ʁFuڑ҂v
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcBattleReceive::InitBattleReceiveStand(void)
{
  app::pss::pss_message_window::APP_PARAM *param = reinterpret_cast<app::pss::pss_message_window::APP_PARAM*>(m_paramWork);

  param->m_layout        = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData   = m_msgData;
  param->m_wordset       = m_wordset;
  param->m_type          = app::pss::pss_message_window::E_TYPE_MESSAGE;
  param->m_messageText   = msg_pss_05_11_01;  // ł܂ŁA΂炭܂
  param->m_playerIconMgr = m_playerIconMgr;
  param->m_isDispLoading = true;
  param->m_inputLock     = true;

  // ʐMJnԂL^
  gfl::std::DateTime::GetNow( &m_connectStartingTime );

  m_subProc = dll::CreatePssMessageWindow( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ΐ󂯓ʁFuڑvvZX
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
PssSubProcBattleReceive::E_BATTLE_RECIVE_SEQUENCE PssSubProcBattleReceive::MainSeq_BattleReceiveMatching(void)
{
  if(m_beaconResponder->GetEachOther())
  {
    u64 transferId = m_InvitePlayer.localFriendCode;
    GFL_ASSERT( (transferId != NN_FRIENDS_INVALID_LOCAL_FRIEND_CODE) );
    m_beaconResponder->GetEachOther()->ResetConnect();

    NN_LOG("ΐ[%llu]\n",transferId);
    //@todo Ƃ肠r[Rwɂ͂ȂĂ邪݂Ȃ
    //@todo ق̒ʐM̎Ăꍇ[vĂ܂
    if(m_beaconResponder->GetEachOther()->Matching(transferId))
    {
      gfl::std::DateTime::GetNow( &m_connectStartingTime );
      return BATTLE_RECIVE_MAINSEQ_STAND;
    }
  }

  UpdateSubProc();

  // 30bԂŃ^CAEg
  if( IsTimeout( 30000 ) )
  {
    ReleaseProc( &m_subProc );
    InitBattleReceiveCancelAction();
    return BATTLE_RECIVE_MAINSEQ_CANCEL_ACTION;
  }

  return BATTLE_RECIVE_MAINSEQ_MATCHING;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ΐ󂯓ʁFuڑLZv
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
void PssSubProcBattleReceive::InitBattleReceiveCancelAction( void )
{
  app::pss::pss_message_window::APP_PARAM *param = reinterpret_cast<app::pss::pss_message_window::APP_PARAM*>(m_paramWork);

  param->m_layout        = GFL_SINGLETON_INSTANCE(gfl::grp::g2d::LytSys);
  param->m_messageData   = m_msgData;
  param->m_wordset       = m_wordset;
  param->m_type          = app::pss::pss_message_window::E_TYPE_MESSAGE;
  param->m_messageText   = msg_pss_05_06_01;  // sȂ܂Bΐ𒆎~܂B
  param->m_playerIconMgr = m_playerIconMgr;
  param->m_isDispLoading = false;
  param->m_inputLock     = false;

  m_subProc = dll::CreatePssMessageWindow( m_gameProgMgr, param );
  m_subProc->InitFunc( m_gameProgMgr );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ΐ󂯓ʁFuڑLZvvZX
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
PssSubProcBattleReceive::E_BATTLE_RECIVE_SEQUENCE PssSubProcBattleReceive::MainSeq_BattleReceiveCancelAction(void)
{
  // ΐ\݂LZ
  if( !UpdateSubProc() )
  {
    // P2PʐMLZ
    if(m_beaconResponder->GetEachOther() != NULL ){
      m_beaconResponder->GetEachOther()->MatchingFinalize();
    }

    gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
    return BATTLE_RECIVE_MAINSEQ_CANCEL;
  }

  return BATTLE_RECIVE_MAINSEQ_CANCEL_ACTION;
}


}		// subproc
}		// pss
}		// subscreen
}		// field

