

#include "pss_subproc_base.h"


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


//--------------------------------------------------------------------------------------------
/**
* @brief   RXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcBase::PssSubProcBase( void ) : m_gameProgMgr(NULL), m_subProc(NULL), m_beaconResponder(NULL), m_paramWork(NULL)
{
}

//--------------------------------------------------------------------------------------------
/**
* @brief   x[XNX̏
*
* @param   gameProgMgr      GameProcManagerւ̃|C^
* @param   beaconResponder  PssBeaconResponderւ̃|C^
* @param   paramWork        Procp[^p̈
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
void PssSubProcBase::InitBase( gamesystem::GameProcManager *gameProgMgr, netapp::pss::PssBeaconResponder* beaconResponder, void* paramWork )
{
  m_paramWork       = paramWork;
  m_beaconResponder = beaconResponder;
  m_gameProgMgr     = gameProgMgr;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   TuvZX
*
* @param   none
*
* @return  ȂtrueAIԂȂfalseԋp
*/
//--------------------------------------------------------------------------------------------
bool PssSubProcBase::UpdateSubProc( void )
{
  if( m_subProc == NULL ){
    return true;
  }

  if( m_subProc->UpdateFunc( m_gameProgMgr ) == gfl::proc::RES_CONTINUE ){
    return true;
  }
  ReleaseProc( &m_subProc );

  return false;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   vZX
*
* @param   procHandle ΏۂƂȂvZXnh
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
void PssSubProcBase::ReleaseProc( gamesystem::GameProc** procHandle )
{
  if( *procHandle != NULL )
  {
    (*procHandle)->EndFunc( m_gameProgMgr );

  #if GFL_ENABLE_RO
    nn::ro::Module* pModule = (*procHandle)->GetModulePtr();
    GFL_DELETE( *procHandle );
    if( pModule != NULL )
    {
      gfl::ro::RoManager *roMgr = GFL_SINGLETON_INSTANCE( gfl::ro::RoManager );
      roMgr->DisposeModule( pModule );
    }
  #else
    GFL_DELETE( (*procHandle) );
  #endif
    *procHandle = NULL;
  }
}


//--------------------------------------------------------------------------------------------
/**
* @brief   \
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
void PssSubProcBase::Draw( void )
{
  if( m_subProc != NULL )
  {
    m_subProc->DrawFunc( m_gameProgMgr );
  }
}


//--------------------------------------------------------------------------------------------
/**
* @brief   
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
void PssSubProcBase::Release( void )
{
  if( m_subProc != NULL )
  {
    ReleaseProc( &m_subProc );
  }
}


//------------------------------------------------------------------
/**
* @brief ^CAEg`FbN
*
* @param  limitTime  ^CAEg܂ł̎ԁimsec)
*
* @return ^CAEgȂtrueԋp
*/
//------------------------------------------------------------------
bool PssSubProcBase::IsTimeout( u32 limitTime )
{
  if( ++m_timerCheckWait >= 10 )
  {
    gfl::std::DateTime nowDate;
    gfl::std::DateTime::GetNow( &nowDate );
    s64 sec = nowDate.GetDateTimeToMilliSecond() - m_connectStartingTime.GetDateTimeToMilliSecond();

    m_timerCheckWait = 0;

    return (sec >= limitTime);
  }
  return false;
}


}		// subproc
}		// pss
}		// subscreen
}		// field


