//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		poke_memo.cpp
 *	@brief  g[i[ݒNX
 *	@author	Toru=Nagihashi
 *	@date		2012.05.08
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include <pmlib.h>
#include <savedata/MyStatus.h>
#include <poke_tool/poke_place.h>
#include <poke_tool/poke_memo.h>

GFL_NAMESPACE_BEGIN(poke_tool)

//----------------------------------------------------------------------------
/**
 *	@brief  |Pւ̃ݒ
 */
//-----------------------------------------------------------------------------
/**
 *  @brief ߊlŕ߂܂ꍇ̃|Pݒ
 *  @param  param           |Pp
 *  @param  mystatus        }CXe[^X
 *  @param  place_no    ߂܂ꏊ̒nbZ[Wԍ
 *  @param  temporary_heap  e|pq[v
 */
void PokeMemo::SetFromCapture( pml::pokepara::CoreParam * param, const savedata::MyStatus *mystatus, u32 place_no, gfl::heap::HeapBase *temporary_heap )
{
  bool fast_mode = param->StartFastMode();

  PokeMemo::ClearPlaceTime( param, DATA_TYPE_EGG_TAKEN );
  PokeMemo::SetPlaceTime( param, place_no, DATA_TYPE_FIRST_CONTACT );
  PokeMemo::SetMyStatus( param, mystatus, temporary_heap );
  PokeMemo::SetGetLevel( param );
  PokeMemo::SetVersion( param );

  param->EndFastMode( fast_mode );
}

/**
 *  @brief Q[ꍇ̃|Pݒ
 *  @param  param           |Pp
 */
void PokeMemo::SetFromInnerTrade( pml::pokepara::CoreParam * param )
{
  bool fast_mode = param->StartFastMode();

  PokeMemo::SetPlaceTime( param, PokePlace::PLACE_NO_SPECIAL_INNER_TRADE, DATA_TYPE_FIRST_CONTACT );
  PokeMemo::SetGetLevel( param );
  PokeMemo::SetVersion( param );

  param->EndFastMode( fast_mode );
}
/**
 *  @brief lƌꍇ̃|Pݒ
 *  @param  param           |Pp
 */
void PokeMemo::SetFromOuterTrade( pml::pokepara::CoreParam * param )
{
  //ȂɂȂ
}

/**
 *  @brief ^}Szꍇ̃|Pݒ
 *  @param  param           |Pp
 *  @param  mystatus        }CXe[^X
 *  @param  place_no           ߂܂ꏊ̒nbZ[Wԍ
 *  @param  temporary_heap  e|pq[v
 */
void PokeMemo::SetFromEggBirth( pml::pokepara::CoreParam * param, const savedata::MyStatus *mystatus, u32 place_no, gfl::heap::HeapBase *temporary_heap )
{
  bool fast_mode = param->StartFastMode();

  if( mystatus->IsMyPokemon( *param ) )
  {
    PokeMemo::SetPlaceTime( param, place_no, DATA_TYPE_FIRST_CONTACT );
    PokeMemo::SetMyStatus( param, mystatus, temporary_heap );
  }
  else
  {
    PokeMemo::CopyPlaceTime( param, DATA_TYPE_FIRST_CONTACT );
    PokeMemo::SetPlaceTime( param, place_no, DATA_TYPE_FIRST_CONTACT );
    PokeMemo::SetMyStatus( param, mystatus, temporary_heap );
  }
  PokeMemo::SetVersion( param );

  param->EndFastMode( fast_mode );
}

/**
 *  @brief ߋ삩玝Ăꍇ̃|Pݒ
 *  @param  param           |Pp
 */
void PokeMemo::SetFromPastTranslate( pml::pokepara::CoreParam * param )
{
  bool fast_mode = param->StartFastMode();

  PokeMemo::SetPlaceTime( param, PokePlace::PLACE_NO_SPECIAL_PAST_TRANSLATE, DATA_TYPE_FIRST_CONTACT );
  PokeMemo::SetGetLevel( param );

  param->EndFastMode( fast_mode );
}

/**
 *  @brief zzŎ擾ꍇ̃|Pݒ
 *  @param  param           |Pp
 *  @param  place_no           ꏊiӂȑ蕨ɓĂꏊj
 *  @param  year            Niӂȑ蕨ɓĂNj
 *  @param  month           iӂȑ蕨ɓĂ錎j
 *  @param  day             iӂȑ蕨ɓĂj
 */
void PokeMemo::SetFromDistribution( pml::pokepara::CoreParam * param, u32 place_no, u32 year, u32 month, u32 day )
{
  bool fast_mode = param->StartFastMode();

  if( param->IsEgg(pml::pokepara::CHECK_BOTH_EGG) )
  {
    PokeMemo::SetPlaceTime( param, place_no, year, month, day, DATA_TYPE_EGG_TAKEN );
  }
  else
  {
    PokeMemo::SetPlaceTime( param, place_no, year, month, day, DATA_TYPE_FIRST_CONTACT );
  }

  param->EndFastMode( fast_mode );
}
/**
 *  @brief ^}Sꍇ̃|Pݒ
 *  @param  param           |Pp
 *  @param  mystatus        }CXe[^X
 *  @param  place_no    ߂܂ꏊ̒nbZ[Wԍ
 *  @param  temporary_heap  e|pq[v
 */
void PokeMemo::SetFromEggTaken( pml::pokepara::CoreParam * param, const savedata::MyStatus *mystatus, u32 place_no, gfl::heap::HeapBase *temporary_heap )
{
  bool fast_mode = param->StartFastMode();

  //mark
  PokeMemo::SetPlaceTime( param, place_no, DATA_TYPE_EGG_TAKEN );
  PokeMemo::SetMyStatus( param, mystatus, temporary_heap );
  PokeMemo::SetVersion( param );
  param->EndFastMode( fast_mode );
}

/**
 *  @brief ^}Sꍇ̃|Pݒ
 *  @param  param           |Pp
 *  @param  place_no    ߂܂ꏊ̒nbZ[Wԍ
 */
void PokeMemo::SetFromEggTrade( pml::pokepara::CoreParam * param, u32 place_no )
{
  bool fast_mode = param->StartFastMode();
  //mark
  PokeMemo::SetPlaceTime( param, place_no, DATA_TYPE_FIRST_CONTACT );
  param->EndFastMode( fast_mode );
}

//----------------------------------------------------------------------------
/**
 *	@brief  private
 */
//----------------------------------------------------------------------------
/**
 *  @brief ꏊƎԂݒi݂̎ݒj
 *  @param  param           |Pp
 *  @param  place_no           ꏊ
 *  @param  type            ݒӏ
 */
void PokeMemo::SetPlaceTime( pml::pokepara::CoreParam * param, u32 place_no, DataType type )
{
  gfl::std::DateTime  date_time;
  PokeMemo::SetPlaceTime( param, place_no, date_time.GetYear(), date_time.GetMonth(), date_time.GetDay(), type );
}
/**
 *  @brief ꏊƎԂݒiOwj
 *  @param  param           |Pp
 *  @param  place_no           ꏊ
 *  @param  year            N
 *  @param  month           
 *  @param  day             
 *  @param  type            ݒӏ
 */
void PokeMemo::SetPlaceTime( pml::pokepara::CoreParam * param, u32 place_no, u32 year, u32 month, u32 day, DataType type )
{
  if( type == DATA_TYPE_EGG_TAKEN )
  {
    param->SetMemories( pml::pokepara::MEMORIES_EGG_TAKEN_PLACE, place_no );
    param->SetMemories( pml::pokepara::MEMORIES_EGG_TAKEN_YEAR, year );
    param->SetMemories( pml::pokepara::MEMORIES_EGG_TAKEN_MONTH, month );
    param->SetMemories( pml::pokepara::MEMORIES_EGG_TAKEN_DAY, day );
  }
  else
  {
    param->SetMemories( pml::pokepara::MEMORIES_FIRST_CONTACT_PLACE, place_no );
    param->SetMemories( pml::pokepara::MEMORIES_FIRST_CONTACT_YEAR, year );
    param->SetMemories( pml::pokepara::MEMORIES_FIRST_CONTACT_MONTH, month );
    param->SetMemories( pml::pokepara::MEMORIES_FIRST_CONTACT_DAY, day );
  }
}

/**
 *  @brief ꏊƎԂ
 *  @param  param           |Pp
 *  @param  type            ݒӏ
 */
void PokeMemo::ClearPlaceTime( pml::pokepara::CoreParam * param, DataType type )
{
  PokeMemo::SetPlaceTime( param, 0, 0, 0, 0, type );
}
/**
 *  @brief ꏊƎԂsrc_typeЕփRs[
 *  @param  param           |Pp
 *  @param  src_type        Rs[
 */
void PokeMemo::CopyPlaceTime( pml::pokepara::CoreParam * param, DataType src_type )
{
  u32 place_no;
  u32 year;
  u32 month;
  u32 day;
  DataType dst_type;

  if( src_type == DATA_TYPE_EGG_TAKEN )
  {
    place_no = param->GetMemories( pml::pokepara::MEMORIES_EGG_TAKEN_PLACE );
    year  = param->GetMemories( pml::pokepara::MEMORIES_EGG_TAKEN_YEAR );
    month = param->GetMemories( pml::pokepara::MEMORIES_EGG_TAKEN_MONTH );
    day   = param->GetMemories( pml::pokepara::MEMORIES_EGG_TAKEN_DAY );
    dst_type  = DATA_TYPE_FIRST_CONTACT;
  }
  else
  {
    place_no = param->GetMemories( pml::pokepara::MEMORIES_FIRST_CONTACT_PLACE );
    year  = param->GetMemories( pml::pokepara::MEMORIES_FIRST_CONTACT_YEAR );
    month = param->GetMemories( pml::pokepara::MEMORIES_FIRST_CONTACT_MONTH );
    day   = param->GetMemories( pml::pokepara::MEMORIES_FIRST_CONTACT_DAY );
    dst_type  = DATA_TYPE_EGG_TAKEN;
  }

  PokeMemo::SetPlaceTime( param, place_no, year, month, day, dst_type );
}

/**
 *  @brief ꏊƎԂsrc_typeЕփRs[
 *  @param  param             |Pp
 *  @param  mystatus          ݒ肷܂Xe[^X
 *  @param  temporary_heap    e|pq[v
 */
void PokeMemo::SetMyStatus( pml::pokepara::CoreParam * param, const savedata::MyStatus *mystatus, gfl::heap::HeapBase *temporary_heap )
{
  bool fast_mode = param->StartFastMode();
  gfl::str::StrBuf *tmp_buf = GFL_NEW(temporary_heap->GetLowerHandle()) gfl::str::StrBuf( 32, temporary_heap->GetLowerHandle() );

  param->SetID( mystatus->GetID() );
  mystatus->GetNameString( tmp_buf );
  param->SetParentName( tmp_buf );
  param->SetParentSex( static_cast<pml::Sex>( mystatus->GetSex() ) );
  param->EndFastMode( fast_mode );

  GFL_SAFE_DELETE( tmp_buf );
}
/**
 *  @brief ݂̃x߂܂̃xɐݒ肷B
 *  @param  param
 */
void PokeMemo::SetGetLevel( pml::pokepara::CoreParam * param )
{
  param->SetMemories( pml::pokepara::MEMORIES_CAPTURED_LEVEL, param->GetLevel() );
}
/**
 *  @brief o[Wݒ肷
 *  @param  param   |Pp
 *
 *  @note |Pp̐ɍŏ烍o[Wt̂
 *        KvȂȂ܂̂ŁAȂɂ܂B
 */
void PokeMemo::SetVersion( pml::pokepara::CoreParam * param )
{
  //->SWAN܂ł͖IVersionĂA
  //񂩂VERSION̓|Pp쐬ɂƃZbg邽߁A
  //ł͍sȂB
}

GFL_NAMESPACE_END(poke_tool)
