//============================================================================================
/**
 * @file		app_tool_PaletteTextureExport.cpp
 * @brief		pbg̃CAEgeNX`ɖ߂
 * @author	Hiroyuki Nakamura
 * @date		12.05.09
 *
 * namespace	app::tool::
 */
//============================================================================================
#include "app/tool/app_tool_PaletteTextureExport.h"


namespace app {
namespace tool {

void ExportTexture( nw::lyt::TexResource * res, gfl::heap::HeapBase * heap )
{
	u16 * p = reinterpret_cast<u16 *>( res->GetImageAddress() );
	u32	size = res->GetImageSize();

	u16 * cpy = static_cast<u16 *>( GflHeapAllocMemoryLowAlign( heap, size, 4 ) );
	gfl::std::MemCopy( p, cpy, size );

	u16 * pal = &cpy[2];		// pbgf[^
	u32	pbsiz = 4 + cpy[0] * cpy[1];	// format[2] + size[2] + format * size
	u8 * dot = reinterpret_cast<u8 *>( &cpy[pbsiz/2] );		// hbgf[^

	// pbg16ȉ	
	if( cpy[1] <= 16 ){
		for( u32 i=0; i<size/2; i+=2 ){
			p[i]   = pal[ (*dot)>>4 ];
			p[i+1] = pal[ (*dot)&0x0f ];
			dot++;
		}
	// pbg16ȏ
	}else{
		for( u32 i=0; i<size/2; i++ ){
			p[i] = pal[ dot[i] ];
		}
	}

	GflHeapFreeMemory( cpy );
}


}		// tool
}		// app
