#ifndef __TEST_SUZUKI_UIVIEW_TEST_H__
#define __TEST_SUZUKI_UIVIEW_TEST_H__

#pragma once

#include <gflib.h>
#include <gamesystem/GameProc.h>
#include <friends/gflnet_FriendManager.h>
#include <nex/gflnet_NexManager.h>
#include <netapp/subscription/SubscriptionManager.h>
#include <app/ui/UIView.h>
#include <app/ui/UIInputListener.h>

namespace test {
namespace suzuki {

  class ParentUIListener
  {
    public:
      virtual void OnParentClose( void ) = 0;
  };

  class ChildUIListener
  {
    public:
      virtual void OnChildClose( void ) = 0;
  };

  // qEChE
  class ChildView : public app::ui::UIView, public app::ui::UIInputListener
  {
    public:
      static const u32  BOX_SIZE = 50;
    public:
      ChildView( app::util::Heap * heap, gfl::grp::GraphicsSystem* grpSystem, u32 x, u32 y, bool isModal );
      ~ChildView(void);
    public:
      virtual void Update(void);
      virtual void Draw(void);
    public:
      virtual bool OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick);
    public:
      bool    IsClose(void);
    private:
      bool    m_isModal;
      bool    m_isClose;
      u32     m_posX;
      u32     m_posY;
    public:
      nw::ut::LinkListNode node;
  };

  // eEChE
  class ParentView : public app::ui::UIView, public app::ui::UIInputListener
  {
    public:
      ParentView( app::util::Heap * heap );
      ~ParentView(void);
    public:
      virtual void Update(void);
      virtual void Draw(void);
    public:
      virtual bool OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick);
    public:
      void SetParentUIListener( ParentUIListener* listener );
    private:
      typedef nw::ut::LinkList<ChildView, offsetof(ChildView,node)> ChildViewList;

      ChildViewList      m_childs;
      app::util::Heap*   m_heap;
      ParentUIListener*  m_uiListener;
      gfl::math::Random  m_randContext;
  };


  // eXg{
  class UIViewTest : public gamesystem::GameProc, public ParentUIListener
  {
    public:
                   UIViewTest();
      virtual      ~UIViewTest();

    public:
      virtual gfl::proc::Result InitFunc( gfl::proc::Manager * proc_manager );
      virtual gfl::proc::Result EndFunc( gfl::proc::Manager * proc_manager );
      virtual gfl::proc::Result UpdateFunc( gfl::proc::Manager * proc_manager );
      virtual void              DrawFunc( gfl::proc::Manager * proc_manager );
    public:
      virtual void OnParentClose( void );

    private:
      bool                      m_isFinish;
      app::util::Heap           m_heap;
      ParentView*               m_superView;
  };


} // namespace suzuki
} // namespace test

#endif // __TEST_SUZUKI_UIVIEW_TEST_H__

