#include "UIViewTest.h"

namespace test {
namespace suzuki {

//============================================================================================

ChildView::ChildView( app::util::Heap * heap, gfl::grp::GraphicsSystem* grpSystem, u32 x, u32 y, bool isModal ) : app::ui::UIView(heap)
{
  m_isModal       = isModal;
  m_graphicSystem = grpSystem;
  m_isClose       = false;
  m_posX          = x;
  m_posY          = y;

  SetInputListener( this );

  if( isModal ){
    this->SetModal();
  }
}

ChildView::~ChildView(void)
{
}

void ChildView::Update(void)
{
  app::ui::UIView::Update();
}

bool ChildView::IsClose(void)
{
  return m_isClose;
}


void ChildView::Draw(void)
{
  if( m_isModal )
  {
    DrawMaskRect( GetGraphicSystem(), gfl::grp::DISPLAY_UPPER,       m_posX, m_posY, BOX_SIZE, BOX_SIZE, 0.0f, 1.0f, 1.0f, 1.0f );
    DrawMaskRect( GetGraphicSystem(), gfl::grp::DISPLAY_UPPER_RIGHT, m_posX, m_posY, BOX_SIZE, BOX_SIZE, 0.0f, 1.0f, 1.0f, 1.0f );
  }
  else
  {
    DrawMaskRect( GetGraphicSystem(), gfl::grp::DISPLAY_UPPER,       m_posX, m_posY, BOX_SIZE, BOX_SIZE, 1.0f, 1.0f, 0.0f, 1.0f );
    DrawMaskRect( GetGraphicSystem(), gfl::grp::DISPLAY_UPPER_RIGHT, m_posX, m_posY, BOX_SIZE, BOX_SIZE, 1.0f, 1.0f, 0.0f, 1.0f );
  }
}

bool ChildView::OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick)
{
  if( pKey->IsTrigger( gfl::ui::BUTTON_B ) )
  {
    m_isClose = true;
    return false;
  }

  if( pKey->IsHold( gfl::ui::BUTTON_LEFT ) )
  {
    m_posX--;
  }
  else if( pKey->IsHold( gfl::ui::BUTTON_RIGHT ) )
  {
    m_posX++;
  }

  if( pKey->IsHold( gfl::ui::BUTTON_UP ) )
  {
    m_posY--;
  }
  else if( pKey->IsHold( gfl::ui::BUTTON_DOWN ) )
  {
    m_posY++;
  }

  return true;
}
//============================================================================================

ParentView::ParentView( app::util::Heap * heap ) : app::ui::UIView(heap)
{
  m_heap = heap;
  m_randContext.Initialize();

  CreateGraphicsSystem( heap );

  SetInputListener( this );
}

ParentView::~ParentView(void)
{
  for( ChildViewList::iterator it = m_childs.begin(); it != m_childs.end(); ++it )
  {
    ChildView *child = &(*it);
    it = m_childs.erase( it );

    GFL_DELETE( child );
  }
  DeleteGraphicsSystem();
}

void ParentView::Update(void)
{
  app::ui::UIView::Update();

  for( ChildViewList::iterator it = m_childs.begin(); it != m_childs.end(); ++it )
  {
    // TuEChE
    if( it->IsClose() )
    {
      // eq֌W
      ChildView *child = &(*it);
      it = m_childs.erase( it );
      child->RemoveFromSuperView();
      GFL_DELETE( child );
    }
  }
}

void ParentView::SetParentUIListener( ParentUIListener* listener )
{
  m_uiListener = listener;
}


void ParentView::Draw(void)
{
  gfl::grp::GraphicsSystem *graphics = GetGraphicSystem();

  DrawUpperMaskRect( graphics, gfl::grp::DISPLAY_UPPER,       1.0f );
  DrawUpperMaskRect( graphics, gfl::grp::DISPLAY_UPPER_RIGHT, 1.0f );
  DrawLowerMaskRect( graphics, gfl::grp::DISPLAY_LOWER,       1.0f );

  gfl::grp::RenderTarget* frameBuffer = graphics->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );

  wchar_t string[128];

  nw::ut::snwprintf( string, 128, 127, L"TuEChE: %u", m_childs.size() );

  gfl::grp::util::DrawUtil::BeginRender( frameBuffer );
  gfl::grp::util::DrawUtil::SetTextScale( 0.5f, 0.5f );
  gfl::grp::util::DrawUtil::SetTextColor( gfl::math::VEC4(1.0f, 1.0f, 1.0f, 1.0f) );
  gfl::grp::util::DrawUtil::DrawText( 0, 0,  L"A{^ŃTuEChEJ([_X)" );
  gfl::grp::util::DrawUtil::DrawText( 0, 30, L"X{^ŃTuEChEJ([_)" );
  gfl::grp::util::DrawUtil::DrawText( 0, 60, L"B{^ŃTuEChEƂ" );
  gfl::grp::util::DrawUtil::DrawText( 0, 90, L"{^ŃTuEChEړ" );
  gfl::grp::util::DrawUtil::DrawText( 0, 140, string );
  gfl::grp::util::DrawUtil::EndRender();
}

bool ParentView::OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick)
{
  // 
  if( pKey->IsTrigger( gfl::ui::BUTTON_B ) )
  {
    if( m_uiListener != NULL )
    {
      if( m_childs.size() == 0 )
      {
        m_uiListener->OnParentClose();
        return false;
      }
    }
  }
  // [_XEChEǉ
  else if( pKey->IsTrigger( gfl::ui::BUTTON_A ) )
  {
    u32 x = m_randContext.Next( DISPLAY_UPPER_WIDTH  -ChildView::BOX_SIZE );
    u32 y = m_randContext.Next( DISPLAY_UPPER_HEIGHT -ChildView::BOX_SIZE );

    ChildView* child = GFL_NEW( m_heap->pHeap ) ChildView( m_heap, GetGraphicSystem(), x, y, false );

    m_childs.push_back( child );
    this->AddSubView( child );

    return false;
  }
  // [_EChEǉ
  else if( pKey->IsTrigger( gfl::ui::BUTTON_X ) )
  {
    u32 x = m_randContext.Next( DISPLAY_UPPER_WIDTH  -ChildView::BOX_SIZE );
    u32 y = m_randContext.Next( DISPLAY_UPPER_HEIGHT -ChildView::BOX_SIZE );

    ChildView* child = GFL_NEW( m_heap->pHeap ) ChildView( m_heap, GetGraphicSystem(), x, y, true );

    m_childs.push_back( child );
    this->AddSubView( child );

    return false;
  }


  return true;
}


//============================================================================================


UIViewTest::UIViewTest() : m_isFinish(false)
{
  gfl::heap::HeapBase* base = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );

  m_heap.Create( HEAPID_TOWNMAP_APP, 0x30000, HEAPID_TOWNMAP_DEVICE, 0x80000 );

  m_superView = GFL_NEW( m_heap.pHeap ) test::suzuki::ParentView( &m_heap );
  m_superView->SetParentUIListener( this );
}

UIViewTest::~UIViewTest()
{
  if( m_superView != NULL )
  {
    GFL_DELETE( m_superView );
    m_superView = NULL;
  }

  m_heap.Delete();
}

gfl::proc::Result UIViewTest::InitFunc( gfl::proc::Manager * proc_manager )
{
  return gfl::proc::RES_FINISH;
}

gfl::proc::Result UIViewTest::EndFunc( gfl::proc::Manager * proc_manager )
{
  return gfl::proc::RES_FINISH;
}

gfl::proc::Result UIViewTest::UpdateFunc( gfl::proc::Manager * proc_manager )
{
  if( m_superView != NULL ){
    m_superView->Update();
  }
  return m_isFinish ? gfl::proc::RES_FINISH : gfl::proc::RES_CONTINUE;
}

void UIViewTest::DrawFunc( gfl::proc::Manager * proc_manager )
{
  // ParentVieweƂDrawTree`
  if( m_superView != NULL ){
    m_superView->DrawTree();
  }
}


void UIViewTest::OnParentClose( void )
{
  m_isFinish = true;
}


} // namespace suzuki
} // namespace test

