//===================================================================
/**
 * @file    SaveData.cpp
 * @brief   Z[uf[^̃mۃNX
 * @author  k.ohno
 * @date    11.12.3
 * @note    Z[uf[^ɏ풓邽߂̃NX
 */
//===================================================================

#include <gflib.h>

#include "savedata/SaveData.h"
#include "savedata/SaveLoadControl.h"

GFL_NAMESPACE_BEGIN(savedata)


//-----------------------------------------------------------------------------
/**
 *  @brief    RXgN^
 */
//-----------------------------------------------------------------------------
SaveData::SaveData( gfl::heap::HeapBase * heap )
{
  //mSystemHeap = heap;
  /// @attention ɒǉZ[uf[^ɒǉ`ŋLq
  /// Z[uf[^͂̏ŋL^邱ƂɂȂBo̒`ł͂ȂB
  int i = 0;
#ifndef MAPVIEWER_PROJECT
  mSaveObject[i++] = &mKawaigari;
  mSaveObject[i++] = &mMyItem;
  mSaveObject[i++] = &mBag;
  mSaveObject[i++] = &mFashion;
  mSaveObject[i++] = &mMiniGame;
  mSaveObject[i++] = &mGimmickWork;
  mSaveObject[i++] = &mMmdl;
  mSaveObject[i++] = &mMisc;
  mSaveObject[i++] = &mPlayerWork;
  mSaveObject[i++] = &mBox;
  mSaveObject[i++] = &mBoxPokemon;
  mSaveObject[i++] = &mBattleBox;
  mSaveObject[i++] = &mPssFavorite;
  mSaveObject[i++] = &mMyStatus;
  mSaveObject[i++] = &mPokePartySave;
  mSaveObject[i++] = &mEventWork;
#else
  mSaveObject[i++] = &mGameTime;
  mSaveObject[i++] = &mSituation;
  mSaveObject[i++] = &mRandomGroup;
  mSaveObject[i++] = &mPlayTime;
  mSaveObject[i++] = &mGimmickWork;
  mSaveObject[i++] = &mMisc;
  mSaveObject[i++] = &mPlayerWork;
  mSaveObject[i++] = &mMyStatus;
  mSaveObject[i++] = &mEventWork;

  for( ; i<SAVEDATA_CLASS_NUM; ++i ){
    mSaveObject[i] = &mGameTime;  // _~[̃Z[uf[^Ŗ߂B
  }
#endif 

  GFL_ASSERT_STOP( i == SAVEDATA_CLASS_NUM );

  this->Clear(heap);
}

//-----------------------------------------------------------------------------
/**
 *  @brief    obNAbvf[^̓o^
 */
//-----------------------------------------------------------------------------
void SaveData::AddBackupEntry( SaveLoadControl* pSLControl )
{
  //ʂ̃Z[uf[^ǉ
  for ( int i = 0; i < SAVEDATA_CLASS_NUM; i ++ )
  {
      pSLControl->AddBackupEntry( mSaveObject[i]->GetData(), mSaveObject[i]->GetDataSize() );
  }

  //`FbNǉ
  pSLControl->AddBackupEntry( &mTotalCheckData,    sizeof(TOTAL_CHECK_DATA) );
}

//-----------------------------------------------------------------------------
/**
 *  @brief    obNAbvf[^̃NA
 *  @param heap  NAɎgpe|q[v
 */
//-----------------------------------------------------------------------------
  void SaveData::Clear( gfl::heap::HeapBase * heap )
  {
    for ( int i = 0; i < SAVEDATA_CLASS_NUM; i ++ )
    {
        mSaveObject[i]->Clear( heap );
    }
    SetupCheckData();
  }

//-----------------------------------------------------------------------------
/**
 *  @brief    obNAbvf[^̐`FbN
 */
//-----------------------------------------------------------------------------
bool SaveData::IsValidCheckData( void )
{
    GFL_PRINT("MAGIC_NUMBER = %08x\n", mTotalCheckData.magic_number);
    if ( mTotalCheckData.magic_number != MAGIC_NUMBER) return false;
    for ( int i = 0; i < SAVEDATA_CLASS_NUM; i ++ )
    {
      CHECK_DATA * pCD = &mTotalCheckData.mCheckData[i];
      u32 size = mSaveObject[i]->GetDataSize();
      u16 crc = gfl::math::Crc::Calc( mSaveObject[i]->GetData(), size );
      GFL_PRINT("%02d:calc:rec =%04x:%04x\n",i, pCD->crc, crc );
      if ( pCD->size != size ) return false;
      if ( pCD->id != i ) return false;
      if ( pCD->crc != crc  ) return false;
    }
    return true;
}

//-----------------------------------------------------------------------------
/**
 *  @brief    obNAbvf[^̐񖄂ߍ
 */
//-----------------------------------------------------------------------------
void SaveData::SetupCheckData( void )
{
  for ( int i = 0; i < SAVEDATA_CLASS_NUM; i ++)
  {
    CHECK_DATA * pCD = &mTotalCheckData.mCheckData[i];
    pCD->size = mSaveObject[i]->GetDataSize();
    pCD->id = i;
    pCD->crc = gfl::math::Crc::Calc( mSaveObject[i]->GetData(), pCD->size );
  }
  mTotalCheckData.magic_number = MAGIC_NUMBER;
}

GFL_NAMESPACE_END(savedata)
