//========================================================================================
/**
 * @brief AvʃW[( ^b`o[ )
 * @file app_config_TouchBar.cpp
 * @author obata_toshihiro
 * @date 2011.05.18
 */
//========================================================================================
#include <app/config/app_config_TouchBar.h>


namespace app {
  namespace config {



    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp TouchBar::m_layout_work_setup_data[2] =
    {
      // ʗp
      {
        gfl::math::VEC3(0,0,0),   // pos
        gfl::math::VEC2(1,1),     // scale
        gfl::math::VEC3(0,0,0),   // rotate
        1,                        // priority
      },
      // ʗp
      {
        gfl::math::VEC3(0,-290,0),   // pos
        gfl::math::VEC2(1,1),        // scale
        gfl::math::VEC3(0,0,0),      // rotate
        1,                           // priority
      },
    };


    // ˉeϊp[^
    const gfl::grp::ProjectionParam TouchBar::m_projection_parameter[2] =
    {
      // ʗp
      { 
        gfl::grp::PROJECTION_ORTHO,
        { -200.0f, 200.0f, -120.0f, 120.0f },
        0.10f,
        800.0f,
        gfl::math::PIVOT_UPSIDE_TO_TOP,
      },
      // ʗp
      { 
        gfl::grp::PROJECTION_ORTHO,
        { -160.0f, 160.0f, -120.0f, 120.0f },
        0.10f,
        800.0f,
        gfl::math::PIVOT_UPSIDE_TO_TOP,
      },
    };


    // r[ϊp[^
    const gfl::grp::ViewParam TouchBar::m_view_parameter[3] = 
    {
      // ( ڗp )
      { 
        gfl::math::VEC3(0,0,1),  // JW
        gfl::math::VEC3(0,1,0),  // 
        gfl::math::VEC3(0,0,0),  // ^[QbgW
      },
      // ( Eڗp )
      { 
        gfl::math::VEC3(10,0,1),  // JW
        gfl::math::VEC3(0,1,0),   // 
        gfl::math::VEC3(10,0,0),  // ^[QbgW
      },
      // ʗp
      { 
        gfl::math::VEC3(0,-290,1),  // JW
        gfl::math::VEC3(0,1,0),     // 
        gfl::math::VEC3(0,-290,0),  // ^[QbgW
      },
    }; 




    // Aj[Vԍ̃e[u
    const TouchBar::AnimationTable TouchBar::m_animation_table = 
    {
      // eACRgp\ɂȂۂɓKpAj[V
      {
        /*ICON_EXIT*/ ANIMATION_EXIT_ICON_ACTIVE,
        /*ICON_RETURN*/ ANIMATION_RETURN_ICON_ACTIVE,
        /*ICON_RETURN_WITH_TEXT*/ ANIMATION_RETURN_ICON_WITH_TEXT_ACTIVE,
        /*ICON_UP*/ ANIMATION_UP_ICON_ACTIVE,
        /*ICON_DOWN*/ ANIMATION_DOWN_ICON_ACTIVE,
        /*ICON_LEFT*/ ANIMATION_LEFT_ICON_ACTIVE,
        /*ICON_RIGHT*/ ANIMATION_RIGHT_ICON_ACTIVE,
        /*ICON_TOUCH_DISABLE*/ ANIMATION_NULL,
        /*ICON_KEY_DISABLE*/ ANIMATION_NULL,
      },
      // eACRgps\ɂȂۂɓKpAj[V
      {
        /*ICON_EXIT*/ ANIMATION_EXIT_ICON_PASSIVE,
        /*ICON_RETURN*/ ANIMATION_RETURN_ICON_PASSIVE,
        /*ICON_RETURN_WITH_TEXT*/ ANIMATION_RETURN_ICON_WITH_TEXT_PASSIVE,
        /*ICON_UP*/ ANIMATION_UP_ICON_PASSIVE,
        /*ICON_DOWN*/ ANIMATION_DOWN_ICON_PASSIVE,
        /*ICON_LEFT*/ ANIMATION_LEFT_ICON_PASSIVE,
        /*ICON_RIGHT*/ ANIMATION_RIGHT_ICON_PASSIVE,
        /*ICON_TOUCH_DISABLE*/ ANIMATION_NULL,
        /*ICON_KEY_DISABLE*/ ANIMATION_NULL,
      },
      // eACR^b`ꂽۂɓKpAj[V
      {
        /*ICON_EXIT*/ ANIMATION_EXIT_ICON_TOUCHED,
        /*ICON_RETURN*/ ANIMATION_RETURN_ICON_TOUCHED,
        /*ICON_RETURN_WITH_TEXT*/ ANIMATION_RETURN_ICON_WITH_TEXT_TOUCHED,
        /*ICON_UP*/ ANIMATION_UP_ICON_TOUCHED,
        /*ICON_DOWN*/ ANIMATION_DOWN_ICON_TOUCHED,
        /*ICON_LEFT*/ ANIMATION_LEFT_ICON_TOUCHED,
        /*ICON_RIGHT*/ ANIMATION_RIGHT_ICON_TOUCHED,
        /*ICON_TOUCH_DISABLE*/ ANIMATION_NULL,
        /*ICON_KEY_DISABLE*/ ANIMATION_NULL,
      },
      // eACR̃^b`ꂽۂɓKpAj[V
      {
        /*ICON_EXIT*/ ANIMATION_EXIT_ICON_RELEASED,
        /*ICON_RETURN*/ ANIMATION_RETURN_ICON_RELEASED,
        /*ICON_RETURN_WITH_TEXT*/ ANIMATION_RETURN_ICON_WITH_TEXT_RELEASED,
        /*ICON_UP*/ ANIMATION_UP_ICON_RELEASED,
        /*ICON_DOWN*/ ANIMATION_DOWN_ICON_RELEASED,
        /*ICON_LEFT*/ ANIMATION_LEFT_ICON_RELEASED,
        /*ICON_RIGHT*/ ANIMATION_RIGHT_ICON_RELEASED,
        /*ICON_TOUCH_DISABLE*/ ANIMATION_NULL,
        /*ICON_KEY_DISABLE*/ ANIMATION_NULL,
      },
      // eACRIꂽۂɓKpAj[V
      {
        /*ICON_EXIT*/ ANIMATION_EXIT_ICON_SELECTED,
        /*ICON_RETURN*/ ANIMATION_RETURN_ICON_SELECTED,
        /*ICON_RETURN_WITH_TEXT*/ ANIMATION_RETURN_ICON_WITH_TEXT_SELECTED,
        /*ICON_UP*/ ANIMATION_UP_ICON_SELECTED,
        /*ICON_DOWN*/ ANIMATION_DOWN_ICON_SELECTED,
        /*ICON_LEFT*/ ANIMATION_LEFT_ICON_SELECTED,
        /*ICON_RIGHT*/ ANIMATION_RIGHT_ICON_SELECTED,
        /*ICON_TOUCH_DISABLE*/ ANIMATION_NULL,
        /*ICON_KEY_DISABLE*/ ANIMATION_NULL,
      },
    };






    //------------------------------------------------------------------------------------
    // RXgN^
    //------------------------------------------------------------------------------------
    TouchBar::TouchBar( 
        gfl::heap::HeapBase* heap, 
        gfl::heap::HeapBase* device_heap,
        const gfl::ui::TouchPanel* touch_panel, 
        const gfl::ui::Button* button, 
        gfl::grp::GraphicsSystem* graphics_system,
        gfl::grp::g2d::LytSys* layout_system,
        const void* layout_resource_data,
        const LayoutInfo& layout_info, 
        const SetupParameter& setup_param ) : 
      m_graphics_system( graphics_system ),
      m_layout_system( layout_system ),
      m_layout_work( NULL ),
      m_upper_layout_env( NULL ),
      m_lower_layout_env( NULL ),
      m_layout_info(),
      m_touch_panel( touch_panel ),
      m_button( button ),
      m_icon_select_type_by_touch( setup_param.icon_select_type_by_touch ),
      m_icon_select_type_by_button( setup_param.icon_select_type_by_button ),
      m_current_touch_icon( ICON_NULL ),
      m_prev_touch_icon( ICON_NULL ),
      m_holding_icon( ICON_NULL ),
      m_selected_icon( ICON_NULL ),
      m_icon_active_flag(),
      m_linked_button_with_icon()
    {
      gfl::std::MemCopy( &layout_info, &(this->m_layout_info), sizeof(LayoutInfo) );
      gfl::std::MemCopy( setup_param.linked_button_with_icon, this->m_linked_button_with_icon, sizeof(this->m_linked_button_with_icon) );
      this->CreateLayoutWork( heap, device_heap, layout_system, layout_resource_data, layout_info );
      this->InitializeIcons( setup_param );
      if( setup_param.string_of_return_icon ) {
        this->SetReturnIconString( setup_param.string_of_return_icon );
      }
    }


    // CAEg[N𐶐
    void TouchBar::CreateLayoutWork( 
        gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap, 
        gfl::grp::g2d::LytSys* layout_system, const void* layout_resource_data, const LayoutInfo& layout_info )
    {
      GFL_ASSERT( m_upper_layout_env == NULL );
      m_upper_layout_env = GFL_NEW( heap ) gfl::grp::g2d::Env();
      m_upper_layout_env->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, m_projection_parameter[0], m_view_parameter[0] );
      m_upper_layout_env->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, m_projection_parameter[0], m_view_parameter[1] );

      GFL_ASSERT( m_lower_layout_env == NULL );
      m_lower_layout_env = GFL_NEW( heap ) gfl::grp::g2d::Env(); 
      m_lower_layout_env->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, m_projection_parameter[1], m_view_parameter[2] );
      m_lower_layout_env->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, m_projection_parameter[1], m_view_parameter[2] );

      gfl::heap::NwAllocator nw_device_allocator( device_heap );
      gfl::grp::g2d::LytResID layout_reousrce_id = layout_system->LoadLytRes( &nw_device_allocator, layout_resource_data );
      layout_system->TransferAllTexture( layout_reousrce_id, gfl::grp::MEMORY_AREA_FCRAM );

      GFL_ASSERT( m_layout_work == NULL ); 
      m_layout_work = layout_system->CreateLytWk(
          layout_reousrce_id, layout_info.layout_data_id, 
          m_layout_info.animation_data_id_table, ANIMATION_DATA_NUM, ANIMATION_NUM, 
          &m_layout_work_setup_data[1], false );  // Aj[VBindȂ

      m_layout_work->SetAutoDrawFlag( false );  // I[g`悵Ȃ
      m_layout_work->SetUserEnv( m_upper_layout_env, m_lower_layout_env );

      m_layout_work->CreateShareAnime( ANIMATION_RETURN_ICON_ACTIVE, m_layout_info.animation_data_id_table[ ANIMATION_DATA_ICON_ACTIVE ] );
      m_layout_work->CreateShareAnime( ANIMATION_RETURN_ICON_PASSIVE, m_layout_info.animation_data_id_table[ ANIMATION_DATA_ICON_PASSIVE ] );
      m_layout_work->CreateShareAnime( ANIMATION_RETURN_ICON_TOUCHED, m_layout_info.animation_data_id_table[ ANIMATION_DATA_ICON_TOUCHED ] );
      m_layout_work->CreateShareAnime( ANIMATION_RETURN_ICON_RELEASED, m_layout_info.animation_data_id_table[ ANIMATION_DATA_ICON_RELEASED ] );
      m_layout_work->CreateShareAnime( ANIMATION_RETURN_ICON_SELECTED, m_layout_info.animation_data_id_table[ ANIMATION_DATA_ICON_SELECTED ] );
    }

    // eACȐԂ
    void TouchBar::InitializeIcons( const SetupParameter& setup_param )
    {
      for( int i=0; i<ICON_NUM; i++ ) {
        if( setup_param.is_icon_active[i] ) {
          this->SetIconActive( static_cast<Icon>(i) );
        }
        else {
          this->SetIconPassive( static_cast<Icon>(i) );
        }
      }
    }

    //u߂v{^ɕteLXgݒ肷
    void TouchBar::SetReturnIconString( const wchar_t* string )
    {
      GFL_ASSERT( m_layout_work );
      gfl::grp::g2d::LytPaneIndex pane_index = m_layout_info.pane_index_of_text_with_return_icon;
      gfl::grp::g2d::LytTextBox* text_pane;
      text_pane = m_layout_work->GetTextBoxPane( pane_index ); 
      GFL_ASSERT( text_pane );
      if( text_pane ) {
        text_pane->SetString( string );
      }
    }






    //------------------------------------------------------------------------------------
    // fXgN^
    //------------------------------------------------------------------------------------
    TouchBar::~TouchBar()
    {
      this->DeleteLayoutWork();
    }

    // CAEg[Nj
    void TouchBar::DeleteLayoutWork( void )
    {
      m_layout_system->RemoveLytWk( m_layout_work );

      if( m_upper_layout_env ) {
        GFL_DELETE m_upper_layout_env; 
        m_upper_layout_env = NULL;
      }

      if( m_lower_layout_env ) {
        GFL_DELETE m_lower_layout_env; 
        m_lower_layout_env = NULL;
      }
    }






    //------------------------------------------------------------------------------------
    // ACR\
    //------------------------------------------------------------------------------------
    void TouchBar::SetIconVisible( Icon icon )
    {
      GFL_ASSERT( icon < ICON_NUM );
      if( icon < ICON_NUM ) {
        gfl::grp::g2d::LytPaneIndex pane_index = m_layout_info.pane_index_of_icon_for_visibility_control[ icon ];
        gfl::grp::g2d::LytPane* pane = m_layout_work->GetPane( pane_index );
        pane->SetVisible( true );
      }
    }


    //------------------------------------------------------------------------------------
    // ACR\ɂ
    //------------------------------------------------------------------------------------
    void TouchBar::SetIconInvisible( Icon icon )
    {
      GFL_ASSERT( icon < ICON_NUM );
      if( icon < ICON_NUM ) {
        gfl::grp::g2d::LytPaneIndex pane_index = m_layout_info.pane_index_of_icon_for_visibility_control[ icon ];
        gfl::grp::g2d::LytPane* pane = m_layout_work->GetPane( pane_index );
        pane->SetVisible( false );
      }
    }







    //------------------------------------------------------------------------------------
    // ACRgp\̏Ԃɂ
    //------------------------------------------------------------------------------------
    void TouchBar::SetIconActive( Icon icon )
    {
      if( !m_icon_active_flag[ icon ] ) {
        this->StopIconPassiveAnimation( icon );
        this->StartIconActiveAnimation( icon );
        m_icon_active_flag[ icon ] = true;
      }
    } 

    
    //------------------------------------------------------------------------------------
    // ACRgps\̏Ԃɂ
    //------------------------------------------------------------------------------------
    void TouchBar::SetIconPassive( Icon icon )
    {
      if( m_icon_active_flag[ icon ] ) {
        this->StopIconActiveAnimation( icon );
        this->StartIconPassiveAnimation( icon );
        m_icon_active_flag[ icon ] = false;
      }
    }



    // ACRgp\ȏԂ\Aj[VJn
    // ( eLXgtu߂vACR𑀍삷ꍇ, teLXgꏏɑ삷 )
    void TouchBar::StartIconActiveAnimation( Icon icon )
    {
      GFL_ASSERT( icon < ICON_NUM );
      if( icon < ICON_NUM ) {
        AnimationId animation_id = m_animation_table.on_icon_active[ icon ];
        this->StartAnimation( animation_id );
      }
      if( icon == ICON_RETURN_WITH_TEXT ) {
        this->StartAnimation( ANIMATION_RETURN_TEXT_ACTIVE );
      }
    }

    // ACRgp\ȏԂ\Aj[V~
    // ( eLXgtu߂vACR𑀍삷ꍇ, teLXgꏏɑ삷 )
    void TouchBar::StopIconActiveAnimation( Icon icon )
    {
      GFL_ASSERT( icon < ICON_NUM );
      if( icon < ICON_NUM ) {
        AnimationId animation_id = m_animation_table.on_icon_active[ icon ];
        this->StopAnimation( animation_id );
      }
      if( icon == ICON_RETURN_WITH_TEXT ) {
        this->StopAnimation( ANIMATION_RETURN_TEXT_ACTIVE );
      }
    }

    // ACRgps\ȏԂ\Aj[VJn
    // ( eLXgtu߂vACR𑀍삷ꍇ, teLXgꏏɑ삷 )
    void TouchBar::StartIconPassiveAnimation( Icon icon )
    {
      GFL_ASSERT( icon < ICON_NUM );
      if( icon < ICON_NUM ) {
        AnimationId animation_id = m_animation_table.on_icon_passive[ icon ];
        this->StartAnimation( animation_id );
      }
      if( icon == ICON_RETURN_WITH_TEXT ) {
        this->StartAnimation( ANIMATION_RETURN_TEXT_PASSIVE );
      }
    } 

    // ACRgps\ȏԂ\Aj[V~
    // ( eLXgtu߂vACR𑀍삷ꍇ, teLXgꏏɑ삷 )
    void TouchBar::StopIconPassiveAnimation( Icon icon )
    {
      GFL_ASSERT( icon < ICON_NUM );
      if( icon < ICON_NUM ) {
        AnimationId animation_id = m_animation_table.on_icon_passive[ icon ];
        this->StopAnimation( animation_id );
      }
      if( icon == ICON_RETURN_WITH_TEXT ) {
        this->StopAnimation( ANIMATION_RETURN_TEXT_PASSIVE );
      }
    }

    // ACR^b`ꂽۂ̃Aj[VJn
    void TouchBar::StartIconTouchedAnimation( Icon icon )
    {
      GFL_ASSERT( icon < ICON_NUM );
      if( icon < ICON_NUM ) {
        AnimationId animation_id = m_animation_table.on_icon_touched[ icon ];
        this->StartAnimation( animation_id );
      }
    }

    // ACR^b`ꂽۂ̃Aj[V~
    void TouchBar::StopIconTouchedAnimation( Icon icon )
    {
      GFL_ASSERT( icon < ICON_NUM );
      if( icon < ICON_NUM ) {
        AnimationId animation_id = m_animation_table.on_icon_touched[ icon ];
        this->StopAnimation( animation_id );
      }
    }

    // ACR̃^b`ꂽۂ̃Aj[VJn
    void TouchBar::StartIconReleasedAnimation( Icon icon )
    {
      GFL_ASSERT( icon < ICON_NUM );
      if( icon < ICON_NUM ) {
        AnimationId animation_id = m_animation_table.on_icon_released[ icon ];
        this->StartAnimation( animation_id );
      }
    }

    // ACR̃^b`ꂽۂ̃Aj[V~
    void TouchBar::StopIconReleasedAnimation( Icon icon )
    {
      GFL_ASSERT( icon < ICON_NUM );
      if( icon < ICON_NUM ) {
        AnimationId animation_id = m_animation_table.on_icon_released[ icon ];
        this->StopAnimation( animation_id );
      }
    } 

    // ACRIꂽۂ̃Aj[VJn
    void TouchBar::StartIconSelectedAnimation( Icon icon )
    {
      GFL_ASSERT( icon < ICON_NUM );
      if( icon < ICON_NUM ) {
        AnimationId animation_id = m_animation_table.on_icon_selected[ icon ];
        this->StartAnimation( animation_id );
      }
    }

    // ACRIꂽۂ̃Aj[V~
    void TouchBar::StopIconSelectedAnimation( Icon icon )
    {
      GFL_ASSERT( icon < ICON_NUM );
      if( icon < ICON_NUM ) {
        AnimationId animation_id = m_animation_table.on_icon_selected[ icon ];
        this->StopAnimation( animation_id );
      }
    }




    // Aj[VJn
    void TouchBar::StartAnimation( AnimationId animation_id )
    {
      if( animation_id < ANIMATION_NUM ) {
        m_layout_work->BindAnime( animation_id );
        m_layout_work->SetAutoAnime( animation_id, true );
        m_layout_work->SetAnimeFrame( animation_id, 0 );
      }
    }

    // Aj[V~
    void TouchBar::StopAnimation( AnimationId animation_id ) 
    {
      if( animation_id < ANIMATION_NUM ) {
        m_layout_work->UnBindAnime( animation_id );
      }
    }




    //------------------------------------------------------------------------------------
    // SẴACȒIAj[VIǂ𒲂ׂ
    //------------------------------------------------------------------------------------
    bool TouchBar::IsSelectedAnimationOfAllIconFinished( void ) const
    {
      for( u32 i=0; i<ICON_NUM; i++ ) {
        AnimationId animation_id = m_animation_table.on_icon_selected[i];
        if( ( animation_id < ANIMATION_NUM ) && m_layout_work->IsBindAnime( animation_id ) && !m_layout_work->IsAnimeEnd( animation_id ) ) {
          return false;
        }
      }
      return true;
    }







    //------------------------------------------------------------------------------------
    // 1t[̍XV
    //------------------------------------------------------------------------------------
    void TouchBar::Update( void )
    {
      m_selected_icon = ICON_NULL;
      m_prev_touch_icon = m_current_touch_icon;
      m_current_touch_icon = this->GetHitIconByCurrentTouch();

      if( m_touch_panel->IsTouchTrigger() ) {
        if( m_icon_select_type_by_touch == ICON_SELECT_TYPE_TRIGGER ) {
          if( ( m_current_touch_icon != ICON_NULL ) && ( m_icon_active_flag[ m_current_touch_icon ] ) ) {
            m_selected_icon = m_current_touch_icon;
            this->StopIconSelectedAnimation( m_selected_icon );
            this->StartIconSelectedAnimation( m_selected_icon );
          }
        }
        else if( m_icon_select_type_by_touch == ICON_SELECT_TYPE_RELEASE ) {
          if( ( m_current_touch_icon != ICON_NULL ) && ( m_icon_active_flag[ m_current_touch_icon ] ) ) {
            m_holding_icon = m_current_touch_icon;
            this->StopIconReleasedAnimation( m_holding_icon );
            this->StartIconTouchedAnimation( m_holding_icon );
          }
        }
      }
      else if( m_touch_panel->IsTouch() ) {
        if( m_icon_select_type_by_touch == ICON_SELECT_TYPE_RELEASE ) {
          if( m_holding_icon != ICON_NULL ) {
            if( ( m_prev_touch_icon == m_holding_icon ) && ( m_current_touch_icon != m_holding_icon ) ) {
              this->StopIconTouchedAnimation( m_holding_icon );
              this->StartIconReleasedAnimation( m_holding_icon );
            }
            else if( ( m_prev_touch_icon != m_holding_icon ) && ( m_current_touch_icon == m_holding_icon ) ) {
              this->StopIconReleasedAnimation( m_holding_icon );
              this->StartIconTouchedAnimation( m_holding_icon );
            }
          }
        }
      }
      else if( m_touch_panel->IsTouchRelease() ) {
        if( m_icon_select_type_by_touch == ICON_SELECT_TYPE_RELEASE ) {
          if( ( m_holding_icon != ICON_NULL ) && ( m_prev_touch_icon == m_holding_icon ) ) {
            m_selected_icon = m_holding_icon;
            this->StopIconTouchedAnimation( m_selected_icon );
            this->StopIconSelectedAnimation( m_selected_icon );
            this->StartIconReleasedAnimation( m_selected_icon );
            this->StartIconSelectedAnimation( m_selected_icon );
            if( m_selected_icon == ICON_EXIT ) {
              xy_snd::PlaySE( SEQ_SE_CLOSE1 );
            }
          }
        }
        m_holding_icon = ICON_NULL;
      }
      else if( ( m_button->GetTrigger() != 0 ) || ( m_button->GetRelease() != 0 ) ) {
        for( int i=0; i<ICON_NUM; i++ ) {
          if( m_icon_active_flag[i] ) {
            u32 linked_button = m_linked_button_with_icon[i];
            if( ( ( m_icon_select_type_by_button == ICON_SELECT_TYPE_TRIGGER ) && m_button->IsTrigger( linked_button ) ) ||
                ( ( m_icon_select_type_by_button == ICON_SELECT_TYPE_RELEASE ) && m_button->IsRelease( linked_button ) ) ) {
              m_selected_icon = static_cast<Icon>(i);
              this->StopIconSelectedAnimation( m_selected_icon );
              this->StartIconSelectedAnimation( m_selected_icon );
              break;
            }
          }
        }
      }

      m_layout_work->Update();  // I[g`悵Ȃ̂ŌʂɍXV
    }


    // ݂̃^b`WHITĂACR擾
    TouchBar::Icon TouchBar::GetHitIconByCurrentTouch( void ) 
    {
      if( !m_layout_work->IsHitCheckOK() ) {  // x`悵ȂƔs
        return ICON_NULL;
      }
      u16 touch_x = m_touch_panel->GetX();
      u16 touch_y = m_touch_panel->GetY();
      gfl::grp::g2d::LytPaneIndex group_index = m_layout_info.group_id_for_icon_hit_check;
      gfl::grp::g2d::LytPaneIndex hit_pane_index = m_layout_work->GetHitPaneIndexGroup( group_index, touch_x, touch_y, false );
      for( u32 i=0; i<ICON_NUM; i++ ) {
        if( hit_pane_index == m_layout_info.pane_index_of_icon_for_hit_check[i] ) {
          return static_cast<Icon>(i);
        }
      }
      return ICON_NULL;
    }



    //------------------------------------------------------------------------------------
    // `悷
    //------------------------------------------------------------------------------------
    void TouchBar::Draw( void )
    {
      gfl::grp::RenderTarget* lower_frame_buffer = m_graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
      m_layout_work->Draw( m_graphics_system, gfl::grp::DISPLAY_LOWER, lower_frame_buffer );  // I[g`悵Ȃ̂Ōʂɕ`悷
    }



    //------------------------------------------------------------------------------------
    // w肵ACRIꂽǂ𒲂ׂ
    //------------------------------------------------------------------------------------
    bool TouchBar::IsIconSelected( Icon icon ) const
    {
      return ( icon == m_selected_icon );
    }






  } // namespace config
} // namespace app 
