//========================================================================================
/**
 * @brief AvʃW[( ^b`o[ )
 * @file app_tool_TouchBar.h
 * @author obata_toshihiro
 * @date 2011.05.17
 *
 * @note  app_tool_TouchBar͎gp֎~ɂȂĂconfigŎgpĂ̂ŁA
 *        namespaceconfigɕςĂƂ肠œ悤ɂBƂŏB
 *
 * @todo Ƃŏ
 */
//========================================================================================
#ifndef __APP_CONFIG_TOUCH_BAR_H__
#define __APP_CONFIG_TOUCH_BAR_H__

namespace app {
  namespace config {

    class TouchBar
    {
      GFL_FORBID_COPY_AND_ASSIGN( TouchBar );

      public:

        /**
         * @brief ^b`o[ɔzuACR
         */
        enum Icon {
          ICON_EXIT,              // I
          ICON_RETURN,            // ߂
          ICON_RETURN_WITH_TEXT,  // eLXgt߂
          ICON_UP,                // 
          ICON_DOWN,              // 
          ICON_LEFT,              // 
          ICON_RIGHT,             // E
          ICON_TOUCH_DISABLE,     // ^b`֎~
          ICON_KEY_DISABLE,       // L[֎~
          ICON_NUM,   // 
          ICON_NULL,  // l
        };

        /**
         * @brief Aj[Vf[^
         */
        enum AnimationData {
          ANIMATION_DATA_ICON_ACTIVE,          // ACRgp\ȏԂɂȂۂ̃Aj[V
          ANIMATION_DATA_ICON_PASSIVE,         // ACRgps\ȏԂɂȂۂ̃Aj[V
          ANIMATION_DATA_ICON_TOUCHED,         // ACR^b`ꂽۂ̃Aj[V
          ANIMATION_DATA_ICON_RELEASED,        // ACR̃^b`ꂽۂ̃Aj[V
          ANIMATION_DATA_ICON_SELECTED,        // ACRIꂽۂ̃Aj[V
          ANIMATION_DATA_RETURN_TEXT_ACTIVE,   // eLXgtu߂vACRgp\ȏԂ̂Ƃ, eLXg̃Aj[V
          ANIMATION_DATA_RETURN_TEXT_PASSIVE,  // eLXgtu߂vACRgps\ȏԂ̂Ƃ, eLXg̃Aj[V
          ANIMATION_DATA_NUM,
        };

        /**
         * @brief CAEgf[^̏
         */
        struct LayoutInfo {
          gfl::grp::g2d::LytArcIndex layout_data_id;                                          // CAEg\[X, CAEgf[^ID
          gfl::grp::g2d::LytArcIndex animation_data_id_table[ ANIMATION_DATA_NUM ];           // CAEg\[X, Aj[Vf[^ID
          u32 group_id_for_icon_hit_check;                                                    // ACR̃^b`̑ΏۂɂȂO[v
          gfl::grp::g2d::LytPaneIndex pane_index_of_icon_for_hit_check[ ICON_NUM ];           // eACR̃^b`̑ΏۂɂȂyC
          gfl::grp::g2d::LytPaneIndex pane_index_of_icon_for_visibility_control[ ICON_NUM ];  // eACR̕\E\𐧌䂷邽߂̃yC
          gfl::grp::g2d::LytPaneIndex pane_index_of_text_with_return_icon;                    //u߂vACRɕteLXgyC
        };

        /**
         * @brief ACȒI@
         */
        enum IconSelectType {
          ICON_SELECT_TYPE_NONE,     // Is
          ICON_SELECT_TYPE_TRIGGER,  // gKI
          ICON_SELECT_TYPE_RELEASE,  // [XI
        }; 

        /**
         * @brief ZbgAbv
         */
        struct SetupParameter {
          IconSelectType icon_select_type_by_touch;   // ^b`͂ɂACȒI@
          IconSelectType icon_select_type_by_button;  // {^͂ɂACȒI@
          u32 linked_button_with_icon[ ICON_NUM ];    // eACRɊ֘At{^( gfl::ui::BUTTON_xxxx )
          bool is_icon_active[ ICON_NUM ];            // eACRgp\ǂ
          wchar_t* string_of_return_icon;             //u߂vACRɕt镶( svȂNULL )
        };

        //--------------------------------------------------------------------------------
        /**
         * @brief RXgN^
         * @param heap                  CX^X̐Ɏgpq[v
         * @param device_heap           CX^X̐ɎgpfoCXq[v
         * @param touch_panel           ^b`o[̐Ɏgp^b`pl
         * @param button                ^b`o[̐Ɏgp{^
         * @param graphics_system       `ɎgpOtBbNXVXe
         * @param layout_system         ^b`o[̕`sCAEgVXe
         * @param layout_resource_data  CAEg\[X̃oCif[^
         * @param layout_info           gp郌CAEgf[^̏
         * @param setup_param           ZbgAbv
         */
        //--------------------------------------------------------------------------------
        TouchBar( 
            gfl::heap::HeapBase* heap, 
            gfl::heap::HeapBase* device_heap, 
            const gfl::ui::TouchPanel* touch_panel, 
            const gfl::ui::Button* button, 
            gfl::grp::GraphicsSystem* graphics_system,
            gfl::grp::g2d::LytSys* layout_system,
            const void* layout_resource_data,
            const LayoutInfo& layout_info, 
            const SetupParameter& setup_param );

        //--------------------------------------------------------------------------------
        /**
         * @brief fXgN^
         */
        //--------------------------------------------------------------------------------
        virtual ~TouchBar();

        //--------------------------------------------------------------------------------
        /**
         * @brief 1t[̍XVs
         */
        //--------------------------------------------------------------------------------
        void Update( void );

        //--------------------------------------------------------------------------------
        /**
         * @brief `悷
         */
        //--------------------------------------------------------------------------------
        void Draw( void );




        // ACR̔

        //--------------------------------------------------------------------------------
        /**
         * @brief w肵ACRIꂽǂ𒲂ׂ
         * @param icon  ׂACR
         * @retval true   Iꂽ
         * @retval false  IĂȂ
         */
        //--------------------------------------------------------------------------------
        bool IsIconSelected( Icon icon ) const;

        //--------------------------------------------------------------------------------
        /**
         * @brief SẴACȒIAj[VIǂ𒲂ׂ
         * @retval true   SẴACȒIAj[VĂ
         * @retval false  IAj[ṼACR݂
         */
        //--------------------------------------------------------------------------------
        bool IsSelectedAnimationOfAllIconFinished( void ) const;




        // ACR̐

        //--------------------------------------------------------------------------------
        /**
         * @brief ACR\
         * @param icon  \ACRw
         */
        //--------------------------------------------------------------------------------
        void SetIconVisible( Icon icon );

        //--------------------------------------------------------------------------------
        /**
         * @brief ACR\ɂ
         * @param icon  \ACRw
         */
        //--------------------------------------------------------------------------------
        void SetIconInvisible( Icon icon );

        //--------------------------------------------------------------------------------
        /**
         * @brief ACRgp\̏Ԃɂ
         * @param icon  gp\ɂACRw
         */
        //--------------------------------------------------------------------------------
        void SetIconActive( Icon icon );
        
        //--------------------------------------------------------------------------------
        /**
         * @brief ACRgps\̏Ԃɂ
         * @param icon  gps\ɂACRw
         */
        //--------------------------------------------------------------------------------
        void SetIconPassive( Icon icon );





      private:

        static const gfl::grp::g2d::LytWkSetUp m_layout_work_setup_data[2];
        static const gfl::grp::ProjectionParam m_projection_parameter[2];
        static const gfl::grp::ViewParam m_view_parameter[3];
        gfl::grp::GraphicsSystem* m_graphics_system;
        gfl::grp::g2d::LytSys* m_layout_system;
        gfl::grp::g2d::LytWk* m_layout_work;
        gfl::grp::g2d::Env* m_upper_layout_env;
        gfl::grp::g2d::Env* m_lower_layout_env;
        LayoutInfo m_layout_info;


        /**
         * @brief CAEg[N𐶐
         * @param arc_file              CAEgf[^܂ރA[JCut@C
         * @param heap                  gpq[v
         * @param device_heap           gpfoCXq[v
         * @param layout_resource_data  CAEg\[X̃oCif[^
         * @param layout_system         CAEg[NǗVXe
         * @param layout_info           CAEgf[^̏
         */
        void CreateLayoutWork( 
            gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap, 
            gfl::grp::g2d::LytSys* layout_system, const void* layout_resource_data, const LayoutInfo& layout_info );

        /**
         * @brief CAEg[Nj
         */
        void DeleteLayoutWork( void );




        /**
         * @brief Aj[Vԍ
         * @note ACR̋ʃAj[V́uIvACRɂ̂ݍ쐬, ̑̃ACR͋LAj[VKp.
         */
        enum AnimationId {
          ANIMATION_EXIT_ICON_ACTIVE,      //uIvACRgp\
          ANIMATION_EXIT_ICON_PASSIVE,     //uIvACRgps\
          ANIMATION_EXIT_ICON_TOUCHED,     //uIvACR^b`ꂽ
          ANIMATION_EXIT_ICON_RELEASED,    //uIvACR̃^b`ꂽ
          ANIMATION_EXIT_ICON_SELECTED,    //uIvACRIꂽ
          ANIMATION_RETURN_TEXT_ACTIVE,    // eLXgtu߂vACRgp\ȏԂ̂Ƃ, eLXg̃Aj[V
          ANIMATION_RETURN_TEXT_PASSIVE,   // eLXgtu߂vACRgps\ȏԂ̂Ƃ, eLXg̃Aj[V
          // ȉALAj[V
          ANIMATION_RETURN_ICON_ACTIVE,              //u߂vACRgp\
          ANIMATION_RETURN_ICON_WITH_TEXT_ACTIVE,    // eLXgtu߂vACRgp\
          ANIMATION_UP_ICON_ACTIVE,                  //uvACRgp\
          ANIMATION_DOWN_ICON_ACTIVE,                //uvACRgp\
          ANIMATION_LEFT_ICON_ACTIVE,                //uvACRgp\
          ANIMATION_RIGHT_ICON_ACTIVE,               //uEvACRgp\
          ANIMATION_RETURN_ICON_PASSIVE,             //u߂vACRgps\
          ANIMATION_RETURN_ICON_WITH_TEXT_PASSIVE,   // eLXgtu߂vACRgps\
          ANIMATION_UP_ICON_PASSIVE,                 //uvACRgps\
          ANIMATION_DOWN_ICON_PASSIVE,               //uvACRgps\
          ANIMATION_LEFT_ICON_PASSIVE,               //uvACRgps\
          ANIMATION_RIGHT_ICON_PASSIVE,              //uEvACRgps\
          ANIMATION_RETURN_ICON_TOUCHED,             //u߂vACR^b`ꂽ
          ANIMATION_RETURN_ICON_WITH_TEXT_TOUCHED,   // eLXgtu߂vACR^b`ꂽ
          ANIMATION_UP_ICON_TOUCHED,                 //uvACR^b`ꂽ
          ANIMATION_DOWN_ICON_TOUCHED,               //uvACR^b`ꂽ
          ANIMATION_LEFT_ICON_TOUCHED,               //uvACR^b`ꂽ
          ANIMATION_RIGHT_ICON_TOUCHED,              //uEvACR^b`ꂽ
          ANIMATION_RETURN_ICON_RELEASED,            //u߂vACR̃^b`ꂽ
          ANIMATION_RETURN_ICON_WITH_TEXT_RELEASED,  // eLXgtu߂vACR̃^b`ꂽ
          ANIMATION_UP_ICON_RELEASED,                //uvACR̃^b`ꂽ
          ANIMATION_DOWN_ICON_RELEASED,              //uvACR̃^b`ꂽ
          ANIMATION_LEFT_ICON_RELEASED,              //uvACR̃^b`ꂽ
          ANIMATION_RIGHT_ICON_RELEASED,             //uEvACR̃^b`ꂽ
          ANIMATION_RETURN_ICON_SELECTED,            //u߂vACRIꂽ
          ANIMATION_RETURN_ICON_WITH_TEXT_SELECTED,  // eLXgtu߂vACRIꂽ
          ANIMATION_UP_ICON_SELECTED,                //uvACRIꂽ
          ANIMATION_DOWN_ICON_SELECTED,              //uvACRIꂽ
          ANIMATION_LEFT_ICON_SELECTED,              //uvACRIꂽ
          ANIMATION_RIGHT_ICON_SELECTED,             //uEvACRIꂽ
          ANIMATION_NUM,   // 
          ANIMATION_NULL,  // l
        }; 

        /**
         * @brief Aj[VJn
         * @param animation_id  JnAj[V̔ԍ
         */
        void StartAnimation( AnimationId animation_id );

        /**
         * @brief Aj[V~
         * @param animation_id  ~Aj[V̔ԍ
         */
        void StopAnimation( AnimationId animation_id );




        /**
         * @brief Aj[Vԍ̃e[u
         */
        struct AnimationTable {
          AnimationId on_icon_active[ ICON_NUM ];    // eACRgp\ɂȂۂɓKpAj[V
          AnimationId on_icon_passive[ ICON_NUM ];   // eACRgps\ɂȂۂɓKpAj[V
          AnimationId on_icon_touched[ ICON_NUM ];   // eACR^b`ꂽۂɓKpAj[V
          AnimationId on_icon_released[ ICON_NUM ];  // eACR̃^b`ꂽۂɓKpAj[V
          AnimationId on_icon_selected[ ICON_NUM ];  // eACRIꂽۂɓKpAj[V
        };
        static const AnimationTable m_animation_table;

        /**
         * @brief ACRgp\ȏԂ\Aj[VJn
         * @param icon  Aj[VJnACR
         * @note eLXgtu߂vACR𑀍삷ꍇ, teLXgꏏɑ삷
         */
        void StartIconActiveAnimation( Icon icon );

        /**
         * @brief ACRgp\ȏԂ\Aj[V~
         * @param icon  Aj[V~ACR
         * @note eLXgtu߂vACR𑀍삷ꍇ, teLXgꏏɑ삷
         */
        void StopIconActiveAnimation( Icon icon );

        /**
         * @brief ACRgps\ȏԂ\Aj[VJn
         * @param icon  Aj[VJnACR
         * @note eLXgtu߂vACR𑀍삷ꍇ, teLXgꏏɑ삷
         */
        void StartIconPassiveAnimation( Icon icon );

        /**
         * @brief ACRgps\ȏԂ\Aj[V~
         * @param icon  Aj[V~ACR
         * @note eLXgtu߂vACR𑀍삷ꍇ, teLXgꏏɑ삷
         */
        void StopIconPassiveAnimation( Icon icon );

        /**
         * @brief ACR^b`ꂽۂ̃Aj[VJn
         * @param icon  Aj[VJnACR
         */
        void StartIconTouchedAnimation( Icon icon );

        /**
         * @brief ACR^b`ꂽۂ̃Aj[V~
         * @param icon  Aj[V~ACR
         */
        void StopIconTouchedAnimation( Icon icon );

        /**
         * @brief ACR̃^b`ꂽۂ̃Aj[VJn
         * @param icon  Aj[VJnACR
         */
        void StartIconReleasedAnimation( Icon icon );

        /**
         * @brief ACR̃^b`ꂽۂ̃Aj[V~
         * @param icon  Aj[V~ACR
         */
        void StopIconReleasedAnimation( Icon icon );

        /**
         * @brief ACRIꂽۂ̃Aj[VJn
         * @param icon  Aj[VJnACR
         */
        void StartIconSelectedAnimation( Icon icon );

        /**
         * @brief ACRIꂽۂ̃Aj[V~
         * @param icon  Aj[V~ACR
         */
        void StopIconSelectedAnimation( Icon icon );






        const gfl::ui::TouchPanel* m_touch_panel;    // ̐Ɏgp^b`pl
        const gfl::ui::Button* m_button;             // ̐Ɏgp{^
        IconSelectType m_icon_select_type_by_touch;  // ^b`͂ɂACȒI@
        IconSelectType m_icon_select_type_by_button; // {^͂ɂACȒI@
        Icon m_current_touch_icon;                   // ݂̃^b`ŐGĂACR
        Icon m_prev_touch_icon;                      // Õ^b`ŐGĂACR
        Icon m_holding_icon;                         // ^b`̃ACR
        Icon m_selected_icon;                        // IꂽACR
        bool m_icon_active_flag[ ICON_NUM ];         // eACRgp\ǂ
        u32 m_linked_button_with_icon[ ICON_NUM ];   // eACRɊ֘Atꂽ{^

        /**
         * @brief eACȐԂ
         * @param setup_param  ZbgAbvp[^
         */
        void InitializeIcons( const SetupParameter& setup_param );

        /**
         * @briefu߂v{^ɕteLXgݒ肷
         * @param string  ݒ肷镶
         */
        void SetReturnIconString( const wchar_t* string ); 

        /**
         * @brief ݂̃^b`WHITĂACR擾
         * @return HITĂACRԍ
         * @retval ICON_NULL  HITĂACRȂꍇ
         */
        Icon GetHitIconByCurrentTouch( void );
    };


  } // namespace config
} // namespace app 

#endif
