#ifndef __AUTOWIFIMATCH_H__
#define __AUTOWIFIMATCH_H__
//================================================================================
/**
 * @file   AutoWifiMatch.h
 * @brief  ŏ̓r[R
           r[R e@ƂȂڑ҂
           r[R̒Ɏq@ɂȂڑɂBBB
           ǂeɂȂ\邩 eɂȂ邩qɂȂ邩̎w肪o悤ɂ
 * @author k.ohno
 * @date   2011.11.15
 */
//================================================================================
#pragma once
#include <gflib.h>
#include <gflnet.h>
#include <netapp/automatch/AutoEachOther.h>
#include <net/XyNetInterface.h>

GFL_NAMESPACE_BEGIN(netapp)



class AutoWifiMatch : public xynet::XyNetInterface {
  GFL_FORBID_COPY_AND_ASSIGN( AutoWifiMatch );

  enum{
    _START,
    _CONNECT,
    _CONNECT_END,
    _CREATE_MASTER,
    _CREATE_MASTER1,
    _CREATE_MASTER2,
    _CREATE_MASTER3,
    _CREATE_MASTER4,
    _CREATE_MASTER5,
    _CREATE_MASTER6,
    _CREATE_MASTER7,
    _CREATE_MASTER8,
    _MATCH_READY,
    _MATCH_READY2,
    _MATCH_READY3,
    _MATCH_READY4,
    _MATCHING,
    _MATCHING_END,
    _MATCHING_END2,
    _LOOP,
    _MATCHING_TIMING1,
    _MATCHING_TIMING2,
    _MATCHING_TIMING3,
    _SHUTDOWN,

  };

  static const int AUTOCONNECT_MAX = 4;

  struct TestBeaconStruct{  //eXgpr[R
    int id1;
    int id2;
  };


public:
  enum{
    AUTOMATCH_BOTH,
    AUTOMATCH_PARENT,
    AUTOMATCH_CHILD,
  };



public:

  //------------------------------------------------------------------
  /**
   * @brief   RXgN^  ʐMڑJn܂
   * @param   heap         VXeHEAP
   * @param   device_heap  foCXHEAP
   * @param   mode         [h eɂȂ邩qɂȂ邩 ǂł̂wł
   */
  //------------------------------------------------------------------
  AutoWifiMatch(  gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap, int connectNum, const int mode);
  virtual ~AutoWifiMatch();
  //------------------------------------------------------------------
  /**
   * @brief   ʐMɐi߂܂
   */
  //------------------------------------------------------------------
  virtual void Update( void );
  //------------------------------------------------------------------
  /**
   * @brief   ʐMIꍇɂт܂  update isEnd=trueɂȂ܂ŌĂŉ
              NetGameNX͉Ăĉ
   */
  //------------------------------------------------------------------
  virtual bool Finalize( void );
  //------------------------------------------------------------------
  /**
   * @brief   ڑǂԂ܂
              ꂪTRUEȂʐM\ł
              NetGameNX쐬đMJnł܂
   * @return  true ڑ
   */
  //------------------------------------------------------------------
  bool isConnect(void);
  //------------------------------------------------------------------
  /**
   * @brief   ʐMIǂԂ܂
   * @return  true I fXgN^Ăł
   */
  //------------------------------------------------------------------
  virtual bool IsFinalized(void);


private:

  bit64 mTransferedID[AUTOCONNECT_MAX];   //
  gfl::heap::HeapBase* mpSystemHeap;
  gfl::heap::HeapBase* mpDevHeap;
  gflnet::p2p::P2pManager* mpP2pManager;
  gflnet::p2p::NetGame*  mpNetGame;     //x[Xpnetgame
  netapp::beacon::AutoEachOther* mAutoEachOther;
  gflnet::p2p::NetPlayer* mpNetPlayer[AUTOCONNECT_MAX];
  int mConnectNum;

#if PM_DEBUG
  int debugno;
#endif


  int mStep;
  int mMode;
  bool mbEnd;
  bool mbConnected;

  void initP2p(void );

};



GFL_NAMESPACE_END(netapp)
#endif //__AUTOWIFIMATCH_H__
