#if PM_DEBUG

//================================================================================
/**
 * @file   test_ohno_wifi.cpp
 * @brief  Ct@CP2P̎
 * @author k.ohno
 * @date   2012.4.30
 */
//================================================================================
#include <nn.h>
#include <gflib.h>
#include <gflnet.h>
#include <gamesystem/GameManager.h>
#include <gamesystem/GameProcManager.h>
#include "test/ohno/test_ohno_battle.h"
#include <system/gfl_use.h>

GFL_NAMESPACE_BEGIN(test)
GFL_NAMESPACE_BEGIN(ohno)




//-----------------------------------------------------------------------------
// RXgN^
//-----------------------------------------------------------------------------
TestOhnoWifi::TestOhnoWifi(
  gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
  gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
  gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager ) :
Base( heap, device_heap, heap_allocator, device_allcator, graphics_system, ui_device_manager )
{

  mpSystemHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  mpDevHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );


  if(m_button->IsHold( gfl::ui::BUTTON_X )){
    mpAutoMatch = GFL_NEW(mpSystemHeap) netapp::AutoWifiMatch( mpSystemHeap, mpDevHeap,2,netapp::AutoMatch::AUTOMATCH_PARENT );
    NN_LOG("\n");
  }
  else if(m_button->IsHold( gfl::ui::BUTTON_Y )){
    mpAutoMatch = GFL_NEW(mpSystemHeap) netapp::AutoWifiMatch( mpSystemHeap,mpDevHeap,2,netapp::AutoMatch::AUTOMATCH_BOTH );
    NN_LOG("\n");
  }
  else{
    mpAutoMatch = GFL_NEW(mpSystemHeap) netapp::AutoWifiMatch( mpSystemHeap, mpDevHeap,2,netapp::AutoMatch::AUTOMATCH_CHILD );
    NN_LOG("q\n");
  }
  mStep=0;
}


//-----------------------------------------------------------------------------
// fXgN^
//-----------------------------------------------------------------------------
TestOhnoWifi::~TestOhnoWifi()
{
  GFL_DELETE mpAutoMatch;
}


//-----------------------------------------------------------------------------
// C
//-----------------------------------------------------------------------------


void TestOhnoWifi::UpdateTest( void )
{

  enum{
    _START,
    _CONNECT,
    _CONNECT2,
    _CONNECT3,
    _CONNECT4,
    _CONNECT5,
    _CONNECT6,
    _CONNECT7,
    _NETGAME_INIT,
    _NETGAME_COMM,

    _END_START,
    _END_START2,
	  _CONNECT_END,
	  _SHUTDOWN,

	};


//  mpAutoMatch->Update();
  if(mStepBK!=mStep){
    NN_LOG("test_ohno_step %d\n",mStep);
    mStepBK = mStep;
  }
  
  switch(mStep){
  case _START:
    if(mpAutoMatch->isConnect()){
      NN_LOG("mpAutoMatch->isConnect\n ");
      mStep++;
      gflnet::p2p::GameInitialize  initialize;

      initialize.max         = 2;
      initialize.pHeapSystem = mpSystemHeap;
      mNetGame = GFL_NEW(mpSystemHeap) gflnet::p2p::NetGame( &initialize,NULL );

    }
    break;
  case _CONNECT:
/*    if( m_button->IsTrigger( gfl::ui::BUTTON_A ) ){
      mStep = _END_START;
      break;
    }
    if( m_button->IsTrigger( gfl::ui::BUTTON_B ) ){
      mNetGame->Initialize();
      mStep++;
    }
  */
      NN_LOG("Init\n ");
    mNetGame->Initialize();
    mStep++;
    break;
  case _CONNECT2:
    if(mNetGame->IsInitialize()){
      NN_LOG("mNetGame1\n ");
      mStep++;
    }
    break;
  case _CONNECT3:
    {
      gflnet::p2p::GameInitialize  initialize;
      initialize.max         = 2;
      initialize.pHeapSystem = mpSystemHeap;
      mNetGame2 = GFL_NEW(mpSystemHeap) gflnet::p2p::NetGame( &initialize,NULL );
      mNetGame2->Initialize();
      mStep++;
    }
    break;
  case _CONNECT4:
    if(mNetGame2->IsInitialize()){
      NN_LOG("mNetGame2\n ");
      mStep++;
    }
    break;
  case _CONNECT5:
    {
      gflnet::p2p::GameInitialize  initialize;
      initialize.max         = 2;
      initialize.pHeapSystem = mpSystemHeap;
      mNetGame3 = GFL_NEW(mpSystemHeap) gflnet::p2p::NetGame( &initialize,NULL );
      mNetGame3->Initialize();
      mStep++;
    }
    break;
  case _CONNECT6:
    if(mNetGame3->IsInitialize()){
      mNetGame3->TimingStart(33);
      NN_LOG("mNetGame3\n ");
      mStep++;
    }
    break;
  case _CONNECT7:
    if( mNetGame3->IsTimingEnd(33) ){
      char buff[]="123-444";
      mNetGame3->SendData( buff , 10);
      NN_LOG("_NETGAME_COMM\n ");
      mStep++;
    }
    break;
    
  case _NETGAME_INIT:
/*    if(mNetGame->IsInitialize()){
      NN_LOG("_NETGAME_INIT\n ");
      mStep++;
    }
    break;
*/
  case _NETGAME_COMM:
    if( m_button->IsTrigger( gfl::ui::BUTTON_A ) ){
      mStep = _END_START;
      break;
    }
    if( m_button->IsTrigger( gfl::ui::BUTTON_B ) ){
      char buff[]="123456";
      mNetGame->SendData( buff , 10);
      NN_LOG("_NETGAME_COMM\n ");
    }

    for(int i=0;i<4;i++){
      char buff[128];
      if( mNetGame3->RecvData( i, buff, 127) ){
        buff[127]=0;
        NN_LOG("RECV %s\n",buff);
      }
    }
    for(int i=0;i<4;i++){
      char buff[128];
      if( mNetGame->RecvData( i, buff, 127) ){
        buff[127]=0;
        NN_LOG("RECV %s\n",buff);
      }
    }
    for(int i=0;i<4;i++){
      char buff[128];
      if( mNetGame2->RecvData( i, buff, 127) ){
        buff[127]=0;
        NN_LOG("RECV %s\n",buff);
      }
    }

    break;
  case _END_START:
    if(mNetGame->IsTimingLoopCheck(100)){
      mStep++;
    }
    break;
  case _END_START2:
    NN_LOG("mpAutoMatch->End\n ");
    mpAutoMatch->Finalize();
    if( mNetGame ){
      GFL_DELETE( mNetGame );
      mNetGame = NULL;
      mStep++;
    }
    break;
  case _CONNECT_END:
    if(mpAutoMatch->IsFinalized()){
      mStep++;
    }
    break;
  case _SHUTDOWN:
    this->End();
    mStep++;
    break;
  }

}



//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void TestOhnoWifi::DrawTest( void )
{

}


GFL_NAMESPACE_END(ohno)
GFL_NAMESPACE_END(test)

#endif // PM_DEBUG
