//================================================================================
/**
 * @file   AutoWifiMatch.cpp
 * @brief  Wifiɐڑ@ɌĐڑ܂
           p͂܂Ȃ eXgɋ߂
 * @author k.ohno
 * @date   2012.4.30
 */
//================================================================================
#include <gflib.h>
#include <gflnet.h>
#include <gamesystem/GameManager.h>
#include <gamesystem/GameProcManager.h>
#include "netapp/automatch/AutoWifiMatch.h"
#include "net/net_define.h"
#include <system/gfl_use.h>
#include "netapp/cfg/NetConfig.h"

GFL_NAMESPACE_BEGIN(netapp)


//------------------------------------------------------------------
/**
 * @brief   RXgN^  ʐMڑJn܂
 * @param   heap         VXeHEAP
 * @param   device_heap  foCXHEAP
 * @param   mode         [h eɂȂ邩qɂȂ邩 ǂł̂wł
 */
//------------------------------------------------------------------

AutoWifiMatch::AutoWifiMatch(
  gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap, int connectnum, const int mode)
{

  mpSystemHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_NETWORK );
  mpDevHeap = gfl::heap::Manager::GetHeapByHeapId(HEAPID_SHAREPLAY_DEVICE);



  TestBeaconStruct tbs = {12,13};
  mConnectNum = connectnum;

  bool bSearchMode = false;
  if(mode==AUTOMATCH_PARENT){
    NN_LOG("ɂP  \n");
    bSearchMode=true;
  }
  mAutoEachOther = GFL_NEW(mpSystemHeap) netapp::beacon::AutoEachOther( mpSystemHeap, mpDevHeap,bSearchMode );
  mAutoEachOther->Initialize(reinterpret_cast<const u8*>( &tbs ), false);

  mMode = mode;
  mStep = 0;
  mbConnected = false;
  mbEnd = false;
#if PM_DEBUG
  debugno = 0;
#endif
  GFL_SINGLETON_INSTANCE(xynet::XyNetManager)->Initialize(this);

}


//-----------------------------------------------------------------------------
// fXgN^
//-----------------------------------------------------------------------------
AutoWifiMatch::~AutoWifiMatch()
{
  GFL_SINGLETON_INSTANCE(xynet::XyNetManager)->Finalize();

  GFL_DELETE mAutoEachOther;
  GFL_DELETE mpNetGame;
  GFL_DELETE mpP2pManager;

  for(int i=0;i<AUTOCONNECT_MAX;i++){
    if(mpNetPlayer[i]){
      GFL_DELETE mpNetPlayer[i];
    }
  }
}


//------------------------------------------------------------------
/**
 * @brief   ʐMɐi߂܂
 */
//------------------------------------------------------------------


void AutoWifiMatch::Update( void )
{
  gfl::proc::MainStatus ms;
  if(mpP2pManager){
    ms = mpP2pManager->NetMain();
  }

  switch(mStep){
  case _START:
    if(mMode == AUTOMATCH_PARENT){
      mStep++;
    }
    else if (mMode == AUTOMATCH_CHILD) {
      mStep = _MATCH_READY;
    }
    break;
  case _CONNECT:
    mStep++;
    break;
  case _CONNECT_END:
    mStep++;
    break;
  case _CREATE_MASTER:
    initP2p();
    mStep++;
    break;
  case _CREATE_MASTER1:
    mpP2pManager->Connect();
    NN_LOG("ConnectJn\n");
    mStep++;
    break;
  case _CREATE_MASTER2:
    if(mpP2pManager->IsConnectEnd() && (ms == gfl::proc::MAINSTATUS_NULL)){
      mStep++;
    }
    break;
  case _CREATE_MASTER3:
    mpNetPlayer[0] = GFL_NEW(mpSystemHeap) gflnet::p2p::NetPlayer();
    mpNetPlayer[0]->SetTransferedID( mTransferedID[0] );
    NN_LOG("AddPlayer %llu\n", mTransferedID[0]);
    mpNetGame->Initialize();
    mpP2pManager->CreateMaster(mpNetPlayer[0]);
    if(mConnectNum != 2 ){
      for(int z = 1 ; z < mConnectNum-1; z++){
        mpNetPlayer[z] = GFL_NEW(mpSystemHeap) gflnet::p2p::NetPlayer();
        mpNetPlayer[z]->SetTransferedID( mTransferedID[z] );
        mpP2pManager->AddPlayer( mpNetPlayer[z] );
        NN_LOG("AddPlayer %llu\n", mTransferedID[z]);
      }
    }
    mStep++;
    break;
  case _CREATE_MASTER4:
    {
      mStep++;
    }
    break;
  case _CREATE_MASTER5:
    if(!mpNetGame->IsInitialize()){
      break;
    }
#if PM_DEBUG
    if(debugno != mpP2pManager->GetConnectionCount()){
      debugno = mpP2pManager->GetConnectionCount();
      NN_LOG("%dlڑ lŊJn\n", debugno);
    }
#endif
    {
      int num = mpP2pManager->GetConnectionCount();
      if( mConnectNum == num ){
        if(mpP2pManager->GameStart()){
          mStep++;
          NN_LOG("Jn\n");
          mbConnected = true;
        }
      }
    }
    break;
  case _CREATE_MASTER6:
    mStep++;
    break;
  case _CREATE_MASTER7:
    break;
  case _CREATE_MASTER8:
    break;
  case _MATCH_READY:
    mStep++;
    break;
  case _MATCH_READY2:
    initP2p();
    mStep++;
    break;
  case _MATCH_READY3:
    mpP2pManager->Connect();
    mStep++;
    break;
  case _MATCH_READY4:
    if(mpP2pManager->IsConnectEnd() && (ms == gfl::proc::MAINSTATUS_NULL)){
      mStep++;
    }
    break;
  case _MATCHING:
    mpNetPlayer[0] = GFL_NEW(mpSystemHeap) gflnet::p2p::NetPlayer();
    mpNetPlayer[0]->SetTransferedID( mTransferedID[0] );
    mpNetGame->Initialize();
    mpP2pManager->Matching(mpNetPlayer[0]);
    mStep++;
    break;
  case _MATCHING_END:
    if(!mpP2pManager->IsMatchingEnd()){
      break;
    }
    if(!mpNetGame->IsInitialize()){
      break;
    }
    mStep++;
    break;
  case _MATCHING_END2:
    //ڑJn
    mbConnected=true;
    mStep++;
    NN_LOG("A{^ŊJn\n");
    break;
  case _LOOP:

    //ڑ

    break;
  case _MATCHING_TIMING1:
    break;
  case _MATCHING_TIMING2:
    break;
  case _MATCHING_TIMING3:
    // I
    mStep++;
    mpP2pManager->Disconnect();
    mpP2pManager->Shutdown();
    mpNetGame->Finalize();
    break;
  case _SHUTDOWN:
    if(mpP2pManager->IsShutdownEnd()){
      mStep++;
      mbEnd = true;
      //   this->End();
    }
    break;
  }

}



void AutoWifiMatch::initP2p( void )
{
  gflnet::p2p::NETWORK_CONFIG cfg = {
    0,//  u32 maxSilenceTime;
    0,//  u32 keepAliveTimeout;
    0,//  u32 maxWindowMapSize;
    false,//  bool useUserDO;   //IuWFNg Duplicated Object̂
    // lbg[Ng|W֘AB
    nn::nex::NetworkTopology::Peer2Peer,
    false, // bool testRouting;

    // bZ[Woh֘A
    false, //  bool enableMessageBundle;
    0,//  u16  messageBundleFlushDelay;
    0,//  u16  messageBundleFlushCheckPeriod;

    // pPbgoh֘A
    false,//  bool enablePacketBundle;
    0,//  u32  packetBundleFlushDelay;

  };

  gflnet::InitParameter netInitParam = {
    0,
    mpSystemHeap,
    mpDevHeap,
    NULL,
    gflnet::TYPE_WIFI_P2P,
    true,
    DEBUG_GAMENO_MATCH,
    mConnectNum, //ڑl
    10,
  };

  gflnet::InitParameterFixed netInitParamFix = {
    XY_PRODUCT_CODE,  //
    0,  //܂̓}WbN @todo
    0, //܂̓}WbN @todo
    XY_NET_VERSION, //
  };


  netInitParam.TransferedID = netapp::cfg::GetTransferableId();
  mpP2pManager = GFL_NEW(mpSystemHeap) gflnet::p2p::P2pManager( mpSystemHeap,  mpDevHeap, mpSystemHeap );
  mpP2pManager->Initialize( &cfg,&netInitParam,&netInitParamFix );

  gflnet::p2p::GameInitialize init;
  init.max = mConnectNum;
  NN_LOG("ڑJnl %d\n", mConnectNum);
  init.pHeapSystem = mpSystemHeap;  //ʐMŎgHEAPID
  mpNetGame = GFL_NEW( mpSystemHeap ) gflnet::p2p::NetGame(&init, mpP2pManager->GetInitParam());
}



//------------------------------------------------------------------
/**
 * @brief   ʐMIꍇɂт܂  update isEnd=trueɂȂ܂ŌĂŉ
 */
//------------------------------------------------------------------
bool AutoWifiMatch::Finalize( void )
{
  mStep = _MATCHING_TIMING3;
  return true;
}

//------------------------------------------------------------------
/**
 * @brief   ڑǂԂ܂
 * @return  true ڑ
 */
//------------------------------------------------------------------
bool AutoWifiMatch::isConnect(void)
{
  return mbConnected;
}

//------------------------------------------------------------------
/**
 * @brief   ʐMIǂԂ܂
 * @return  true I fXgN^Ăł
 */
//------------------------------------------------------------------
bool AutoWifiMatch::IsFinalized(void)
{
  return mbEnd;
}




GFL_NAMESPACE_END(netapp)
