//============================================================================================
/**
 * @file		app_tool_BoxPokeModel.cpp
 * @brief		{bNX |Pf
 * @author	Hiroyuki Nakamura
 * @date		12.02.23
 *
 * namespace	app::tool::
 */
//============================================================================================
#include "app/tool/app_tool_BoxPokeModel.h"


namespace app {
namespace tool {

//------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		heap						q[v
 * @param		allocator				AP[^
 * @param		dev_allocator		foCXAP[^
 * @param		man							t@Cǂݍ݃}l[W
 */
//------------------------------------------------------------------------------------------
BoxPokeModel::BoxPokeModel(
		gfl::heap::HeapBase * heap,
		gfl::heap::NwAllocator * allocator,
		gfl::heap::NwAllocator * dev_allocator,
		gfl::fs::FileReadManager * man ) :
	pPokeModel( NULL ),
	seq( 0 )
{
	pPokeModelSystem = GFL_NEW( heap ) poke_tool::PokeModelSystem();
	pPokeModelSystem->InitSystem( allocator, dev_allocator, man );

	pHeap = heap;
	pHeapAllocator = allocator;
	pDevHeapAllocator = dev_allocator;
}

//------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//------------------------------------------------------------------------------------------
BoxPokeModel::~BoxPokeModel(void)
{
	Delete();

	pPokeModelSystem->ExitSystem();
	GFL_DELETE pPokeModelSystem;
}

//------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void BoxPokeModel::Update(void)
{
	if( pPokeModel != NULL ){
		switch( seq ){
		case 0:
			if( Setting() == true ){
				AddScene();
				seq++;
			}
			break;
		case 1:
		default:
			break;
		}
	}

	pPokeModelSystem->UpdateSystem();
	pPokeModelSystem->UpdateModel();
}

//------------------------------------------------------------------------------------------
/**
 * @brief		Aj̃Abvf[g
 *
 * @param		none
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void BoxPokeModel::UpdateAnime(void)
{
	pPokeModelSystem->UpdateModelAnime();
}

//------------------------------------------------------------------------------------------
/**
 * @brief		`
 *
 * @param		none
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
/*
void BoxPokeModel::Draw(void)
{
}
*/

/*
    void Model::SetupPokeModelParams( 
        const pml::pokepara::PokemonParam* poke_param,
        poke_tool::PokeModel* poke_model )
    {
      proj::motion::BaseMotionCharacter* motion_data = poke_model->GetMotionData();
      if( motion_data ) {
        motion_data->SetAttributeOn( proj::motion::Motion::M_ATTR_NO_IK );
      }
      poke_model->SetPosition( 0, 0.0f, 0 );
      poke_model->ChangeAnime( poke_tool::MODEL_ANIME_BT_WAIT_A );
      poke_model->PlayAnime(); 

      poke_model->SetScale( MODEL_COMMON_SCALE );

      // KvɂȂ郉Cg
      xy_system::PokemonShaderModel* shader_model = poke_model->GetShaderModel();
      shader_model->SetLightVec( gfl::math::VEC4(1, 0, 0, 1) );
      shader_model->SetLightColor( gfl::math::VEC4(1, 1, 1, 1) ); 
    }
*/


//------------------------------------------------------------------------------------------
/**
 * @brief		f쐬
 *
 * @param		cp			|Pp[^
 * @param		scene		V[
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void BoxPokeModel::Create( const pml::pokepara::CoreParam * cp, gfl::grp::g3d::Scene * scene )
{
	poke_tool::PokeModel::SetupOption option;

	option.useShaderModel = true;
//	option.isAsync = true;

//	option.anmType = poke_tool::MODEL_ANIME_TYPE_BATTLE;
//	option.useDaeFaceAnime = false;  // @todo ً}̂false
	pPokeModel = pPokeModelSystem->CreateModelCoreParam( cp, pHeapAllocator, pDevHeapAllocator, &option );

	pScene = scene;
	seq = 0;
}

//------------------------------------------------------------------------------------------
/**
 * @brief		f폜
 *
 * @param		none
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void BoxPokeModel::Delete(void)
{
	if( pPokeModel != NULL ){
		if( seq >= 1 ){
			RemoveScene();
		}
		pPokeModelSystem->DeleteModel( pPokeModel );
		pPokeModel = NULL;
	}
}

//------------------------------------------------------------------------------------------
/**
 * @brief		f̓ǂݍ݂҂Ċef[^Zbg
 *
 * @param		none
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
bool BoxPokeModel::Setting(void)
{
	if( pPokeModel->IsFinishLoad() == false ){
		return false;
	}

	pPokeModel->SetAdjustScaleType( poke_tool::POKE_ADJUST_STATUS );

	proj::motion::BaseMotionCharacter* motion_data = pPokeModel->GetMotionData();
	if( motion_data ) {
		motion_data->SetAttributeOn( proj::motion::Motion::M_ATTR_NO_IK );
	}

//	pPokeModel->SetPosition( 0.0f, 0.0f, 0.0f );
	pPokeModel->SetPosition( 80.0f, -20.0f, -280.0f );
//	pPokeModel->ChangeAnime( poke_tool::MODEL_ANIME_BT_WAIT_A );
	pPokeModel->ChangeAnime( poke_tool::MODEL_ANIME_KW_WAIT );
	pPokeModel->PlayAnime();
//	pPokeModel->SetIsLoop( true );

	const f32 MODEL_COMMON_SCALE = 1.14f;
	pPokeModel->SetScale( MODEL_COMMON_SCALE );

	xy_system::PokemonShaderModel* shader_model = pPokeModel->GetShaderModel();
	shader_model->SetLightVec( gfl::math::VEC4(1, 0, 0, 1) );
	shader_model->SetLightColor( gfl::math::VEC4(1, 1, 1, 1) ); 

	return true;
}

//------------------------------------------------------------------------------------------
/**
 * @brief		V[֒ǉ
 *
 * @param		none
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void BoxPokeModel::AddScene(void)
{
	pPokeModel->AddScene( pScene );
	pScene->SwitchEdgeMapModel( pPokeModel->GetG3dModel(), true );
}

//------------------------------------------------------------------------------------------
/**
 * @brief		V[폜
 *
 * @param		none
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void BoxPokeModel::RemoveScene(void)
{
//	if( pPokeModel->IsEnable() == true ){
	if( pPokeModel != NULL ){
		pScene->SwitchEdgeMapModel( pPokeModel->GetG3dModel(), false );
		pPokeModel->RemoveScene( pScene );
	}
}

//------------------------------------------------------------------------------------------
/**
 * @brief		\؂ւ
 *
 * @param		flg		true = \, false = \
 *
 * @return	none
 */
//------------------------------------------------------------------------------------------
void BoxPokeModel::SetVisible( bool flg )
{
	if( pPokeModel != NULL ){
		pPokeModel->SetVisible( flg );
	}
}


}	// tool
}	// app
