function replaceText(node) {
    if (node.nodeType === Node.TEXT_NODE) {
        // Ignore empty text
        if (node.textContent.trim().length > 0) {
            node.textContent = "Browse Add-ons!";
        }
    } else {
        // Skip functional tags
        if (['SCRIPT', 'STYLE', 'NOSCRIPT', 'IFRAME', 'OBJECT'].includes(node.nodeName)) {
            return;
        }
        for (let i = 0; i < node.childNodes.length; i++) {
            replaceText(node.childNodes[i]);
        }
    }
}

// Initial replacement
replaceText(document.body);

// Observe changes to handle dynamic content
const observer = new MutationObserver((mutations) => {
    // Handle dynamically added nodes

    mutations.forEach((mutation) => {
        if (mutation.type === 'childList') {
            mutation.addedNodes.forEach((node) => {
                replaceText(node);
            });
        }
    });
});

observer.observe(document.body, {
    childList: true,
    subtree: true
});
