;---------------------------------------------------------------------------
; Specials / Statdef's : 1000 - 1999
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
; PSICO BLAST
;---------------------------------------------------------------------------
[Statedef 1000]
type    = S
movetype= A
physics = N
juggle  = 1
velset = 0,0
poweradd = 100
anim = 1000
ctrl = 0
sprpriority = 0

[State 0, PlaySnd]
type = PlaySnd
trigger1 = animelem = 2
value = 8,1

[State 0, PlaySnd]
type = PlaySnd
trigger1 = animelem = 2
value = 800,5
channel = 2

[state 1000, Psico Blast]
type = helper
trigger1 = AnimElem = 3
name = "Psico Blast"
ID = 1001
stateno = 1001
postype = p1
facing = 1
ownpal = 1
keyctrl = 0
size.xscale = 1;0.7
size.yscale = 1;0.5

[State 1000, 2]
type = Projectile
trigger1 = AnimElem = 3
trigger2 = AnimElem = 5
ProjID = 1002
projanim = 1002
projhitanim = 1004
projremanim = 1004
projcancelanim = 1004
velocity = 30,0
offset = 20,-85
; HitDef
attr = S,SP
hitflag = MAF        ;HLAFD+-
guardflag = MA         ;HLA
animtype = low
priority = 4,Hit   ;Hit,Miss,Dodge
damage = 30,3
pausetime = 4,4
;postype = P2
sparkno = -1
guard.sparkno = -1;s9993
hitsound   = S8000,2
guardsound = S8000,6
ground.type = Low
ground.slidetime = 8
ground.hittime  = 10
ground.velocity = -4
air.velocity = -4,-1

[State 1000, End]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------
;Psico Blast (helper)
[Statedef 1001]
type = S
movetype = A
physics = N
ctrl = 0
velset = 0, 0
sprpriority = 4
anim = 1001

[state 1105, Parent Bind]
type = bindtoparent
trigger1 = 1
pos = 20, -85

[state 1105, Special Effect]
type = assertspecial
trigger1 = 1
flag = noshadow

[state 1105, Vulnerability]
type = nothitby
trigger1 = 1
value = SCA
time = -1

[state 1105, Attack Distance]
type = attackdist
trigger1 = 1
value = const(size.proj.attack.dist)

[state 1105, Destroy]
type = destroyself
trigger1 = time = 30 || root,movetype = H
trigger2 = (root,stateno != [1000,1050]) || (root,anim != [1000,1050])
trigger3 = root,time <= 1

;---------------------------------------------------------------------------
; PSICO BLAST AIR
;---------------------------------------------------------------------------
[Statedef 1050]
type    = A
movetype= A
physics = N
juggle  = 1
velset = 0,0
poweradd = 100
anim = 1050
ctrl = 0
sprpriority = 0

[State 0, PlaySnd]
type = PlaySnd
trigger1 = animelem = 2
value = 800,5
channel = 2

[state 1050, Psico Blast]
type = helper
trigger1 = AnimElem = 3
name = "Psico Blast Air"
ID = 1051
stateno = 1051
postype = p1
facing = 1
ownpal = 1
keyctrl = 0
size.xscale = 1;0.7
size.yscale = 1;0.5

[State 1050, 2]
type = Projectile
trigger1 = AnimElem = 3
trigger2 = AnimElem = 5
ProjID = 1002
projanim = 1002
projhitanim = 1004
projremanim = 1004
projcancelanim = 1004
velocity = 30,0
offset = 20,-90
; HitDef
attr = S,SP
hitflag = MAF        ;HLAFD+-
guardflag = MA         ;HLA
animtype = low
priority = 4,Hit   ;Hit,Miss,Dodge
damage = 30,3
pausetime = 4,4
;postype = P2
sparkno = -1
guard.sparkno = -1;s9993
hitsound   = S8000,2
guardsound = S8000,6
ground.type = Low
ground.slidetime = 8
ground.hittime  = 10
ground.velocity = -4
air.velocity = -4,-1

[State 1050, End]
type = ChangeState
trigger1 = AnimTime = 0
value = 70
ctrl = 1

;---------------------------------------------
;Psico Blast (helper)
[Statedef 1051]
type = S
movetype = A
physics = N
ctrl = 0
velset = 0, 0
sprpriority = 4
anim = 1001

[state 1051, Parent Bind]
type = bindtoparent
trigger1 = 1
pos = 20, -90

[state 1051, Special Effect]
type = assertspecial
trigger1 = 1
flag = noshadow

[state 1051, Vulnerability]
type = nothitby
trigger1 = 1
value = SCA
time = -1

[state 1051, Attack Distance]
type = attackdist
trigger1 = 1
value = const(size.proj.attack.dist)

[state 1051, Destroy]
type = destroyself
trigger1 = time = 30 || root,movetype = H
trigger2 = (root,stateno != [1000,1050]) || (root,anim != [1000,1050])
trigger3 = root,time <= 1


;---------------------------------------------------------------------------
; CINECTIC UP
;---------------------------------------------------------------------------
[Statedef 1100]
type    = S
movetype= A
physics = N
juggle  = 1
velset = 0,0
poweradd = 100
anim = 1100
ctrl = 0
sprpriority = 2

[State 200, 1]
type = PlaySnd
trigger1 = animelem = 3
value = 1000, 3+random%3

[State 1100, Explod]
type = Explod
trigger1 = animelem = 5
anim = 1112
id = 1112
postype = p1
pos = 100,0
vel = 0,-25
sprpriority = 2
removetime = 20
persistent = 0
bindtime = 1
ownpal = 1
scale = 1,1

[State 1100, Explod]
type = Explod
trigger1 = animelem = 5
anim = 1111
id = 1111
postype = p1
pos = 90,0
;vel = 10
sprpriority = 2
removetime = 18
persistent = 0
bindtime = 1
ownpal = 1
scale = 0.7,1

[State 1100, Explod]
type = Explod
trigger1 = animelem = 5
anim = 1110
id = 1110
postype = p1
pos = 90,0
;vel = 10
sprpriority = 3
removetime = 18
persistent = 0
bindtime = 1
ownpal = 1
scale = 0.7,1

[State 1100, Helper]
type = Helper
triggerall = NumHelper(1105) = 0
trigger1 = animelem = 5
helpertype = normal ;player
name = "Cinectic Wave"
ID = 1105
stateno = 1105
pos = 100,0;-60,floor(P2Dist Y);-floor(Pos Y)
postype = p1    ;p2,front,back,left,right
;facing = -1
supermovetime = 0
pausemovetime = 0

[State 1100, End]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;------------------------------------
;Cinectic Wave
[Statedef 1105]
type    = A
movetype= A
physics = N
anim = 1105
ctrl = 0
sprpriority = 2
velset = 0,0
;facep2 = 1

[State 1105]
type = HitDef
trigger1 = time = 0
attr = A, SA
animtype  = Medium
damage    = 65,6
hitflag = MAFD
guardflag = MA
pausetime = 12,12
sparkno = 2
guard.sparkno = 2
sparkxy = -10,-64+floor(P2Dist Y)
hitsound   = S8000,2
guardsound = S8000,6
ground.type = High
ground.slidetime = 10
ground.hittime  = 20
ground.velocity = -3,-12
air.velocity = -3,-8
down.velocity = -3,-2
fall = 1

[State 1105]
type = DestroySelf
trigger1 = AnimTime = 0
;trigger1 = root, stateno !=3000

;---------------------------------------------------------------------------
[Statedef 1110]
type    = S
movetype= A
physics = N
juggle  = 1
velset = 0,0
poweradd = 100
anim = 1100
ctrl = 0
sprpriority = 2

[State 200, 1]
type = PlaySnd
trigger1 = animelem = 3
value = 1000, 3+random%3

[State 1100, Explod]
type = Explod
trigger1 = animelem = 5
anim = 1112
id = 1112
postype = p1
pos = 170,0
vel = 0,-25
sprpriority = 2
removetime = 30
persistent = 0
bindtime = 1
ownpal = 1
scale = 1,1

[State 1100, Explod]
type = Explod
trigger1 = animelem = 5
anim = 1111
id = 1111
postype = p1
pos = 160,0
;vel = 10
sprpriority = 2
removetime = 18
persistent = 0
bindtime = 1
ownpal = 1
scale = 0.7,1

[State 1100, Explod]
type = Explod
trigger1 = animelem = 5
anim = 1110
id = 1110
postype = p1
pos = 160,0
;vel = 10
sprpriority = 3
removetime = 18
persistent = 0
bindtime = 1
ownpal = 1
scale = 0.7,1

[State 1100, Helper]
type = Helper
triggerall = NumHelper(1105) = 0
trigger1 = animelem = 5
helpertype = normal ;player
name = "Cinectic Wave"
ID = 1105
stateno = 1105
pos = 170,0;-60,floor(P2Dist Y);-floor(Pos Y)
postype = p1    ;p2,front,back,left,right
;facing = -1
supermovetime = 0
pausemovetime = 0

[State 1100, End]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
[Statedef 1120]
type    = S
movetype= A
physics = N
juggle  = 1
velset = 0,0
poweradd = 100
anim = 1100
ctrl = 0
sprpriority = 2

[State 200, 1]
type = PlaySnd
trigger1 = animelem = 3
value = 1000, 3+random%3

[State 1100, Explod]
type = Explod
trigger1 = animelem = 5
anim = 1112
id = 1112
postype = p1
pos = 240,0
vel = 0,-25
sprpriority = 2
removetime = 30
persistent = 0
bindtime = 1
ownpal = 1
scale = 1,1

[State 1100, Explod]
type = Explod
trigger1 = animelem = 5
anim = 1111
id = 1111
postype = p1
pos = 230,0
;vel = 10
sprpriority = 2
removetime = 18
persistent = 0
bindtime = 1
ownpal = 1
scale = 0.7,1

[State 1100, Explod]
type = Explod
trigger1 = animelem = 5
anim = 1110
id = 1110
postype = p1
pos = 230,0
;vel = 10
sprpriority = 3
removetime = 18
persistent = 0
bindtime = 1
ownpal = 1
scale = 0.7,1

[State 1100, Helper]
type = Helper
triggerall = NumHelper(1105) = 0
trigger1 = animelem = 5
helpertype = normal ;player
name = "Cinectic Wave"
ID = 1105
stateno = 1105
pos = 240,0;-60,floor(P2Dist Y);-floor(Pos Y)
postype = p1    ;p2,front,back,left,right
;facing = -1
supermovetime = 0
pausemovetime = 0

[State 1100, End]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1


;---------------------------------------------------------------------------
; VOADORA
;---------------------------------------------------------------------------
;Voadora Start A
[Statedef 1200]
type    = A
movetype= A
physics = N
juggle  = 1
velset = 0,0
poweradd = 100
anim = 1200
ctrl = 0
sprpriority = 2

[State 200, 1]
type = PlaySnd
trigger1 = animelem = 1
value = 1000, 7+random%3

[State 1200, VelSet]
type = VelSet
trigger1 = animelem = 1
x = 5

[State 1200, VelSet]
type = VelSet
trigger1 = animelem = 6
x = 15

[State 1200, VelSet]
type = VelSet
trigger1 = animelem = 9
x = 2

[State 1200, VelSet]
type = VelSet
trigger1 = animelem >= 5
trigger1 = movecontact
x = 2

[State 1200, 2]
type = HitDef
trigger1 = animelem = 4
attr = S, NA
animtype  = Hard
damage    = 30,3
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -6
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15

[State 1200, 2]
type = HitDef
trigger1 = animelem = 5
attr = S, NA
animtype  = Hard
damage    = 10,1
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -6
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15
fall = 1

[State 1200, 2]
type = HitDef
trigger1 = animelem >= 6
attr = S, NA
animtype  = Hard
damage    = 60,6
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -5,-2
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15
fall = 1

[State 1200, End]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
;Voadora Start B
[Statedef 1210]
type    = A
movetype= A
physics = N
juggle  = 1
velset = 0,0
poweradd = 100
anim = 1210
ctrl = 0
sprpriority = 2

[State 200, 1]
type = PlaySnd
trigger1 = animelem = 1
value = 1000, 7+random%3

[State 1210]
type = AngleSet
trigger1 = 1
value = 10;fvar(0)
ignorehitpause = 1

[State 1210]
type = AngleDraw
trigger1 = 1
ignorehitpause = 1

[State 1210, VelSet]
type = VelSet
trigger1 = animelem = 1
x = 5
y = -1

[State 1210, VelSet]
type = VelSet
trigger1 = animelem = 6
x = 15
y = -2

[State 1210, VelSet]
type = VelSet
trigger1 = animelem = 9
x = 2
y = -0.5

[State 1210, VelSet]
type = VelSet
trigger1 = animelem >= 5
trigger1 = movecontact
x = 2
y = -0.5

[State 1210, 2]
type = HitDef
trigger1 = animelem = 4
attr = S, NA
animtype  = Hard
damage    = 30,3
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -6
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15

[State 1210, 2]
type = HitDef
trigger1 = animelem = 5
attr = S, NA
animtype  = Hard
damage    = 10,1
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -6
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15
fall = 1

[State 1210, 2]
type = HitDef
trigger1 = animelem >= 6
attr = S, NA
animtype  = Hard
damage    = 60,6
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -5,-2
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15
fall = 1

[State 1210, End]
type = ChangeState
trigger1 = AnimTime = 0
value = 70
ctrl = 1

;---------------------------------------------------------------------------
;Voadora Start C
[Statedef 1220]
type    = A
movetype= A
physics = N
juggle  = 1
velset = 0,0
poweradd = 100
anim = 1220
ctrl = 0
sprpriority = 2

[State 200, 1]
type = PlaySnd
trigger1 = animelem = 1
value = 1000, 7+random%3

[State 1220]
type = AngleSet
trigger1 = 1
value = 25;fvar(0)
ignorehitpause = 1

[State 1220]
type = AngleDraw
trigger1 = 1
ignorehitpause = 1

[State 1220, VelSet]
type = VelSet
trigger1 = animelem = 1
x = 5
y = -2.5

[State 1220, VelSet]
type = VelSet
trigger1 = animelem = 6
x = 15
y = -5

[State 1220, VelSet]
type = VelSet
trigger1 = animelem = 9
x = 2
y = -1.25

[State 1220, VelSet]
type = VelSet
trigger1 = animelem >= 5
trigger1 = movecontact
x = 2
y = -1.25

[State 1220, 2]
type = HitDef
trigger1 = animelem = 4
attr = S, NA
animtype  = Hard
damage    = 30,3
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -6
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15

[State 1220, 2]
type = HitDef
trigger1 = animelem = 5
attr = S, NA
animtype  = Hard
damage    = 10,1
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -6
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15
fall = 1

[State 1220, 2]
type = HitDef
trigger1 = animelem >= 6
attr = S, NA
animtype  = Hard
damage    = 60,6
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -5,-2
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15
fall = 1

[State 1220, End]
type = ChangeState
trigger1 = AnimTime = 0
value = 70
ctrl = 1

;---------------------------------------------------------------------------
; VOADORA AIR
;---------------------------------------------------------------------------
;Voadora Start AIR A
[Statedef 1250]
type    = A
movetype= A
physics = N
juggle  = 1
velset = 0,0
poweradd = 100
anim = 1250
ctrl = 0
sprpriority = 2

[State 200, 1]
type = PlaySnd
trigger1 = animelem = 1
value = 1000, 7+random%3

[State 1250, VelSet]
type = VelSet
trigger1 = animelem = 1
x = 5

[State 1250, VelSet]
type = VelSet
trigger1 = animelem = 6
x = 15

[State 1250, VelSet]
type = VelSet
trigger1 = animelem = 9
x = 2

[State 1250, VelSet]
type = VelSet
trigger1 = animelem >= 5
trigger1 = movecontact
x = 2

[State 1250, 2]
type = HitDef
trigger1 = animelem = 4
attr = S, NA
animtype  = Hard
damage    = 30,3
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -6
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15

[State 1250, 2]
type = HitDef
trigger1 = animelem = 5
attr = S, NA
animtype  = Hard
damage    = 10,1
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -6
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15
fall = 1

[State 1250, 2]
type = HitDef
trigger1 = animelem >= 6
attr = S, NA
animtype  = Hard
damage    = 60,6
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -5,-2
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15
fall = 1

[State 1250, End]
type = ChangeState
trigger1 = AnimTime = 0
value = 70
ctrl = 1

;---------------------------------------------------------------------------
;Voadora Start Air B
[Statedef 1260]
type    = A
movetype= A
physics = N
juggle  = 1
velset = 0,0
poweradd = 100
anim = 1260
ctrl = 0
sprpriority = 2

[State 200, 1]
type = PlaySnd
trigger1 = animelem = 1
value = 1000, 7+random%3

[State 1260]
type = AngleSet
trigger1 = 1
value = 25;fvar(0)
ignorehitpause = 1

[State 1260]
type = AngleDraw
trigger1 = 1
ignorehitpause = 1

[State 1260, VelSet]
type = VelSet
trigger1 = animelem = 1
x = 5
y = -2.5

[State 1260, VelSet]
type = VelSet
trigger1 = animelem = 6
x = 15
y = -5

[State 1260, VelSet]
type = VelSet
trigger1 = animelem = 9
x = 2
y = -1.25

[State 1260, VelSet]
type = VelSet
trigger1 = animelem >= 5
trigger1 = movecontact
x = 2
y = -1.25

[State 1260, 2]
type = HitDef
trigger1 = animelem = 4
attr = S, NA
animtype  = Hard
damage    = 30,3
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -6
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15

[State 1260, 2]
type = HitDef
trigger1 = animelem = 5
attr = S, NA
animtype  = Hard
damage    = 10,1
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -6
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15
fall = 1

[State 1260, 2]
type = HitDef
trigger1 = animelem >= 6
attr = S, NA
animtype  = Hard
damage    = 60,6
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -5,-2
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15
fall = 1

[State 1260, End]
type = ChangeState
trigger1 = AnimTime = 0
value = 70
ctrl = 1

;---------------------------------------------------------------------------
;Voadora Start Air C
[Statedef 1270]
type    = A
movetype= A
physics = N
juggle  = 1
velset = 0,0
poweradd = 100
anim = 1270
ctrl = 0
sprpriority = 2

[State 200, 1]
type = PlaySnd
trigger1 = animelem = 1
value = 1000, 7+random%3

[State 1270]
type = AngleSet
trigger1 = 1
value = -35;fvar(0)
ignorehitpause = 1

[State 1270]
type = AngleDraw
trigger1 = 1
ignorehitpause = 1

[State 1270, VelSet]
type = VelSet
trigger1 = animelem = 1
x = 5
y = 2.5

[State 1270, VelSet]
type = VelSet
trigger1 = animelem = 6
x = 15
y = 5

[State 1270, VelSet]
type = VelSet
trigger1 = animelem = 9
x = 2
y = 1.25

[State 1270, VelSet]
type = VelSet
trigger1 = animelem >= 5
trigger1 = movecontact
x = 2
y = 1.25

[State 1270, 2]
type = HitDef
trigger1 = animelem = 4
attr = S, NA
animtype  = Hard
damage    = 30,3
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -6
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15

[State 1270, 2]
type = HitDef
trigger1 = animelem = 5
attr = S, NA
animtype  = Hard
damage    = 10,1
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -6
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15
fall = 1

[State 1270, 2]
type = HitDef
trigger1 = animelem >= 6
attr = S, NA
animtype  = Hard
damage    = 60,6
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 12,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 18
ground.hittime  = 15
ground.velocity = -5,-2
guard.velocity = -6
guard.hittime = 15
guard.ctrltime = 15
fall = 1

[State 1270, End]
type = ChangeState
trigger1 = AnimTime = 0
value = 70
ctrl = 1

[State 1331]
type = ChangeState
trigger1 = Pos Y >= 0
trigger1 = Vel Y > 0
value = 52
ctrl = 0

;---------------------------------------------------------------------------
; FLIGHT
;---------------------------------------------------------------------------
;Flight Start
[Statedef 1330]
type    = A
movetype= I
physics = N
poweradd= 20
ctrl = 0
velset = 0,-4
anim = 1330
sprpriority = 2

[State 1330]
type = VarSet
trigger1 = Time = 0
var(54) = 1

[State 1330]
type = ChangeState
trigger1 = AnimTime = 0 && var(54) >= 1
value = 1335
ctrl = 0

;---------------------------------------------------------------------------
;Flight Cancel
[Statedef 1331]
type    = A
movetype= I
physics = N
ctrl = 1
velset = 0,0
anim = 70
sprpriority = 2

[State 1331]
type = VarSet
trigger1 = Time = 0
var(54) = 0

[State 1331]
type = VelAdd
trigger1 = Pos Y < 0
y = 0.35

[State 1331]
type = ChangeState
trigger1 = Pos Y >= 0
trigger1 = Vel Y > 0
value = 52
ctrl = 0

;---------------------------------------------------------------------------
;Flight End
[Statedef 1332]
type    = A
movetype= I
physics = A
ctrl = 1
velset = 0,0
anim = 70
sprpriority = 2

[State 1331]
type = VarSet
trigger1 = Time = 0
var(54) = 0

[State 1332]
type = ChangeState
trigger1 = Pos Y >= 0
trigger1 = Vel Y > 0
value = 52
ctrl = 1

;---------------------------------------------------------------------------
;Flight after S Jump
[Statedef 1333]
type    = S
physics = S
anim = 40
ctrl = 0
sprpriority = 1

[State 1333]
type = PlaySnd
trigger1 = Time = 1
value = 7710,0
channel = 1

[State 1333]
type = Explod
trigger1 = Time = 1
anim = 7055
ownpal = 1

[State 1333]
type = Explod
trigger1 = Time = 1
anim = 7055
facing = -1
ownpal = 1

[State 1333]
type = Explod
trigger1 = Time = 1
anim = 7022
sprpriority = 4
ownpal = 1

[State 1333, 1]
type = VarSet
trigger1 = Time = 0
sysvar(1) = 0

[State 1333, 2]
type = VarSet
trigger1 = command = "holdfwd"
sysvar(1) = 1

[State 1333, 3]
type = VarSet
trigger1 = command = "holdback"
sysvar(1) = -1

[State 1333, 6]
type = ChangeState
trigger1 = AnimTime = 0
value = 1334
ctrl = 0

;---------------------------------------------------------------------------
; Super Jump Up
[Statedef 1334]
type    = A
physics = N

[State 1334, 4]
type = VelSet
trigger1 = Time = 0
y = -15;-13

[State 1334, 4]
type = VelAdd
trigger1 = 1
y = 0.35;0.4

[State 1334]
type = veladd
triggerall = vel x <= 4
trigger1 = var(59)
trigger1 = p2bodydist x >= 0
persistent = 4
x = .9

[State 1334]
type = veladd
triggerall = vel x >= -4
trigger1 = var(59)
trigger1 = p2bodydist x <= 0
persistent = 4
x = -.9

[State 1334]
type = Explod
trigger1 = Time%4 = 0
trigger1 = Time >= 4
trigger1 = Vel Y < 0
anim = 7056
pos = 0,0
random = 50,0
ontop = 1

[State 1334]
type = Explod
trigger1 = Time%2 = 0
trigger1 = Time >= 12
trigger1 = Vel Y < 0
anim = 7057+random%3
pos = 0,0
random = 60,0
ontop = 1

[State 1334, 2]
type = ChangeAnim
trigger1 = Time = 0
value = ifelse((vel x)=0, 41, ifelse((vel x)>0, 42, 43))

[State 1334, 3]
type = ChangeAnim
trigger1 = Vel y > -2
trigger1 = SelfAnimExist(anim + 3)
persistent = 0
value = Anim + 3

[State 1334]
type = turn
trigger1 = p2dist x < -5

[State 1334]
type = ChangeState
trigger1 = Vel Y > -1
value = 1330

;---------------------------------------------------------------------------
; Flight
[Statedef 1335]
type    = A
physics = N
anim = 1331
velset = 0,0
movetype= I
sprpriority = 2
ctrl = 1

[State 1335]
type = Turn
trigger1 = FrontEdgeDist < 15
trigger2 = enemy(0),facing = facing
trigger2 = Time%4 = 0

[State 1335]
type = PosAdd
trigger1 = Pos Y > -10
y = -4

[State 1335]
type = VarSet
trigger1 = 1
sysvar(1) = 0

[State 1335]
type = VarSet
trigger1 = Time = 0
var(1) = 0

[State 1335]
type = VarSet
trigger1 = p2bodydist x != 0
var(1) = ifelse((p2bodydist y/p2bodydist x = [0.4,0.8]),1,0)

[State 1335]
type = ChangeState
trigger1 = var(59)
trigger1 = !var(1)
trigger1 = p2bodydist x > 200
value = 1340

[State 1335]
type = ChangeState
trigger1 = var(59)
trigger1 = !var(1)
trigger1 = p2bodydist x < 70
value = ifelse(BackEdgeDist > 70,1345,1340)

[State 1335]
type = ChangeState
trigger1 = var(59)
trigger1 = !var(1)
trigger1 = p2bodydist y < 170;240
value = 1342

[State 1335]
type = ChangeState
trigger1 = var(59)
trigger1 = !var(1)
trigger1 = p2bodydist y > 240;480
value = 1344

;---------------------------------
[State 1335] ;Frente
type = VarSet
trigger1 = command = "holdfwd"
trigger1 = command != "holdup"
trigger1 = command != "holddown"
trigger2 = var(59)
trigger2 = !var(1)
trigger2 = p2bodydist x > 200
sysvar(1) = 1

[State 1335] ;Tras
type = VarSet
trigger1 = command = "holdback"
trigger1 = command != "holdup"
trigger1 = command != "holddown"
trigger2 = var(59)
trigger2 = !var(1)
trigger2 = p2bodydist x < 70
sysvar(1) = -1

[State 1335, 3] ;Frente cima
type = VarSet
trigger1 = command = "holdfwd"
trigger1 = command = "holdup"
sysvar(1) = 2

[State 1335, 3] ;Tras cima
type = VarSet
trigger1 = command = "holdback"
trigger1 = command = "holdup"
sysvar(1) = -2

[State 1335, 3] ;Cima
type = VarSet
trigger1 = command != "holdfwd"
trigger1 = command != "holdback"
trigger1 = command = "holdup"
trigger2 = var(59)
trigger2 = !var(1)
trigger2 = p2bodydist y < 170
sysvar(1) = 3

[State 1335, 3] ;Baixo
type = VarSet
trigger1 = command = "holddown"
trigger1 = command != "holdfwd"
trigger1 = command != "holdback"
trigger2 = var(59)
trigger2 = !var(1)
trigger2 = p2bodydist y > 240
sysvar(1) = -3

[State 1335, 3] ;Baixo frente
type = VarSet
trigger1 = command = "holdfwd"
trigger1 = command = "holddown"
sysvar(1) = 4

[State 1335, 3] ;Baixo tras
type = VarSet
trigger1 = command = "holddown"
trigger1 = command = "holdback"
sysvar(1) = -4
;-------------------------------------

[State 1335]
type = VarSet
trigger1 = command = "x" && command = "y"
var(1) = 4

;------------------------------------
[State 1335]
type = ChangeAnim
triggerall = anim != 1331
triggerall = (Pos Y > -20)
trigger1 = sysvar(1) = -3
value = 1331

[State 1335]
type = ChangeAnim
triggerall = anim != 1340
trigger1 = sysvar(1) = 1
value = 1340

[State 1335]
type = ChangeAnim
triggerall = anim != 1341
trigger1 = sysvar(1) = -1
value = 1341

[State 1335]
type = ChangeAnim
triggerall = anim != 1344
trigger1 = sysvar(1) = 2
value = 1344

[State 1335]
type = ChangeAnim
triggerall = anim != 1345
trigger1 = sysvar(1) = -2
value = 1345

[State 1335]
type = ChangeAnim
triggerall = anim != 1342
trigger1 = sysvar(1) = 3
value = 1342

[State 1335]
type = ChangeAnim
triggerall = anim != 1343
triggerall = (Pos Y < -20)
trigger1 = sysvar(1) = -3
value = 1343

[State 1335]
type = ChangeAnim
triggerall = anim != 1340
trigger1 = sysvar(1) = 4
value = 1340

[State 1335]
type = ChangeAnim
triggerall = anim != 1341
trigger1 = sysvar(1) = -4
value = 1341

;------------------------------------
[State 1335]
type = VelSet
trigger1 = sysvar(1) = 0
y = 0
x = 0

[State 1335]
type = VelSet
trigger1 = sysvar(1) = 1
x = 5
y = 0

[State 1335]
type = VelSet
trigger1 = sysvar(1) = -1
x = -5
y = 0

[State 1335]
type = VelSet
trigger1 = sysvar(1) = 2
x = 4
y = -4+4*(ScreenPos Y < 0)

[State 1335]
type = VelSet
trigger1 = sysvar(1) = -2
x = -4
y = -4+4*(ScreenPos Y < 0)

[State 1335]
type = VelSet
trigger1 = sysvar(1) = 3
y = -4+4*(ScreenPos Y < 0)
x = 0

[State 1335]
type = VelSet
trigger1 = sysvar(1) = -3
y = 4-4*(Pos Y > -20)
x = 0

[State 1335]
type = VelSet
trigger1 = sysvar(1) = 4
y = 4-4*(Pos Y > -20)
x = 4

[State 1335]
type = VelSet
trigger1 = sysvar(1) = -4
y = 4-4*(Pos Y > -20)
x = -4

;-----------------------------
[State 1335]
type = ChangeAnim
triggerall = anim != 1331
trigger1 = sysvar(1) = 0
value = 1331

[State 1335]
type = ChangeState
trigger1 = var(54) = 0
value = 1331
ctrl = 0

;----------------------------------------------------------
; Air Dash Forward
[Statedef 1340]
type    = A
physics = N
anim = 1340
sprpriority = 0
velset = 0,0
ctrl = 1

[State 1340]
type = PlaySnd
trigger1 = Time = 1
value = 105,2

[State 1340]
type = VelSet
trigger1 = AnimElemNo(0) = [1,2]
x = 7

[State 1340] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 1340]
type = CtrlSet
trigger1 = Time = 4
value = 1

[State 1340]
type = ChangeState
trigger1 = Time = 20 && var(54)
value = 1335
ctrl = 1

[State 1340]
type = ChangeState
trigger1 = Time = 20 && !var(54)
value = 635
ctrl = 1

;----------------------------------------------------------
; Air Dash Forward Up
[Statedef 1341]
type    = A
physics = N
anim = 1340
sprpriority = 0
velset = 0,0

[State 1341]
type = PlaySnd
trigger1 = Time = 2
value = 105,2

[State 1341]
type = VelSet
trigger1 = 1
x = 5
y = -10

[State 1341] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 1341]
type = CtrlSet
trigger1 = Time = 4
value = 1

[State 1341]
type = VelSet
trigger1 = ScreenPos Y < 120
x = 0
y = 0

[State 1341]
type = ChangeState
trigger1 = Time = 17 && var(54)
value = 1335
ctrl = 1

[State 1341]
type = ChangeState
trigger1 = Time = 17 && !var(54)
value = 1332
ctrl = 1

;----------------------------------------------------------
; Air Dash Up
[Statedef 1342]
type    = A
physics = N
anim = 1342
sprpriority = 0
velset = 0,0

[State 1342]
type = PlaySnd
trigger1 = Time = 3
value = 105,2

[State 1342]
type = VelSet
trigger1 = 1
x = 0
y = -8

[State 1342]
type = VelSet
trigger1 = ScreenPos Y < 120
x = 0
y = 0

[State 1342] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 1342]
type = CtrlSet
trigger1 = Time = 4
value = 1

[State 1342]
type = ChangeState
trigger1 = Time = 17 && var(54)
value = 1335
ctrl = 1

[State 1342]
type = ChangeState
trigger1 = Time = 17 && !var(54)
value = 1332
ctrl = 1

;----------------------------------------------------------
; Air Dash Forward Down
[Statedef 1343]
type    = A
physics = N
anim = 1340
sprpriority = 0
velset = 0,0

[State 1343]
type = PlaySnd
trigger1 = Time = 3
value = 105,2

[State 1343]
type = VelSet
trigger1 = 1
x = 5
y = 10

[State 1343] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 1343]
type = CtrlSet
trigger1 = Time = 4
value = 1

[State 1343]
type = ChangeState
trigger1 = (Time = 17 || Pos Y >= 0) && var(54)
value = 1335
ctrl = 1

[State 1343]
type = ChangeState
trigger1 = (Time = 17 || Pos Y >= 0) && !var(54)
value = 1332
ctrl = 1

;----------------------------------------------------------
; Air Dash Down
[Statedef 1344]
type    = A
physics = N
anim = 1342
sprpriority = 0
velset = 0,0

[State 1344]
type = PlaySnd
trigger1 = Time = 3
value = 105,2

[State 1344]
type = VelSet
trigger1 = 1
x = 0
y = 8

[State 1344] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 1344]
type = CtrlSet
trigger1 = Time = 4
value = 1

[State 1344]
type = ChangeState
trigger1 = (Time = 17 || Pos Y >= 0) && var(54)
value = 1335
ctrl = 1

[State 1344]
type = ChangeState
trigger1 = (Time = 17 || Pos Y >= 0) && !var(54)
value = 1332
ctrl = 1

;---------------------------------------------------------------------------
; Air Dash Back
[Statedef 1345]
type    = A
physics = N
ctrl = 0
anim = 1341
sprpriority = 0

[State 1345]
type = PlaySnd
trigger1 = Time = 3
value = 105,2

[State 1345]
type = VelSet
trigger1 = AnimElemNo(0) = [1,2]
x = -7

[State 1345] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 1345]
type = CtrlSet
trigger1 = Time = 4
value = 1

[State 1345]
type = ChangeState
trigger1 = Time = 17 && var(54)
value = 1335
ctrl = 1

[State 1345]
type = ChangeState
trigger1 = Time = 17 && !var(54)
value = 1332
ctrl = 1

;---------------------------------------------------------------------------
; Air Dash Back Up
[Statedef 1346]
type    = A
physics = N
ctrl = 0
anim = 1341
sprpriority = 0

[State 1346]
type = PlaySnd
trigger1 = Time = 3
value = 105,2

[State 1346]
type = VelSet
trigger1 = 1
x = -5
y = -10

[State 1346] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 1346]
type = CtrlSet
trigger1 = Time = 4
value = 1

[State 1346]
type = VelSet
trigger1 = ScreenPos Y < 120
x = 0
y = 0

[State 1346]
type = ChangeState
trigger1 = Time = 17 && var(54)
value = 1335
ctrl = 1

[State 1346]
type = ChangeState
trigger1 = Time = 17 && !var(54)
value = 1332
ctrl = 1

;---------------------------------------------------------------------------
; Air Dash Back Down
[Statedef 1347]
type    = A
physics = N
ctrl = 0
anim = 1341
sprpriority = 0

[State 1347]
type = PlaySnd
trigger1 = Time = 3
value = 105,2

[State 1347]
type = VelSet
trigger1 = 1
x = -5
y = 10

[State 1347] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 1347]
type = CtrlSet
trigger1 = Time = 4
value = 1

[State 1347]
type = ChangeState
trigger1 = (Time = 17 || Pos Y >= 0) && var(54)
value = 1335
ctrl = 1

[State 1347]
type = ChangeState
trigger1 = (Time = 17  || Pos Y >= 0) && !var(54)
value = 1332
ctrl = 1

;---------------------------------------------------------------------------
; MEDITAO
;---------------------------------------------------------------------------
;Meditao
[Statedef 1400]
type    = S
movetype= I
physics = S
poweradd = 100
anim = 1400
ctrl = 0
sprpriority = 2

[State 1400, End]
type = ChangeState
trigger1 = animtime = 0
value = 1401
ctrl = 0

;------------------------------------
;stand
[Statedef 1401]
type    = A
movetype= I
physics = N
anim = 1401
ctrl = 0
sprpriority = 2
velset = 0,0

[State 1401, PowerAdd]
type = PowerAdd
triggerall = NumHelper(1420) = 0
triggerall = NumHelper(1430) = 0
triggerall = NumHelper(1440) = 0
triggerall = NumHelper(1450) = 0
triggerall = NumHelper(1460) = 0
triggerall = NumHelper(1470) = 0
trigger1 = Time%1 = 0
value = 10
persistent = 1

[State 1401, Explod]
type = Explod
trigger1 = time = 1
anim = 1405
id = 1405
postype = p1
pos = -8,-103
;vel = 10
sprpriority = 3
removetime = -1
persistent = 0
bindtime = 1
ownpal = 1
scale = 1,1

[State 1401, Helper]
type = Helper
triggerall = NumHelper(1420) = 0
triggerall = NumHelper(1430) = 0
triggerall = NumHelper(1440) = 0
triggerall = NumHelper(1450) = 0
triggerall = NumHelper(1460) = 0
triggerall = NumHelper(1470) = 0
trigger1 = Command = "x"
helpertype = normal ;player
name = "Comando X"
ID = 1420
stateno = 1420
pos = 100,-180;-60,floor(P2Dist Y);-floor(Pos Y)
postype = p2    ;p2,front,back,left,right
facing = -1
supermovetime = 0
pausemovetime = 0

[State 1401, Helper]
type = Helper
triggerall = NumHelper(1420) = 0
triggerall = NumHelper(1430) = 0
triggerall = NumHelper(1440) = 0
triggerall = NumHelper(1450) = 0
triggerall = NumHelper(1460) = 0
triggerall = NumHelper(1470) = 0
trigger1 = Command = "y"
helpertype = normal ;player
name = "Comando Y"
ID = 1430
stateno = 1430
pos = 70,-20;-60,floor(P2Dist Y);-floor(Pos Y)
postype = p2    ;p2,front,back,left,right
facing = -1
supermovetime = 0
pausemovetime = 0

[State 1401, Helper]
type = Helper
triggerall = NumHelper(1420) = 0
triggerall = NumHelper(1430) = 0
triggerall = NumHelper(1440) = 0
triggerall = NumHelper(1450) = 0
triggerall = NumHelper(1460) = 0
triggerall = NumHelper(1470) = 0
trigger1 = Command = "z"
helpertype = normal ;player
name = "Comando Z"
ID = 1440
stateno = 1440
pos = 90,0;-60,floor(P2Dist Y);-floor(Pos Y)
postype = p2    ;p2,front,back,left,right
facing = -1
supermovetime = 0
pausemovetime = 0

[State 1401, Helper]
type = Helper
triggerall = NumHelper(1420) = 0
triggerall = NumHelper(1430) = 0
triggerall = NumHelper(1440) = 0
triggerall = NumHelper(1450) = 0
triggerall = NumHelper(1460) = 0
triggerall = NumHelper(1470) = 0
trigger1 = Command = "a"
helpertype = normal ;player
name = "Comando A"
ID = 1450
stateno = 1450
pos = 90,0;-60,floor(P2Dist Y);-floor(Pos Y)
postype = p2    ;p2,front,back,left,right
facing = -1
supermovetime = 0
pausemovetime = 0

[State 1401, Helper]
type = Helper
triggerall = NumHelper(1420) = 0
triggerall = NumHelper(1430) = 0
triggerall = NumHelper(1440) = 0
triggerall = NumHelper(1450) = 0
triggerall = NumHelper(1460) = 0
triggerall = NumHelper(1470) = 0
trigger1 = Command = "b"
helpertype = normal ;player
name = "Comando B"
ID = 1460
stateno = 1460
pos = 90,0;-60,floor(P2Dist Y);-floor(Pos Y)
postype = p2    ;p2,front,back,left,right
facing = -1
supermovetime = 0
pausemovetime = 0

[State 1401, Helper]
type = Helper
triggerall = NumHelper(1420) = 0
triggerall = NumHelper(1430) = 0
triggerall = NumHelper(1440) = 0
triggerall = NumHelper(1450) = 0
triggerall = NumHelper(1460) = 0
triggerall = NumHelper(1470) = 0
trigger1 = Command = "c"
helpertype = normal ;player
name = "Comando C"
ID = 1470
stateno = 1470
pos = 90,0;-60,floor(P2Dist Y);-floor(Pos Y)
postype = p2    ;p2,front,back,left,right
facing = -1
supermovetime = 0
pausemovetime = 0

[State 1401, End]
type = ChangeState
triggerall = prevstateno = 1410
trigger1 = time = 300
trigger2 = Command = "holddown"
value = 1412
ctrl = 0

[State 1000, End]
type = ChangeState
trigger1 = time = 300
trigger2 = Command = "holddown"
value = 1402
ctrl = 0

;------------------------------------
;Fim
[Statedef 1402]
type    = S
movetype= I
physics = N
anim = 1402
ctrl = 0
sprpriority = 2
velset = 0,0

[State 0, PlaySnd]
type = PlaySnd
trigger1 = animelem = 4
value = 8,1
channel = 1

[State 1000, End]
type = ChangeState
trigger1 = animtime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
;Meditao air
[Statedef 1410]
type    = A
movetype= I
physics = N
poweradd = 100
anim = 1410
ctrl = 0
sprpriority = 2

[State 0, VelSet]
type = VelSet
trigger1 = time = 1
x = 0
y = -3

[State 1400, End]
type = ChangeState
trigger1 = animtime = 0
value = 1401
ctrl = 0

;------------------------------------
;Fim
[Statedef 1412]
type    = A
movetype= I
physics = N
anim = 1412
ctrl = 0
sprpriority = 2
velset = 0,0

[State 0, CtrlSet]
type = CtrlSet
trigger1 = animelem = 7
value = 1

[State 0, StateTypeSet]
type = StateTypeSet
trigger1 = animelem = 3
statetype = A       ;S,A,C,L
movetype = I        ;I,A,H
physics = A         ;A,C,S,N

[State 70, End]
type = ChangeState
trigger1 = (Pos Y >= 0) && (Vel Y > 0)
value = 52

;------------------------------------
;Comando X
[Statedef 1420]
type    = A
movetype= A
physics = N
anim = 1420
ctrl = 0
sprpriority = 2
velset = 0,0
facep2 = 1

[State 8018]
type = Turn
trigger1 = Time = 0
trigger1 = FrontEdgeBodyDist <= 5

[State 8018]
type = ScreenBound
trigger1 = 1
value = 1
movecamera = 0,1

[State 8018]
type = VelSet
trigger1 = Time = 2
x = 9
y = 11

[State 8018]
type = VelAdd
trigger1 = 1
y = 0.4

[State 8018]
type = PlaySnd
trigger1 = Time = 5
value = 220,2

[State 8018]
type = HitDef
trigger1 = hitcount < 1
trigger1 = moveguarded < 1
attr = A, SA
animtype  = Medium
damage    = 40,4
hitflag = MAFD
guardflag = HA
pausetime = 12,12
sparkno = 2
guard.sparkno = 2
sparkxy = -10,-64+floor(P2Dist Y)
hitsound   = S8000,2
guardsound = S8000,6
ground.type = High
ground.slidetime = 10
ground.hittime  = 20
ground.velocity = -4,-3
air.velocity = -4,-3

[State 8018]
type = VarAdd
trigger1 = MoveContact
var(21) = 1
ignorehitpause = 1
persistent = 0

[State 8018]
type = VarAdd
trigger1 = !MoveContact && Time >= 22
var(9) = 1
ignorehitpause = 1
persistent = 0

[State 11010, 5]
type = HitOverride
trigger1 = 1
attr = SCA, NA, NP, NT, SA, SP, ST, HA, HP, HT
stateno = 1425
time = -1

[State 3000]
type = DestroySelf
trigger1 = Pos Y >= 0
trigger1 = Vel Y > 0
trigger2 = AnimTime = 0
;trigger1 = root, stateno !=3000

;------------------------------------
;Destruindo iluso
[Statedef 1425]
type    = A
movetype= A
physics = N
anim = 1425
ctrl = 0
sprpriority = 2
velset = 0,0
;facep2 = 1

[State 3000]
type = DestroySelf
trigger1 = AnimTime = 0

;------------------------------------
;Comando Y
[Statedef 1430]
type    = A
movetype= A
physics = N
anim = 1430
ctrl = 0
sprpriority = 2
velset = 5,-3
;facep2 = 1

[State 8018]
type = VelAdd
trigger1 = 1
y = 0.3

[State 230, 1]
type = PlaySnd
trigger1 = random >= 500
trigger1 = animelem = 1
value = 210, 0

[State 630, 1]
type = PlaySnd
trigger1 = Time = 6
value = 8400, 0

[State 630, HitDef]
type = HitDef
trigger1 = animelem = 2
attr = A,NA
damage = 20,2
animtype = Light
guardflag = HA
hitflag = MAF
priority = 2, Hit
pausetime = 8,8
sparkno = 1
sparkxy = -15,-49
guard.sparkno = 1
hitsound = s8000,0
guardsound = S8000,6
ground.type = High
air.type = Low
ground.slidetime = 6
ground.hittime  = 10
ground.velocity = -3
air.velocity = -3,-4
air.hittime  = 10
guard.hittime = 12
airguard.ctrltime = 2
airguard.velocity = -3,-2

[State 250, 1]
type = PlaySnd
trigger1 = animelem = 5
value = 220, 0

[State 650, 1]
type = PlaySnd
trigger1 = Time = 16
value = 8400, 2

[State 650, HitDef]
type = HitDef
trigger1 = animelem = 6
attr = A,NA
damage = 40,4
animtype = High
guardflag = HA
hitflag = MAF
priority = 4, Hit
pausetime = 12,12
sparkno = 2
sparkxy = -15,-20
guard.sparkno = 2
hitsound = s8000,2
guardsound = S8000,6
ground.type = High
air.type = Low
ground.slidetime = 15
ground.hittime  = 18
ground.velocity = -5
air.velocity = -5,4
airguard.ctrltime = 2
airguard.velocity = -5,4
air.hittime  = 12
air.fall = 1
fall.recover = 0
fall.xvelocity =0
fall.yvelocity =0
down.bounce =0

[State 11010, 5]
type = HitOverride
trigger1 = 1
attr = SCA, NA, NP, NT, SA, SP, ST, HA, HP, HT
stateno = 1425
time = -1

[State 3000]
type = DestroySelf
trigger1 = Pos Y >= -5
trigger1 = Vel Y > -5
trigger2 = AnimTime = 0
;trigger1 = root, stateno !=3000

;------------------------------------
;Comando Z
[Statedef 1440]
type    = A
movetype= A
physics = N
anim = 1440
ctrl = 0
sprpriority = 2
velset = 3,-7
;facep2 = 1

[State 0, PosSet]
type = PosSet
trigger1 = time = 1
;x = p2bodydist x ;(P2Dist Y)
y = 0

[State 8018]
type = VelAdd
trigger1 = 1
y = 0.3

[State 230, 1]
type = PlaySnd
trigger1 = random >= 500
trigger1 = animelem = 1
value = 210, 0

[State 630, 1]
type = PlaySnd
trigger1 = Time = 6
value = 8400, 0

[State 630, HitDef]
type = HitDef
trigger1 = animelem = 2
attr = A,NA
damage = 20,2
animtype = Light
guardflag = HA
hitflag = MAF
priority = 2, Hit
pausetime = 8,8
sparkno = 1
sparkxy = -15,-49
guard.sparkno = 1
hitsound = s8000,0
guardsound = S8000,6
ground.type = High
air.type = Low
ground.slidetime = 6
ground.hittime  = 10
ground.velocity = -2,-7
air.velocity = -2,-7
air.hittime  = 10
guard.hittime = 12
airguard.ctrltime = 2
airguard.velocity = -3,-2

[State 250, 1]
type = PlaySnd
trigger1 = animelem = 5
value = 220, 0

[State 650, 1]
type = PlaySnd
trigger1 = Time = 16
value = 8400, 2

[State 650, HitDef]
type = HitDef
trigger1 = animelem = 6
attr = A,NA
damage = 40,4
animtype = High
guardflag = HA
hitflag = MAF
priority = 4, Hit
pausetime = 12,12
sparkno = 2
sparkxy = -15,-20
guard.sparkno = 2
hitsound = s8000,2
guardsound = S8000,6
ground.type = High
air.type = Low
ground.slidetime = 15
ground.hittime  = 18
ground.velocity = -5,-6
air.velocity = -5,-6
airguard.ctrltime = 2
airguard.velocity = -4,-5
air.hittime  = 12
air.fall = 1
fall.recover = 0
fall.xvelocity =0
fall.yvelocity =0
down.bounce =0

[State 11010, 5]
type = HitOverride
trigger1 = 1
attr = SCA, NA, NP, NT, SA, SP, ST, HA, HP, HT
stateno = 1425
time = -1

[State 3000]
type = DestroySelf
trigger1 = Pos Y >= -5
trigger1 = Vel Y > -5
trigger2 = AnimTime = 0
;trigger1 = root, stateno !=3000

;------------------------------------
;Comando A
[Statedef 1450]
type    = S
movetype= A
physics = S
anim = 1450
ctrl = 0
sprpriority = 2
velset = 0,0

[State 0, PosSet]
type = PosSet
trigger1 = time = 1
;x = p2bodydist x ;(P2Dist Y)
y = 0

[State 0, VelSet]
type = VelSet
trigger1 = animelem = 1
x = 3

[State 210, 1]
type = PlaySnd
trigger1 = random >= 400
trigger1 = animelem = 2
value = 210, 0

[State 200, 1]
type = PlaySnd
trigger1 = animelem = 5
value = 8400, 1

[State 210, HitDef]
type = HitDef
trigger1 = animelem = 2
attr = S,NA
damage = 20,2
animtype = Medium
guardflag = HA
hitflag = MAF
priority = 4, Hit
pausetime = 5,10
sparkno = 2
sparkxy = -15,-79
guard.sparkno = 2
hitsound = s8000,1
guardsound = S8000,6
ground.type = Low
ground.slidetime = 18
ground.hittime  = 18
ground.velocity = -5
air.type = Low
air.hittime = 18
air.velocity = -5,10
guard.velocity = -6
airguard.velocity = -6,5
guard.ctrltime = 20
air.fall = 1

[State 0, VelSet]
type = posadd
trigger1 = animelem = 6
x = 25

[State 220, 1]
type = PlaySnd
trigger1 = animelem = 7
value = 220, 1

[State 200, 1]
type = PlaySnd
trigger1 = animelem = 10
value = 8400, 2

[State 220, 2]
type = HitDef
trigger1 = animelem = 11
attr = S, NA
animtype  = Hard
damage    = 40,4
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 6,12
guard.pausetime =12,12
sparkno = 1;ifelse(!var(55),-1,2)
guard.sparkno = 1;ifelse(!var(55),-1,40)
sparkxy = -10,-70
hitsound = s8000,2
guardsound = S8000,6
ground.type = high
ground.slidetime = 20
ground.hittime  = 15
ground.velocity = -8
guard.velocity = -8
guard.hittime = 15
guard.ctrltime = 15
air.velocity = -6,-2

[State 1450, p2]
type = Explod
;trigger1 = p2stateno = 804
trigger1 = animelem = 10
anim = 221
id=221
postype = p1
pos = 30,-58
vel = 10
sprpriority = -7
removetime = 4
persistent = 0
bindtime = 1
ownpal = 1
scale = 1,1

[State 11010, 5]
type = HitOverride
trigger1 = 1
attr = SCA, NA, NP, NT, SA, SP, ST, HA, HP, HT
stateno = 1425
time = -1

[State 3000]
type = DestroySelf
trigger1 = AnimTime = 0
;trigger1 = root, stateno !=3000

;------------------------------------
;Comando B
[Statedef 1460]
type    = S
movetype= A
physics = S
anim = 1460
ctrl = 0
sprpriority = 2
velset = 0,0

[State 0, PosSet]
type = PosSet
trigger1 = time = 1
;x = p2bodydist x -140;(P2Dist Y)
y = 0

[State 230, 1]
type = PlaySnd
trigger1 = random >= 500
trigger1 = animelem = 1
value = 210, 0

[State 430, 1]
type = PlaySnd
trigger1 = Time = 6
value = 8400, 0

[State 430, HitDef]
type = HitDef
trigger1 = animelem = 3
attr = C,NA
damage = 10,1
animtype = Light
hitflag = MAFD
guardflag = LA
priority = 2, Hit
pausetime = 4,8
sparkno = 1
sparkxy = -15,-10
guard.sparkno = 1
hitsound = s8000,0
guardsound = S8000,6
ground.type = Low
ground.slidetime = 12
ground.hittime = 15
ground.velocity = -3,0
air.type = Low
air.hittime = 15
air.velocity = -3,-2
down.velocity=-1.5,-4
down.hittime=15
ground.cornerpush.veloff = -5
air.cornerpush.veloff = -5

[State 0, VelSet]
type = VelSet
trigger1 = animelem = 7
x = 10

[State 0, VelSet]
type = VelSet
trigger1 = animelem = 8
x = 7

[State 0, VelSet]
type = VelSet
trigger1 = animelem = 9
x = 5

[State 220, 1]
type = PlaySnd
trigger1 = random >= 400
trigger1 = animelem = 8
value = 220, 2

[State 440, 1]
type = PlaySnd
trigger1 = animelem = 9
value = 8400, 1

[State 440, 1]
type = PlaySnd
trigger1 = animelem = 7
value = 100, 1
channel = 2

[State 440, HitDef]
type = HitDef
trigger1 = animelem = 9
attr = C,NA
damage = 20,2
animtype = Medium
hitflag = MAF
guardflag = LA
priority = 4, Hit
pausetime = 5,10
sparkno = 1
sparkxy = -15,-59
guard.sparkno = 1
hitsound = s8000,1
guardsound = S8000,6
ground.type = Low
ground.slidetime = 18
ground.hittime = 18
ground.velocity = -4
air.type = Low
air.hittime = 18
air.velocity = -4,-3
guard.velocity = -4
guard.hittime = 18

[State 0, VelSet]
type = VelSet
trigger1 = animelem = 12
x = 3

[State 0, VelSet]
type = VelSet
trigger1 = animelem = 14
x = 0

[State 220, 1]
type = PlaySnd
trigger1 = animelem = 13
value = 220, 0

[State 450, 1]
type = PlaySnd
trigger1 = animelem = 14
value = 8400, 2

[State 450, HitDef]
type = HitDef
trigger1 = animelem = 14
attr = C,NA
damage = 30,3
animtype = High
hitflag = MAF
guardflag = LA
priority = 5, Hit
pausetime = 6,12
sparkno = 2;s8222
sparkxy = -15,-59
guard.sparkno = 2;s8001
hitsound = s8000,2
guardsound = S8000,6
ground.type = trip
ground.slidetime = 24
ground.hittime = 15
ground.velocity = -1,-4
air.type = Low
air.hittime = 15
air.velocity = -1,-3
airguard.ctrltime = 26
airguard.velocity = -7,-2
guard.velocity = -7
down.velocity = -3,-8
down.hittime = 32
fall = 1
fall.recover = 0

[State 11010, 5]
type = HitOverride
trigger1 = 1
attr = SCA, NA, NP, NT, SA, SP, ST, HA, HP, HT
stateno = 1425
time = -1

[State 3000]
type = DestroySelf
trigger1 = AnimTime = 0
;trigger1 = root, stateno !=3000

;------------------------------------
;Comando C
[Statedef 1470]
type    = S
movetype= A
physics = S
anim = 1470
ctrl = 0
sprpriority = 2
velset = 0,0

[State 0, PosSet]
type = PosSet
trigger1 = time = 1
;x = p2bodydist x -140;(P2Dist Y)
y = 0

[State 240, 0]
type = velSet
trigger1 = animelem = 1
x = 12

[State 240, 0]
type = velSet
trigger1 = animelem = 2
x = 0

[State 250, 1]
type = PlaySnd
trigger1 = Time = 6
value = 220, 0

[State 200, 1]
type = PlaySnd
trigger1 = animelem = 4
value = 8400, 2

[State 250, HitDef]
type = HitDef
trigger1 = animelem = 3
trigger2 = animelem = 7
attr = S,NA
damage = 30,3
animtype = High
guardflag = MA
hitflag = MAF
priority = 4, Hit
pausetime = 6,12
sparkno = 2
sparkxy = -15,-79
guard.sparkno = 2
hitsound = s8000,2
guardsound = S8000,6
ground.type = High
ground.slidetime = 24
ground.hittime = 15
ground.velocity = -3
guard.velocity = -3
air.type = Low
air.hittime = 15
air.velocity = -3,-4

[State 0, VelSet]
type = posadd
trigger1 = animelem = 9
x = 30

[State 220, 1]
type = PlaySnd
trigger1 = animelem = 10
value = 220, 0

[State 420, 1]
type = PlaySnd
trigger1 = animelem = 11
value = 8400, 2

[State 420, HitDef]
type = HitDef
trigger1 = animelem = 11
attr = S, NA
damage = 30,3
priority = 5, Hit
hitflag = MAF
guardflag = MA
pausetime = 6,12
sparkno = 2
sparkxy = 8, -94
guard.sparkno = 2
hitsound = s8000,2
guardsound = S8000,6
animtype = Up
ground.type = high
ground.slidetime = 30
ground.hittime  = 15
ground.velocity = -1,-15
guard.velocity = -8
air.velocity = -1,-12
air.type = high
air.hittime = 15

[State 11010, 5]
type = HitOverride
trigger1 = 1
attr = SCA, NA, NP, NT, SA, SP, ST, HA, HP, HT
stateno = 1425
time = -1

[State 3000]
type = DestroySelf
trigger1 = AnimTime = 0
;trigger1 = root, stateno !=3000



;---------------------------------------------------------------------------
; BARREIRA
;---------------------------------------------------------------------------
[Statedef 1500]
type    = S
movetype= A
physics = N
juggle  = 1
velset = 0,0
poweradd = 100
anim = 1500
ctrl = 0
sprpriority = 0

[State 1500, PlaySnd]
type = PlaySnd
trigger1 = animelem = 2
value = 800,4

[State 1500, PlaySnd]
type = PlaySnd
trigger1 = animelem = 2
value = 8,1

[state 1500, Barreira]
type = helper
trigger1 = AnimElem = 3
name = "Barreira"
ID = 1510
stateno = 1510
postype = p1
facing = 1
ownpal = 1
keyctrl = 0
size.xscale = 1;0.7
size.yscale = 1;0.5

[State 1000, End]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------
;Psico Blast (helper)
[Statedef 1510]
type = S
movetype = A
physics = N
ctrl = 0
velset = 0, 0
sprpriority = 4
anim = 1510

[state 1510, Parent Bind]
type = bindtoparent
trigger1 = 1
pos = 0, 20

;[state 1105, Palette]
;type = remappal
;trigger1 = !prevstateno && !time
;source = 7000, 0
;dest = 7000, 1

[state 1510, Transparency]
type = trans
trigger1 = 1
trans = addalpha
alpha = 256, 256

[State 1510, PalFX]
type = PalFX
trigger1 = 1;time= 0
time = 20
add = 100,200,100
mul = 50,256,50
;sinadd = 0,0,0,10
invertall = 0
color = 256

[state 1510, Special Effect]
type = assertspecial
trigger1 = 1
flag = noshadow

[state 1510, Vulnerability]
type = nothitby
trigger1 = 1
value = SCA
time = -1

[state 1510, Attack Distance]
type = attackdist
trigger1 = 1
value = const(size.proj.attack.dist)

[State 1510, hitdef]
type = HitDef
trigger1 = TimeMod = 20,0
attr = S,HA
hitflag = MAF
guardflag = MAF
damage = 5,1
pausetime = 0,4
hitsound = s8000,2
guardsound = S3,0
sparkno = S8222
sparkxy = 0,75
animtype = Light
ground.type = High;Low
ground.slidetime = 10
ground.hittime  = 10
ground.velocity = -7
guard.velocity = -5
air.velocity = -5,-1

[state 1510, Destroy]
type = destroyself
trigger1 = time = 200; || root,movetype = H
;trigger2 = (root,stateno != [1000,1050]) || (root,anim != [1000,1050])
;trigger3 = root,time <= 1

;---------------------------------------------------------------------------
; BARREIRA AIR
;---------------------------------------------------------------------------
[Statedef 1550]
type    = A
movetype= A
physics = N
juggle  = 1
velset = 0,0
poweradd = 100
anim = 1050
ctrl = 0
sprpriority = 0

[State 1500, PlaySnd]
type = PlaySnd
trigger1 = animelem = 2
value = 800,4

[state 1550, Barreira]
type = helper
trigger1 = AnimElem = 3
name = "Barreira"
ID = 1510
stateno = 1510
postype = p1
facing = 1
ownpal = 1
keyctrl = 0
size.xscale = 1;0.7
size.yscale = 1;0.5

[State 1550, End]
type = ChangeState
trigger1 = AnimTime = 0
value = 70
ctrl = 1

; End
