#a very simple gallery
init python:

    maxnumx = 3
    maxnumy = 3
    maxthumbx = config.screen_width / (maxnumx + 1)
    maxthumby = config.screen_height / (maxnumy + 1)
    maxperpage = maxnumx * maxnumy
    gallery_page = 0
    closeup_page = 0


    class GalleryItem:
        def __init__(self, name, images, thumb, locked="lockedthumb"):
            self.name = name
            self.images = images
            self.thumb = thumb
            self.locked = locked
            self.refresh_lock()

        def num_images(self):
            return len(self.images)

        def refresh_lock(self):
            self.num_unlocked = 0
            lockme = False
            for img in self.images:
                if not renpy.seen_image(img):
                    lockme = True
                else:
                    self.num_unlocked += 1
            self.is_locked = lockme

    gallery_items = []
    gallery_items.append(GalleryItem("{color=#000}{/color}", ["gal1"], "tgal1"))
    gallery_items.append(GalleryItem("{color=#000}{/color}", ["gal2"], "tgal2"))
    gallery_items.append(GalleryItem("{color=#000}{/color}", ["gal3"], "tgal3"))
    gallery_items.append(GalleryItem("{color=#000}{/color}", ["gal4"], "tgal4"))

image gray = "#777"

#384x216 (16x9) set 1280x720p for the lock and all thumbnails
#600x338 (16x9) set 1920x1080 for the lock and thumbnails
#gallery locked image
image lockedthumb = ("images/gallery/thumbs/tgallery0.jpg")

#gallery images
image gal1 = ("images/bg preisla5-1.jpg")
image gal2 = ("images/bg preisla54.jpg")
image gal3 = ("images/bg isladia2-39.jpg")
image gal4 = ("images/bg isladia2-56.jpg")



#gallery thumbnails images
image tgal1 = ("images/gallery/thumbs/tgallery1.jpg")
image tgal2 = ("images/gallery/thumbs/tgallery2.jpg")
image tgal3 = ("images/gallery/thumbs/tgallery3.jpg")
image tgal4 = ("images/gallery/thumbs/tgallery4.jpg")
