; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
; 
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
; 

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

[Defaults]
command.time = 15
command.buffer.time = 1
;-| Super Motions |--------------------------------------------------------
[Command]
name = "Hyper Smash"
command = ~D, DF, F, x+y

[Command]
name = "Ultimate Smash"
command = ~D, DB, B, x+y

[Command]
name = "Final Smash"
command = ~F, D, DF, a+b
;-| Special Motions |------------------------------------------------------
[Command]
name = "Dimitrescu Claws"
command = ~D, DF, F, x

[Command]
name = "Dimitrescu Slash"
command = ~D, DF, F, y

[Command]
name = "Dimitrescu Slash Rush"
command = ~D, DF, F, a

[Command]
name = "Vampiric Drain"
command = ~F, D, DF, x

[Command]
name = "Vampiric Slam"
command = ~F, D, DF, y

[Command]
name = "Vampiric Slam (Air)"
command = ~F, D, DF, y
time = 10

[Command]
name = "Vampiric Throw"
command = ~F, D, DF, a

[Command]
name = "Dimitrescu Daughters (L)"
command = ~D, DB, B, x

[Command]
name = "Dimitrescu Daughters (M)"
command = ~D, DB, B, y

[Command]
name = "Dimitrescu Daughters (H)"
command = ~D, DB, B, a
;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = b+c
time = 1

[Command]
name = "recovery"
command = a+c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "back_x"
command = /$B,x
time = 1

[Command]
name = "back_y"
command = /$B,y
time = 1

[Command]
name = "back_z"
command = /$B,z
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_x"
command = /$F,x
time = 1

[Command]
name = "fwd_y"
command = /$F,y
time = 1

[Command]
name = "fwd_z"
command = /$F,z
time = 1

[Command]
name = "up_x"
command = /$U,x
time = 1

[Command]
name = "up_y"
command = /$U,y
time = 1

[Command]
name = "up_z"
command = /$U,z
time = 1

[Command]
name = "back_a"
command = /$B,a
time = 1

[Command]
name = "back_b"
command = /$B,b
time = 1

[Command]
name = "back_c"
command = /$B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_a"
command = /$F,a
time = 1

[Command]
name = "fwd_b"
command = /$F,b
time = 1

[Command]
name = "fwd_c"
command = /$F,c
time = 1

[Command]
name = "up_a"
command = /$U,a
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "up_c"
command = /$U,c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Single Dir |------------------------------------------------------------
[Command]
name = "fwd" ;Required (do not remove)
command = $F
time = 1

[Command]
name = "downfwd"
command = $DF
time = 1

[Command]
name = "down" ;Required (do not remove)
command = $D
time = 1

[Command]
name = "downback"
command = $DB
time = 1

[Command]
name = "back" ;Required (do not remove)
command = $B
time = 1

[Command]
name = "upback"
command = $UB
time = 1

[Command]
name = "up" ;Required (do not remove)
command = $U
time = 1

[Command]
name = "upfwd"
command = $UF
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd" ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holddownfwd"
command = /$DF
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownback"
command = /$DB
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdupback"
command = /$UB
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holdupfwd"
command = /$UF
time = 1

[Command]
name = "SJ"
command = $D, $U





















;==============================================================================================================;
;=========================================;
;=code_bao_maru_cmd_by_shadaloo666========;
;=========================================;
;ȉ[Command]ǉ

;-| bao |--------------------------------------------------------------
[Command]
name = "bao"
command = D, D, s;==BAOMARU_HELPHER_START
time = 20

[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

[command]
name="fwd"
command=F
time=1

[command]
name="back"
command=B
time=1

[command]
name="up"
command=U
time=1

[command]
name="down"
command=D
time=1

[Command]
name = "holdfwd"   ;vς (L[̕ύX͉\łOς薳ɂĂ͂܂)
command = /$F
time = 1

[Command]
name = "holdback"  ;vς (L[̕ύX͉\łOς薳ɂĂ͂܂)
command = /$B
time = 1

[Command]
name = "holdup"    ;vς (L[̕ύX͉\łOς薳ɂĂ͂܂)
command = /$U
time = 1

[Command]
name = "holddown"  ;vς (L[̕ύX͉\łOς薳ɂĂ͂܂)
command = /$D
time = 1

[Command]
name = "hold_a"
command = /$a
time = 1

[Command]
name = "hold_b"
command = /$b
time = 1

[Command]
name = "hold_c"
command = /$c
time = 1

[Command]
name = "hold_x"
command = /$x
time = 1

[Command]
name = "hold_y"
command = /$y
time = 1

[Command]
name = "hold_z"
command = /$z
time = 1

;---------------------------------------------------------------------------
;end_baomaru_code_by_shadaloo666
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
;[Statedef -1]
;=========================================;
;===========end_cmd_baomaru_code==========;
;=========================================;
;---------------------------------------------------------------------------
[Statedef -1]
;============================================================================;
;baomaru_trigger_by_shadaloo666
;============================================================================;

;[Statedef -1]̂ɈȉRsy
;---------------------------------------------------------------------------
;bao
;---------------------------------------------------------------------------
[State -1, bao]
type = ChangeState
value = 948494501
triggerall = AILevel=0
triggerall = command = "bao"
trigger1 = statetype != A
trigger1 = movetype != H
trigger1 = ctrl

;AI
[State -1, bao]
type = ChangeState
value = 948494501
triggerall = AILevel>0
TriggerAll = P2MoveType != H
triggerall = P2statetype != A
TriggerAll = RoundState = 2
triggerall = enemynear,selfanimexist(19230)
triggerAll = p2bodydist X = [0,30]
triggerall = EnemyNear,life > 0
triggerall = P2stateno != 5120
trigger1 = statetype != A
trigger1 = movetype != H
trigger1 = ctrl
trigger1 = random >= 500
;---------------------------------------------------------------------------

;end_baomaru_triger==========================================================;
;============================================================================;
;---------------------------------------------------------------------------




;===========================================================================
;Artificial Intelligence
;===========================================================================

[State -1, AI Activation]
type = varset
triggerall = AILevel > 2
triggerall = (roundstate = 2) && (var(59) = 0)
trigger1 = Random <= ((AILevel-2)*100)
v = 59
value = 1

[State -1, AI Deactivation]
type = varset
triggerall = AIlevel < 7
triggerall = var(59) = 1
trigger1 = Random > ((AILevel-2)*100)
trigger2 = roundstate != 2
v = 59
value = 0

;--|-AI Defense-|-----------------------------------------------------------
[State -1, Artificial Intelligence]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0) 
triggerall = (Ctrl) && (p2movetype = A) && (statetype = S)
trigger1 = (p2bodydist X <= 200) && (random <= 799)
value = 130

[State -1, Artificial Intelligence]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0) 
triggerall = (Ctrl) && (p2movetype = A) && (statetype = C)
trigger1 = (p2bodydist X <= 200) && (random <= 799)
value = 131

[State -1, Artificial Intelligence]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0) 
triggerall = (Ctrl) && (p2movetype = A) && (statetype = A)
trigger1 = (p2bodydist X <= 200) && (random <= 799)
value = 132

;--|-AI Combos-|------------------------------------------------------------
;Start Standing Chain Combo
[State -1, Standing Chain Combo]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
trigger1 = (stateno = [210,230]) && movecontact
value = 240

[State -1, Standing Chain Combo]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
trigger1 = (stateno = 230) && movecontact
value = IfElse(P2BodyDist X > 15,210,230)

[State -1, Standing Chain Combo]
type = ChangeState
triggerall = (roundstate = 2) && (var(50) != 0)
triggerall = AILevel >= 3
trigger1 = (stateno = 200) && movecontact
value = 230

[State -1, Standing Chain Combo]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = AILevel >= 3
trigger1 = (stateno = 200) && movecontact
value = 210

[State -1, Standing Chain Combo]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = p2stateno != 7600
triggerall = (Ctrl) && (statetype = S)
triggerall = (p2stateno != [120,155]) && (p2stateno != [5100,5150])
trigger1 = (p2bodydist x <= 40) && (random > 900)
value = 200
;End Standing Chain

;---------------------------------------------------------------------------
;Start Crouching Chain

[State -1, Crouching Chain Combo]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0) && (statetype !=A)
trigger1 = AILevel >= 4
trigger1 = (stateno = 430) && movecontact
value = 410

[State -1, Alternate start for Easy AI]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
trigger1 = AILevel >= 4
trigger1 = (stateno = 400) && movecontact
trigger2 = p2stateno != 7600
trigger2 = (Ctrl) && (statetype = S)
trigger2 = (p2stateno != [120,155]) && (p2stateno != [5100,5150])
trigger2 = (p2bodydist x <= 40) && (random < 50)
trigger2 = AILevel < 3
value = 430

[State -1, Combo start for Med/Hard AI]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = p2stateno != 7600
triggerall = (Ctrl) && (statetype = S)
triggerall = (p2stateno != [120,155]) && (p2stateno != [5100,5150])
trigger1 = (p2bodydist x <= 40) && (random < 100)
value = 400
;End Crouching Chain

[State -1,  Always superjump on launch]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = AILevel >= 3
triggerall = (random <= 900)
trigger1 = numexplod (6003) > 0
value = 7500

;---------------------------------------------------------------------------
;Start Air Chain
[State -1, Air Chain Combo]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = AILevel >= 5
trigger1 = (stateno = 610) && movecontact
value = 640

[State -1, Air Chain Combo]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = AILevel >= 4
trigger1 = (stateno = 600) && movecontact
value = 610

[State -1, Air Chain Combo]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = AILevel >= 3
trigger1 = (stateno = 600) && movecontact
value = 630

[State -1, Air Chain Combo]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = (Ctrl) && (statetype = A)
triggerall = prevstateno != 600
trigger1 = (p2bodydist x <= 25) && (random <= 150)
trigger2 = (p2bodydist x <= 25) && (random <= 750) && (stateno = [7000,7100])
value = 600
;End Air Chain

[State -1, Followup jump attack with crouch hard kick]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = (Ctrl) && (p2movetype = H) ;opponent has been hit
triggerall = AILevel >= 4
trigger1 = (p2bodydist X <= 25) ;close to opponent
trigger1 = Prevstateno = 50 ;falling from attack (which means the previous hit must have been an air attack)
trigger1 = (random <= 750) ;This will happen 75% of the time that the other triggers are true
value = 450

;-|-AI Special Attempt-|---------------------------------------------
[State -1, AI Dimitrescu Claws]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = stateno < 3000
triggerall = (Ctrl) && (Statetype = S) && (random = [70,100])
trigger1 = (prevstateno != 5120) && (p2statetype != A) && (statetype != A)
value = 1000

[State -1, AI Dimitrescu Slash]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = stateno < 3000
triggerall = (Ctrl) && (Statetype = S) && (random = [70,100])
trigger1 = (prevstateno != 5120) && (p2statetype != A) && (statetype != A)
value = 1010

[State -1, AI Dimitrescu Slash Rush]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = stateno < 3000
triggerall = (Ctrl) && (Statetype = S) && (random = [170,200])
trigger1 = (prevstateno != 5120) && (p2statetype != A) && (statetype != A)
value = 1020

[State -1, AI Vampiric Drain]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = stateno < 3000
triggerall = (Ctrl) && (Statetype = S) && (random = [170,200])
trigger1 = (prevstateno != 5120) && (p2statetype != A) && (statetype != A)
value = 1100

[State -1, AI Vampiric Slam]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = stateno < 3000
triggerall = (Ctrl) && (Statetype = S) && (random = [170,200])
trigger1 = (prevstateno != 5120) && (p2statetype != A) && (statetype != A)
value = 1110

[State -1, AI Vampiric Slam (Air)]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = stateno < 3000
triggerall = (Ctrl) && (Statetype = A) && (random = [170,200])
trigger1 = (prevstateno != 5120) && (p2statetype != A) && (statetype != A)
value = 1113

[State -1, AI Vampiric Throw]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = stateno < 3000
triggerall = (Ctrl) && (Statetype = S) && (random = [170,200])
trigger1 = (prevstateno != 5120) && (p2statetype != A) && (statetype != A)
value = 1120

[State -1, AI Dimitrescu Daughters (L)]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = stateno < 3000
triggerall = (Ctrl) && (Statetype = S) && (random = [170,200])
trigger1 = (prevstateno != 5120) && (p2statetype != A) && (statetype != A)
value = 1200

[State -1, AI Dimitrescu Daughters (M)]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = stateno < 3000
triggerall = (Ctrl) && (Statetype = S) && (random = [170,200])
trigger1 = (prevstateno != 5120) && (p2statetype != A) && (statetype != A)
value = 1210

[State -1, AI Dimitrescu Daughters (H)]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = stateno < 3000
triggerall = (Ctrl) && (Statetype = S) && (random = [170,200])
trigger1 = (prevstateno != 5120) && (p2statetype != A) && (statetype != A)
value = 1220
;-|-AI Hyper Attempt|---------------------------------------------

[State -1, AI Hyper Smash]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = (Ctrl) && (Statetype = S) && (p2statetype != L)
trigger1 = (prevstateno != 5120) && (numproj = 0) && (statetype != A)
trigger1 = (power >= 1000) && (numproj = 0) && (random = [0,300])
value = 3000

[State -1, AI Ultimate Smash]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = (Ctrl) && (Statetype = S) && (p2statetype != L)
trigger1 = (power > 2000) && (numproj = 0) && (random = [0,300]) && (statetype != A)
value = 3100

[State -1, AI Final Smash]
type = ChangeState
triggerall = (roundstate = 2) && (var(59) != 0)
triggerall = (Ctrl) && (Statetype = S) && (p2statetype != L)
trigger1 = (power > 3000) && (numproj = 0) && (random = [0,300]) && (statetype != A)
value = 3200
;====================== [ FINISHING MOVES ] ==========================
[State -1, Hyper Smash]
type = ChangeState
value = 3000
triggerall = !Var(59)
triggerall = command = "Hyper Smash"
triggerall = power >= 1000 
trigger1 = Statetype != A && ctrl

[State -1, Ultimate Smash]
type = ChangeState
value = 3100
triggerall = !Var(59)
triggerall = command = "Ultimate Smash"
triggerall = power >= 2000 
trigger1 = Statetype != A && ctrl

[State -1, Final Smash]
type = ChangeState
value = 3200
triggerall = !Var(59)
triggerall = command = "Final Smash"
triggerall = power >= 3000 
trigger1 = Statetype != A && ctrl
;===========================================================================
;Commands
;===========================================================================

;---------------------------------------------------------------------------
; Dimitrescu Daughters

[State -1, Dimitrescu Daughters (L)]
type = ChangeState
value = 1200
triggerall = !Var(59)
triggerall = command = "Dimitrescu Daughters (L)"
trigger1 = Statetype != A && ctrl

[State -1, Dimitrescu Daughters (M)]
type = ChangeState
value = 1210
triggerall = !Var(59)
triggerall = command = "Dimitrescu Daughters (M)"
trigger1 = Statetype != A && ctrl

[State -1, Dimitrescu Daughters (H)]
type = ChangeState
value = 1220
triggerall = !Var(59)
triggerall = command = "Dimitrescu Daughters (H)"
trigger1 = Statetype != A && ctrl
;---------------------------------------------------------------------------
; Vampiric Throw
[State -1, Vampiric Throw]
type = ChangeState
value = 1120
triggerall = !Var(59)
triggerall = command = "Vampiric Throw"
trigger1 = Statetype != A && ctrl
;---------------------------------------------------------------------------
; Vampiric Slam

[State -1, Vampiric Slam]
type = ChangeState
value = 1110
triggerall = !Var(59)
triggerall = command = "Vampiric Slam"
trigger1 = Statetype != A && ctrl

[State -1, Vampiric Slam (Air)]
type = ChangeState
value = 1113
triggerall = command = "Vampiric Slam (Air)"
triggerall = var(59) <= 1
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
; Vampiric Drain
[State -1, Vampiric Drain]
type = ChangeState
value = 1100
triggerall = !Var(59)
triggerall = command = "Vampiric Drain"
trigger1 = Statetype != A && ctrl
;---------------------------------------------------------------------------
; Dimitrescu Slash Rush
[State -1, Dimitrescu Slash Rush]
type = ChangeState
value = 1020
triggerall = !Var(59)
triggerall = command = "Dimitrescu Slash Rush"
trigger1 = Statetype != A && ctrl
;---------------------------------------------------------------------------
; Dimitrescu Slash
[State -1, Dimitrescu Slash]
type = ChangeState
value = 1010
triggerall = !Var(59)
triggerall = command = "Dimitrescu Slash"
trigger1 = Statetype != A && ctrl
;---------------------------------------------------------------------------
; Dimitrescu Claws
[State -1, Dimitrescu Claws]
type = ChangeState
value = 1000
triggerall = !Var(59)
triggerall = command = "Dimitrescu Claws"
trigger1 = Statetype != A && ctrl
;---------------------------------------------------------------------------

[State -1, Dash Forward]
type = ChangeState
value = 100
triggerall = StateType = S
triggerall = (Ctrl) && (StateNo != 100)
trigger1 = Command = "FF"

[State -1, Jump Back]
type = ChangeState
value = 105
triggerall = StateType = S
triggerall = (Ctrl) && (StateNo != 100)
trigger1 = Command = "BB"

[State -1, Taunt]
type = ChangeState
value = 195
triggerall = Command = "s"
triggerall = Command != "holddown"
triggerall = stateno != 100
trigger1 = (StateType = S) && (Ctrl)
;---------------------------------------------------------------------------
; Throw 1
[State -1, Throw 1]
type = ChangeState
value = 800
triggerall = command = "y"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 20
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
;---------------------------------------------------------------------------
; Throw 2
[State -1, Throw 2]
type = ChangeState
value = 850
triggerall = command = "b"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 20
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
;===========================================================================
;---------------------------------------------------------------------------
; Light Attack
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = !Var(59)
triggerall = Command = "x"
triggerall = Command != "holddown"
trigger1 = (StateType = S) && (Ctrl)

;---------------------------------------------------------------------------
; Medium Attack
[State -1, Stand Medium Punch]
type = ChangeState
value = 210
triggerall = !Var(59)
triggerall = Command = "y"
triggerall = Command != "holddown"
trigger1 = (StateType = S) && (Ctrl)
trigger2 = (StateNo = 200) && Movecontact
trigger3 = (StateNo = 230) && Movecontact
;---------------------------------------------------------------------------
; Heavy Attack
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = !Var(59)
triggerall = Command = "a"
triggerall = Command != "holddown"
triggerall = stateno != 100
trigger1 = (StateType = S) && (Ctrl)
trigger2 = (Stateno = 200) && Movecontact
;---------------------------------------------------------------------------
; Launcher
[State -1, Standing Medium Kick]
type = ChangeState
value = 240
triggerall = !Var(59)
triggerall = Command = "b"
triggerall = Command != "holddown"
trigger1 = (StateType = S) && (Ctrl)
trigger2 = (StateNo = 200) && Movecontact
trigger3 = (StateNo = 230) && Movecontact
trigger4 = (StateNo = 210) && Movecontact
trigger5 = (StateNo = 211) && Movecontact
;---------------------------------------------------------------------------
; Light Attack
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = !Var(59)
triggerall = Command = "x"
triggerall = Command = "holddown"
trigger1 = (StateType != A) && (Ctrl)
trigger2 = (StateNo = 200) && Movecontact
trigger3 = (StateNo = 230) && Movecontact
;---------------------------------------------------------------------------
; Medium Attack
[State -1, Crouching Medium Punch]
type = ChangeState
value = 410
triggerall = !Var(59)
triggerall = Command = "y"
triggerall = Command = "holddown"
trigger1 = (StateType != A) && (Ctrl)
trigger2 = (StateNo = 200) && Movecontact
trigger3 = (StateNo = 230) && Movecontact
trigger4 = (StateNo = 400) && Movecontact
trigger5 = (StateNo = 430) && Movecontact
trigger6 = (StateNo = 210) && Movecontact
trigger7 = (StateNo = 240) && Movecontact
;---------------------------------------------------------------------------
; Heavy Attack
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = !Var(59)
triggerall = Command = "a"
triggerall = Command = "holddown"
trigger1 = (StateType != A) && (Ctrl)
trigger2 = (Stateno = 200) && Movecontact
trigger3 = (Stateno = 230) && Movecontact
trigger4 = (Stateno = 400) && Movecontact
;---------------------------------------------------------------------------
; Light Attack
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = !Var(59)
triggerall = command = "x"
trigger1 = Statetype = A && ctrl
;---------------------------------------------------------------------------
; Medium Attack
[State -1, Jump Medium Punch]
type = ChangeState
value = 610
triggerall = !Var(59)
triggerall = command = "y"
trigger1 = Statetype = A && ctrl
trigger2 = (StateNo = 600) && Movecontact
trigger3 = (StateNo = 630) && Movecontact
;---------------------------------------------------------------------------
; Heavy Attack
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = !Var(59)
triggerall = command = "a"
trigger1 = Statetype = A && ctrl
trigger2 = (StateNo = 600) && Movecontact
;---------------------------------------------------------------------------
; Special
[State -1, Jump Medium Kick]
type = ChangeState
value = 640
triggerall = !Var(59)
triggerall = command = "b"
trigger1 = Statetype = A && ctrl
trigger2 = (StateNo = 600) && Movecontact
trigger3 = (StateNo = 610) && Movecontact
trigger4 = (StateNo = 630) && Movecontact
;----------------------------------------------------------------------------
; Super Jump
[State -1, Super Jump]
type = ChangeState
value = 7000
triggerall = !Var(59)
trigger1 = Command = "SJ"
trigger1 = StateType = S
trigger1 = ctrl
trigger2 = Command = "holdup"
trigger2 = stateno = 420 && movehit