/*:
 * @target MZ
 * @plugindesc แสดงภาพบนหน้าจอ และเรียก Common Event เมื่อคลิกภาพ (สำหรับ RPG Maker MZ)
 * @author ChatGPT
 * 
 * @help ClickPictureToCommonEvent.js
 *
 * วิธีใช้:
 * ใช้ Plugin Command:
 *   ShowClickablePicture pictureId imageName x y commonEventId
 *
 * ตัวอย่าง:
 *   ShowClickablePicture 1 ButtonA 300 400 5
 *   → แสดงภาพชื่อ "ButtonA" ที่ตำแหน่ง (300,400)
 *      และเมื่อคลิก → เรียก Common Event ID 5
 *
 * ไม่มี Plugin Parameters
 */

(() => {
  const pluginName = "ClickPictureToCommonEvent";

  PluginManager.registerCommand(pluginName, "ShowClickablePicture", args => {
    const pictureId = Number(args.pictureId);
    const imageName = String(args.imageName);
    const x = Number(args.x);
    const y = Number(args.y);
    const commonEventId = Number(args.commonEventId);

    $gameScreen.showPicture(pictureId, imageName, 0, x, y, 100, 100, 255, 0);

    if (!$gameTemp._clickablePictures) {
      $gameTemp._clickablePictures = {};
    }

    $gameTemp._clickablePictures[pictureId] = {
      x, y,
      width: ImageManager.loadPicture(imageName).width || 100,
      height: ImageManager.loadPicture(imageName).height || 100,
      commonEventId
    };
  });

  const _Scene_Map_update = Scene_Map.prototype.update;
  Scene_Map.prototype.update = function () {
    _Scene_Map_update.call(this);
    this.checkPictureClick();
  };

  Scene_Map.prototype.checkPictureClick = function () {
    if (TouchInput.isTriggered() && $gameTemp._clickablePictures) {
      const pictures = $gameTemp._clickablePictures;
      for (const picId in pictures) {
        const pic = pictures[picId];
        const x = pic.x;
        const y = pic.y;
        const w = pic.width;
        const h = pic.height;

        if (TouchInput.x >= x && TouchInput.x <= x + w &&
            TouchInput.y >= y && TouchInput.y <= y + h) {
          $gameTemp.reserveCommonEvent(pic.commonEventId);
        }
      }
    }
  };
})();
