var toPreload = new Set();
var preloadIter;
var preload = {
	paths: new Set(),
	files: new Set(),
	temp:{

	},
	perm:{

	},
	canvas:{

	},
	spine: {

	},
	failed: false,
	failedPaths: [],
	loaded: 0,
	audio:{
		voice: new Audio(),
		bgm: new Audio(),
		se: new Audio(),
	}
}

//make scene uninteractable until load

function initPreload(){
	preload.permElem = document.getElementById("preload-perm-elem");
	preload.tempElem = document.getElementById("preload-temp-elem");
}

function preloadSceneResources(script){
	for(let command of script){
		let fn;
		let src;
		const commandArgs = splitCommand(command);
		switch(commandArgs[1]){
			case "EV":
			case "BG":
				fn = commandArgs[2].trim();
				if(fn == "black" || fn == "white"){
					continue;
				}
				src = createImagePath(fn);
			break;
			case "ACTOR":
				fn = commandArgs[3].trim();
				src = createImagePath(fn);
			break;
			case "SPINE":
				fn = commandArgs[2].trim();
				src = createSpinePath(fn);
				break;
			case "VOICE_PLAY":
				// src = constructVoiceAudioPath(command.substr(command.lastIndexOf(">") +1).trim(), scene.id);
			break;
			case "BGM_PLAY":
				// src = constructBGMAudioPath(command.substr(command.lastIndexOf(">") +1, command.indexOf(",") - (command.lastIndexOf(">") +1)).trim());
			break;
			case "SE_PLAY":
				// src = constructSEAudioPath(command.substr(command.lastIndexOf(">") +1).trim());
			break;
			default:
			break;
		}
		preload.paths.add(src);
	}
	preload.paths.delete(undefined);
	preload.iter = preload.paths.values();
	fileLoader(loadSceneResources);
}

function preloadTABAResources(){
	for(let part in sceneData[scene.id].SCRIPTS){
		let curPart = sceneData[scene.id].SCRIPTS[part];
		let folder = curPart.FOLDER;
		let script;
		if(scene.translated){
			for(let tl of curPart.TRANSLATIONS){
				if(tl.LANGUAGE == scene.language && tl.TRANSLATOR == scene.translator){
					script = tl.SCRIPT;
					break;
				}
			}
		} else {
			script = curPart.SCRIPT
		}
		let path = "./TABAScenes/" + folder;
		for(let cmd of script){
			let src = cmd.src;
            let type = cmd.type;
            let id = cmd.id;
            let fullPath;

            switch(type){
            	case "BG":
            	case "EV":
            	case "OV":
            		if(src){
            			fullPath = path + "/images/" + src.split("/")[src.split("/").length -1];
            		}
            	break;
            	case "TXT":
	            	if(src){
            			// fullPath = path + "/sounds/" + src.split("/")[src.split("/").length -1];
            		}
            	break;
            	default:
            	break;
            }
            if(fullPath != undefined && !fullPath.includes("non_resource")){
            	preload.files.add(fullPath.split("/")[fullPath.split("/").length-1]);
            	preload.paths.add(fullPath);
            }
		}
		preload.paths.delete(undefined);
		preload.iter = preload.paths.values();
		fileLoader(loadSceneResources);
	}
}

function preloadNecroResources(script){
	let path = `./NecroScenes/${scene.id}`;
	for(let command of script){
		let src;
		let cmd = command.split(",");
		switch(cmd[0]){
			case "bg":
				src = `${path}/images/${cmd[1]}.png`;
			break;
			case "bgmplay":
				// src = `./data/audio/bgm/${cmd[1]}.m4a`;
			break;
			case "msgvoicesync":
				// src = `${path}/voices/${cmd[5]}.m4a`;
			break;
			case "playmovie":
				src = `${path}/videos/${cmd[1]}.webm`;
			break;
			case "seplay":
				// src = `./data/audio/se/${cmd[1]}.m4a`;
			break;
			case "voice":
				// if(!cmd[1].includes("_i_men")){
				// 	src = `${path}/voices/${cmd[1]}.m4a`;
				// }
			break;
			default:
			break;
		}
		preload.paths.add(src);
	}
	preload.paths.delete(undefined);
	preload.iter = preload.paths.values();
	fileLoader(loadSceneResources);
}

function preloadOtogiResources(script){
	let path = `./OtogiScenes/${scene.id.split("_")[1]}`;
	// for(let cmd of script){
	// 	if(cmd.Voice != ""){
	// 		// preload.paths.add(`${path}/voices/${cmd.Voice}.m4a`);
	// 	}
	// 	if(cmd.BGM != null){
	// 		// preload.paths.add(`./data/audio/bgm/${cmd.BGM}.m4a`);
	// 	}
	// 	if(cmd.SE != ""){
	// 		// preload.paths.add(`./data/audio/se/${cmd.BGM}.m4a`);
	// 	}
	// }
	// for(let img of sceneData[scene.id].SCRIPTS.PART1.images){
	// 	preload.paths.add(img);
	// }
	preload.paths.add(`${path}/${scene.id.substring(6)}_spine.js`);
	preload.paths.delete(undefined);
	preload.iter = preload.paths.values();
	fileLoader(loadSceneResources);
}

function loadSceneResources(){
	let path = preload.iter.next().value;
	if(path == null){
		if(preload.failed){
			fileErrorPopup();
			return;
		}
		if(scene.type == H_TABA){
			// Multi-part scenes may use the same files so using paths
			// doesn't always work.
			if(preload.files.size == Object.keys(preload.temp).length){
				cleanupPreload();
				startScene();
				return;
			}
		} else {
			// I don't know why filenames doesn't work and paths does
			// for RPGX but I also don't care enough to find out.
			// if(preload.paths.size == Object.keys(preload.temp).length ){
			// 	cleanupPreload();
			// 	startScene();
			// 	return;
			// }
			cleanupPreload();
			startScene();
			return;
		}
		//console.log("Error code: Some shit's not fucking loading");
		//console.log(loadSceneResources.caller);
		return;
	}
	main.elements.loadingFile.innerText = path;
	let fn = path.substr(path.lastIndexOf("/") + 1, path.lastIndexOf(".") - path.lastIndexOf("/") - 1);
	if(preload.temp[fn]){
		loadSceneResources();
		return;
	}
	let ext = path.substr(path.lastIndexOf(".")  + 1);
	if(ext === "png" || ext === "jpg"){
		loadImage(path, "tempPreloadImage", false, loadSceneResources);
	} else if(ext === "ogg" || ext === "m4a"){
		//loadAudio(path, false, loadSceneResources);
	} else if(ext === "webm"){
		loadVideo(path, "tempPreloadImage", false, loadSceneResources);
	} else if(ext === "js") {
		loadJS(path, loadSceneResources);
	}
}

function cleanupPreload(){
	preload.paths = new Set();
	preload.files = new Set();
	preload.failed = false;
	preload.failedPaths = [];
	preload.loaded = 0;
	main.elements.loadingWrap.style.visibility = "hidden";
}

function createCanvases(script, pairList=null){
	let evData = getCommandData(script, "<EV>", 0);
	evData = [...new Set(evData)];
	const prevParent = {ev:null}
	for(let ev of evData){
		createCGCanvases(ev, pairList, prevParent);
	}
	// for(let img of sceneData[id].hierarchy.pairList){
	// 	if(!preload.canvas.hasOwnProperty(img.parent)){
	// 		createCanvas([img.parent]);
	// 	}
	// 	if(!preload.canvas.hasOwnProperty(img.child)){
	// 		createCanvas([img.parent, img.child]);
	// 	}
	// }
}

function getPrevImage(image){
	const fn = image.split("_r18")[0];
	const prev = String.fromCharCode(fn.at(-1).charCodeAt(0) - 1);
	const r18 = image.includes("_r18") ? "_r18" : "";
	return fn.substring(0, fn.length - 1) + prev + r18;
}

function createCGCanvases(ev, pairList=null, prevParent={ev:null}){
	//console.log(ev + ", " + pairList)
	if(!preload.canvas.hasOwnProperty(ev) && pairList != null){
		const parentMap = new Map();
		for(const pair of pairList){
			parentMap.set(pair.parent, pair.parent);
			parentMap.set(pair.child, pair.parent);
		}
		let imageIndex = ev.split("_r18")[0].at(-1);
		if(parentMap.has(ev)){
			createCanvas([parentMap.get(ev), ev]);
		} else {
			let found = false;
			let prev = ev;
			while(imageIndex !== "a"){
				prev = getPrevImage(prev);
				imageIndex = prev.split("_r18")[0].at(-1);
				if(parentMap.has(prev)){
					found = true;
					createCanvas([parentMap.get(prev), ev]);
					break;
				}
			}
			if(!found){
				createCanvas([ev]);
			}
		}


		// let foundMatch = false;
		// for(let pair of pairList){
		// 	if(ev == pair.parent){
		// 		foundMatch = true;
		// 		prevParent.ev = pair.parent;
		// 		createCanvas([pair.parent]);
		// 		break;
		// 	} else if(ev == pair.child){
		// 		foundMatch = true;
		// 		prevParent.ev = pair.parent;
		// 		createCanvas([pair.parent, pair.child]);
		// 		break;	
		// 	}
		// }
		// if(!foundMatch){
		// 	// Sometimes EVs aren't listed in the pair list.
		// 	if(prevParent.ev == null){
		// 		createCanvas([ev])
		// 	} else {
		// 		createCanvas([prevParent.ev, ev]);
		// 	}
		// }
	} else {
		createCanvas([ev]);
	}
}

function createCanvas(files){
	let name = files[files.length - 1];
	let canvas = document.createElement("canvas");
	canvas.id = name
	canvas.height = 720;
	canvas.width = 1280;
	main.elements.canvasHoldElem.append(canvas);
	// let ctx = canvas.getContext("2d");

	// for(file of files){
	// 	let image = new Image();
	// 	image.onload = function(){
	// 		ctx.drawImage(image, 160, 0, 960, 720, 0, 0, 960, 720);
	// 	}
	// 	image.src = createImagePath(file);
	// }
	if(files.length == 2){
		drawImage(canvas, files[0], function(){
			drawImage(canvas, files[1])
		});
	} else {
		drawImage(canvas, files[0]);
	}
	canvas.classList.add("tempPreloadImage");
	preload.canvas[name] = canvas;
}

function drawImage(canvas, file, callback=null){
	let ctx = canvas.getContext("2d");
	let image = new Image();
	image.onload = function(){
		ctx.drawImage(image, 0, 0, 1280, 720, 0, 0, 1280, 720);
		if(callback != null){
			callback();
		}
	}
	image.src = createImagePath(file);
}

const hasExternalFile = new Set(["0295", "0299", "0334", "0364", "0382", "0470", "0494", "0498", "0502", "0516", "0542", "0562", "0615", "0651", "0680", "0697", "0732", "0345", "0603", "5003"]);

function createImagePath(file){
	if(scene.type === H_RPGX || scene.type === CG_RPGX){
		let id;
		if(file.startsWith("chr_0") && !hasExternalFile.has(file.substring(4,8))){
			id = file.replace("chr_", "").replace("_r18", "").replace(/[a-z]/g, "").substr(0,6);
		} else if(file.startsWith("exev")){
			id = (file.split("_")[0] + file.split("_")[1].replace(/[a-z]/, "")).replace("exev", "EX");
		// } else if(file.startsWith("ex")){
		// 	id = file.split("_")[0] + file.split("_")[1].replace(/[a-z]/, "");
		// 	console.log("ex match: " + file + ", " + id + ", " + scene.id)
		} else {
			id = scene.type === H_RPGX ? scene.id : cgViewer.scene;
		}
		return "./scenes/" + id + "/images/" + file + ".png";
	} else if(scene.type === STORY_RPGX){
		if(/[a-z]+_[a-z][0-9][0-9][0-9][a-z]/.test(file) || file.startsWith("chr_") || file.startsWith("ex_")){
			return "./Story/char/" + file + ".png";
		} else if(file.startsWith("ef") || file.startsWith("nc") || file.startsWith("chrnc")){
			return "./Story/bg/" + file + ".png";
		} else if(file.startsWith("stv") || file.startsWith("asg")){
			return "./Story/ev/" + file + ".png";
		}
	}
}

function createSpinePath(file) {
	if(scene.type === H_RPGX) {
		return `./scenes/${scene.id}/${file}.js`;
	}
}

function getCommandData(script, tag, idx=null){
	let data = []
	for(let cmd of script){
		if(cmd.startsWith(tag)){
			if(idx != null){
				data.push(cmd.substr(cmd.lastIndexOf(">") + 1).split(",")[idx]);
			} else {
				data.push(cmd.substr(cmd.lastIndexOf(">") + 1));
			}
		}
	}
	return data
}

// var trans = new Set();
// for(let key in sceneData){
// 	console.log(getCommandData(sceneData[key].script, "<TRANSITION>", 0));
// }

function constructImagePath(src, id){
	return "./scenes/" + id + "/images/" + src + ".png";
}
function constructVoiceAudioPath(src, id){
	return "./scenes/" + id + "/voices/" + src + ".ogg";
}

const RPGX2019BGM = new Set(["bgm010","bgm011","bgm012","bgm017","bgm018","bgm201","bgm202","bgm203","bgm205","bgm206","bgm207","bgm208","bgm209","bgm303","bgm304","bgm305","bgm306","bgm307","bgm308","bgm309","bgm310","bgm311","bgm312","bgm313","bgm314","bgm315","bgm317","bgm319","bgm320","bgm321","bgm401","bgm402","bgm403","bgm404","bgm405","bgm406","bgm407","bgm408","bgm409","bgm410","bgm501","bgm502","bgm503","bgm504","bgm505","bgm506","bgm509","bgm510","bgm601","bgm603","bgm604","bgm605","bgm606","bgm608","bgm609","bgm610","bgm611","bgm612","bgm705","bgm706","bgm709","bgm710","bgm716","bgm721","bgm724","bgm725","bgm801","bgm802","bgm803","bgm804","bgm805","bgm901","bgm902","bgm903","bgm904","bgm905","bgm906","bgm907","bgm908","bgm909","bgm910","bgm911","bgm912","bgm913","bgm914","bgm915"]);
const RPGX2019SE = new Set(["se001","se002","se002_01","se003","se003_01","se004","se005","se006","se007","se008","se009","se010","se011","se012","se013","se014","se014_01","se015","se016","se020","se020_01","se021","se023","se024","se025","se026","se027","se028","se030","se030_01","se030_02","se031","se032","se033","se035","se036","se036_02","se036_03","se036_04","se037","se038","se039","se039_01","se040","se040_02","se041","se042","se043","se044","se045","se046","se047","se047_01","se050","se051","se052","se053","se054","se056","se056_01","se057","se059","se060","se061","se062","se062_01","se063","se064","se065","se066","se067","se068","se069","se070","se071","se072","se073","se074","se074_01","se075","se076","se077","se077_01","se078","se079","se080","se081","se082","se083_01","se084","se085","se086","se087","se087_01","se088","se088_01","se090","se091","se093","se094","se095","se096","se097","se098","se099","se100","se101","se102","se103","se104","se105","se106","se107","se107_01","se108","se108_01","se109","se109_01","se110","se111","se112","se113","se114","se115","se116","se117","se118","se119","se120","se121","se122","se124","se125","se127","se128","se129","se130","se131","se132","se133","se134","se135","se136","se137","se138","se139","se139_01","se139_02","se140","se141","se142","se143","se144","se145","se146","se147","se148","se149"]);

function constructBGMAudioPath(src){
	return "./data/audio/bgm/" + src + (RPGX2019BGM.has(src) ? ".ogg" : ".m4a");
}

function constructSEAudioPath(src){
	return "./data/audio/se/" + src + (RPGX2019SE.has(src) ? ".ogg" : ".m4a");
}

function emptyTempPreload(){
	// Kill children causes some weird shit in CG mode for the canvas holder
	// for(let key in preload.canvas){
	// 	let child = preload.canvas[key];
	// 	child.parentElement.removeChild(child)
	// }
	preload.spine = {};
	preload.canvas = {};
	preload.temp = {};
	preload.paths = new Set();
	preload.files = new Set();
	killChildren(document.getElementById("preload-temp-elem"));
	killChildren(main.elements.canvasHoldElem);
}

// var names = new Set();
// for(let key in sceneData){
// 	let curScene = sceneData[key];
// 	for(let cmd of curScene.script){
// 		if(cmd.startsWith("<NAME_PLATE>")){
// 			let name = cmd.substr(cmd.lastIndexOf(">") + 1);
// 			if(/[ａ-ｚＡ-Ｚ０-９？]/.test(name)){
// 				names.add(name.substr(0, /[ａ-ｚＡ-Ｚ０-９？]/.exec(name).index).trim());
// 			} else {
// 				names.add(name.trim());
// 			}
// 		}
// 	}
// }

function permPreload(paths){
	preload.paths = new Set(paths);
	preload.paths.delete(undefined);
	preload.iter = preload.paths.values();
	displayLoadScreen();
	loadPermFiles();
}

function loadPermFiles(){
	let path = preload.iter.next().value;
	if(path == null || path == undefined){
		if(preload.failed){
			fileErrorPopup();
			return;
		} else {
			cleanupPreload();
			return;
		}
	}
	main.elements.loadingFile.innerText = path;
	let fn = path.substr(path.lastIndexOf("/") + 1, path.lastIndexOf(".") - path.lastIndexOf("/") - 1);
	if(preload.temp[fn]){
		loadPermFiles();
		return;
	}
	loadImage(path, "permPreloadImage", true, loadPermFiles);
}

function errorLoading(path){
	preload.failed = true;
	preload.failedPaths.push(path);
}

function fileErrorPopup(){
	main.elements.loadingError.style.visibility = "initial";
	main.elements.loadingErrorMsg.value = "The following files could not be loaded:\n"
	for(let error of preload.failedPaths){
		main.elements.loadingErrorMsg.value += "    " + error + "\n";
	}
}

function closeError(){
	main.elements.loadingError.style.visibility = "hidden";
	main.elements.loadingErrorMsg.value = "";
	cleanupPreload();
	endScene();
}

function fileLoader(loadFunction){
	for(let i = 0; i < prefs.viewer.fileLoaders; i++){
		loadFunction();
	}
}

function updateProgress(){
	main.elements.loadingProgress.style.width = ((preload.loaded / preload.paths.size) * 100) + "%";
}

function loadImage(path, className, perm, callback){
	let img = new Image();
	let fn = path.substr(path.lastIndexOf("/") + 1, path.lastIndexOf(".") - path.lastIndexOf("/") - 1);
	img.className = className;
	img.addEventListener("load", function(){
		if(perm){
			preload.perm[fn] = img;
			preload.permElem.append(img);
		} else {
			preload.temp[fn] = img;
			preload.tempElem.append(img);
		}
		preload.loaded++;
		updateProgress();
		callback();
	}, {once:true});
	img.addEventListener("error", function(){
		errorLoading(path);
		callback();
	}, {once:true})
	img.src = path;
}

function loadJS(path, callback) {
	const elem = document.createElement("script");
	elem.addEventListener("load", () => {
		elem.remove();
		preload.loaded++;
		updateProgress();
		callback();
	}, {once: true});
	elem.addEventListener("error", () => {
		elem.remove();
		preload.loaded++;
		errorLoading(path);
		callback();
	}, {once: true});
	elem.src = path;
	document.body.appendChild(elem);
}

function loadVideo(path, className, perm, callback){
	let vid = document.createElement("video");
	let fn = path.substr(path.lastIndexOf("/") + 1, path.lastIndexOf(".") - path.lastIndexOf("/") - 1);
	vid.className = className;
	vid.addEventListener("canplay", function(){
		if(perm){
			preload.perm[fn] = vid;
			preload.permElem.append(vid);
		} else {
			preload.temp[fn] = vid;
			preload.tempElem.append(vid);
		}
		preload.loaded++;
		updateProgress();
		callback();
	}, {once:true});
	vid.addEventListener("error", function(){
		errorLoading(path);
		callback();
	}, {once:true})
	vid.src = path;
}

function loadAudio(path, perm, callback){
	let audio = new Audio();
	let fn = path.substr(path.lastIndexOf("/") + 1, path.lastIndexOf(".") - path.lastIndexOf("/") - 1);
	audio.addEventListener("canplay", function(){
		if(perm){
			preload.perm[fn] = audio;
		} else {
			preload.temp[fn] = audio;
		}
		preload.loaded++;
		updateProgress();
		callback();
	}, {once:true});
	audio.addEventListener("error", function(){
		errorLoading(path);
		callback();
	}, {once:true});
	audio.src = path;
}

async function loadAudioNow(path, type){
	return new Promise((resolve, reject) => {
		let audio = preload.audio[type.toLowerCase()];
		audio.src = "";
		audio.oncanplaythrough = () => resolve();
		audio.onerror = (e) => {
			//deleteElement(elem);
			errorLoading(path)
			reject()
		};
		audio.src = path;
	});

	// function promiseFile(path, obj){
	// 	return new Promise((resolve, reject) => {
	// 		let audio = obj;
	// 		audio.oncanplaythrough = () => resolve();
	// 		audio.onerror = (e) => {
	// 			//deleteElement(elem);
	// 			errorLoading(path)
	// 			reject()
	// 		};
	// 		audio.src = path;
	// 	});
	// }
}

async function loadBacklogVoice(path){
	scene.current.backlogVoice.src = "";
	try{
		await promiseFile(path);
	} catch(e){
		console.log("Backlog Audio Load Error");
	}

	function promiseFile(path){
		return new Promise((resolve, reject) => {
			let audio = scene.current.backlogVoice;
			audio.oncanplaythrough = () => resolve();
			audio.onerror = () => {
				//deleteElement(elem);
				reject()
			};
			audio.src = path;
		});
	}
}

// requires a default switch statement to handle text commands
function getCommandType(cmd){
    return cmd.split(/[<>]/)[1];
}

function splitCommand(cmd){
    return cmd.split(/[<>,]/);
}