var cgViewer = {
	animQ:[],
	imgQ:[],
	sceneQ:[],
	index:0,
	slideshow:false,
	scene:"0000",
	rpgx:true,
	alt:false,
	elements:{

	},
	spine: {}
}

async function startCGViewMode(id){
	buildCGViewer();

	main.elements.viewer.style.zIndex = "1"
	main.elements.viewer.style.opacity = "1";
	main.view.current = CG_VIEWER;
	switchView();

	cgViewer.sceneQ = [...main.sceneList];
	if(prefs.cg.shuffleScene){
		shuffle(cgViewer.sceneQ);
	}

	cgViewer.scene = id;
	cgViewer.rpgx = sceneData[cgViewer.scene].rpgx;
	scene.type = cgViewer.rpgx ? CG_RPGX : CG_TABA;
	cgViewer.index = 0;
	if(prefs.cg.slideshow){
		toggleSlideShow();
	}
	main.elements.foot.auto.innerHTML = "";
	main.elements.foot.skip.innerHTML = "Play Scene";

	fillImgQ();
	await preloadCGs()
	displayCG();
}

function exitCGViewMode(){
	main.elements.foot.mode.value = "Mode: CG";
	cgViewer.slideshow = false;
	toggleOffSlideShow()
	cgViewer.imgQ.length = 0;
	cgViewer.animQ.length = 0;
	killChildren(main.elements.viewer);
	emptyTempPreload();
	loadSceneSelect();
}

function buildCGViewer(){
	ui = cgViewer.elements;
	ui.cg = elem("div", "viewer-main-class", "viewer-large-image");
	ui.cgAlt = elem("div", "viewer-main-class", "viewer-large-image");
	ui.menu = elem("div", "cg-viewer-menu");
	ui.play = elem("div", "styled-btn", "cg-viewer-btn");
	ui.exit = elem("div", "styled-btn", "cg-viewer-btn");
	ui.slideInput = elem("input", "no-display");
	ui.slide = elem("div", "styled-btn", "cg-viewer-btn");
	ui.full = elem("div", "styled-btn", "cg-viewer-btn");

	ui.play.innerText = "Play Scene";
	ui.exit.innerText = "Exit";
	ui.slide.innerText = "Slideshow";
	ui.full.innerText = "Full Screen";

	ui.slideInput.type = "checkbox";

	ui.play.addEventListener("click", () => {
		chooseScene(cgViewer.scene)
	});
	ui.exit.addEventListener("click", exitCGViewMode);
	ui.slide.addEventListener("click", toggleSlideShow);
	ui.full.addEventListener("click", toggleFullscreen);
	ui.menu.append(ui.play, ui.slideInput, ui.slide, ui.full, ui.exit);
	main.elements.viewer.append(ui.cg, ui.cgAlt, ui.menu);
}

async function nextCGScene(){
	if(prefs.cg.randomScene || prefs.cg.randomImg){
		cgViewer.scene = cgViewer.sceneQ[Math.floor(Math.random() * cgViewer.sceneQ.length)];
	} else {
		cgViewer.scene = cgViewer.sceneQ.indexOf(cgViewer.scene) != cgViewer.sceneQ.length - 1 ? cgViewer.sceneQ[cgViewer.sceneQ.indexOf(cgViewer.scene) + 1] : cgViewer.sceneQ[0];
	}

	cgViewer.index = 0;
	emptyTempPreload();
	cgViewer.spine = {};
	cgViewer.imgQ.length = 0;
	cgViewer.animQ.length = 0;
	cgViewer.rpgx = sceneData[cgViewer.scene].rpgx;
	scene.type = cgViewer.rpgx ? CG_RPGX : CG_TABA;
	
	fillImgQ();
	await preloadCGs();
}

async function prevCGScene(){
	if(prefs.cg.randomScene || prefs.cg.randomImg){
		cgViewer.scene = cgViewer.sceneQ[Math.floor(Math.random() * cgViewer.sceneQ.length)];
	} else {
		cgViewer.scene = cgViewer.sceneQ.indexOf(cgViewer.scene) != 0 ? cgViewer.sceneQ[cgViewer.sceneQ.indexOf(cgViewer.scene) - 1] : cgViewer.sceneQ[cgViewer.sceneQ.length - 1];
	}

	emptyTempPreload();
	cgViewer.imgQ.length = 0;
	cgViewer.animQ.length = 0;
	cgViewer.rpgx = sceneData[cgViewer.scene].rpgx;
	scene.type = cgViewer.rpgx ? CG_RPGX : CG_TABA;
	
	fillImgQ();
	await preloadCGs();
}

async function nextCG(){
	const queue = cgViewer.animQ.length > 0 ? cgViewer.animQ : cgViewer.imgQ;
	if(prefs.cg.randomImg){
		await nextCGScene();
	} else if(cgViewer.index >= queue.length - 1){
		console.log("next scene")
		await nextCGScene();
		cgViewer.index = 0;
	} else {
		console.log("inc index")
		cgViewer.index++;
	}
	console.log("display")
	displayCG();
}

async function prevCG(){
	
	if(prefs.cg.randomImg){
		await prevCGScene();
	} else if(cgViewer.index <= 0){
		await prevCGScene();
		const queue = cgViewer.animQ.length > 0 ? cgViewer.animQ : cgViewer.imgQ;
		cgViewer.index = queue.length - 1;
	} else {
		cgViewer.index--;
	}
	displayCG();
}

function fillImgQ(){
	if(cgViewer.rpgx){
		for(let part in sceneData[cgViewer.scene].SCRIPTS){
			let data = sceneData[cgViewer.scene].SCRIPTS[part];
			if(data.images.length === 1) {
				cgViewer.imgQ.push(`scenes/${cgViewer.scene}/${data.images[0]}`);
				cgViewer.animQ.push.apply(cgViewer.animQ, data.animations);
			} else {
				cgViewer.imgQ.push.apply(cgViewer.imgQ, data.images);
			}
		}
	} else {
		if(cgViewer.scene[0] == "c"){
			cgViewer.imgQ = sceneData[cgViewer.scene].images;
		} else if (cgViewer.scene.includes("HAR")){
			for(let part in sceneData[cgViewer.scene].SCRIPTS){
				let data = sceneData[cgViewer.scene].SCRIPTS[part];
				cgViewer.imgQ.push.apply(cgViewer.imgQ, data.images);
			}
		} else if(cgViewer.scene.includes("OTOGI")) {
			const id = cgViewer.scene.substring(6);
			cgViewer.imgQ.push(`OtogiScenes/${id}/${id}_spine.js`);
			cgViewer.animQ.push("animation1", "animation2", "animation3", "animation4");
		}
	}
}

async function preloadCGs(){
	// Preload just the single CG if random, all if not
	if(prefs.cg.randomImg){
		cgViewer.index = Math.floor(Math.random() * cgViewer.imgQ.length);
		await preloadCG(cgViewer.imgQ[cgViewer.index], cgViewer.scene);
	} else {
		for(let image of cgViewer.imgQ){
			await preloadCG(image, cgViewer.scene);
		}
	}
}

async function preloadCG(image, id){
	let scene = sceneData[id]
	if(cgViewer.rpgx && cgViewer.animQ.length === 0){
		for(let part in scene.SCRIPTS){
			let data = scene.SCRIPTS[part];
			if(data.images.includes(image)){
				createCGCanvases(image, data.HIERARCHY.pairList);
				break;
			}
		}
	} else {
		let ext = image.substr(image.lastIndexOf(".")  + 1);
		switch(ext) {
			case "webm": {
				let vid = document.createElement("video");
				vid.className = "tempPreloadImage";
				vid.addEventListener("canplay", function(){
					preload.temp[image] = vid;
					preload.tempElem.append(vid);
				}, {once:true});
				vid.src = image;
				break;
			}
			case "js": {
				console.log(image, id)
				const script = document.createElement("script");
				script.src = image;
				await new Promise((resolve, reject) => {
					script.addEventListener("load", async () => {
						script.remove();
						if(cgViewer.rpgx) {
							const fn = image.split("/")[2].split(".")[0];
							console.log(fn)
							cgViewer.spine[id] = await SpineModel.from(preload.spine[fn]);
						} else {
							cgViewer.spine[id] = await SpineGroup.from(preload.spine[id]);
						}
						resolve();
					}, {once:true});
					script.addEventListener("error", () => {
						script.remove();
						reject();
					}, {once: true});
					document.body.appendChild(script);
				});
				break;
			}
			default: {
				let img = new Image();
				img.className = "tempPreloadImage";
				img.addEventListener("load", function(){
					preload.temp[image] = img
					preload.tempElem.append(img);
				}, {once:true});
				img.src = image;
				break;
			}
		}
	}
}

function displayCG(){
	let cgElem = cgViewer.alt ? cgViewer.elements.cgAlt : cgViewer.elements.cg;
	const animation = cgViewer.imgQ[0].endsWith(".js");
	let curCG = animation ? cgViewer.animQ[cgViewer.index] : cgViewer.imgQ[cgViewer.index];
	let fade = prefs.cg.fadeEffect;

	if(animation) {
		fade = false;
	} else {
		for (let child of cgElem.children){
			child.style.visibility = "hidden";
			main.elements.canvasHoldElem.append(child);
		}
	}
	
	cgElem.style.background = "";

	if(cgViewer.rpgx){
		// let clone = cloneCanvas(preload.canvas[curCG]);
		// cgElem.appendChild(clone);
		if(animation) {
			const model = cgViewer.spine[cgViewer.scene];
			const canvas = scene.spine.canvas;
			canvas.style.visibility = "initial";
			if(canvas.parentElement !== cgElem) {
				const pillar1 = document.createElement("div");
				const pillar2 = document.createElement("div");
				const style = {
					width: "160px",
					height: "720px",
					backgroundColor: "black",
					position:"absolute"
				}
				Object.assign(pillar1.style, style);
				Object.assign(pillar2.style, style);
				pillar2.style.right = "0";
				setSpineCanvasSize(H_RPGX);
				scene.spine.frameRequestId = requestAnimationFrame(renderSpine);
				cgElem.append(pillar1, pillar2, canvas);
			}
			if(!scene.spine.renderList.includes(model)) {
				console.log("updating model")
				scene.spine.renderList.length = 0;
				model.pma = false;
				scene.spine.renderList.push(model);
				model.position(640, 360);
				model.scale(0.75);
			}
			console.log(curCG)
			model.setAnimation({animationName: curCG, loop: true});
		} else {
			cgElem.appendChild(preload.canvas[curCG]);
			preload.canvas[curCG].style.visibility = "initial";
		}
	} else {
		if(cgViewer.scene[0] == "c"){
			cgElem.style.background = "black url('" + curCG + "') no-repeat center";
		} else if (cgViewer.scene.includes("HAR")){
			let ext = curCG.substr(curCG.lastIndexOf(".")  + 1);
			if(ext == "webm"){
				let vid = document.createElement("video");
				vid.width = 960;
				vid.height = 720;
				vid.loop = true;
				vid.src = curCG;
				vid.classList = "viewer-main-class viewer-video";
				cgElem.appendChild(vid);
				vid.load();
				vid.play();
			} else {
				cgElem.style.background = "black url('" + curCG + "') no-repeat center/960px 720px";
			}
		} else if (cgViewer.scene.includes("OTOGI")){
			const model = cgViewer.spine[cgViewer.scene];
			const canvas = scene.spine.canvas;
			canvas.style.visibility = "initial";
			if(canvas.parentElement !== cgElem) {
				setSpineCanvasSize(H_OTOGI);
				scene.spine.frameRequestId = requestAnimationFrame(renderSpine);
				cgElem.appendChild(canvas);
			}
			if(!scene.spine.renderList.includes(model)) {
				console.log("updating model")
				scene.spine.renderList.length = 0;
				model.pma = true;
				const originalSpines = otogi.originalSpines.has(scene.id);
				if(otogi.thumb) {
					const y = originalSpines ? -18 : 180;
					model.position(240, y);
					model.scale(0.5);
				} else {
					const y = originalSpines ? -125 : 320;
					model.position(568, y);
				}
				scene.spine.renderList.push(model);
			}
			model.setAnimation({animationName: curCG, loop: true});

			

			
			// let vid = document.createElement("video");
			// vid.width = 1402;
			// vid.height = 898;
			// vid.loop = true;
			// vid.src = curCG;
			// vid.style.width = "1402px";
			// vid.style.height = "898px";
			// vid.style.left = "-140px";
			// vid.style.top = "-118px";
			// vid.classList = "viewer-main-class viewer-video";
			// cgElem.appendChild(vid);
			// vid.load();
			// vid.play();
		}
		
	}

	if(fade){
		animateElement(cgElem, 1000, "fade-in", false);

		cgElem.style.zIndex = "2";
		if(cgViewer.alt){
			cgViewer.elements.cg.style.zIndex = "1";
			removeAnimation(cgViewer.elements.cg);
		} else {
			cgViewer.elements.cgAlt.style.zIndex = "1";
			removeAnimation(cgViewer.elements.cgAlt);
		}
		cgViewer.alt = !cgViewer.alt;
	}
	
	
}

function slideshowMode(){
	cgViewer.nextSlide = setTimeout(function(){
		if(cgViewer.slideshow && main.view.current == CG_VIEWER){
			nextCG();
			slideshowMode();
		}
	}, prefs.cg.slideshowWait);
}

function shuffle(array) {
	for (let i = array.length - 1; i > 0; i--) {
		let j = Math.floor(Math.random() * (i + 1));
		[array[i], array[j]] = [array[j], array[i]];
	}
}