#    Name: softdenchi_remove.py
#
#   Usage: Drag game.exe onto softdenchi_remove.py.
#          This will make a new exe in the same location as game.exe.
#
# Process: SoftDenchi is a DRM that requires you to run its parent program in
#          the background before it will run the protected binary. The parent
#          service behaves eerily similar to malware in that it is constantly
#          running in the background, even when you aren't using applications
#          protected by it. The parent service UCManSvc is somewhat intricate
#          especially when compared to the trivial wrapper which protects the
#          main program. The wrapper itself puts the protected binary data at
#          the end of its own binary content. You may think that DRM wrappers
#          would obfuscate or encrypt the binary data it aims to protect, but
#          with SoftDenchi this is not the case. As such, the main program is
#          easily extracted if you can find where it begins. This script uses
#          the executable file header to find the start of the protected data
#          and dumps the data to a new executable. Now we can enjoy a legally
#          obtained game without needing to install an ever-present watchdog.
#          
# Version: Works with the latest version (5.0.5.0/May 2017) as of August 2018.

import sys

in_path = sys.argv[1]
out_path = in_path[:-4] + "-nodrm.exe"

with open(in_path, "rb") as drm_file, open(out_path, "wb") as cleaned_file:
	drm_data = drm_file.read()
	exe_header = drm_data[:4] # 4D 5A 90 00
	start_location = drm_data.find(exe_header, 1)
	protected_data = drm_data[start_location:]
	cleaned_file.write(protected_data)