-- name: Sprays
-- description: Adds a Source-like spray system to Mario 64! \nDPAD_DOWN to spray! \nChange sprays with /spray-type! \nMade by BuckleyTim and Birdekek

local msg_timer = 0

current_spray = 0

E_MODEL_SOURCE_SPRAY = smlua_model_util_get_id("icon_display_geo")
SFX_JSR_M64 = audio_sample_load("spray.ogg")

define_custom_obj_fields({
    oIcon = "u32",
    oIconType = "u32"
})

--add spray textures

spray_table = { -- add new custom sprays here
    -- {name = 'finn', texture = get_texture_info("spray_finn")},
    -- {name = 'warger', texture = get_texture_info("spray_warger")},
    -- {name = 'trollface', texture = get_texture_info("spray_trollface")},
    -- {name = 'retro', texture = get_texture_info("spray_retro")},
    -- {name = 'bup', texture = get_texture_info("spray_bup")},
}

local defaultIcons = {
    [CT_MARIO]   = get_texture_info("spray_mario"),
    [CT_LUIGI]   = get_texture_info("spray_luigi"),
    [CT_TOAD]    = get_texture_info("spray_toad"),
    [CT_WALUIGI] = get_texture_info("spray_waluigi"),
    [CT_WARIO]   = get_texture_info("spray_wario")
}

local fe_mat = gfx_get_from_name("mat_icon_display_icon")
local changed_objects = {}

function vec3f() return {x=0,y=0,z=0} end

local function get_beh_param(behParams, param) -- credits to xLuigiGamerx
    return (behParams >> (8 * (4 - param))) & 0xFF
end

local function set_beh_param(behParams, param, value)
    local shift = 8 * (4 - param)
    behParams = behParams & ~(0xFF << shift)
    return behParams | ((value & 0xFF) << shift)
end

local function get_icon(o)
    local icon

    if o.oBehParams2ndByte ~= 1 then
        local char_table = _G.charSelect.character_get_current_table(o.oBehParams2ndByte, get_beh_param(o.oBehParams, 4))
        icon = char_table.lifeIcon
    else
        if _G.charSelectExists then
            icon = defaultIcons[(o.oBehParams & 0xFF) - 1]
        else
            icon = defaultIcons[o.oBehParams & 0xFF]
        end
    end

    return icon
end

function display_icon_geo_func(node, matStackIndex)
    local o = geo_get_current_object()

    local ptr = o._pointer
    local geo = cast_graph_node(node.next)

    local dlHead = gfx_get_from_name("fe_displaylist" .. ptr)

    if not dlHead then
        dlHead = gfx_create("fe_displaylist" .. ptr, 16)
        gfx_copy(dlHead, fe_mat, gfx_get_length(fe_mat))
    end

    local texture

    if o.oBehParams2ndByte ~= 0 then
        texture = get_icon(o)
    else
        texture = spray_table[get_beh_param(o.oBehParams, 4)].texture
    end

    if not changed_objects[o] then
        local cmdt = gfx_get_command(dlHead, 7)
        gfx_set_command(cmdt, "gsDPSetTextureImage(G_IM_FMT_RGBA, G_IM_SIZ_16b_LOAD_BLOCK, 1, %t)", texture.texture)

        changed_objects[o] = true
    end

    geo.displayList = dlHead
end

function spawn_mist_spray(obj, scale)
    local spi = obj_get_temp_spawn_particles_info(E_MODEL_MIST)
    if spi == nil then
        return nil
    end

    spi.behParam = 3
    spi.count = 5
    spi.offsetY = 25
    spi.forwardVelBase = 6 * scale
    spi.forwardVelRange = -12 * scale
    spi.velYBase = 6 * scale
    spi.velYRange = -12 * scale
    spi.gravity = 0
    spi.dragStrength = 5
    spi.sizeBase = 10 * scale
    spi.sizeRange = 16 * scale

    cur_obj_spawn_particles(spi)
    djui_chat_message_create('spawn mist')
end

function bhv_spray_init(o)
    obj_scale(o, 0.4)
end

id_bhvCustomSpray = hook_behavior(nil, OBJ_LIST_GENACTOR, true, bhv_spray_init, nil, "bhvCustomSpray")

-----------
-- MARIO UPDATE

function mario_update(m) -- ALL Mario_Update hooked commands.,
    if is_player_active(m) == 0 or m ~= gMarioStates[0] then return end

    if (m.wall and (m.controller.buttonPressed & D_JPAD ~= 0)) then
        local spray = spawn_sync_object(id_bhvCustomSpray, E_MODEL_SOURCE_SPRAY, m.pos.x, m.pos.y + 175, m.pos.z, function(o)
            local z, normal = vec3f(), m.wall.normal
            local x, xnormal = vec3f(), m.wall.normal
            --remove 16384 for floor spray variant
            o.oFaceAnglePitch = calculate_pitch(x, xnormal)
            o.oFaceAngleYaw = calculate_yaw(z, normal)
            o.oFaceAngleRoll = obj_resolve_collisions_and_turn(o.oFaceAngleYaw, 0)
            o.oPosX = o.oPosX - (48 * sins(o.oFaceAngleYaw))
            o.oPosZ = o.oPosZ - (48 * coss(o.oFaceAngleYaw))

            if current_spray == 0 then
                if _G.charSelectExists then
                    o.oBehParams2ndByte = _G.charSelect.character_get_current_number(0)
                    o.oBehParams = set_beh_param(o.oBehParams, 4, _G.charSelect.character_get_current_costume(0))
                else
                    o.oBehParams2ndByte = 1
                    o.oBehParams = set_beh_param(o.oBehParams, 4, gMarioStates[0].character.type)
                end
            else
                o.oBehParams = set_beh_param(o.oBehParams, 4, current_spray)
            end
        end)

        audio_sample_play(SFX_JSR_M64, m.pos, 1)
        spawn_mist_spray(spray, 3)
    end
end

hook_event(HOOK_MARIO_UPDATE, mario_update)

local function change_spray(msg) -- for future reference please don't name your functions like chat_changeSprayType. it's very cursed
    local spray_name_table = {}

    for i = 1, #spray_table do
        local spray_name = spray_table[i].name

        if msg == spray_name then
            current_spray = i
            djui_chat_message_create('Spray changed to ' .. spray_name .. '!')
            return true
        end

        table.insert(spray_name_table, spray_name)
    end

    if msg == 'character' then
        current_spray = 0
        djui_chat_message_create('Spray changed to character!')
        return true
    end

    djui_chat_message_create('All Sprays: \\#00ffff\\[ character | ' .. table.concat(spray_name_table, ' | ', 1, #spray_name_table) .. ' ]')
    return true
end

local function obj_unload(o)
    if changed_objects[o] then
        changed_objects[o] = nil
    end
end

local function update()
    msg_timer = msg_timer + 1

    if msg_timer == 10 then
        djui_chat_message_create('This server has Spray mod enabled. Press DPAD Down to spray.')
        djui_chat_message_create('"/spray" can also be used to change what type of spray you have!')
        msg_timer = 20
    end
end

hook_event(HOOK_UPDATE, update)
hook_event(HOOK_ON_OBJECT_UNLOAD, obj_unload)

hook_chat_command("spray", "\\#00ffff\\[ character | spray ]", change_spray)

--credits
--BuckleyTim made the thing
--Holc is a genius for Goremod which is where a lot of this code is cribbed from
--Birdekek is another genius where the retexture function is from