--- Hook Wrapper
--- @param hookEventType LuaHookedEventType
local function create_hook_wrapper(hookEventType)
  local callbacks = {}

  hook_event(hookEventType, function(...)
    for _, func in pairs(callbacks) do
      func(...)
    end
  end)

  return function(func)
    table.insert(callbacks, func)
  end
end

local hook_mario_update = create_hook_wrapper(HOOK_MARIO_UPDATE)
local hook_update = create_hook_wrapper(HOOK_UPDATE)

_G.Moi64Mods = {
  hook_update = hook_update,
  hook_mario_update = hook_mario_update
}