
local ipairs, warp_to_level, soft_reset_camera, set_mario_action, get_temp_object_hitbox, obj_set_hitbox, load_object_collision_model, nearest_mario_state_to_object,
      hook_behavior, spawn_non_sync_object, hook_event, allocate_mario_action, hook_mario_action, play_sound_if_no_flag, set_character_animation
      =
      ipairs, warp_to_level, soft_reset_camera, set_mario_action, get_temp_object_hitbox, obj_set_hitbox, load_object_collision_model, nearest_mario_state_to_object,
      hook_behavior, spawn_non_sync_object, hook_event, allocate_mario_action, hook_mario_action, play_sound_if_no_flag, set_character_animation

local np = gNetworkPlayers[0]

local WARP_TYPE_PIPE = 0
local WARP_TYPE_FADE = 1

local ACT_CUSTOM_TELEPORT_FADE_OUT = allocate_mario_action(ACT_FLAG_STATIONARY | ACT_FLAG_INTANGIBLE)

HACK_VANILLA = 0

--* Define the warps in the table
--* there are multiple parameters like exitFunc used when you exit out of the warp
--* if you want the warp to be one way then simply don't put a target area or target node

local sVanillaWarps = {
    [LEVEL_CASTLE_GROUNDS] = {
        { area = 1, warpType = WARP_TYPE_PIPE, pos = { x = 0, y = 803, z = 0, yaw = -204, pitch = 0, roll = 0 }, node = 0, targetLevel = LEVEL_CASTLE_COURTYARD, targetArea = 1, targetNode = 0 },
    },
    [LEVEL_CASTLE_COURTYARD] = {
        { area = 1, warpType = WARP_TYPE_PIPE, pos = { x = 0, y = 0, z = -3576, yaw = -143, pitch = 0, roll = 0 }, node = 0, targetLevel = LEVEL_CASTLE_GROUNDS, targetArea = 1, targetNode = 0 },
    },
    [LEVEL_LLL] = {
        { area = 2, warpType = WARP_TYPE_PIPE, pos = { x = -1691, y = 50, z = -431, yaw = 0, pitch = 0, roll = 0 },      node = 0, targetLevel = LEVEL_LLL, targetArea = 1, targetNode = 1 },
        { area = 1, warpType = WARP_TYPE_PIPE, pos = { x = 7132, y = 307, z = 1396, yaw = -16415, pitch = 0, roll = 0 }, node = 1, targetLevel = LEVEL_LLL },
    },
    [LEVEL_SSL] = {
        { area = 1, warpType = WARP_TYPE_PIPE, pos = { x = 3333, y = 0, z = -5915, yaw = 0, pitch = 0, roll = 0 },    node = 1, targetLevel = LEVEL_SSL },
        { area = 2, warpType = WARP_TYPE_PIPE, pos = { x = 575, y = 0, z = 4323, yaw = -32768, pitch = 0, roll = 0 }, node = 0, targetLevel = LEVEL_SSL, targetArea = 1, targetNode = 1 },
    },
    [LEVEL_JRB] = {
        { area = 1, warpType = WARP_TYPE_PIPE, pos = { x = -2456, y = -2966, z = -4105, yaw = 18258, pitch = 0, roll = 0 }, node = 1, targetLevel = LEVEL_JRB },
        { area = 2, warpType = WARP_TYPE_PIPE, pos = { x = 467, y = -202, z = 735, yaw = 0, pitch = 0, roll = 0 },          node = 0, targetLevel = LEVEL_JRB, targetArea = 1, targetNode = 1 },
    },
    [LEVEL_RR] = {
        { area = 1, warpType = WARP_TYPE_PIPE, pos = { x = 6462, y = -1091, z = 893, yaw = -16384, pitch = 0, roll = 0 }, node = 1, targetLevel = LEVEL_RR, targetArea = 1, targetNode = 0 },
        { area = 1, warpType = WARP_TYPE_PIPE, pos = { x = -4974, y = 6451, z = -5158, yaw = 0, pitch = 0, roll = 0 },    node = 0, targetLevel = LEVEL_RR, targetArea = 1, targetNode = 1 },
    },
}

local sWarps = {
    ["Vanilla"] = sVanillaWarps
}

local delay = 0
local delayedWarp = nil

local function perform_warp(m, exitAct, currNode)
    local warps = sWarps[currHack]
    local currLevelWarps = warps[np.currLevelNum]
    if not warps or not currLevelWarps then return end
    for _, warp in ipairs(currLevelWarps) do
        if warp.node == currNode then
            local targetLevelWarps = warps[warp.targetLevel]
            if not targetLevelWarps then return end
            if warp.targetNode == nil or warp.targetArea == nil then return end

            for _, targetWarp in ipairs(targetLevelWarps) do
                if targetWarp.node == warp.targetNode then
                    if (targetWarp.area ~= warp.area) or (targetWarp.targetLevel ~= warp.targetLevel) then
                        delay = 2
                        delayedWarp = {
                            m = m,
                            exitAct = exitAct,
                            targetWarp = targetWarp,
                        }
                        if not warp_to_level(warp.targetLevel, warp.targetArea, np.currActNum) then
                            warp_to_warpnode(warp.targetLevel, warp.targetArea, np.currActNum, 0)
                        end
                    else
                        soft_reset_camera(m.area.camera)
                        set_mario_action(m, exitAct, 0)
                        m.pos.x = targetWarp.pos.x
                        m.pos.y = targetWarp.pos.y
                        m.pos.z = targetWarp.pos.z
                        m.faceAngle.y = targetWarp.yaw or 0
                        if targetWarp.exitFunc then
                            targetWarp.exitFunc()
                        end
                    end
                    return
                end
            end
        end
    end
end

local function act_custom_teleport_fade_out(m)
    if not m then return 0 end
    play_sound_if_no_flag(m, SOUND_ACTION_TELEPORT, MARIO_ACTION_SOUND_PLAYED)
    set_character_animation(m, m.prevAction == ACT_CROUCHING and CHAR_ANIM_CROUCHING or CHAR_ANIM_FIRST_PERSON)

    if m.actionTimer == 0 then
        queue_rumble_data_mario(m, 30, 70)
    end

    m.flags = m.flags | MARIO_TELEPORTING

    if m.actionTimer < 32 then
        m.fadeWarpOpacity = (-m.actionTimer << 3) + 0xF8
    end

    if m.actionTimer == 30 then
        if m.playerIndex == 0 then
            perform_warp(m, ACT_TELEPORT_FADE_IN, m.actionArg)
        end
    end

    m.actionTimer = m.actionTimer + 1
    stop_and_set_height_to_floor(m)

    return false
end

local function custom_pipe_init(o)
    local hitbox = get_temp_object_hitbox()
    hitbox.interactType = INTERACT_WATER_RING
    hitbox.radius = 100
    hitbox.height = 90
    obj_set_hitbox(o, hitbox)

    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    o.collisionData = gGlobalObjectCollisionData.warp_pipe_seg3_collision_03009AC8
end

local function custom_pipe_loop(o)
    load_object_collision_model()
    local m = nearest_mario_state_to_object(o)
    if m and (o.oInteractStatus & INT_STATUS_INTERACTED) ~= 0 then
        perform_warp(m, ACT_EMERGE_FROM_PIPE, o.oBehParams2ndByte)
    end
    o.oInteractStatus = 0
end

local function custom_fade_init(o)
    local hitbox = get_temp_object_hitbox()
    hitbox.interactType = INTERACT_WATER_RING
    hitbox.radius = 85
    hitbox.height = 50
    obj_set_hitbox(o, hitbox)

    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
end

local function custom_fade_loop(o)
    local m = nearest_mario_state_to_object(o)
    if m.prevAction == ACT_TELEPORT_FADE_IN or m.action == ACT_TELEPORT_FADE_IN or m.health <= 0xFF then return end
    if m and (o.oInteractStatus & INT_STATUS_INTERACTED) ~= 0 and (m.action == ACT_IDLE or m.action == ACT_PANTING or m.action == ACT_STANDING_AGAINST_WALL
    or m.action == ACT_CROUCHING) then
        set_mario_action(m, ACT_CUSTOM_TELEPORT_FADE_OUT, o.oBehParams2ndByte)
    end
    o.oInteractStatus = 0
end

local id_bhvCustomPipe = hook_behavior(nil, OBJ_LIST_SURFACE, true, custom_pipe_init, custom_pipe_loop, "bhvBlockyCustomPipe")
local id_bhvCustomFadingWarp = hook_behavior(nil, OBJ_LIST_LEVEL, true, custom_fade_init, custom_fade_loop, "bhvBlockyCustomFade")

--* you should be able to get rid of this code that handles warp spawning if you put
--* the behaviors directly in the script.c file of the level

local function on_warp()

    if not sWarps[currHack] then return end

    local warpInfo = sWarps[currHack][np.currLevelNum]
    if not warpInfo then return end

    if warpInfo then
        for _, warp in ipairs(warpInfo) do
            if np.currAreaIndex == warp.area then
                if warp.warpType == WARP_TYPE_PIPE then
                    spawn_non_sync_object(id_bhvCustomPipe, E_MODEL_BITS_WARP_PIPE, warp.pos.x, warp.pos.y, warp.pos.z, function(pipe)
                        pipe.oBehParams2ndByte = warp.node
                        pipe.oFaceAngleYaw = warp.pos.yaw
                        pipe.oFaceAnglePitch = warp.pos.pitch
                        pipe.oFaceAngleRoll = warp.pos.roll
                    end)
                elseif warp.warpType == WARP_TYPE_FADE then
                    spawn_non_sync_object(id_bhvCustomFadingWarp, E_MODEL_RED_COIN, warp.pos.x, warp.pos.y, warp.pos.z, function(fade)
                        fade.oBehParams2ndByte = warp.node
                        fade.oFaceAngleYaw = warp.pos.yaw
                        fade.oFaceAnglePitch = warp.pos.pitch
                        fade.oFaceAngleRoll = warp.pos.roll
                    end)
                end
            end
        end
    end
end

local function update()
    if delay > 0 then
        delay = delay - 1
    end
    if delay <= 0 and delayedWarp then
        local m = delayedWarp.m
        local exitAct = delayedWarp.exitAct
        local targetWarp = delayedWarp.targetWarp

        set_mario_action(m, exitAct, 0)
        m.pos.x = targetWarp.pos.x
        m.pos.y = targetWarp.pos.y
        m.pos.z = targetWarp.pos.z
        m.faceAngle.y = targetWarp.pos.yaw
        if targetWarp.exitFunc then
            targetWarp.exitFunc()
        end
        soft_reset_camera(m.area.camera)

        delayedWarp = nil
    end
end

hook_mario_action(ACT_CUSTOM_TELEPORT_FADE_OUT, act_custom_teleport_fade_out)
hook_event(HOOK_ON_SYNC_VALID, on_warp)
hook_event(HOOK_UPDATE, update)