
course_to_painting = {
    [COURSE_BOB] = { top = "inside_castle_seg7_texture_0700A800", bottom = "inside_castle_seg7_texture_0700B800" },
    [COURSE_WF ] = { top = "inside_castle_seg7_texture_0700E800", bottom = "inside_castle_seg7_texture_0700F800" },
    [COURSE_JRB] = { top = "inside_castle_seg7_texture_07010800", bottom = "inside_castle_seg7_texture_07011800" },
    [COURSE_CCM] = { top = "inside_castle_seg7_texture_0700C800", bottom = "inside_castle_seg7_texture_0700D800" },
    [COURSE_HMC] = { top = "inside_castle_seg7_texture_07016800", bottom = "inside_castle_seg7_texture_07016800" },
    [COURSE_LLL] = { top = "inside_castle_seg7_texture_07013800", bottom = "inside_castle_seg7_texture_07012800" },
    [COURSE_SSL] = { top = "inside_castle_seg7_texture_07014800", bottom = "inside_castle_seg7_texture_07015800" },
    [COURSE_DDD] = { top = "inside_castle_seg7_texture_07017000", bottom = "inside_castle_seg7_texture_07017000" },
    [COURSE_WDW] = { top = "inside_castle_seg7_texture_07017800", bottom = "inside_castle_seg7_texture_07018800" },
    [COURSE_SL ] = { top = "inside_castle_seg7_texture_0701F800", bottom = "inside_castle_seg7_texture_07020800" },
    [COURSE_TTM] = { top = "inside_castle_seg7_texture_0701B800", bottom = "inside_castle_seg7_texture_0701C800" },
    [COURSE_THI] = { top = "inside_castle_seg7_texture_07019800", bottom = "inside_castle_seg7_texture_0701A800" },
    [COURSE_TTC] = { top = "inside_castle_seg7_texture_0701D800", bottom = "inside_castle_seg7_texture_0701E800" },
    [COURSE_SA]    = { top = "sa_top"   , bottom = "sa_bottom"   },
    [COURSE_BBH]   = { top = "bbh_top"  , bottom = "bbh_bottom"   },
    [COURSE_RR]    = { top = "rr_top"   , bottom = "rr_bottom"    },
    [COURSE_BITDW] = { top = "bitdw_top", bottom = "bitdw_bottom" },
    [COURSE_BITFS] = { top = "bitfs_top", bottom = "bitfs_bottom" },
    [COURSE_BITS]  = { top = "bits_top" , bottom = "bits_bottom"  },
    [COURSE_PSS]   = { top = "pss_top"  , bottom = "pss_bottom"   },
    [COURSE_WMOTR] = { top = "wmotr_top", bottom = "wmotr_bottom" },
    [COURSE_TOTWC] = { top = "totwc_top", bottom = "totwc_bottom" },
    [COURSE_VCUTM] = { top = "vcutm_top", bottom = "vcutm_bottom" },
    [COURSE_COTMC] = { top = "cotmc_top", bottom = "cotmc_bottom" },
}

selection = 0
hasVoted = false

offset = 0
targetOffset = 0

local function everyone_voted()
    --* everyone is ready by default
    local allReady = true

    for i = 0, (MAX_PLAYERS - 1) do
        local np = gNetworkPlayers[i]
        local psi = ps[i]
        --* loop through all players
        if np.connected then
            --* go through the hiders

            if not psi.isReady then
                --* set all ready to false if one hider isn't ready
                allReady = false
                break
            end
        end
    end

    return allReady
end
local HUD_ACT_APPEARING   = 0
local HUD_ACT_VOTING      = 1
local HUD_ACT_VOTING_END  = 2

-- Global variables (declared once, persist throughout script's lifetime)
local idleTimer       = 0.0
local swaySpeed       = 1.0      -- speed of swaying animation
local swayAmount      = 5        -- vertical sway amplitude in pixels
local appearTimer     = 0.0      -- timer for appearing animation
local appearDuration  = 0.5      -- seconds for full appear
local endTimer        = 0.0      -- timer for end animation
local endDuration     = 0.5      -- seconds for full end
local hudAction       = HUD_ACT_APPEARING
local selection       = 0        -- Initial selection index
local targetOffset    = 0.0      -- Target angle for the current selection
local offset          = 0.0      -- Current angle for interpolation
local hasVoted        = false    -- Track if the local player has voted
local paintingsInitialized = false

-- NEW: Reset function for the entire voting state
function reset_voting_state()
    paintingsInitialized = false
    idleTimer       = 0.0
    appearTimer     = 0.0
    endTimer        = 0.0
    hudAction       = HUD_ACT_APPEARING
    selection       = 0
    targetOffset    = 0.0
    offset          = 0.0
    hasVoted        = false

    gGlobalSyncTable.storedVotes = 0

    -- Re-calculate initial targetOffset based on current votable levels
    -- This ensures it's set up correctly every time voting starts.
    if not paintingsInitialized and hudAction == HUD_ACT_VOTING then
        local mask = gGlobalSyncTable.votableLevels or 0
        votableList = {}
        for cid = 0, COURSE_MAX - 1 do
            if ((mask >> cid) & 1) == 1 then
                table.insert(votableList, cid)
            end
        end
        n = #votableList
        angleStep = (n > 0) and (2 * math.pi / n) or 0
        selection = 0
        targetOffset = selection * angleStep
        offset = targetOffset
        paintingsInitialized = true
    end

    -- Assuming ps[0].isReady needs to be reset for the local player
    if ps and ps[0] then
        ps[0].isReady = false
    end
end

-- This boolean will track if we were in the voting state in the previous frame.
-- It helps detect the *exit* from the voting state.
local wasInVotingState = false

local function on_hud_render()
    djui_hud_set_resolution(RESOLUTION_N64)
    local sw, sh = djui_hud_get_screen_width(), djui_hud_get_screen_height()

    local m = gMarioStates[0]

    -- Check if we are entering or exiting the voting state
    if gGlobalSyncTable.gameState == GAME_STATE_VOTING then
        -- If we just entered the voting state, or if it's the very first frame of voting
        if not wasInVotingState then
            reset_voting_state()
        end
        wasInVotingState = true
    else
        -- If we are no longer in the voting state, reset all voting-related variables
        if wasInVotingState then
            -- Resetting here ensures a clean state for the *next* time voting begins.
            -- We don't call reset_voting_state directly if we are just returning,
            -- as that would re-initialize too early.
            hudAction = HUD_ACT_APPEARING
            appearTimer = 0.0
            endTimer = 0.0
            selection = 0
            targetOffset = 0.0
            offset = 0.0
            hasVoted = false
            if ps and ps[0] then
                ps[0].isReady = false
            end
        end
        wasInVotingState = false
        return -- Exit the function if not in voting state
    end

    idleTimer = idleTimer + (1 / 30) * swaySpeed

    local mask = gGlobalSyncTable.votableLevels or 0
    local votableList = {}
    for cid = 0, COURSE_MAX - 1 do
        if ((mask >> cid) & 1) == 1 then
            table.insert(votableList, cid)
        end
    end
    local n = #votableList
    if n == 0 then return end

    local angleStep = 2 * math.pi / n

    if hudAction == HUD_ACT_APPEARING then
        appearTimer = appearTimer + (1 / 30)
        if appearTimer >= appearDuration then
            hudAction = HUD_ACT_VOTING
            appearTimer = appearDuration
        end
        m.freeze = 3
    elseif hudAction == HUD_ACT_VOTING then
        local controller = m.controller

        if not hasVoted then
            if (controller.buttonPressed & L_JPAD) ~= 0 then
                selection = (selection - 1 + n) % n
                local currentIndex = offset / angleStep
                local targetIndex = selection
                local delta = ((targetIndex - currentIndex + n + n // 2) % n) - n // 2
                targetOffset = offset + delta * angleStep
                play_sound(SOUND_MENU_MESSAGE_NEXT_PAGE, gGlobalSoundSource)
            elseif (controller.buttonPressed & R_JPAD) ~= 0 then
                selection = (selection + 1) % n
                local currentIndex = offset / angleStep
                local targetIndex = selection
                local delta = ((targetIndex - currentIndex + n + n // 2) % n) - n // 2
                targetOffset = offset + delta * angleStep
                play_sound(SOUND_MENU_MESSAGE_NEXT_PAGE, gGlobalSoundSource)
            end
            if (controller.buttonPressed & A_BUTTON) ~= 0 then
                local chosen = votableList[selection + 1]
                if chosen then
                    local shift = get_level_shift(chosen)
                    gGlobalSyncTable.storedVotes = (gGlobalSyncTable.storedVotes or 0) + (1 << shift)
                    hasVoted = true
                end
                play_sound(SOUND_MENU_MESSAGE_APPEAR, gGlobalSoundSource)
                ps[0].isReady = true
            end
        end

        -- Single consistent smoothing step
        local diff = targetOffset - offset
        if math.abs(diff) < 0.01 then
            offset = targetOffset
        else
            offset = offset + diff * 0.25
        end

        if everyone_voted() and gGlobalSyncTable.roundTimer < VOTING_TIMER_MAX then
            gGlobalSyncTable.roundTimer = VOTING_TIMER_MAX
        end
        m.freeze = 3
    elseif hudAction == HUD_ACT_VOTING_END then
        endTimer = endTimer + (1 / 30)
        if endTimer >= endDuration then
            endTimer = endDuration
        end
    end

    local bgAlpha
    if hudAction == HUD_ACT_APPEARING then
        bgAlpha = math.floor((appearTimer / appearDuration) * 170)
    elseif hudAction == HUD_ACT_VOTING then
        bgAlpha = 170
    else
        bgAlpha = math.floor((1 - endTimer / endDuration) * 170)
    end
    djui_hud_set_color(0, 0, 0, bgAlpha)
    djui_hud_render_rect(0, 0, sw + 2, sh)

    local centerX = sw * 0.5
    local centerY = sh * 0.4 + 20
    local maxRadius = math.min(sw, sh) * 0.5 * math.min(1, n / 6)

    local tA = appearTimer / appearDuration
    local tE = endTimer / endDuration
    local inAnim = hudAction == HUD_ACT_APPEARING
    local outAnim = hudAction == HUD_ACT_VOTING_END

    local items = {}
    for i, cid in ipairs(votableList) do
        local baseAng = (i - 1) * angleStep
        local finalAng = baseAng - offset

        local posX, posY_, scaleMul

        local currentSway = 0
        local isSelectedPaintingPerfectlyCentered = (math.abs(baseAng - targetOffset) < 0.005)

        if not isSelectedPaintingPerfectlyCentered then
            currentSway = math.sin(idleTimer) * swayAmount
        end

        if inAnim then
            local r = maxRadius * tA
            local overshootFactor = math.sin(tA * math.pi) * 0.2
            scaleMul = tA + overshootFactor
            scaleMul = math.max(0, math.min(scaleMul, 1.2))

            local a = baseAng + (1 - tA) * 2 * math.pi
            posX = centerX + math.sin(a) * r
            posY_ = centerY + currentSway * tA
        elseif outAnim then
            local r = maxRadius * (1 - tE)
            local a = baseAng + tE * 2 * math.pi
            posX = centerX + math.sin(a) * r
            posY_ = centerY + currentSway * (1 - tE)
            scaleMul = 1 - tE
        else
            posX = centerX + math.sin(finalAng) * maxRadius
            posY_ = centerY + currentSway
            scaleMul = 1
        end

        local cosv = math.cos(finalAng)
        local baseScale = 0.8 + 0.4 * cosv
        local bright = 0.4 + 0.6 * ((cosv + 1) * 0.5)
        table.insert(items, {
            courseID = cid,
            angle = finalAng,
            depth = -cosv,
            scale = baseScale * scaleMul,
            bright = bright,
            x = posX,
            y = posY_
        })
    end
    table.sort(items, function(a, b) return a.depth > b.depth end)

    for _, it in ipairs(items) do
        local info = course_to_painting[it.courseID]
        if not info then goto continue end
        djui_hud_set_filter(FILTER_LINEAR)
        local top = get_texture_info(info.top)
        local bot = get_texture_info(info.bottom)
        local tw, th = top.width * it.scale, (top.height + bot.height) * it.scale
        local x = it.x - tw * 0.5
        local y = it.y - th * 0.5

        local c = math.floor(it.bright * 255)
        djui_hud_set_color(c, c, c, 255)
        djui_hud_render_texture(top, x, y, it.scale, it.scale)
        djui_hud_render_texture(bot, x, y + top.height * it.scale, it.scale, it.scale)

        local cnts = decode_all_votes()
        local txt = tostring(cnts[it.courseID] or 0)
        djui_hud_set_font(FONT_RECOLOR_HUD)
        local w = djui_hud_measure_text(txt) * it.scale
        djui_hud_print_text(txt, x + tw * 0.5 - w * 0.5, y + th + 5, it.scale)
        ::continue::
    end

    local front = items[#items]
    if front then
        local info = course_to_painting[front.courseID]
        if info then
            local top = get_texture_info(info.top)
            local bot = get_texture_info(info.bottom)
            local w = top.width * front.scale
            local h = (top.height + bot.height) * front.scale
            local x = front.x - w * 0.5
            local y = front.y - h * 0.5
            local alpha = (hudAction == HUD_ACT_VOTING_END and math.floor((1 - tE) * 255)) or 255
            djui_hud_set_color(255, 255, hasVoted and 0 or 255, alpha)
            djui_hud_render_rect(x - 3, y - 3, w + 6, 2)
            djui_hud_render_rect(x - 3, y + h + 1, w + 6, 2)
            djui_hud_render_rect(x - 3, y - 3, 2, h + 6)
            djui_hud_render_rect(x + w + 1, y - 3, 2, h + 6)
        end
    end

    local sel = selection + 1
    local cid = votableList[sel]
    if cid then
        local name = get_level_name(cid, cid, 1) or ""
        djui_hud_set_font(FONT_CUSTOM_HUD)
        local w = djui_hud_measure_text(name)
        local targetY = sh * 0.4 - 50
        local y
        if inAnim then
            y = -20 + (targetY + 20) * tA
        elseif outAnim then
            y = targetY - (targetY + 50) * tE
        else
            y = targetY
        end
        local x = (sw - w) * 0.5
        djui_hud_set_color(255, 255, 255, 255)
        djui_hud_print_text(name, x, y, 1)
    end

    local countdown = math.floor(math.max(VOTING_TIMER_MAX - gGlobalSyncTable.roundTimer, 0) / 30)
    local txt = "PROCEEDING IN : " .. countdown
    djui_hud_set_font(FONT_CUSTOM_HUD)
    local tw = djui_hud_measure_text(txt)
    local baseY = sh * 0.9
    local y
    if inAnim then
        y = sh + 20 - (sh + 20 - baseY) * tA
    elseif outAnim then
        y = baseY + (sh - baseY + 20) * tE
    else
        y = baseY
    end
    djui_hud_set_color(255, 255, 255, 255)
    djui_hud_print_text(txt, (sw - tw) * 0.5, y, 1)

    if countdown == 0 and hudAction == HUD_ACT_VOTING then
        hudAction = HUD_ACT_VOTING_END
    end
end

hook_event(HOOK_ON_HUD_RENDER, on_hud_render)