local l = gLakituState
local np = gNetworkPlayers

local MOVEMENT_SPEED = 40
local ROTATION_SPEED_H = 1000
local ROTATION_SPEED_V = 1000

local function get_room_at_pos(x, y, z)
    local surface = collision_find_floor(x, y, z)

    if (surface) then
        return surface.room
    else
        return 0
    end
end

function control_cam(m)

    camera_freeze()

    m.freeze = 1

    local camPosX = sCamInfo.pos.x
    local camPosY = sCamInfo.pos.y
    local camPosZ = sCamInfo.pos.z
    local yaw = sCamInfo.yaw
    local pitch = sCamInfo.pitch

    local speedMultiplier = 1
    if m.controller.buttonDown & B_BUTTON ~= 0 then
        speedMultiplier = 1.75
    end

    if m.controller.buttonDown & D_CBUTTONS ~= 0 then
        pitch = pitch - (ROTATION_SPEED_V) * speedMultiplier
    end
    if m.controller.buttonDown & U_CBUTTONS ~= 0 then
        pitch = pitch + (ROTATION_SPEED_V) * speedMultiplier
    end
    if m.controller.buttonDown & R_CBUTTONS ~= 0 then
        yaw = yaw - ROTATION_SPEED_H * speedMultiplier
    end
    if m.controller.buttonDown & L_CBUTTONS ~= 0 then
        yaw = yaw + ROTATION_SPEED_H * speedMultiplier
    end

    local sensX = 60
    local sensY = 60

    pitch = pitch - sensY * djui_hud_get_raw_mouse_y()
    yaw   = yaw   + sensX * -djui_hud_get_raw_mouse_x()

    if pitch > 0x3F00 then
        pitch = 0x3F00
    elseif pitch < -0x3F00 then
        pitch = -0x3F00
    end

    yaw = yaw % 0x10000
    if yaw > 0x8000 then
        yaw = yaw - 0x10000
    end

    local stickX = m.controller.rawStickX / 100.0
    local stickY = m.controller.rawStickY / 100.0

    local forwardX = math.sin(yaw * math.pi / 0x8000) * math.cos(pitch * math.pi / 0x8000)
    local forwardY = math.sin(pitch * math.pi / 0x8000)
    local forwardZ = math.cos(yaw * math.pi / 0x8000) * math.cos(pitch * math.pi / 0x8000)
    local rightX = math.cos(yaw * math.pi / 0x8000)
    local rightZ = -math.sin(yaw * math.pi / 0x8000)

    camPosX = camPosX - stickX * MOVEMENT_SPEED * speedMultiplier * rightX + stickY * MOVEMENT_SPEED * speedMultiplier * forwardX
    camPosY = camPosY + stickY * MOVEMENT_SPEED * speedMultiplier * forwardY
    camPosZ = camPosZ - stickX * MOVEMENT_SPEED * speedMultiplier * rightZ + stickY * MOVEMENT_SPEED * speedMultiplier * forwardZ

    if m.controller.buttonDown & A_BUTTON ~= 0 then
        camPosY = camPosY + MOVEMENT_SPEED * speedMultiplier
    end
    if m.controller.buttonDown & Z_TRIG ~= 0 then
        camPosY = camPosY - MOVEMENT_SPEED * speedMultiplier
    end

    sCamInfo.pos.x = camPosX
    sCamInfo.pos.y = camPosY
    sCamInfo.pos.z = camPosZ
    sCamInfo.yaw = yaw
    sCamInfo.pitch = pitch

    m.area.camera.yaw = yaw + 32767

    set_room_override(get_room_at_pos(l.pos.x, l.pos.y, l.pos.z))

    vec3f_copy(l.pos, {x = camPosX, y = camPosY, z = camPosZ})
    vec3f_copy(l.goalPos, {x = camPosX, y = camPosY, z = camPosZ})
    vec3f_copy(l.focus, {x = camPosX + (1000 * math.sin(yaw * math.pi / 0x8000) * math.cos(pitch * math.pi / 0x8000)), y = camPosY + (1000 * math.sin(pitch * math.pi / 0x8000)), z = camPosZ + (1000 * math.cos(yaw * math.pi / 0x8000) * math.cos(pitch * math.pi / 0x8000))})
    vec3f_copy(l.curFocus, {x = camPosX + (1000 * math.sin(yaw * math.pi / 0x8000) * math.cos(pitch * math.pi / 0x8000)), y = camPosY + (1000 * math.sin(pitch * math.pi / 0x8000)), z = camPosZ + (1000 * math.cos(yaw * math.pi / 0x8000) * math.cos(pitch * math.pi / 0x8000))})
    l.yaw = yaw
    l.oldYaw = yaw
    l.nextYaw = yaw

    if not ps[0].frozen then
        sCamInfo.yaw = m.faceAngle.y
        sCamInfo.pos.y = m.pos.y + 160
        ps[0].isUsingFreeCam = false
        camera_unfreeze()
        m.vel.x = 0
        m.vel.y = 0
        m.vel.z = 0
        m.forwardVel = 0
        set_room_override(-1)
    end
end

function mario_update(m)
    if not ps[0].isUsingFreeCam or m.playerIndex ~= 0 then return end

    control_cam(m)
end

function on_cam_command()
    local m = gMarioStates[0]
    if ps[0].team ~= TEAM_HIDERS then return end
    ps[0].isUsingFreeCam = not ps[0].isUsingFreeCam
    vec3f_copy(sCamInfo.pos, m.pos)
    sCamInfo.yaw = m.faceAngle.y
    sCamInfo.pos.y = m.pos.y + 160
    return true
end

hook_chat_command("spec", "Enables free camera", on_cam_command)
hook_event(HOOK_BEFORE_MARIO_UPDATE, mario_update)