local currentMenu = nil
local currentIndex = 1
local scrollIndices = {}
local scrollOffset = 0
local lockedIndex = nil
local gScrollIndex = 1

local MENU_TYPE_OPTION = 1
local MENU_TYPE_CATEGORY = 2
local MENU_TYPE_BIND = 3
local MENU_TYPE_BACK = 4
local MENU_TYPE_HEADER = 5

local MAX_VISIBLE_OPTIONS = 9

local function set_menu(menu)
    currentMenu = {}
    currentIndex = 1
    scrollIndices = {}
    scrollOffset = 0
    lockedIndex = nil

    local hasPerms = (network_is_server() or network_is_moderator())

    for i = 1, #menu do
        if not menu[i].hostOnly or hasPerms then
            table.insert(currentMenu, menu[i])
            scrollIndices[#currentMenu] = 1
        end
    end
end

local function toggle_option(option)
    if option.enableable ~= nil then
        option.enableable = not option.enableable
    end
end

local function alter_bits(value, bit)
    if value & bit ~= 0 then
        value = value & ~bit
    else
        value = value | bit
    end
    return value
end

local function update_scroll_offset()
    if currentIndex > scrollOffset + MAX_VISIBLE_OPTIONS then
        scrollOffset = currentIndex - MAX_VISIBLE_OPTIONS
    elseif currentIndex <= scrollOffset then
        scrollOffset = currentIndex - 1
    end
end

local sTimerOptions = {
    {
        name = "Enable Round Timer",
        enableable = gGlobalSyncTable.roundModifiers & MODIFIER_TIMED_ROUND ~= 0,
        func = function(option)
            gGlobalSyncTable.roundModifiers = alter_bits(gGlobalSyncTable.roundModifiers, MODIFIER_TIMED_ROUND)
            mod_storage_save("roundModifiers", ""..gGlobalSyncTable.roundModifiers)
        end
    },
    {
        name = "Round Timer",
        value = math.floor(gGlobalSyncTable.roundTimerMax / 30 / 60),
        valueText = " Minutes",
        min = 1,
        max = 60,
        step = 1,
        func = function(option)
            gGlobalSyncTable.roundTimerMax = math.floor(option.value * 30 * 60)
            mod_storage_save("maxRoundTimer", ""..gGlobalSyncTable.roundTimerMax)
            gGlobalSyncTable.roundTimer = 0
        end
    },
    {
        name = "Hider Headstart",
        value = math.floor(gGlobalSyncTable.hiderHeadStartTimerMax / 30),
        valueText = "s",
        min = 0,
        max = 5*60,
        step = 15,
        func = function(option)
            gGlobalSyncTable.hiderHeadStartTimerMax = math.floor(option.value * 30)
            mod_storage_save("hiderHeadStart", ""..gGlobalSyncTable.hiderHeadStartTimerMax)
            gGlobalSyncTable.hiderHeadStartTimer = 0
        end
    },
    {
        name = "Exit Cooldown",
        value = math.floor(gGlobalSyncTable.pauseExitTimerMax / 30),
        valueText = "s",
        min = 0,
        max = 5*60,
        step = 15,
        func = function(option)
            gGlobalSyncTable.pauseExitTimerMax = math.floor(option.value * 30)
            mod_storage_save("pauseExitTimer", ""..gGlobalSyncTable.pauseExitTimerMax)
            gGlobalSyncTable.pauseExitTimer = 0
        end
    },
    { name = "Back", type = MENU_TYPE_BACK, func = function() set_menu(sMainMenuOptions) end },
}

local sBlacklistedLevels = {}

---@param levelname string
local function string_abbriviate(levelname)
    local s = ''
    local space = true
    -- Check for if levels actually have the 2d format like "1-2 Mushroom Caverns"
    _, _, format_name = string.find(levelname, "^(%d-%d)")
    if format_name then
        return levelname:sub(1,3)
    end
    -- Otherwise abbriviate level name
    for i = 1, #levelname do
        local c = levelname:sub(i,i)
        if space then
            if i ~= 1 or string.lower(levelname:sub(1,4)) ~= "the " then
                s = s..string.upper(c)
            end
            space = false
        end
        if c == " " or c == "-" then
            space = true
        end
    end
    return s
end

local sLevelOptions = {
    {
        name = "Voting",
        enableable = votingEnabled,
        func = function(option)
            votingEnabled = not votingEnabled
        end
    },
    {
        name = "Forced Level",
        value = 1,
        valueText = function(option)
            if option.value == 0 then
                return "OFF"
            elseif option.value < 0 then
                return "RANDOM"
            end
            
            local course
            if combinedCourses[option.value].isModded then
                course = COURSE_NONE
            else
                course = combinedCourses[option.value].course
            end

            local level = combinedCourses[option.value].level
            return string_abbriviate(get_level_name(course, level, 1))
        end,
        min = -1,
        max = #combinedCourses,
        step = 1,
        func = function(option)
            if option.value == 0 then
                gGlobalSyncTable.forcedLevel = nil
            elseif option.value < 0 then
                gGlobalSyncTable.forcedLevel = -get_random_course()
            else
                gGlobalSyncTable.forcedLevel = combinedCourses[option.value].level
            end
        end
    },
    {
        name = "Forced Floor",
        value = 1,
        valueText = function(option)
            if option.value == 0 then
                return "OFF"
            elseif option.value < 0 then
                return "RANDOM"
            end

            return string_abbriviate(valueToFloor[option.value].name)
        end,
        min = -1,
        max = FLOOR_MAX -1,
        step = 1,
        func = function(option)
            if option.value == 0 then
                gGlobalSyncTable.forcedFloor = nil
            else
                gGlobalSyncTable.forcedFloor = math.random(1, FLOOR_MAX - 1) --option.value
            end
        end
    },
    { name = "Blacklisted Levels", func = function() set_menu(sBlacklistedLevels) end },
    { name = "Back", type = MENU_TYPE_BACK, func = function() set_menu(sMainMenuOptions) end },
}

valueToFloor = {}

local function on_mods_loaded()
    if not network_is_server() then return end
    sBlacklistedLevels = {}

    for _, courseData in ipairs(combinedCourses) do
        local course = courseData.isModded and COURSE_NONE or courseData.course
        local levelName = get_level_name(course, courseData.level, 1)
        
        table.insert(sBlacklistedLevels, {
            name = levelName,
            func = function(option)
                toggle_blacklist(courseData.level)
            end,
            enableable = true
        })
    end

    for i = 1, FLOOR_MAX - 1 do
        local floors = {
            [OUTSIDE] = {course = COURSE_NONE, level = LEVEL_CASTLE_GROUNDS, area = 1},
            [MAIN_FLOOR] = {course = COURSE_NONE, level = LEVEL_CASTLE, area = 1},
            [BASEMENT_FLOOR] = {course = COURSE_NONE, level = LEVEL_CASTLE, area = 3},
            [UPPER_FLOOR] = {course = COURSE_NONE, level = LEVEL_CASTLE, area = 2},
        }

        local levelName = get_level_name(floors[i].course, floors[i].level, floors[i].area)
        
        table.insert(valueToFloor, {
            name = levelName,
        })
    end

    table.insert(sBlacklistedLevels, {name = "Back", type = MENU_TYPE_BACK, func = function() set_menu(sMainMenuOptions) end })
end

hook_event(HOOK_ON_MODS_LOADED, on_mods_loaded)

local sVariationOptions = {
    {
        name = "Prophunt",
        enableable = gGlobalSyncTable.roundModifiers & MODIFIER_PROP_HUNT ~= 0,
        func = function(option)
            gGlobalSyncTable.roundModifiers = alter_bits(gGlobalSyncTable.roundModifiers, MODIFIER_PROP_HUNT)
            if option.enableable then
                texture_override_set("outside_0900BC00", TEXT_NOTHING)
                texture_override_set("grass_0900B000", TEXT_NOTHING)
                texture_override_set("generic_0900B000", TEXT_NOTHING)
                texture_override_set("texture_shadow_quarter_square", TEXT_NOTHING)
            else
                texture_override_reset("outside_0900BC00")
                texture_override_reset("grass_0900B000")
                texture_override_reset("generic_0900B000")
                texture_override_reset("texture_shadow_quarter_square")
            end
            mod_storage_save("roundModifiers", ""..gGlobalSyncTable.roundModifiers)
        end
    },
    {
        name = "Fog",
        enableable = gGlobalSyncTable.roundModifiers & MODIFIER_FOG ~= 0,
        func = function(option)
            gGlobalSyncTable.roundModifiers = alter_bits(gGlobalSyncTable.roundModifiers, MODIFIER_FOG)
            mod_storage_save("roundModifiers", ""..gGlobalSyncTable.roundModifiers)
        end
    },
    {
        name = "Randomize Object Locations",
        enableable = false,
        hostOnly = true,
        func = function(option)
            gGlobalSyncTable.randomizeObj = not gGlobalSyncTable.randomizeObj
        end
    },
    {
        name = "Object Deletion",
        value = gGlobalSyncTable.deleteObjectPercentage,
        valueText = "%",
        min = 0,
        max = 100,
        step = 5,
        func = function(option)
            gGlobalSyncTable.deleteObjectPercentage = math.floor(option.value)
        end
    },
    {
        name = "Delete Random Objects",
        enableable = false,
        hostOnly = true,
        func = function(option)
            gGlobalSyncTable.deleteObjs = not gGlobalSyncTable.deleteObjs
        end
    },
    { name = "Back", type = MENU_TYPE_BACK, func = function() set_menu(sMainMenuOptions) end },
}

local sPropHuntControls = {

    {
        name = function() return "Reset To Default Binds" end,
        func = function(option)
            PROP_BUTTON = defaultButtons.prop_button
            FREEZE_BUTTON = defaultButtons.freeze_button
            FAKE_PROP_BUTTON = defaultButtons.fake_prop_button
            VERT_UP_BUTTON = defaultButtons.vert_up_button
            VERT_DOWN_BUTTON = defaultButtons.vert_down_button
            ANIM_LEFT_BUTTON = defaultButtons.anim_left_button
            ANIM_RIGHT_BUTTON = defaultButtons.anim_right_button

            mod_storage_save("prop_button", ""..PROP_BUTTON)
            mod_storage_save("anim_right_button", ""..ANIM_RIGHT_BUTTON)
            mod_storage_save("anim_left_button", ""..ANIM_LEFT_BUTTON)
            mod_storage_save("vert_down_button", ""..VERT_DOWN_BUTTON)
            mod_storage_save("vert_up_button", ""..VERT_UP_BUTTON)
            mod_storage_save("fake_prop_button", ""..FAKE_PROP_BUTTON)
            mod_storage_save("freeze_button", ""..FREEZE_BUTTON)
        end
    },

    {name = "Basic Prop Binds", type = MENU_TYPE_HEADER},
    {
        name = function() return "Open Prop Selector: " .. get_button_combination_string(PROP_BUTTON) end,
        receivedInput = function (option)
            PROP_BUTTON = gMarioStates[0].controller.buttonDown & ~C_BUTTONS
            mod_storage_save("prop_button", ""..PROP_BUTTON)
        end,
        func = function(option)
            option.waitingForInput = true
        end
    },
    {
        name = function() return "Freeze: " .. get_button_combination_string(FREEZE_BUTTON) end,
        receivedInput = function (option)
            FREEZE_BUTTON = gMarioStates[0].controller.buttonDown & ~C_BUTTONS
            mod_storage_save("freeze_button", ""..FREEZE_BUTTON)
        end,
        func = function(option)
            option.waitingForInput = true
        end
    },
    {
        name = function() return "Place Fake Prop: " .. get_button_combination_string(FAKE_PROP_BUTTON) end,
        receivedInput = function (option)
            FAKE_PROP_BUTTON = gMarioStates[0].controller.buttonDown & ~C_BUTTONS
            mod_storage_save("fake_prop_button", ""..FAKE_PROP_BUTTON)
        end,
        func = function(option)
            option.waitingForInput = true
        end
    },
    {name = "Vertical Offset Binds", type = MENU_TYPE_HEADER},
    {
        name = function() return "Up: " .. get_button_combination_string(VERT_UP_BUTTON) end,
        receivedInput = function (option)
            VERT_UP_BUTTON = gMarioStates[0].controller.buttonDown & ~C_BUTTONS
            mod_storage_save("vert_up_button", ""..VERT_UP_BUTTON)
        end,
        func = function(option)
            option.waitingForInput = true
        end
    },
    {
        name = function() return "Down: " .. get_button_combination_string(VERT_DOWN_BUTTON) end,
        receivedInput = function (option)
            VERT_DOWN_BUTTON = gMarioStates[0].controller.buttonDown & ~C_BUTTONS
            mod_storage_save("vert_down_button", ""..VERT_DOWN_BUTTON)
        end,
        func = function(option)
            option.waitingForInput = true
        end
    },
    {name = "Change Animation Binds", type = MENU_TYPE_HEADER},
    {
        name = function() return "Prev: " .. get_button_combination_string(ANIM_LEFT_BUTTON) end,
        receivedInput = function (option)
            ANIM_LEFT_BUTTON = gMarioStates[0].controller.buttonDown & ~C_BUTTONS
            mod_storage_save("anim_left_button", ""..ANIM_LEFT_BUTTON)
        end,
        func = function(option)
            option.waitingForInput = true
        end
    },
    {
        name = function() return "Next: " .. get_button_combination_string(ANIM_RIGHT_BUTTON) end,
        receivedInput = function (option)
            ANIM_RIGHT_BUTTON = gMarioStates[0].controller.buttonDown & ~C_BUTTONS
            mod_storage_save("anim_right_button", ""..ANIM_RIGHT_BUTTON)
        end,
        func = function(option)
            option.waitingForInput = true
        end
    },
    { name = "Back", type = MENU_TYPE_BACK, func = function() set_menu(sMainMenuOptions) end },
}

sBlacklistedLevels = {}

local sControls = {
    {
        name = "Prophunt Controls",
        type = MENU_TYPE_CATEGORY,
        func = function() set_menu(sPropHuntControls) end
    },
    { name = "Back", type = MENU_TYPE_BACK, func = function() set_menu(sMainMenuOptions) end },
}

sMainMenuOptions = {
    { name = "Start", func = function()
        network_send_include_self(true, {id = PACKET_GAME_STATE_CHANGE, param = GAME_STATE_ACTIVE})
        mainMenu = false
        currentIndex = 1
        scrollIndices = {}
        scrollOffset = 0
        lockedIndex = nil
        for i = 1, #currentMenu do
            scrollIndices[i] = 1
        end
    end},
    {
        name = "Seekers",
        hostOnly = true,
        value = gGlobalSyncTable.seekerNum,
        --valueText = "",
        min = 1,
        max = 15,
        step = 1,
        func = function(option)
            gGlobalSyncTable.seekerNum = option.value
        end
    },
    {
        name = "Auto Restart",
        enableable = false,
        hostOnly = true,
        func = function(option)
            gGlobalSyncTable.autoRestart = not gGlobalSyncTable.autoRestart
        end
    },
    {
        name = "Disable Eyestrain",
        enableable = false,
        hostOnly = false,
        func = function(option)
            removeEyeStrain = not removeEyeStrain
        end
    },
    { name = "Timer Options"    , hostOnly = true, type = MENU_TYPE_CATEGORY, func = function() set_menu(sTimerOptions) end },
    { name = "Level Options"    , hostOnly = true, type = MENU_TYPE_CATEGORY, func = function() set_menu(sLevelOptions) end },
    { name = "Variation Options", hostOnly = true, type = MENU_TYPE_CATEGORY, func = function() set_menu(sVariationOptions) end },
    { name = "Controls"         , hostOnly = false, type = MENU_TYPE_CATEGORY, func = function() set_menu(sControls) end },
    { name = "Back", type = MENU_TYPE_BACK, func = function()
        mainMenu = false
        currentIndex = 1
        scrollIndices = {}
        scrollOffset = 0
        lockedIndex = nil
        for i = 1, #currentMenu do
            scrollIndices[i] = 1
        end
    end
    },
}

local TEXT_TITLE_1 = "Hide & Seek"
local TEXT_TITLE_2 = "REBIRTH"
local TEXT_ENTER_CATEGORY = ">"
local TEXT_EXIT_CATEGORY = "<"
local TEXT_VERSION = "v"..HNS_VERSION

local TEX_BACKGROUND = get_texture_info("backTile")

local TYPE_FUNCTION = "function"

animOpenCloseMax = 200
local animOpenClose = animOpenCloseMax
local animSwayTimer = 0
local animSwayScale = 2
local bgScroll = 0
local prevMenuX = nil
local prevMenuY = nil

local function render_menu()
    djui_hud_set_resolution(RESOLUTION_N64)
    local sWidth = djui_hud_get_screen_width()
    local sHeight = 240
    local visibleOptions = math.min(#currentMenu - scrollOffset, MAX_VISIBLE_OPTIONS)
    
    -- Opening and Closing Animation
    if mainMenu and currentMenu then
        animOpenClose = math.max(animOpenClose * 0.9, 1)
    else
        animOpenClose = math.min(animOpenClose * 1.2, animOpenCloseMax)
    end
    -- Passive Menu Swaying
    animSwayTimer = animSwayTimer + 1

    local menuWidth = 130
    local menuHeight = 180
    local menuX = sWidth*0.5 - menuWidth*0.5 + math.sin(animSwayTimer*0.02)*animSwayScale*2
    local menuY = sHeight*0.5 - menuHeight*0.5 - animOpenClose + math.sin(animSwayTimer*0.04)*animSwayScale
    if not prevMenuX and not prevMenuY then
        prevMenuX = menuX
        prevMenuY = menuY
    end

    local headerHeight = 40
    -- Render Fade-in Background
    djui_hud_set_color(0, 0, 0, ((animOpenCloseMax - animOpenClose)/animOpenCloseMax)*150)
    djui_hud_render_rect(0, 0, sWidth + 1, sHeight)
    -- Render Menu Background (Don't try this at home)
    djui_hud_set_color(200, 200, 200, 255)
    local tileScale = 0.5
    bgScroll = ((bgScroll + 0.25)%32)
    local bgScrollScale = math.floor(bgScroll)*tileScale
    for iY = 0, math.ceil((menuHeight + 2)/32/tileScale) + 1 do
        for iX = 0, math.ceil((menuWidth + 2)/32/tileScale) + 1 do
            local x = menuX + math.max(bgScrollScale + iX*32*tileScale, 0) - 32
            local y = menuY + math.max(bgScrollScale + iY*32*tileScale, 0) - 32
            local tileX = math.max((menuX - x), 0)
            local tileY = math.max((menuY - y), 0)
            local tileWidth = math.max(math.min(32 - tileX, math.min((menuX + menuWidth) - x, 32)), 0)
            local tileHeight = math.max(math.min(32 - tileY, math.min((menuY + menuHeight) - y, 32)), 0)
            x = x + tileX
            y = y + tileY
            djui_hud_render_texture_tile(TEX_BACKGROUND, x, y, tileHeight/tileWidth*tileScale, tileScale, tileX/tileScale, tileY/tileScale, tileWidth/tileScale, tileHeight/tileScale)
        end
    end
    -- Render Header
    local playerColor = network_player_get_palette_color(gNetworkPlayers[0], SHIRT)
    djui_hud_set_color(playerColor.r, playerColor.g, playerColor.b, 150)
    djui_hud_render_rect_interpolated(prevMenuX, prevMenuY, menuWidth, headerHeight, menuX, menuY, menuWidth, headerHeight)
    djui_hud_set_color(255, 255, 255, 255)
    djui_hud_set_font(FONT_ALIASED)
    local scale = 0.75
    local textX =  menuWidth*0.5 - djui_hud_measure_text(TEXT_TITLE_1)*scale*0.5
    djui_hud_print_text_interpolated(TEXT_TITLE_1, prevMenuX + textX, prevMenuY + 2, scale, menuX + textX, menuY + 2, scale)
    local scale = 0.5
    local textX =  menuWidth*0.5 - djui_hud_measure_text(TEXT_TITLE_2)*scale*0.5
    djui_hud_print_text_interpolated(TEXT_TITLE_2, prevMenuX + textX, prevMenuY + 22, scale, menuX + textX, menuY + 22, scale)
    local scale = 0.2
    local textX =  menuWidth - djui_hud_measure_text(TEXT_VERSION)*scale - 2
    djui_hud_print_text_interpolated(TEXT_VERSION, prevMenuX + textX, prevMenuY + headerHeight - 8, scale, menuX + textX, menuY + headerHeight - 8, scale)
    

    local optionOffset = 0
    for i = scrollOffset + 1, scrollOffset + visibleOptions do
        local option = currentMenu[i]
        if not option then break end

        local text = type(option.name) == "function" and option.name() or option.name

        if option.scrollOptions then
            local scrollIndex = scrollIndices[i]
            local scrollOption = option.scrollOptions[scrollIndex]
            text = text .. ": " .. scrollOption.name
        elseif option.value then
            if option.valueText then
                if type(option.valueText) == TYPE_FUNCTION then
                    text = text .. ": " .. tostring(option.valueText(option))
                else
                    text = text .. ": " .. tostring(option.value) .. tostring(option.valueText)
                end
            else
                text = text .. ": " .. tostring(option.value)
            end
        end


        djui_hud_set_font(FONT_TINY)
        local scale = 0.8
        local lineHeight = 14
        local textWidth = djui_hud_measure_text(text)
        local animBounce = math.abs(math.sin(animSwayTimer*0.2)*2)
        local textX = menuX + 10
        local textY = headerHeight + 6 + lineHeight*(i - 1 - scrollOffset)
        local prevTextY = prevMenuY + textY
        textY = menuY + textY

        if option.enableable then
            djui_hud_set_color(34, 150, 34, 200)
        elseif option.enableable == false then
            djui_hud_set_color(200, 0, 0, 200)
        else
            djui_hud_set_color(0, 0, 0, 200)
        end

        djui_hud_render_rect_interpolated(menuX + 5, prevTextY - 1, menuWidth - 10, lineHeight, menuX + 5, textY - 1, menuWidth - 10, lineHeight)

        djui_hud_set_font(FONT_TINY)
        djui_hud_set_color(255, 255, 255, 255)
        if option.type == nil or option.type == MENU_TYPE_OPTION or option.type == MENU_TYPE_BIND then
            textX = textX + optionOffset
        end
        if i == currentIndex then
            local blickSpeed = 0.07
            if option.waitingForInput then
                text = "Press C Button When Done..."
            elseif lockedIndex == i then
                blickSpeed = blickSpeed * 3
            end
            djui_hud_set_color(255, 255, 100, math.sin(animSwayTimer*blickSpeed)*40 + 80)
            djui_hud_render_rect_interpolated(menuX + 5, prevTextY - 1, menuWidth - 10, lineHeight, menuX + 5, textY - 1, menuWidth - 10, lineHeight)
            djui_hud_set_color(255, 255, 255, 255)

            if option.type == MENU_TYPE_BACK then
                djui_hud_print_text_interpolated(TEXT_EXIT_CATEGORY, textX + animBounce, prevTextY, scale, textX + animBounce, textY, scale)
                textX = menuX + menuWidth - textWidth*scale - 10
            elseif option.type == MENU_TYPE_CATEGORY then
                local textX = menuX + menuWidth - 12
                djui_hud_print_text_interpolated(TEXT_ENTER_CATEGORY, textX - animBounce, prevTextY, scale, textX - animBounce, textY, scale)
            end
            if option.type == MENU_TYPE_HEADER then
                currentIndex = currentIndex + 1
            end
            
        else
            if option.type == MENU_TYPE_BACK then
                textX = menuX + menuWidth - textWidth*scale - 10
            end
        end
        if option.type == MENU_TYPE_HEADER then
            scale = 0.7
            djui_hud_render_rect(menuX + 10, textY + 11, menuWidth - 20, 1)
            optionOffset = 5
        end

        djui_hud_print_text_interpolated(text, textX, prevTextY, scale, textX, textY, scale)
    end

    -- Render Boarders
    local boarderThickness = 2
    djui_hud_set_color(0, 0, 0, 255)
    djui_hud_render_rect_interpolated(prevMenuX, prevMenuY - boarderThickness*0.5, menuWidth, boarderThickness, menuX, menuY - boarderThickness*0.5, menuWidth, boarderThickness)
    djui_hud_render_rect_interpolated(prevMenuX, prevMenuY + headerHeight - boarderThickness*0.5, menuWidth, boarderThickness, menuX, menuY + headerHeight - boarderThickness*0.5, menuWidth, boarderThickness)
    djui_hud_render_rect_interpolated(prevMenuX, prevMenuY + menuHeight - boarderThickness*0.5, menuWidth, boarderThickness, menuX, menuY + menuHeight - boarderThickness*0.5, menuWidth, boarderThickness)
    djui_hud_render_rect_interpolated(prevMenuX - boarderThickness*0.5, prevMenuY, boarderThickness, menuHeight, menuX - boarderThickness*0.5, menuY, boarderThickness, menuHeight)
    djui_hud_render_rect_interpolated(prevMenuX + menuWidth - boarderThickness*0.5, prevMenuY, boarderThickness, menuHeight, menuX + menuWidth - boarderThickness*0.5, menuY, boarderThickness, menuHeight)

    --[[
    if scrollOffset + MAX_VISIBLE_OPTIONS < #currentMenu then
        local dotsX = sWidth * 0.5 - 1.5
        local dotsY = y
        local padding = 5
        local rectWidth = 3 + padding * 2
        local rectHeight = textHeight + padding * 2

        djui_hud_set_color(0, 0, 0, 128)
        djui_hud_render_rect(dotsX - 1, y, rectWidth, rectHeight)
        djui_hud_set_color(255, 255, 255, 255)
        djui_hud_print_text("...", dotsX, dotsY, 1)
    end
    ]]


    -- Used for interplation
    prevMenuX = menuX
    prevMenuY = menuY

    --[[
    ]]
end

local function handle_input()
    local m = gMarioStates[0]
    m.freeze = 15

    if currentMenu[currentIndex] == nil then
        currentIndex = (currentIndex - 1) % #currentMenu + 1
    end

    local currentOption = currentMenu[currentIndex]
    local func = currentOption and currentOption.receivedInput

    if currentOption and currentOption.waitingForInput then
        if m.controller.buttonPressed & C_BUTTONS ~= 0 then
            currentOption.waitingForInput = false
            play_sound(SOUND_ACTION_READ_SIGN, gGlobalSoundSource)
            if func then func(currentOption) end
        end
        return
    end

    if lockedIndex then
        local option = currentMenu[lockedIndex]
        if m.controller.buttonPressed & A_BUTTON ~= 0 then
            play_sound(SOUND_ACTION_READ_SIGN, gGlobalSoundSource)
            lockedIndex = nil
            if option.func then
                option.func(option)
                if option.enableable ~= nil then toggle_option(option) end
            end
        elseif m.controller.buttonPressed & (L_JPAD | R_JPAD) ~= 0 then
            play_sound(SOUND_MENU_CHANGE_SELECT, gGlobalSoundSource)
            if option.scrollOptions then
                local scrollIndex = (scrollIndices[lockedIndex] + (m.controller.buttonPressed & R_JPAD ~= 0 and 1 or -1) - 1) % #option.scrollOptions + 1
                scrollIndices[lockedIndex] = scrollIndex
                gScrollIndex = scrollIndex
            elseif option.value then
                local delta = m.controller.buttonPressed & R_JPAD ~= 0 and option.step or -option.step
                local newValue = option.value + delta
                if newValue > option.max then
                    option.value = option.min
                elseif newValue < option.min then
                    option.value = option.max
                else
                    option.value = newValue
                end
            end
        end
        return
    end

    local buttonPressed = m.controller.buttonPressed
    if buttonPressed & (U_JPAD | D_JPAD) ~= 0 then
        play_sound(SOUND_MENU_CHANGE_SELECT, gGlobalSoundSource)
        repeat
            currentIndex = currentIndex + (buttonPressed & D_JPAD ~= 0 and 1 or -1)
            if currentIndex < 1 then currentIndex = #currentMenu end
            if currentIndex > #currentMenu then currentIndex = 1 end
        until currentMenu[currentIndex].type ~= MENU_TYPE_HEADER
        update_scroll_offset()
    elseif buttonPressed & A_BUTTON ~= 0 then
        play_sound(SOUND_ACTION_READ_SIGN, gGlobalSoundSource)
        if currentOption then
            if currentOption.func and not (currentOption.value or currentOption.scrollOptions) then
                if currentOption.enableable ~= nil then toggle_option(currentOption) end
                currentOption.func(currentOption)
            elseif currentOption.value or currentOption.scrollOptions then
                lockedIndex = currentIndex
            end
        end
    elseif buttonPressed & B_BUTTON ~= 0 and currentMenu ~= sMainMenuOptions then
        set_menu(sMainMenuOptions)
        play_sound(SOUND_GENERAL_PAINTING_EJECT, gGlobalSoundSource)
    elseif buttonPressed & START_BUTTON ~= 0 then
        mainMenu = false
        currentIndex = 1
        scrollIndices = {}
        scrollOffset = 0
        lockedIndex = nil
        for i = 1, #currentMenu do
            scrollIndices[i] = 1
        end
        play_sound(SOUND_GENERAL_PAINTING_EJECT, gGlobalSoundSource)
    end
end

local function hud_render()
    djui_hud_set_resolution(RESOLUTION_N64)
    djui_hud_set_font(FONT_TINY)

    if animOpenClose == animOpenCloseMax then return end
    render_menu()
    if not mainMenu or not currentMenu then return end
    handle_input()
end

set_menu(sMainMenuOptions)

hook_event(HOOK_ON_HUD_RENDER, hud_render)

local function open_hns_menu()
    if not propMenu then
        mainMenu = not mainMenu
        if mainMenu then
            animOpenClose = animOpenCloseMax - 1
        end
    else
        djui_chat_message_create("Please exit the menu you are currently in!")
    end
    return true
end

hook_chat_command("hns", "Opens the hide and seek menu", open_hns_menu)