-- name: Hide And Seek \\#ffff00\\Rebirth V1.1
-- incompatible: gamemode

debug = false

gLevelValues.disableActs = true

-- This function now cycles through all levels for the given forced floor.
function is_level_allowed_forced_floor(forcedF, currentLevel, currentArea, currentCourse, currentAct)
    if currentAct > 0 then return false end
    if gGlobalSyncTable.forcedFloor then
        local floor = math.abs(gGlobalSyncTable.forcedFloor)

        -- Let seekers play anywhere during head start
        if ps[0].team == TEAM_SEEKERS and gGlobalSyncTable.hiderHeadStartTimer <= gGlobalSyncTable.hiderHeadStartTimerMax then
            return true
        end
        
        local currentFloorLevels = forcedF[floor]
        if currentFloorLevels then
            for _, levelInfo in ipairs(currentFloorLevels) do
                if levelInfo.level == currentLevel then
                    return levelInfo.area == nil or levelInfo.area == currentArea
                end
            end
        end
        return false
    elseif gGlobalSyncTable.forcedLevel then
        -- If forced floors are off, check forced level.
        return currentCourse == math.abs(gGlobalSyncTable.forcedLevel)
    end
    return false
end

--* shoutouts to emily emmi for fixing this
function assign_roles(numSeekers)
    local connectedPlayers = get_player_count()
    local currentSeekersCount = get_total_seekers_count()

    local seekersToAdd = clamp(numSeekers - currentSeekersCount, 0, connectedPlayers)

    local validIndices = {}
    for playerIndex = 0, MAX_PLAYERS - 1 do
        local np = gNetworkPlayers[playerIndex]
        if np.connected then
            ps[playerIndex].team = TEAM_HIDERS
            table.insert(validIndices, playerIndex)
        end
    end

    for i = 1, seekersToAdd do
        if #validIndices == 0 then break end

        local chosenIndex = math.random(1, #validIndices)
        local chosenPlayer = validIndices[chosenIndex]
        table.remove(validIndices, chosenIndex)

        ps[chosenPlayer].team = TEAM_SEEKERS
    end
end

local function handle_inactive_state()
    if get_player_count() >= 2 then
        if gGlobalSyncTable.autoRestart then
            gGlobalSyncTable.gameStartTimer = gGlobalSyncTable.gameStartTimer + 1
        end
        if gGlobalSyncTable.gameStartTimer > 300 then
            if votingEnabled then
                network_send_include_self(true, {id = PACKET_GAME_STATE_CHANGE, param = GAME_STATE_VOTING})
            else
                network_send_include_self(true, {id = PACKET_GAME_STATE_CHANGE, param = GAME_STATE_ACTIVE})
            end
        end
    end
end

local function start_command()
    gGlobalSyncTable.gameStartTimer = 9999999
    return true
end

local function all_hiders_ready()
    --* everyone is ready by default
    local allReady = true

    for i = 0, (MAX_PLAYERS - 1) do
        local np = gNetworkPlayers[i]
        local psi = ps[i]
        --* loop through all players
        if np.connected and psi.team == TEAM_HIDERS then
            --* go through the hiders

            if not psi.isReady then
                --* set all ready to false if one hider isn't ready
                allReady = false
                break
            end
        end
    end

    return allReady
end

local function handle_active_state()
    if gGlobalSyncTable.hiderHeadStartTimer <= gGlobalSyncTable.hiderHeadStartTimerMax then
        gGlobalSyncTable.hiderHeadStartTimer = gGlobalSyncTable.hiderHeadStartTimer + 1
    end
    if gGlobalSyncTable.roundModifiers & MODIFIER_TIMED_ROUND ~= 0 then
        --* timer, self explanatory
        if gGlobalSyncTable.roundTimer < gGlobalSyncTable.roundTimerMax and gGlobalSyncTable.hiderHeadStartTimer >= gGlobalSyncTable.hiderHeadStartTimerMax then
            gGlobalSyncTable.roundTimer = gGlobalSyncTable.roundTimer + 1
        elseif gGlobalSyncTable.roundTimer >= gGlobalSyncTable.roundTimerMax then
            network_send_include_self(true, {id = PACKET_GAME_STATE_CHANGE, param = GAME_STATE_HIDER_WIN})
            gGlobalSyncTable.winText = "Hiders Win!"
            play_music(SEQ_PLAYER_ENV, SEQ_EVENT_HIGH_SCORE, 0)
        end
    else
        gGlobalSyncTable.roundTimer = gGlobalSyncTable.roundTimer + 1
    end

    if all_hiders_ready() and gGlobalSyncTable.hiderHeadStartTimer < gGlobalSyncTable.hiderHeadStartTimerMax then
        --* end the headstart if all hiders are ready
        gGlobalSyncTable.hiderHeadStartTimer = gGlobalSyncTable.hiderHeadStartTimerMax
    end

    local totalSeekers = get_total_seekers_count()

    if not debug then
        if totalSeekers >= get_player_count() then
            --* if seekers are superior or equal to player count, they win
            network_send_include_self(true, {id = PACKET_GAME_STATE_CHANGE, param = GAME_STATE_SEEKER_WIN})
            gGlobalSyncTable.winText = "Seekers Win!"
            play_music(SEQ_PLAYER_ENV, SEQ_EVENT_KOOPA_MESSAGE, 0)
        elseif totalSeekers <= 0 then
            --* if seekers are inferior or equal to 0 count, game ends
            network_send_include_self(true, {id = PACKET_GAME_STATE_CHANGE, param = GAME_STATE_HIDER_WIN})
            gGlobalSyncTable.winText = "Seekers Disconnected!"
            play_music(SEQ_PLAYER_ENV, SEQ_EVENT_CUTSCENE_LAKITU, 0)
        elseif not totalSeekers then
            --* if their seekers are nil, game ends
            network_send_include_self(true, {id = PACKET_GAME_STATE_CHANGE, param = GAME_STATE_HIDER_WIN})
            gGlobalSyncTable.winText = "Total Seeker Count is nil"
            play_music(SEQ_PLAYER_ENV, SEQ_EVENT_CUTSCENE_LAKITU, 0)
        end
    end
end

local function handle_win_state()
    --* display win text for 5 seconds
    if gGlobalSyncTable.winTextTimer <= 150 then
        gGlobalSyncTable.winTextTimer = gGlobalSyncTable.winTextTimer + 1
    else
        network_send_include_self(true, {id = PACKET_GAME_STATE_CHANGE, param = GAME_STATE_INACTIVE})
        gGlobalSyncTable.winTextTimer = 0
    end
end

local function handle_voting_state()
    if gGlobalSyncTable.roundTimer < VOTING_TIMER_MAX + VOTING_TIMER_IDLE then
        gGlobalSyncTable.roundTimer = gGlobalSyncTable.roundTimer + 1
    else
        local course, votes = get_winning_course()

        gGlobalSyncTable.forcedLevel = get_level_num_from_course_num(course)

        network_send_include_self(true, {id = PACKET_GAME_STATE_CHANGE, param = GAME_STATE_ACTIVE})
    end
end

local sGameStateHandler = {
    [GAME_STATE_HIDER_WIN] = handle_win_state,
    [GAME_STATE_SEEKER_WIN] = handle_win_state,
    [GAME_STATE_INACTIVE] = handle_inactive_state,
    [GAME_STATE_ACTIVE] = handle_active_state,
    [GAME_STATE_VOTING] = handle_voting_state,
}

local isLight = false

local function game_update()

    --* this handles the 1 minute mark
    if not removeEyeStrain and get_global_timer() % 44 == 0 and hurryUp and gGlobalSyncTable.hiderHeadStartTimer >= gGlobalSyncTable.hiderHeadStartTimerMax then
        --* this runs every 44 frames

        play_sound(SOUND_GENERAL_PENDULUM_SWING, gGlobalSoundSource)

        --* isLight decides if the color should change to red or gray, as well as the light direction
        if isLight then
            set_world_color(0, 200)
            set_world_color(1, 200)
            set_world_color(2, 200)
            set_override_skybox(-1)
            set_lighting_dir(1, vanillaLightDir)
        else
            set_world_color(0, 255)
            set_world_color(1, 70)
            set_world_color(2, 70)
            set_lighting_dir(1, 1)
            set_override_skybox(BACKGROUND_FLAMING_SKY)
        end

        isLight = not isLight
    end

    if not network_is_server() then return end -- Only the host updates the timer and other game logic

    local handler = sGameStateHandler[gGlobalSyncTable.gameState]
    if handler then
        handler()
    end
end

local function on_pvp_attack(attacker, victim)
    if victim.playerIndex ~= 0 then return end

    --* if attacker is seeker and victim is NOT a seeker then set the victim to seeker
    if ps[attacker.playerIndex].team == TEAM_SEEKERS and ps[victim.playerIndex].team ~= TEAM_SEEKERS and gGlobalSyncTable.hiderHeadStartTimer > gGlobalSyncTable.hiderHeadStartTimerMax then
        ps[victim.playerIndex].team = TEAM_SEEKERS
        play_sound(SOUND_OBJ_BOWSER_LAUGH, gMarioStates[0].marioObj.header.gfx.cameraToObject)

        if victim.playerIndex == 0 then
            notify_caught_player(victim.playerIndex)
        end

        gGlobalSyncTable.roundTimer = gGlobalSyncTable.roundTimer - gGlobalSyncTable.roundTimerMax * 0.1

        ps[victim.playerIndex].time =  gGlobalSyncTable.roundTimerMax - gGlobalSyncTable.roundTimer
        if ps[attacker.playerIndex].isSkeltan then
            ps[victim.playerIndex].skeltanJumpscareTimer = 1
        end
        --network_send_include_self(true, {id = PACKET_CHANGE_TIME, param = gGlobalSyncTable.roundTimerMax * 0.1})
    end
end

local function handle_seeker_team(m)

    --* silly skeltan freddy easter egg
    if ps[m.playerIndex].isSkeltan and gGlobalSyncTable.gameState == GAME_STATE_ACTIVE then
        obj_set_model_extended(m.marioObj, E_MODEL_SKELTAN)
    end

    if ps[m.playerIndex].team == TEAM_SEEKERS then
        if gGlobalSyncTable.roundModifiers & MODIFIER_PROP_HUNT == 0 then
            --* seekers are only metal if prophunt
            m.marioBodyState.modelState = m.marioBodyState.modelState | MODEL_STATE_METAL
        end

        --* seekers don't die
        m.health = 0x880

        --* this is so seekers can get props that are too high above water because of their offset
        if m.action == ACT_WATER_JUMP and m.playerIndex == 0 and gGlobalSyncTable.roundModifiers & MODIFIER_PROP_HUNT ~= 0 then
            if m.controller.buttonPressed & Z_TRIG ~= 0 then
                set_mario_action(m, ACT_GROUND_POUND, 0)
            elseif m.controller.buttonPressed & B_BUTTON ~= 0 then
                set_mario_action(m, ACT_JUMP_KICK, 0)
                m.vel.y = 30
            end
        end

        if m.playerIndex ~= 0 then return end

        if bombCooldown < gGlobalSyncTable.bombCooldownMax then
            bombCooldown = bombCooldown + 1
        end

        if gGlobalSyncTable.roundModifiers & MODIFIER_PROP_HUNT ~= 0 and bombCooldown >= gGlobalSyncTable.bombCooldownMax then
            if m.controller.buttonPressed & L_TRIG ~= 0 and m.pos.y <= m.floorHeight then
                spawn_sync_object(id_bhvSlowBomb, E_MODEL_BOWSER_BOMB, m.pos.x, m.pos.y, m.pos.z, function (o)
                    o.globalPlayerIndex = npl[0].globalIndex
                end)
                set_mario_action(m, ACT_JUMP_KICK, 0)
                m.vel.y = 25
                bombCooldown = 0
            end
        end

        if gGlobalSyncTable.hiderHeadStartTimer < gGlobalSyncTable.hiderHeadStartTimerMax and gGlobalSyncTable.gameState == GAME_STATE_ACTIVE then
            if gNetworkPlayers[0].currLevelNum ~= gGlobalSyncTable.seekerWaitLevel then
                warp_to_level(gGlobalSyncTable.seekerWaitLevel, 1, 50)
            end
        end
    end
end

-- Revised so that forced floors are given priority over forced levels.
function handle_forced_floor_or_level()
    -- First, check forced floor: if it exists, process that.
    if gGlobalSyncTable.forcedFloor then
        local floor = math.abs(gGlobalSyncTable.forcedFloor)
        local forcedFloorData = forcedFloor[floor]
        if forcedFloorData and #forcedFloorData > 0 then
            local hubLevel = forcedFloorData[1].level
            local hubArea = forcedFloorData[1].area or 1
            if not is_level_allowed_forced_floor(forcedFloor, npl[0].currLevelNum, npl[0].currAreaIndex, npl[0].currCourseNum, npl[0].currActNum) then
                warp_to_level(hubLevel, hubArea, 0)
                return true
            end
        end
    -- Only if there is no forced floor, check for a forced level.
    elseif gGlobalSyncTable.forcedLevel then
        local level = math.abs(gGlobalSyncTable.forcedLevel)
        if level and (npl[0].currLevelNum ~= level or npl[0].currActNum ~= 0) then
            warp_to_level(level, 1, 0)
            return true
        end
    end

    return false
end

local SOUND_HURRY_UP = audio_sample_load("hurry.mp3")

local shellTimer = 0

local function obj_flicker(obj, lifeSpan)
    --* this for the koopa shell because for some reason the other functions would not work
    if not obj then djui_chat_message_create('nil')return false end

    if obj.oTimer < lifeSpan + 40 then
        if obj.oTimer % 2 ~= 0 then
            obj.header.gfx.node.flags = obj.header.gfx.node.flags | GRAPH_RENDER_INVISIBLE
        else
            obj.header.gfx.node.flags = obj.header.gfx.node.flags & ~GRAPH_RENDER_INVISIBLE
        end
    end
end

---@param m MarioState
local function mario_update(m)
    local playerIndex = m.playerIndex

    if m.controller.buttonDown & A_BUTTON ~= 0 and m.controller.buttonDown & D_JPAD ~= 0 and debug then
        set_mario_action(m, ACT_EDITED_DEBUG_FREE_MOVE, 0)
    end

    for i = 0, MAX_PLAYERS - 1 do
        --* display role name on the player list
        local roleInfo = roleToString[ps[i].team]
        network_player_set_description(gNetworkPlayers[i], roleInfo.text, roleInfo.color.r, roleInfo.color.g, roleInfo.color.b, 255)
    end

    handle_seeker_team(m)

    if playerIndex ~= 0 then return end

    if m.floor and (m.floor.type >= SURFACE_PAINTING_WARP_E8 and m.floor.type <= SURFACE_PAINTING_WARP_EA) and currHack == "Vanilla" then
        m.floor.type = SURFACE_DEFAULT
    end

    --* lvlBhv is used for the biobak levels, or custom levels in general
    local lvlBhv = sLevelBehaviors[gNetworkPlayers[0].currLevelNum] or nil
    
    if lvlBhv then
        local func = lvlBhv.func or nil
        if func then
            func(m)
        end
    end

    --* stop using spec cam as seeker
    if ps[0].team == TEAM_SEEKERS and ps[0].isUsingFreeCam then
        ps[0].frozen = false
        set_mario_action(m, m.prevAction, 0)
        camera_unfreeze()
        soft_reset_camera(m.area.camera)
    end

    if ps[0].team == TEAM_HIDERS then
        local action = m.action
        --* if hider and riding a shell
        if action == ACT_RIDING_SHELL_FALL or action == ACT_RIDING_SHELL_GROUND or action == ACT_RIDING_SHELL_JUMP then
            shellTimer = shellTimer + 1

            --* shell starts flickering at 19 seconds
            if shellTimer >= 570 then
                obj_flicker(m.riddenObj, 600)
                if shellTimer >= 600 then
                    --* get rid of the shell after 20 seconds
                    set_mario_action(m, ACT_FREEFALL, 0)
                    obj_mark_for_deletion(m.riddenObj)
                    stop_shell_music()
                end
            end
        elseif shellTimer ~= 0 then
            shellTimer = 0
        end
    end

    local roundTimeLeft = gGlobalSyncTable.roundTimerMax - gGlobalSyncTable.roundTimer

    --* this triggers the one minute left event
    if roundTimeLeft <= 1800 and not hurryUp and gGlobalSyncTable.gameState == GAME_STATE_ACTIVE then
        prevBgMusic = get_current_background_music()
        audio_sample_play(SOUND_HURRY_UP, m.pos, 2)
        hurryUp = true
    elseif roundTimeLeft > 1800 and hurryUp and gGlobalSyncTable.gameState == GAME_STATE_ACTIVE then
        --* if we come back above a minute reset everything back
        hurryUp = false
        set_background_music(0, prevBgMusic, 0)
        set_world_color(0, 255)
        set_world_color(1, 255)
        set_world_color(2, 255)
        set_override_skybox(-1)
        set_lighting_dir(1, vanillaLightDir)
    end

    if hurryUp and get_current_background_music() ~= SEQ_EVENT_HURRY_UP then
        set_background_music(0, SEQ_EVENT_HURRY_UP, 600)
        stop_secondary_music(1)
    end

    if gGlobalSyncTable.gameState == GAME_STATE_ACTIVE then
        if ps[m.playerIndex].team == TEAM_HIDERS then
            handle_forced_floor_or_level()
            if pauseExitTimer < gGlobalSyncTable.pauseExitTimerMax then
                pauseExitTimer = pauseExitTimer + 1 --* make the pause exit timer go down
            end
        end

        if (ps[0].team == TEAM_SEEKERS and gGlobalSyncTable.hiderHeadStartTimer >= gGlobalSyncTable.hiderHeadStartTimerMax) then
            handle_forced_floor_or_level()
        end
    end
end

local function on_packet_receive(data)
    --* packet send system
    if data.id then
        packetTable[data.id](data)
    end
end

local stringToVar = {
    ["OFF"] = nil,
    ["OUT"] = OUTSIDE,
    ["MF"] = MAIN_FLOOR,
    ["UF"] = UPPER_FLOOR,
    ["BF"] = BASEMENT_FLOOR,
}

function chat_command(msg)
    gGlobalSyncTable.forcedFloor = stringToVar[msg]
    play_puzzle_jingle()
    return true
end

function game_state(msg)
    network_send_include_self(true, {id = PACKET_GAME_STATE_CHANGE, param = tonumber(msg)})
    return true
end

function pause_exit()

    --* if the hiders have a headstart they can leave anytime
    if gGlobalSyncTable.hiderHeadStartTimer >= gGlobalSyncTable.hiderHeadStartTimerMax then
        if ps[0].team == TEAM_HIDERS and gGlobalSyncTable.forcedLevel then
            --* if a level is forced return false always
            play_sound(SOUND_MENU_CAMERA_BUZZ, gGlobalSoundSource)
            return false
        end
        if pauseExitTimer < gGlobalSyncTable.pauseExitTimerMax and ps[0].team == TEAM_HIDERS then
            play_sound(SOUND_MENU_CAMERA_BUZZ, gGlobalSoundSource)
            return false
        end
    end

    return true
end

local function on_player_connected()
    --* if a player joins and the headstart is already halfway down they become a seeker
    if gGlobalSyncTable.gameState == GAME_STATE_ACTIVE then
        play_sound(SOUND_OBJ_BOWSER_LAUGH, gMarioStates[0].marioObj.header.gfx.cameraToObject)
        gGlobalSyncTable.roundTimer = gGlobalSyncTable.roundTimer - gGlobalSyncTable.roundTimerMax * 0.1
        --network_send_include_self(true, {id = PACKET_CHANGE_TIME, param = gGlobalSyncTable.roundTimerMax * 0.1})
        ps[0].team = TEAM_SEEKERS
    end
end

local function level_init()

    if get_local_discord_id() == "489114867215630336" and not ps[0].isSkeltan then --* find skeltan
        ps[0].isSkeltan = true
    end

    set_override_skybox(-1)
    pauseExitTimer = 0
    for objList = 0, NUM_OBJ_LISTS - 1 do --* set all objects as billboards
        local o = obj_get_first(objList)
        while o do

            if o.header.gfx.node.flags & GRAPH_RENDER_CYLBOARD ~= 0 then
                o.header.gfx.node.flags = o.header.gfx.node.flags & ~GRAPH_RENDER_CYLBOARD
                o.header.gfx.node.flags = o.header.gfx.node.flags | GRAPH_RENDER_BILLBOARD
            end
    
            o = obj_get_next(o)
        end
    end
end

local sBlockedAreas = {
    ["Vanilla"] = {
        [LEVEL_WDW] = {
            area = 1,
            func = function ()
                spawn_non_sync_object(id_bhvStaticCheckeredPlatform, E_MODEL_CHECKERBOARD_PLATFORM, 3992, 2720, -3207,
                function(box)
                    obj_scale_xyz(box, 2.75, 4, 4)
                    box.oCollisionDistance = 3000
                end)
            end
        },
        [LEVEL_SSL] = {
            area = 2,
            func = function ()
                spawn_non_sync_object(id_bhvStaticCheckeredPlatform, E_MODEL_CHECKERBOARD_PLATFORM, 0, 400, -779,
                function(box)
                    obj_scale_xyz(box, 1, 9, 1)
                    box.oCollisionDistance = 3000
                    box.oFaceAngleYaw = 32661
                    box.oMoveAngleYaw = 32661
                end)
            end
        },
        [LEVEL_TTM] = {
            area = 1,
            func = function ()
                spawn_non_sync_object(id_bhvStaticCheckeredPlatform, E_MODEL_CHECKERBOARD_PLATFORM, 3083, 1115, -1061,
                function(box)
                    obj_scale_xyz(box, 1, 9, 1)
                    box.oFaceAngleYaw = -15092
                    box.oMoveAngleYaw = -15092
                    box.oCollisionDistance = 3000
                end)
            end
        }
    }
}

local function on_sync_valid()
    local blockedInfo = sBlockedAreas[currHack]
    if not blockedInfo or not blockedInfo[gNetworkPlayers[0].currLevelNum] then return end

    if blockedInfo[gNetworkPlayers[0].currLevelNum].area == gNetworkPlayers[0].currAreaIndex then
        blockedInfo[gNetworkPlayers[0].currLevelNum].func()
    end
end

--* make it so you can't push metal boxes
local function metal_box_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    o.collisionData = gGlobalObjectCollisionData.metal_box_seg8_collision_08024C28
end

local function metal_box_loop(o)
    load_object_collision_model()
end

hook_behavior(id_bhvPushableMetalBox, OBJ_LIST_SURFACE, true, metal_box_init, metal_box_loop, "bhvHnSMetalBox")

local function ready()
    if ps[0].team == TEAM_HIDERS and gGlobalSyncTable.gameState == GAME_STATE_ACTIVE then
        ps[0].isReady = not ps[0].isReady
        local text = ps[0].isReady and "\\#ffff00\\You are now Ready." or "\\#ff0000\\You are not Ready."
        djui_chat_message_create(text)
    else
        djui_chat_message_create("\\#ff0000\\You must be a hider!")
    end
    return true
end

local function switch_player_team(msg)
    local returnedIndex, name = get_player_global_index_by_name(msg)
    local gI = msg and returnedIndex or 0
    local i = network_local_index_from_global(gI)

    ps[i].team = (ps[i].team + 1) % TEAM_MAX
    play_sound(SOUND_GENERAL_BOING2, gGlobalSoundSource)
    djui_popup_create_global(name.." \\#fcfcfc\\Is now a "..roleToString[ps[i].team].text, 2)
    return true
end

if network_is_moderator() or network_is_server() then
    hook_chat_command("swapTeam", "[user], will swap the team of the target player", switch_player_team)
    hook_chat_command("start", "starts the game", start_command)

    hook_chat_command("floor", "set the forced floor", chat_command)
    hook_chat_command("gamestate", "set the current game state", game_state)
end

hook_chat_command("ready", "once everyone is ready, start the game", ready)
hook_event(HOOK_JOINED_GAME, on_player_connected)
hook_event(HOOK_ON_PACKET_RECEIVE, on_packet_receive)
hook_event(HOOK_ON_PAUSE_EXIT, pause_exit)
hook_event(HOOK_UPDATE, game_update)
hook_event(HOOK_ON_PVP_ATTACK, on_pvp_attack)
hook_event(HOOK_ON_LEVEL_INIT, level_init)
hook_event(HOOK_ON_SYNC_VALID, on_sync_valid)
hook_event(HOOK_MARIO_UPDATE, mario_update)
hook_event(HOOK_ON_SCREEN_TRANSITION, function (trans)
    local m = gMarioStates[0]
    --* could use hook_on_death but i like this better
    if ps[0].team == TEAM_HIDERS and gGlobalSyncTable.hiderHeadStartTimer >= gGlobalSyncTable.hiderHeadStartTimerMax then
        if trans == WARP_TRANSITION_FADE_INTO_BOWSER or (m.floor and m.floor.type == SURFACE_DEATH_PLANE and m.pos.y < m.floorHeight + 2048) then

            notify_caught_player(0)

            gGlobalSyncTable.roundTimer = gGlobalSyncTable.roundTimer - gGlobalSyncTable.roundTimerMax * 0.1
            ps[0].team = TEAM_SEEKERS
            set_room_override(-1)

            ps[0].time =  gGlobalSyncTable.roundTimerMax - gGlobalSyncTable.roundTimer
        end
    end
end)

ACT_EDITED_DEBUG_FREE_MOVE = allocate_mario_action( ACT_FLAG_STATIONARY | ACT_FLAG_AIR | ACT_FLAG_METAL_WATER)

function act_debug_free_move(m)

    local gPlayer1Controller = gMarioStates[0].controller

    -- integer immediates, generates convert instructions for some reason

    local speed = gPlayer1Controller.buttonDown & B_BUTTON ~= 0 and 2 or 4

    m.faceAngle.y = m.intendedYaw
    m.health = 0x880

    set_mario_animation(m, MARIO_ANIM_A_POSE)
    local pos = {x = m.pos.x, y = m.pos.y, z = m.pos.z}

    if gPlayer1Controller.buttonDown & A_BUTTON ~= 0 then
        pos.y = pos.y + 16.0 * speed
    end
    if gPlayer1Controller.buttonDown & Z_TRIG ~= 0 then
        pos.y = pos.y - 16.0 * speed
    end
    if gPlayer1Controller.buttonPressed & Y_BUTTON ~= 0 then
        set_mario_action(m, ACT_FREEFALL, 0)
    end

    if m.intendedMag > 0 then
        pos.x = pos.x + 26.0 * speed * sins(m.intendedYaw)
        pos.z = pos.z + 26.0 * speed * coss(m.intendedYaw)
    end

    local surf = m.floor.type
    local floorHeight = find_floor_height(pos.x, pos.y, pos.z)
    if surf ~= nil then
        if pos.y < floorHeight then
            pos.y = floorHeight
        end
      vec3f_copy(m.pos, pos)
    end

    vec3f_copy(m.marioObj.header.gfx.pos, m.pos)
    vec3s_set(m.marioObj.header.gfx.angle, 0, m.faceAngle.y, 0)

    return false
end

hook_mario_action(ACT_EDITED_DEBUG_FREE_MOVE, act_debug_free_move, 0)

gLevelValues.fixCollisionBugs = true

local function is_pos_within_box(pos, minX, minY, minZ, maxX, maxY, maxZ)
    return pos.x >= minX and pos.x <= maxX and
           pos.y >= minY and pos.y <= maxY and
           pos.z >= minZ and pos.z <= maxZ
end

local function water_level_fix(m) -- -4183 136 4316
    local waterY
    if is_pos_within_box(m.pos, -4948, -1060, 1420, -4183, 136, 4316) then
        waterY = -11000
    else
        waterY = 450
    end
    set_environment_region(2, waterY)
end

local function skybox_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    o.header.gfx.skipInViewCheck = true
    o.oFaceAnglePitch = 0
    o.oOpacity = 255
    o.oFaceAngleRoll = 0
    o.oPosX = 0
    o.oPosY = 0
    o.oPosZ = 0
    obj_scale(o, 30)
    set_override_far(1000000)
end

local function skybox_loop(o)
    local m = gMarioStates[0]

    local transitionPoint = {x = 0, y = 0, z = 0}
    local fadeRange = 1000

    local posZ = m.pos.z

    if ps[m.playerIndex].isUsingFreeCam then
        posZ = gLakituState.pos.z
    end

    local distanceFromTransition = posZ - transitionPoint.z

    local opacity = math.max(0, math.min(255, (distanceFromTransition / fadeRange) * 255))
    o.oOpacity = opacity

    o.oFaceAngleYaw = o.oFaceAngleYaw + 0x15

    local secondaryMusicVolume = math.max(0, math.min(100, (distanceFromTransition / fadeRange) * 100))

    local bgMusicVolume = 100 - secondaryMusicVolume

    if not hurryUp then
        play_secondary_music(SEQ_LEVEL_HOT, bgMusicVolume, secondaryMusicVolume, 0)
    end
end

local id_bhvSky = hook_behavior(nil, OBJ_LIST_GENACTOR, true, skybox_init, skybox_loop, "bhvSky")

local E_MODEL_SKYBOX = smlua_model_util_get_id("fire_sky_geo")

local function handle_swap(m)
    local skybox = obj_get_first_with_behavior_id(id_bhvSky)

    if not skybox then spawn_non_sync_object(id_bhvSky, E_MODEL_SKYBOX, 0, 0, 0, nil) set_override_skybox(BACKGROUND_SNOW_MOUNTAINS) end
end

add_scroll_target(0, "icelavamap_dl_TransparentLava_mesh_layer_5_vtx_cull")
add_scroll_target(1, "icelavamap_dl_TransparentLava_mesh_layer_5_vtx_0")

add_scroll_target(2, "icelavamap_dl_OpaqueLava_mesh_layer_1_vtx_0")

sLevelBehaviors = {
    [LEVEL_GG] = {func = water_level_fix},
    [LEVEL_BBB] = {func = handle_swap},
}

local function slow_bomb_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    local m = gMarioStates[network_local_index_from_global(o.globalPlayerIndex)]
    local hider = nearest_team_to_object(TEAM_HIDERS, o)
    if not hider or not ps[hider.playerIndex].frozen then hider = m end

    local angleToPlayer = (hider.marioObj and obj_angle_to_object(o, hider.marioObj) or 0) or 0

    if dist_between_objects(m.marioObj, hider.marioObj) > 600 then
        hider = m
    end

    if hider == m then
        angleToPlayer = math.random(0, 65535)
    end

    o.oMoveAngleYaw = angleToPlayer
    o.oFaceAngleYaw = angleToPlayer

    m.faceAngle.y = angleToPlayer

    o.oForwardVel = 30 + hider.forwardVel

    o.oVelY = 40 + hider.vel.y
    o.oGravity = -4

    o.oAnimations = gObjectAnimations.bobomb_seg8_anims_0802396C

    obj_init_animation(o, 1)

    obj_scale(o, 0.75)

    local hitbox = get_temp_object_hitbox()

    hitbox.interactType = INTERACT_WATER_RING
    hitbox.height = 300
    hitbox.radius = 300

    obj_set_hitbox(o, hitbox)

    network_init_object(o, true, {"oMoveAngleYaw", "oForwardVel", "globalPlayerIndex"})
end

local function slow_bomb_loop(o)
    local m = gMarioStates[0]
    local nm = nearest_team_to_object(TEAM_HIDERS, o)

    if not nm or not ps[nm.playerIndex].frozen then nm = m end

    o.oFaceAngleYaw = o.oFaceAngleYaw + 0x450
    o.oFaceAnglePitch = o.oFaceAnglePitch + 0x450

    cur_obj_move_using_fvel_and_gravity()
    cur_obj_update_floor()
    cur_obj_update_floor_height()

    if o.oInteractStatus & INT_STATUS_INTERACTED ~= 0 and ps[nm.playerIndex].team == TEAM_HIDERS then
        if ps[m.playerIndex].team == TEAM_HIDERS then
            ps[m.playerIndex].isSlow = true
        end

        spawn_sync_object(id_bhvBowserBombExplosion, E_MODEL_EXPLOSION, o.oPosX, o.oPosY, o.oPosZ, function ()
            set_camera_shake_from_hit(3)
        end)
        spawn_mist_particles_variable(0, 0, 46)
        --spawn_triangle_break_particles(20, 139, 0.3, o.oAnimState)
        cur_obj_play_sound_1(SOUND_GENERAL_VOLCANO_EXPLOSION)
        obj_mark_for_deletion(o)
    end

    if o.oPosY <= o.oFloorHeight then
        spawn_mist_particles_variable(0, 0, 46)
        --spawn_triangle_break_particles(20, 139, 0.3, o.oAnimState)
        cur_obj_play_sound_1(SOUND_GENERAL_WALL_EXPLOSION)
        obj_mark_for_deletion(o)
    end

    o.oInteractStatus = 0
end

id_bhvSlowBomb = hook_behavior(nil, OBJ_LIST_GENACTOR, true, slow_bomb_init, slow_bomb_loop, "bhvSlowBomb")