-- This file contains the entire API for Flood + that external mods can utilize.
-- Here you can learn how your mod can interact with Flood + using various functions.

_G.floodPlus = {
    -- Adds a level to the gLevels table.
    -- See a-levels.lua for more info on how
    -- you can add a level.
    add_level = function (levelData)
        table.insert(gLevels, { name = levelData.name, level = levelData.level, area = levelData.area, flagPos = levelData.flagPos, flagBase = levelData.flagBase, speed = levelData.speed, author = levelData.author, type = levelData.type, startPos = levelData.startPos, floodScale = levelData.floodScale, unwantedBhvs = levelData.unwantedBhvs, overrideName = levelData.overrideName, overrideWater = levelData.overrideWater, floodHeight = levelData.floodHeight, pipes = levelData.pipes, launchpads = levelData.launchpads, capTimer = levelData.capTimer, act = levelData.act, overrideSlide = levelData.overrideSlide, powerUp = levelData.powerUp, music = levelData.music, skybox = levelData.skybox, separator = levelData.separator, bonus = levelData.bonus })

        if levelData.bonus then
            FLOOD_BONUS_LEVELS = FLOOD_BONUS_LEVELS + 1
        end

        FLOOD_LEVEL_COUNT = FLOOD_LEVEL_COUNT + 1
    end,

    -- Adds a lobby to the gLobbies table.
    -- You can control the level, area, and spawn for your lobby.
    add_lobby = function (lobbyData)
        table.insert(gLobbies, { level = lobbyData.level, area = lobbyData.area, spawn = lobbyData.spawn, unwantedBhvs = lobbyData.unwantedBhvs, overrideWater = lobbyData.overrideWater, pipes = lobbyData.pipes, launchpads = lobbyData.launchpads, skybox = lobbyData.skybox })
    end,

    -- Allows you to set the death sound effect for your custom pursuer skin.
    -- Meant to be used with _G.floodExpanded.trollface_skin
    -- Sound is set with audio_stream_load
    -- Sound ID starts from 1 and so on.
    pursuer_sound = function (model, sound, soundId)
        table.insert(gSamples, sound)

        if eTrollProperties.skin == model then
            eTrollProperties.sound = soundId + #gSamples - 1
        end
    end,

    -- Allows you to set a custom pursuer hitbox for your custom pursuer skin.
    -- Default hitbox is 90.
    pursuer_hitbox = function (model, hitbox)
        if eTrollProperties.skin == model then
            eTrollProperties.hitbox = hitbox
        end
    end,

    -- Gets the current game/romhack.
    -- See a-levels.lua for all of the game IDs (integers)
    get_game = function ()
        return game
    end,

    -- Adds a lobby song.
    add_lobby_song = function (id, name)
        table.insert(gLobbySongs, { id = id, name = name })
    end,

    -- Gets the current flood type.
    -- See a-levels.lua for all of the flood type IDs (integers)
    get_type = function ()
        return gLevels[gGlobalSyncTable.level].type
    end,

    -- Adds an author color to the authorColors table.
    -- See author-colors.lua to get an idea on how the authorColors
    -- table works.
    add_author_color = function (name, r, g, b)
        authorColors[name] = function ()
            djui_hud_set_adjusted_color(r, g, b, 255)
        end
    end,

    -- Gets the current level.
    -- This allows you to check many things about a specific level.
    get_current_level = function ()
        return gLevels[gGlobalSyncTable.level]
    end,

    -- Gets the current round state.
    -- See main.lua for all of the round state IDs (integers)
    get_round_state = function ()
        return gGlobalSyncTable.roundState
    end
}