-- Thanks to EmeraldLockdown to most of the tip code

if unsupported then return end

local randomTipTimer = 0
local currentTipMessage = ""
local tipMessages = {
    "Tip: You can disable Romhack Camera in the General Settings.",
    "Tip: If you want a more in-depth explanation on how Flood + works, you can refer to the official Flood + Manual found in the settings menu!",
    "Tip: You can change the order of the levels by changing the mapmode in the Game Settings.",
    "Tip: You can take a look at the \"Romhacks\" menu inside the Flood Settings to see what hacks are supported. There's even a \"Kaizo\" category as well!",
    "Tip: There are 2 Spectator Modes you can select in the General Settings; Normal or Follow.",
    "Tip: Flood has a built-in Speedrun Mode you can use. You can toggle the Speedrun Mode in the Game Settings.",
    "Tip: It's recommended to do '/custom-hud' on certain Romhacks that contain custom hud.",
    "Tip: You can lower the Flood's speed and difficulty in the Game Settings.",
    "Tip: Try the variants! They shake up the Flood experience by having you traverse areas of a level you don't normally see in Flood!",
    "Tip: Feeling too isolated in Flood +? Enable the PvP modifier for some chaotic player interaction!",
    "Tip: The Start/Restart/Skip/Stop Round options in the Pause Menu are great for people who prefer it over the chat commands!",
    "Tip: Need extra incentive to speed up beyond the flood? Enable the Pursuit Modifier! Make sure not to slouch with the Pursuer around, or you're history!",
    "Tip: Base your flags! It's recommended to base as many as you can. The only exception to this is when it looks bad on a particular level.",
    "Tip: Don't like the Quicksand nerf? Turn on Quicksand in the Game Settings!",
    "Tip: Don't like jumping up slopes with no effort? Turn off Slopejumps in the Game Settings!",
    "Tip: Is Tick Tock Clock hard for you? You can change the speed of the clock itself with /ttc-speed!",
    "Tip: Enable Hard Mode! Including things like 4 HP max and a ban on slopejumps, among others things, it'll give you way less room for slip-ups!",
    "Tip: Ever gotten bored of the way the Hud text looks? Head over to Hud Settings and change the Font to your liking!",
    "Tip: If you ever feel like creating a new romhack port, go into creative mode! (Testing Tool Mods)",
    "Tip: Why not take a break? You can pause the game and go into the Coop Settings to disconnect.",
    "Tip: Stay positive! It's never good to be negative in your life, even if life may be tough.",
    "Tip: Lock in.",
    "Tip: You should just get better honestly.",
    "Tip: Are you in the mood to see SM64 in a whole new way? Enable 'Nearest' Filtering in Coop's Display Settings!",
    "Did You Know: There are " .. totalRomhacks .. " romhacks supported in Flood +! There's a high chance your favorite is among them!",
    "Did You Know: You can enable/disable Custom Music for Vanilla in the General Settings.",
    "Did You Know: Nah, I'd win.",
    "Did You Know: SM64DS is pretty peak.",
    "Did You Know: I am currently in a kilometre range of your home. Start running.",
    "Did You Know: 1981 was the year that AAAAAAAAAAAAAAAAAAAAAAAAAAAAAHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH",
    "Did You Know: You can create custom themes that change the look of the Hud in the Flood Settings menu! Or you can pick a pre-made theme!",
    "Did You Know: You can disable Holiday Events in the General Settings if the effects aren't to your liking!",
    "Did You Know: You can turn off the cap sparkles for the Wing and Metal Cap in the Extra Settings.",
    "Did You Know: You can turn off the Welcome Message in the Extra Settings.",
    "Did You Know: You can change the skin for the Pursuer in the Modifier Settings.",
    "Did You Know: You can check out the Credits in the Flood Settings to see everyone that helped with the development of the mod!",
    "Did You Know: Whenever you sauce on pasta, taste sauce pasta, this, this because sauce and taste pasta and sauce is how the pasta taste when you sauce on pasta.",
    "Did You Know: Moderators have nearly as much power in a Flood + server as the host does! See the Moderator Commands section of the Manual for more info.",
    "Did You Know: Tired out of escaping the flood? Press Set Spectator in the Pause menu to begin watching the crowd flee from the rising flood!",
    "Did You Know: Flood + was based off of the mod \"Flood Expanded\" created by birdekek, aiming to expand its core and functionality. Go check it out!",
    "Did You Know: If you have the 'Leaves' Trail Particle equipped, and the level has snow properties, it becomes 'Snowballs' Trail Particle!",
    "Fun Fact: Flood + was first created back on March 17th, 2024.",
    "Fun Fact: Every SM64DS level is in Flood +. Even the DS Test level is included!",
    "Fun Fact: Flood has lore now..",
    "Fun Fact: There are 5 types of Pursuer skins you can select in the General Settings.",
    "Fun Fact: There are 25+ different texture designs for the Flood in Flood +!",
    "Fun Fact: Coder brainrot legitimately sucks.",
    "Fun Fact: There are a wide variety of custom levels to experience in Flood +, including many made just for the mod!",
    "Fun Fact: One day you will have to repent for your sins and may The Lord be merciful. Amen.",
    "Fun Fact: Some variants that we came up with but ended up scrapping for Vanilla ended up being used in the Luigi's Mansion 64 romhack port!",
    "Fun Fact: Avacados are a fruit, not a vegetable. Technically they're considered a berry with one seed, believe it or not",
    "Fun Fact: Lakitu Cam is peak!",
    "Fun Fact: Mario Cam is peak!",
    "Fun Fact: Romhack Cam is peak!",
    "Fun Fact: Freecam is peak!",
    "Fun Fact: Bup is life.",
    "Fun Fact: [insert game] truly was the game of all time!",
    "Fun Fact: You might be wondering how I got into this situation. To answer that, we need to talk about Parallel Universes.",
    "Fun Fact: Here at Flood + International Headquarters, we never run out of tips.",
    "Fun Fact: The Flood Expanded levels found in Flood + were nighttime-ified.",
    "Fun Fact: Many levels present in old Flood + were scrapped newer versions of Flood +. However, they have been turned into level DLC packs/addons!",
    "Fun Fact: A secret level called \"Pipe Crater\", was originally going to be inside Flood +. Only a select few know what the level actually is.",
    "Thank you for everything, Flood Project EX, Flood Expanded, Flood Romhack, and most importantly, Agent X's original Flood ",
    "Do you want to experience the origin story of Coop as a whole? Play Super Mario 64: The Underworld made by Agent X!",
    "Have you heard of the popular game Among Us? Yeah you have, cultural phenomenom and fun experience to have with your friends!",
    "Why am I a Flood + developer? Written by a Flood + developer.",
    "English or Spanish?",
    "No way! No way? No way!",
    "Written by Oso64DX!",
    ".__. a XDD"
}

-- Romhack tips
if game ~= GAME_VANILLA and FLOOD_LEVEL_COUNT > 1 then
    table.insert(tipMessages, "Fun Fact: This Romhack has " .. FLOOD_LEVEL_COUNT .. " levels!")
end

if game == GAME_SUPER_MARIO_74 then
    table.insert(tipMessages, "Fun Fact: Super Mario 74: Extreme Edition was the first Kaizo Romhack with custom levels.")
end

if game == GAME_STAR_REVENGE_1 or game == GAME_STAR_REVENGE_1_3 or game == GAME_STAR_REVENGE_3 or game == GAME_STAR_REVENGE_6 or game == GAME_STAR_REVENGE_1_5 or game == GAME_STAR_REVENGE_7_5 or game == GAME_STAR_REVENGE_4_9
or game == GAME_STAR_REVENGE_5 or game == GAME_STAR_REVENGE_2_5 or game == GAME_STAR_REVENGE_6_9 or game == GAME_STAR_REVENGE_2 or game == GAME_STAR_REVENGE_0_5 or game == GAME_STAR_REVENGE_7 or game == GAME_STAR_REVENGE_4 then
    table.insert(tipMessages, "Fun Fact: There are 14 of the 24 Star Revenges in sm64coopdx, all of them available in Flood +.")
end

if game == GAME_SM64_THE_BLACK_VIRUS then
    table.insert(tipMessages, "Fun Fact: SM64 The Black Virus is the hardest romhack in Flood +.")
end

if game == GAME_SUPER_MARIO_ODYSSEY_64 then
    table.insert(tipMessages, "Tip: You should play SM64 Odyssey with OMM Rebirth, if you don't want Kaizo difficulty.")
end

if game == GAME_SM74EEEEEE or game == GAME_SM74EEEEEE_2 then
    table.insert(tipMessages, "Fun Fact: 'EEEEEE' means Extreme Extraordinary Extravaganza Empurpled Eellogofusciouhipoppokunurious Edition.")
end

if game == GAME_UNKNOWN_ROMHACK_1 then
    table.insert(tipMessages, "Fun Fact: The creator and creation date of this romhack is a mystery.")
    table.insert(tipMessages, "Fun Fact: In the original version of this romhack, you play as a Cyclops Mario.")
end

-- Spooky easter egg
if holidayEvent == HOLIDAY_EVENT_HALLOWEEN then
    table.insert(tipMessages, "me when it's octobe")
else
    table.insert(tipMessages, "me when it's octove")
end

-- Mod Exclusive tips
for i in pairs(gActiveMods) do
    if _G.charSelectExists then
        table.insert(tipMessages, "Did You Know: You can go to \"Character Select\" through the Pause Menu when you are in Lobby.")
        table.insert(tipMessages, "Fun Fact: CS Characters have your custom palettes automatically enabled, so you can escape the flood in style.")
    end

    if gActiveMods[i].name:find("OMM Rebirth") then
        table.insert(tipMessages, "Fun Fact: There used to be a troll mechanic for OMM players found in FE.")
        table.insert(tipMessages, "Tip: Rolling is a great way to go fast and escape the flood!")
        table.insert(tipMessages, "Do OMM players have a skill issue when trying to escape the flood?")
    end

    if gActiveMods[i].name:find("Super Chained Bros.") then
        table.insert(tipMessages, "You want to have a Bad Time playing Chained Together and Flood combined huh?")
        table.insert(tipMessages, "Tip: You can enable Weight in Super Chained Bros' Settings to make it less annoying to escape the flood together.")
    end

    if gActiveMods[i].name:find("Grab Player") then
        table.insert(tipMessages, "Tip: Grab Player is best used with the PvP Modifier.")
    end
end

local function tips()
    if randomTipTimer <= 0 then
        currentTipMessage = tipMessages[math.random(#tipMessages)]
        randomTipTimer = 5 * 30 -- 10 seconds
    else
        randomTipTimer = randomTipTimer - 1
    end

    djui_hud_set_resolution(RESOLUTION_N64)
    djui_hud_set_font(FONT_MENU)
    local tipScale = 0.1
    local width = djui_hud_get_screen_width()
    local tipWidth = djui_hud_measure_text(currentTipMessage) * tipScale

    if gGlobalSyncTable.roundState == ROUND_STATE_INACTIVE and eHudVariables.tips == true then
        x = (width - tipWidth) / 2
        djui_hud_set_adjusted_color(255, 255, 255, 255)
        djui_hud_set_color(255, 255, 255, 255);
        djui_hud_print_text(currentTipMessage, x, 230, tipScale)
    end
end

hook_event(HOOK_ON_HUD_RENDER, tips)
