-- big thanks to birdekek for coding this hud message

if unsupported then return end

local hudTimer = 0
local hudState = 0
local welcomeMessages = {
    [HOLIDAY_EVENT_NONE] = "Welcome to \\#2BC3FF\\Flood \\#00ff00\\+!",
    [HOLIDAY_EVENT_HALLOWEEN] = "\\#ffa200\\ Happy \\#73008f\\Halloween!",
    [HOLIDAY_EVENT_CHRISTMAS] = "\\#FF0000\\Merry \\#699a00\\Christmas!",
    [HOLIDAY_EVENT_ST_PATRICKS] = "\\#1d940a\\Happy St. Patricks Day!",
    [HOLIDAY_EVENT_NEW_YEARS_EVE] = "\\#940a92\\ Happy New Year's Eve!",
    [HOLIDAY_EVENT_APRIL_FOOLS] = "April Fools!",
    [HOLIDAY_EVENT_EASTER] = "\\#e4abd5\\ Happy Easter!",
    [HOLIDAY_EVENT_ANNIVERSARY] = "\\#0077da\\Happy Flood Anniversary!"
}
local randomizedMessages = {
    "We hope you enjoy your stay.",
    "Get ready to escape the Flood!",
    "There are " .. totalRomhacks .. " supported romhacks.",
    "Survival Mode: Flood Edition",
    "Flood Alert: New Player incoming.",
    "The Flood is rising, and so are you.",
}
local strings = {
    [1] = welcomeMessages[holidayEvent],
    [2] = "[Created by \\#1892f5\\Jzzay\\#dcdcdc\\, \\#ff8eb2\\Bear64DX\\#dcdcdc\\ & \\#ff3030\\~TONO!~\\#dcdcdc\\]",
    [3] = randomizedMessages[math.random(#randomizedMessages)],
    [4] = "Have fun!",
    [5] = "Press \\#344feb\\A \\#ffffff\\to remove this popup.",
}

TEX_STAR = get_texture_info("star")

local function render_colored_text_centered(text, x, y, scale)
    djui_hud_set_font(FONT_MENU)

    djui_hud_print_colored_text(text, x - djui_hud_measure_text(string_without_hex(text)) / 2 * scale, y, scale)
end

local function on_hud_render()
    if not eFloodVariables.welcomeMessage then return end

    hudTimer = clamp(hudTimer + (hudState == 0 and 1 or -1), 0, 1 * 30)

    if hudTimer == 1 and hudState == 0 then
        play_sound_cbutton_up()
    end

    local yOffset = -(djui_hud_get_screen_height() / 2 + 768 / 2 + 30) + (hudTimer * (djui_hud_get_screen_height() / 2 + 768 / 2) / 30)
    local screenWidth = djui_hud_get_screen_width()

    local theme = get_selected_theme()
    local r = math.sin(0.25 * get_global_timer() + 0) * 127 + 128
    local g = math.sin(0.25 * get_global_timer() + 2) * 127 + 128
    local b = math.sin(0.25 * get_global_timer() + 4) * 127 + 128

    djui_hud_set_color(theme.welcomeMessage.r, theme.welcomeMessage.g, theme.welcomeMessage.b, theme.welcomeMessage.a)
    djui_hud_render_rect_rounded_outlined((screenWidth / 2) - 512, djui_hud_get_screen_height() / 2 - 768 / 2 - yOffset, 1024, 768, theme.welcomeMessageOutline.r, theme.welcomeMessageOutline.g, theme.welcomeMessageOutline.b, 30, 255)

    djui_hud_set_color(r, g, b, 255)

    djui_hud_render_texture(TEX_STAR, (screenWidth / 2) - (djui_hud_measure_text(string_without_hex(strings[1])) + (gTextures.star.width * 10)), (djui_hud_get_screen_height() / 2) - (yOffset + 256), 4, 4)

    djui_hud_set_color(b, g, r, 255)

    djui_hud_render_texture(TEX_STAR, (screenWidth / 2) + (djui_hud_measure_text(string_without_hex(strings[1])) + (gTextures.star.width * 6)), (djui_hud_get_screen_height() / 2) - (yOffset + 256), 4, 4)

    render_colored_text_centered(strings[1], screenWidth / 2, (djui_hud_get_screen_height() / 2) - (yOffset + 256), 1)

    djui_hud_set_color(255, 255, 255, 255)

    render_colored_text_centered(strings[2], screenWidth / 2, (djui_hud_get_screen_height() / 2) - (yOffset + 192), 0.5)
    render_colored_text_centered(strings[3], screenWidth / 2, (djui_hud_get_screen_height() / 2) - (yOffset + 64), 1)
    render_colored_text_centered(strings[4], screenWidth / 2, (djui_hud_get_screen_height() / 2) - (yOffset - 64), 1)
    render_colored_text_centered(strings[5], screenWidth / 2, (djui_hud_get_screen_height() / 2) - (yOffset - 256), 1)
end

local function on_mario_update(m)
    if m.playerIndex ~= 0 then return end

    if hudState == 0 and hudTimer == 1 * 30 then
        if m.controller.buttonPressed & A_BUTTON ~= 0 then
            hudState = 1

            play_sound_cbutton_down()
        end
    end
end

hook_event(HOOK_ON_HUD_RENDER, on_hud_render)
hook_event(HOOK_MARIO_UPDATE, on_mario_update)