-- name: \\#2BC3FF\\Flood \\#00ff00\\+\\#dcdcdc\\ /BAG/ Edition
-- incompatible: gamemode
-- description: Modified version of Flood+ that supports Super Momoi 64 levels.
-- deluxe: true

if unsupported then return end

-- constants
ROUND_STATE_INACTIVE   = 0
ROUND_STATE_ACTIVE     = 1
ROUND_STATE_END        = 2
ROUND_COOLDOWN         = 26 * 30 -- 26 seconds, the 26 should only be shown on 1 frame

MAPMODE_NORMAL = 0
MAPMODE_RANDOM = 1
MAPMODE_VOTING = 2

SPEEDRUN_MODE_OFF      = 0
SPEEDRUN_MODE_PROGRESS = 1
SPEEDRUN_MODE_RESTART  = 2
SPEEDRUN_MODE_MARATHON = 3

SPECTATOR_MODE_NORMAL  = 0
SPECTATOR_MODE_FOLLOW  = 1

SKIN_POISONSHROOM      = 0
SKIN_GREENDEMON         = 1
SKIN_ANGRYSUN          = 2
SKIN_HEARTDEMON        = 4

FLAG_RADAR = get_texture_info("flag_radar")

-- local scope variables
local outcomeTimer = 0
local newSeq = 0

gGlobalSyncTable.lobby = math.random(#gLobbies)

version = "v1.0"
totalRomhacks = 137

targetPlayer = 0
alpha = 0

-- theme variables
selectedTheme = 1
requestingThemeName = nil
requestingThemeHex = nil

-- gGlobalSyncTables, used for syncing things between players
gGlobalSyncTable.roundState = ROUND_STATE_INACTIVE
gGlobalSyncTable.timer = ROUND_COOLDOWN
gGlobalSyncTable.level = 1
gGlobalSyncTable.floodLevel = -20000
gGlobalSyncTable.speedMultiplier = 1
gGlobalSyncTable.roundFadeout = true
gGlobalSyncTable.coinCount = 4
gGlobalSyncTable.difficulty = 1
gGlobalSyncTable.mapMode = MAPMODE_NORMAL
gGlobalSyncTable.autoMode = true
gGlobalSyncTable.floodGravity = true
gGlobalSyncTable.floodInteractions = false
gGlobalSyncTable.lobbyPowerups = false
gGlobalSyncTable.lobbyPvp = true
gGlobalSyncTable.lobbyBosses = false
gGlobalSyncTable.autodoors = true
gGlobalSyncTable.respawn = false
gGlobalSyncTable.killInactive = true
gGlobalSyncTable.startShortcut = true
gGlobalSyncTable.startBind = A_BUTTON
gGlobalSyncTable.totalRoundRestarts = 0
gGlobalSyncTable.placementPosition = 0
gGlobalSyncTable.popups = true
gGlobalSyncTable.alpha = 0
gGlobalSyncTable.nospectator = false
gGlobalSyncTable.hardMode = false
gGlobalSyncTable.quicksand = false
gGlobalSyncTable.slopejumps = true
gGlobalSyncTable.pursuerSpeed = 15
gGlobalSyncTable.playerKnockbackStrength = 1
gGlobalSyncTable.pvpType = 0
gGlobalSyncTable.bouncyLevelBounds = 0
gGlobalSyncTable.pauseAnywhere = true
gGlobalSyncTable.bubbleDeath = true
gGlobalSyncTable.nametags = true
gGlobalSyncTable.enablePlayersInLevelDisplay = true
gGlobalSyncTable.enablePlayerList = true
-- modifier gGlobalSyncTables
gGlobalSyncTable.modif_powerups = false
gGlobalSyncTable.modif_instakill = false
gGlobalSyncTable.modif_pursuit = false
gGlobalSyncTable.modif_deathcoin = false
gGlobalSyncTable.modif_winboost = false
gGlobalSyncTable.modif_speed = false
gGlobalSyncTable.modif_bbc = false
gGlobalSyncTable.modif_zbc = false
gGlobalSyncTable.modif_coinrush = false
gGlobalSyncTable.modif_tripping = false
gGlobalSyncTable.modif_lowgravity = false
gGlobalSyncTable.modif_highgravity = false
gGlobalSyncTable.modif_flashflood = false
gGlobalSyncTable.modif_blj = false
gGlobalSyncTable.modif_capless = false
gGlobalSyncTable.modif_fly = false
gGlobalSyncTable.modif_slippery = false
gGlobalSyncTable.modif_hard = false
gGlobalSyncTable.modif_fog = false
gGlobalSyncTable.modif_inverted = false
gGlobalSyncTable.modif_tornadoes = false
gGlobalSyncTable.modif_firsties = false
gGlobalSyncTable.modif_stj = false
gGlobalSyncTable.modif_earthquake = false
-- misc variables, used for stuff like the Cap Sparkles and Romhack Camera
capSparkles = true
warpSparkles = true
romhackCam = true
romhackCamCollision = true
cinematicCamera = false
cinematicBorders = false

-- gLevelValues, to prevent cap stuff as well as pss' star and MC time
if game == GAME_VANILLA then
    gLevelValues.pssSlideStarTime = 30
    gLevelValues.metalCapDurationCotmc  = 1
    gLevelValues.vanishCapDurationVcutm = 85
end

eFloodVariables = {
    customMusic = true,
    spectatorMode = SPECTATOR_MODE_NORMAL,
    welcomeMessage = true,
    holidayEvents = true,
    scrollingFlood = true,
    trailParticleVisibility = true,
}

eHudVariables = {
    levelDisplay = true,
    authorDisplay = true,
    modifiersDisplay = true,
    timeDisplay = true,
    leaderboard = true,
    healthMeter = true,
    font = FONT_MENU,
    levelScale = 0.20,
    authorScale = 0.15,
    coinCounter = true,
    capDisplay = true,
    minimap = true,
    outlines = true,
    flagRadar = true,
    romhackLogos = true,
    tips = true,
    musicDisplay = true,
    typeDisplay = true,
    nextLevelIndicator = true,
    currentLevelIndicator = true,
    gamemodeText = true
}

eTrollProperties = {
    skin = SKIN_POISONSHROOM,
    sound = sShroomDie,
    hitbox = 90
}

pursuerSkinData = {
    [SKIN_POISONSHROOM] = {
        skin = E_MODEL_POISONSHROOM,
        sound = sShroomDie
    },
    [SKIN_GREENDEMON] = {
        skin = E_MODEL_1UP,
        sound = sShroomDie -- Placeholder sound
    },
    [SKIN_ANGRYSUN] = {
        skin = E_MODEL_ANGRYSUN,
        sound = sShroomDie
    },
    [SKIN_HEARTDEMON] = {
        skin = E_MODEL_HEART,
        sound = sShroomDie -- Placeholder sound
    }
}

local winSoundEffects = {
    SOUND_MENU_MARIO_CASTLE_WARP,
    SOUND_MENU_MARIO_CASTLE_WARP2,
    SOUND_MENU_UNK0C,
    SOUND_MENU_YOSHI_GAIN_LIVES,
    SOUND_MENU_COLLECT_SECRET,
    SOUND_MENU_STAR_SOUND,
    SOUND_GENERAL_COLLECT_1UP,
    SOUND_GENERAL_HEART_SPIN
}

local loseSoundEffects = {
    SOUND_GENERAL_PAINTING_EJECT,
    SOUND_MENU_LET_GO_MARIO_FACE
}

local speedOutcomes = {
    1,
    1.10,
    1.25,
    1.50,
    1.75,
    2,
}

local floodConditions = {
    [1.00] = "Calm",
    [1.10] = "Mild",
    [1.25] = "Enraged",
    [1.50] = "Hazardous",
    [1.75] = "Dangerous",
    [2.00] = "Violent"
}

local lavaFloods = {
    [FLOOD_LAVA]      = true,
    [FLOOD_FROSTBITE] = true,
    [FLOOD_MAGMA]     = true,
    [FLOOD_SULFUR]    = true,
    [FLOOD_MOLTEN]    = true,
    [FLOOD_VOLCANO]   = true
}

local sandFloods = {
    [FLOOD_SAND]   = true,
    [FLOOD_WASTE]  = true,
    [FLOOD_DESERT] = true,
    [FLOOD_ACID]   = true,
    [FLOOD_POISON] = true,
    [FLOOD_SUNSET] = true,
    [FLOOD_OPTIC]  = true
}

startBinds = {
    [A_BUTTON] = "A",
    [X_BUTTON] = "X",
    [Y_BUTTON] = "Y"
}

typeNames = {
    [FLOOD_WATER] = "Water",
    [FLOOD_LAVA] = "Lava",
    [FLOOD_SAND] = "Sand",
    [FLOOD_MUD] = "Mud",
    [FLOOD_SNOW] = "Snow",
    [FLOOD_WASTE] = "Waste",
    [FLOOD_DESERT] = "Desert",
    [FLOOD_ACID] = "Acid",
    [FLOOD_POISON] = "Poison",
    [FLOOD_SUNSET] = "Sunset",
    [FLOOD_FROSTBITE] = "Frostbite",
    [FLOOD_CLOUDS] = "Clouds",
    [FLOOD_RAINBOW] = "Rainbow",
    [FLOOD_DARKNESS] = "Darkness",
    [FLOOD_MAGMA] = "Magma",
    [FLOOD_SULFUR] = "Sulfur",
    [FLOOD_COTTON] = "Cotton",
    [FLOOD_MOLTEN] = "Molten",
    [FLOOD_OIL] = "Oil",
    [FLOOD_MATRIX] = "Matrix",
    [FLOOD_BUP] = "Bup",
    [FLOOD_TIDE] = "Tide",
    [FLOOD_DARKTIDE] = "Dark Tide",
    [FLOOD_VOLCANO] = "Volcano",
    [FLOOD_REDTIDE] = "Red Tide",
    [FLOOD_OPTIC] = "Optic"
}

-- for bonus levels
if gLevels[gGlobalSyncTable.level].bonus then
    FLOOD_BONUS_LEVELS = FLOOD_BONUS_LEVELS + 1
end

modifiers = {}

for i = 0, MAX_PLAYERS - 1 do
    gPlayerSyncTable[i].finished = false
    gPlayerSyncTable[i].time = 0
end

local flagIconPrevPos = { x = 0, y = 0 }

speedrunner = 0
local customCoinCounter = 0

function round_start()
    customCoinCounter = 0
    gGlobalSyncTable.roundState = ROUND_STATE_ACTIVE
    gGlobalSyncTable.timer = 100
    gGlobalSyncTable.placementPosition = 0
    gGlobalSyncTable.alpha = 0
    alpha = 0

    if gGlobalSyncTable.modif_flashflood == true then
        djui_popup_create("Flash Flood rising in 10 seconds!", 1)
    end

    if gGlobalSyncTable.modif_capless == false then
        gMarioStates[0].flags = MARIO_HAS_DEFAULT_CAP_ON
    end
end

local function checker()
    if gGlobalSyncTable.modif_powerups == true then
        if table.contains(modifiers, "Power-Ups") == false then
            table.insert(modifiers, "Power-Ups")
        end
    end

    if gGlobalSyncTable.modif_powerups == false then
        if table.contains(modifiers, "Power-Ups") == true then
            local pos = table.poselement(modifiers, "Power-Ups")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_instakill == true then
        if table.contains(modifiers, "Instakill") == false then
            table.insert(modifiers, "Instakill")
        end
    end

    if gGlobalSyncTable.modif_instakill == false then
        if table.contains(modifiers, "Instakill") == true then
            local pos = table.poselement(modifiers, "Instakill")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_pursuit == true then
        if table.contains(modifiers, "Pursuit") == false then
            table.insert(modifiers, "Pursuit")
        end
    end

    if gGlobalSyncTable.modif_pursuit == false then
        if table.contains(modifiers, "Pursuit") == true then
            local pos = table.poselement(modifiers, "Pursuit")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_pvp == true then
        if table.contains(modifiers, "PvP") == false then
            table.insert(modifiers, "PvP")
        end
    end

    if gGlobalSyncTable.modif_pvp == false then
        if table.contains(modifiers, "PvP") == true then
            local pos = table.poselement(modifiers, "PvP")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_deathcoin == true then
        if table.contains(modifiers, "Deathcoin") == false then
            table.insert(modifiers, "Deathcoin")
        end
    end

    if gGlobalSyncTable.modif_deathcoin == false then
        if table.contains(modifiers, "Deathcoin") == true then
            local pos = table.poselement(modifiers, "Deathcoin")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_winboost == true then
        if table.contains(modifiers, "Winboost") == false then
            table.insert(modifiers, "Winboost")
        end
    end

    if gGlobalSyncTable.modif_winboost == false then
        if table.contains(modifiers, "Winboost") == true then
            local pos = table.poselement(modifiers, "Winboost")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_speed == true then
        if table.contains(modifiers, "Speed") == false then
            table.insert(modifiers, "Speed")
        end
    end

    if gGlobalSyncTable.modif_speed == false then
        if table.contains(modifiers, "Speed") == true then
            local pos = table.poselement(modifiers, "Speed")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_bbc == true then
        if table.contains(modifiers, "B Button Challenge") == false then
            table.insert(modifiers, "B Button Challenge")
        end
    end

    if gGlobalSyncTable.modif_bbc == false then
        if table.contains(modifiers, "B Button Challenge") == true then
            local pos = table.poselement(modifiers, "B Button Challenge")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_zbc == true then
        if table.contains(modifiers, "Z Button Challenge") == false then
            table.insert(modifiers, "Z Button Challenge")
        end
    end

    if gGlobalSyncTable.modif_zbc == false then
        if table.contains(modifiers, "Z Button Challenge") == true then
            local pos = table.poselement(modifiers, "Z Button Challenge")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_coinrush == true then
        if table.contains(modifiers, "Coin Rush") == false then
            table.insert(modifiers, "Coin Rush")
        end
    end

    if gGlobalSyncTable.modif_coinrush == false then
        if table.contains(modifiers, "Coin Rush") == true then
            local pos = table.poselement(modifiers, "Coin Rush")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_tripping == true then
        if table.contains(modifiers, "Tripping") == false then
            table.insert(modifiers, "Tripping")
        end
    end

    if gGlobalSyncTable.modif_tripping == false then
        if table.contains(modifiers, "Tripping") == true then
            local pos = table.poselement(modifiers, "Tripping")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_lowgravity == true then
        if table.contains(modifiers, "Low Gravity") == false then
            table.insert(modifiers, "Low Gravity")
        end
    end

    if gGlobalSyncTable.modif_lowgravity == false then
        if table.contains(modifiers, "Low Gravity") == true then
            local pos = table.poselement(modifiers, "Low Gravity")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_highgravity == true then
        if table.contains(modifiers, "High Gravity") == false then
            table.insert(modifiers, "High Gravity")
        end
    end

    if gGlobalSyncTable.modif_highgravity == false then
        if table.contains(modifiers, "High Gravity") == true then
            local pos = table.poselement(modifiers, "High Gravity")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_flashflood == true then
        if table.contains(modifiers, "Flash Flood") == false then
            table.insert(modifiers, "Flash Flood")
        end
    end

    if gGlobalSyncTable.modif_flashflood == false then
        if table.contains(modifiers, "Flash Flood") == true then
            local pos = table.poselement(modifiers, "Flash Flood")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_blj == true then
        if table.contains(modifiers, "BLJ") == false then
            table.insert(modifiers, "BLJ")
        end
    end

    if gGlobalSyncTable.modif_blj == false then
        if table.contains(modifiers, "BLJ") == true then
            local pos = table.poselement(modifiers, "BLJ")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_capless == true then
        if table.contains(modifiers, "Capless") == false then
            table.insert(modifiers, "Capless")
        end
    end

    if gGlobalSyncTable.modif_capless == false then
        if table.contains(modifiers, "Capless") == true then
            local pos = table.poselement(modifiers, "Capless")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_fly == true then
        if table.contains(modifiers, "Fly") == false then
            table.insert(modifiers, "Fly")
        end
    end

    if gGlobalSyncTable.modif_fly == false then
        if table.contains(modifiers, "Fly") == true then
            local pos = table.poselement(modifiers, "Fly")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_slippery == true then
        if table.contains(modifiers, "Slippery Floors") == false then
            table.insert(modifiers, "Slippery Floors")
        end
    end

    if gGlobalSyncTable.modif_slippery == false then
        if table.contains(modifiers, "Slippery Floors") == true then
            local pos = table.poselement(modifiers, "Slippery Floors")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_hard == true then
        if table.contains(modifiers, "Hard Floors") == false then
            table.insert(modifiers, "Hard Floors")
        end
    end

    if gGlobalSyncTable.modif_hard == false then
        if table.contains(modifiers, "Hard Floors") == true then
            local pos = table.poselement(modifiers, "Hard Floors")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_fog == true then
        if table.contains(modifiers, "Fog") == false then
            table.insert(modifiers, "Fog")
        end
    end

    if gGlobalSyncTable.modif_fog == false then
        if table.contains(modifiers, "Fog") == true then
            local pos = table.poselement(modifiers, "Fog")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_inverted == true then
        if table.contains(modifiers, "Inverted Controls") == false then
            table.insert(modifiers, "Inverted Controls")
        end
    end

    if gGlobalSyncTable.modif_inverted == false then
        if table.contains(modifiers, "Inverted Controls") == true then
            local pos = table.poselement(modifiers, "Inverted Controls")
            table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_tornadoes == true then
        if table.contains(modifiers, "Tornadoes") == false then
            table.insert(modifiers, "Tornadoes")
        end
    end

    if gGlobalSyncTable.modif_tornadoes == false then
        if table.contains(modifiers, "Tornadoes") == true then
        local pos = table.poselement(modifiers, "Tornadoes")
        table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_firsties == true then
        if table.contains(modifiers, "Firsties") == false then
            table.insert(modifiers, "Firsties")
        end
    end

    if gGlobalSyncTable.modif_firsties == false then
        if table.contains(modifiers, "Firsties") == true then
        local pos = table.poselement(modifiers, "Firsties")
        table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_stj == true then
        if table.contains(modifiers, "Special Triple Jump") == false then
            table.insert(modifiers, "Special Triple Jump")
        end
    end

    if gGlobalSyncTable.modif_stj == false then
        if table.contains(modifiers, "Special Triple Jump") == true then
        local pos = table.poselement(modifiers, "Special Triple Jump")
        table.remove(modifiers, pos)
        end
    end

    if gGlobalSyncTable.modif_earthquake == true then
        if table.contains(modifiers, "Earthquake") == false then
            table.insert(modifiers, "Earthquake")
        end
    end

    if gGlobalSyncTable.modif_earthquake == false then
        if table.contains(modifiers, "Earthquake") == true then
        local pos = table.poselement(modifiers, "Earthquake")
        table.remove(modifiers, pos)
        end
    end
end

-- booleans and integers
if network_is_server() then
    -- these only apply to hosts
    if mod_storage_exists("gamemode") then gGlobalSyncTable.gamemode = mod_storage_load_number("gamemode") end
    if mod_storage_load_bool("Power-Ups") ~= nil then gGlobalSyncTable.modif_powerups = mod_storage_load_bool("Power-Ups") end
    if mod_storage_load_bool("Instakill") ~= nil then gGlobalSyncTable.modif_instakill = mod_storage_load_bool("Instakill") end
    if mod_storage_load_bool("Pursuit") ~= nil then gGlobalSyncTable.modif_pursuit = mod_storage_load_bool("Pursuit") end
    if mod_storage_load_bool("PvP") ~= nil then gGlobalSyncTable.modif_pvp = mod_storage_load_bool("PvP") end
    if mod_storage_load_bool("Deathcoin") ~= nil then gGlobalSyncTable.modif_deathcoin = mod_storage_load_bool("Deathcoin") end
    if mod_storage_load_bool("Winboost") ~= nil then gGlobalSyncTable.modif_winboost = mod_storage_load_bool("Winboost") end
    if mod_storage_load_bool("Speed") ~= nil then gGlobalSyncTable.modif_speed = mod_storage_load_bool("Speed") end
    if mod_storage_load_bool("B Button Challenge") ~= nil then gGlobalSyncTable.modif_bbc = mod_storage_load_bool("B Button Challenge") end
    if mod_storage_load_bool("Z Button Challenge") ~= nil then gGlobalSyncTable.modif_zbc = mod_storage_load_bool("Z Button Challenge") end
    if mod_storage_load_bool("Coin Rush") ~= nil then gGlobalSyncTable.modif_coinrush = mod_storage_load_bool("Coin Rush") end
    if mod_storage_load_bool("Tripping") ~= nil then gGlobalSyncTable.modif_tripping = mod_storage_load_bool("Tripping") end
    if mod_storage_load_bool("Lowgravity") ~= nil then gGlobalSyncTable.modif_lowgravity = mod_storage_load_bool("Lowgravity") end
    if mod_storage_load_bool("Highgravity") ~= nil then gGlobalSyncTable.modif_highgravity = mod_storage_load_bool("Highgravity") end
    if mod_storage_load_bool("FlashFlood") ~= nil then gGlobalSyncTable.modif_flashflood = mod_storage_load_bool("FlashFlood") end
    if mod_storage_load_bool("BLJ") ~= nil then gGlobalSyncTable.modif_blj = mod_storage_load_bool("BLJ") end
    if mod_storage_load_bool("Capless") ~= nil then gGlobalSyncTable.modif_capless = mod_storage_load_bool("Capless") end
    if mod_storage_load_bool("Fly") ~= nil then gGlobalSyncTable.modif_fly = mod_storage_load_bool("Fly") end
    if mod_storage_load_bool("Slippery") ~= nil then gGlobalSyncTable.modif_slippery = mod_storage_load_bool("Slippery") end
    if mod_storage_load_bool("Hard") ~= nil then gGlobalSyncTable.modif_hard = mod_storage_load_bool("Hard") end
    if mod_storage_load_bool("Fog") ~= nil then gGlobalSyncTable.modif_fog = mod_storage_load_bool("Fog") end
    if mod_storage_load_bool("Inverted") ~= nil then gGlobalSyncTable.modif_inverted = mod_storage_load_bool("Inverted") end
    if mod_storage_load_bool("Tornadoes") ~= nil then gGlobalSyncTable.modif_tornadoes = mod_storage_load_bool("Tornadoes") end
    if mod_storage_load_bool("Firsties") ~= nil then gGlobalSyncTable.modif_firsties = mod_storage_load_bool("Firsties") end
    if mod_storage_load_bool("STJ") ~= nil then gGlobalSyncTable.modif_stj = mod_storage_load_bool("STJ") end
    if mod_storage_load_bool("Earthquake") ~= nil then gGlobalSyncTable.modif_earthquake = mod_storage_load_bool("Earthquake") end
    if mod_storage_load_number("mapMode") ~= nil then gGlobalSyncTable.mapMode = mod_storage_load_number("mapMode") end
    if mod_storage_load("autoMode") == "false" then gGlobalSyncTable.autoMode = false end
    if mod_storage_load("floodGravity") == "false" then gGlobalSyncTable.floodGravity = false end
    if mod_storage_load("floodInteractions") == "true" then gGlobalSyncTable.floodInteractions = true end
    if mod_storage_load("lobbyPowerups") == "true" then gGlobalSyncTable.lobbyPowerups = true end
	if mod_storage_load("lobbyPvp") == "false" then gGlobalSyncTable.lobbyPvp = false end
    if mod_storage_load("lobbyBosses") == "true" then gGlobalSyncTable.lobbyBosses = true end
    if mod_storage_load("autodoors") == "false" then gGlobalSyncTable.autodoors = false end
    if mod_storage_load("respawn") == "true" then gGlobalSyncTable.respawn = true end
    if mod_storage_load("killInactive") == "false" then gGlobalSyncTable.killInactive = false end
    if mod_storage_load("startShortcut") == "false" then gGlobalSyncTable.startShortcut = false end
    if mod_storage_load_number("startBind") ~= nil then gGlobalSyncTable.startBind = mod_storage_load_number("startBind") end
    if mod_storage_load("roundFadeout") == "false" then gGlobalSyncTable.roundFadeout = false end
    if mod_storage_load("nospectator") == "false" then gGlobalSyncTable.nospectator = false end
    if mod_storage_load_bool("hardMode") ~= nil then gGlobalSyncTable.hardMode = mod_storage_load_bool("hardMode") end
    if mod_storage_load("quicksand") ~= nil then gGlobalSyncTable.quicksand = false end
    if mod_storage_load("slopejumps") == "false" then gGlobalSyncTable.slopejumps = false end
    if mod_storage_exists("pursuerSpeed") then gGlobalSyncTable.pursuerSpeed = mod_storage_load_number("pursuerSpeed") end
    if mod_storage_load("pauseAnywhere") == "false" then gGlobalSyncTable.pauseAnywhere = false end
    if mod_storage_load("bubbleDeath") == "false" then gGlobalSyncTable.bubbleDeath = false end
    if mod_storage_load("nametags") == "false" then gGlobalSyncTable.nametags = false end
    if mod_storage_load("enablePlayersInLevelDisplay") == "false" then gGlobalSyncTable.enablePlayersInLevelDisplay = false end
    if mod_storage_load("enablePlayerList") == "false" then gGlobalSyncTable.enablePlayerList = false end
end

-- these apply to everyone
if mod_storage_load("customMusic") == "false" then eFloodVariables.customMusic = false end
if mod_storage_load_number("spectatorMode") ~= nil then eFloodVariables.spectatorMode = mod_storage_load_number("spectatorMode") end
if mod_storage_load("capSparkles") == "false" then capSparkles = false end
if mod_storage_load("warpSparkles") == "false" then warpSparkles = false end
if mod_storage_load("romhackCam") == "false" then romhackCam = false end
if mod_storage_load("romhackCamCollision") == "false" then romhackCamCollision = false end
if mod_storage_load("welcomeMessage") == "false" then eFloodVariables.welcomeMessage = false end
if mod_storage_load("holidayEvents") == "false" then eFloodVariables.holidayEvents = false end
if mod_storage_load("scrollingFlood") == "false" then eFloodVariables.scrollingFlood = false end
if mod_storage_load("trailParticleVisibility") == "false" then eFloodVariables.trailParticleVisibility = false end
if mod_storage_load("tips") == "false" then eHudVariables.tips = false end
if mod_storage_load("musicDisplay") == "false" then eHudVariables.musicDisplay = false end
if mod_storage_load("typeDisplay") == "false" then eHudVariables.typeDisplay = false end
if mod_storage_load("popups") == "false" then gGlobalSyncTable.popups = false end
if mod_storage_load_number("skin") ~= nil then eTrollProperties.skin = mod_storage_load_number("skin") end
if mod_storage_load_number("theme") ~= nil then selectedTheme = mod_storage_load_number("theme") else selectedTheme = 1 end
if mod_storage_load("levelDisplay") == "false" then eHudVariables.levelDisplay = false end
if mod_storage_load("authorDisplay") == "false" then eHudVariables.authorDisplay = false end
if mod_storage_load("modifiersDisplay") == "false" then eHudVariables.modifiersDisplay = false end
if mod_storage_load("timeDisplay") == "false" then eHudVariables.timeDisplay = false end
if mod_storage_load("leaderboard") == "false" then eHudVariables.leaderboard = false end
if mod_storage_load("healthMeter") == "false" then eHudVariables.healthMeter = false end
if mod_storage_load_number("font") ~= nil then eHudVariables.font = mod_storage_load_number("font") end
if mod_storage_load_number("levelScale") ~= nil then eHudVariables.levelScale = mod_storage_load_number("levelScale") end
if mod_storage_load_number("authorScale") ~= nil then eHudVariables.authorScale = mod_storage_load_number("authorScale") end
if mod_storage_load("coinCounter") == "false" then eHudVariables.coinCounter = false end
if mod_storage_load("capDisplay") == "false" then eHudVariables.capDisplay = false end
if mod_storage_load("minimap") == "false" then eHudVariables.minimap = false end
if mod_storage_load("outlines") == "false" then eHudVariables.outlines = false end
if mod_storage_load("flagRadar") == "false" then eHudVariables.flagRadar = false end
if mod_storage_load("romhackLogos") == "false" then eHudVariables.romhackLogos = false end
if mod_storage_load("nextLevelIndicator") == "false" then eHudVariables.nextLevelIndicator = false end
if mod_storage_load("currentLevelIndicator") == "false" then eHudVariables.currentLevelIndicator = false end
if mod_storage_load("gamemodeText") == "false" then eHudVariables.gamemodeText = false end

if gGlobalSyncTable.startBind == 0 then gGlobalSyncTable.startBind = A_BUTTON end
if mod_storage_load("font") == nil then eHudVariables.font = FONT_MENU end
if mod_storage_load("levelScale") == nil then eHudVariables.levelScale = 0.20 end
if mod_storage_load("authorScale") == nil then eHudVariables.authorScale = 0.15 end

local themeIndex = 1
while themeIndex <= 5 do
    if mod_storage_load("theme_" .. themeIndex) ~= nil then
        load_theme(themeIndex)
    end
    themeIndex = themeIndex + 1
end

function round_end()
    gGlobalSyncTable.roundState = ROUND_STATE_END
    gGlobalSyncTable.timer = 5 * 30
    gGlobalSyncTable.floodLevel = -20000
    gGlobalSyncTable.lobby = math.random(#gLobbies)

    if network_is_server() then
        gGlobalSyncTable.totalRoundRestarts = 0
        gGlobalSyncTable.alpha = 0
    end

    if gGlobalSyncTable.modif_capless == false then
        gMarioStates[0].flags = MARIO_HAS_DEFAULT_CAP_ON
    end
end

local function server_update()
    if gGlobalSyncTable.roundState == ROUND_STATE_INACTIVE and not network_is_server() then
        if gGlobalSyncTable.timer == 1 and not gGlobalSyncTable.mapDeciding then
            if gGlobalSyncTable.mapMode == MAPMODE_VOTING then
                init_voting_menu()
            end
        end
    end

    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        if gNetworkPlayers[0].currLevelNum == gLevels[gGlobalSyncTable.level].level then
            gGlobalSyncTable.floodLevel = gGlobalSyncTable.floodLevel + gLevels[gGlobalSyncTable.level].speed * gGlobalSyncTable.speedMultiplier

            local active = 0
            for i = 0, (MAX_PLAYERS - 1) do
                local m = gMarioStates[i]
                if active_player(m) ~= 0 and m.health > 0xff and not gPlayerSyncTable[i].finished then
                    active = active + 1
                end
            end

            if active == 0 then
                local dead = 0
                for i = 0, (MAX_PLAYERS) - 1 do
                    if active_player(gMarioStates[i]) ~= 0 and gMarioStates[i].health <= 0xff then
                        dead = dead + 1
                    end
                end

                if dead == network_player_connected_count() then
                    gGlobalSyncTable.timer = 0
                elseif dead == network_player_connected_count() or (speedrun_mode(SPEEDRUN_MODE_MARATHON)) then
                    gGlobalSyncTable.timer = 0
                end

                if gGlobalSyncTable.timer > 0 then
                    gGlobalSyncTable.timer = gGlobalSyncTable.timer - 1
                else
                    round_end()

                    if not speedrun_mode() or speedrun_mode(SPEEDRUN_MODE_PROGRESS) then
                        local finished = 0
                        for i = 0, (MAX_PLAYERS - 1) do
                            if active_player(gMarioStates[i]) ~= 0 and gPlayerSyncTable[i].finished then
                                finished = finished + 1
                            end
                        end

                        if finished ~= 0 then
                            -- calculate position

                            gGlobalSyncTable.level = gGlobalSyncTable.level + 1
                            if gGlobalSyncTable.level > FLOOD_LEVEL_COUNT - FLOOD_BONUS_LEVELS then
                                gGlobalSyncTable.level = 1
                            end
                        end
                    elseif speedrun_mode(SPEEDRUN_MODE_MARATHON) then
                        local finished = 0
                        for i = 0, (MAX_PLAYERS - 1) do
                            if active_player(gMarioStates[i]) ~= 0 and gPlayerSyncTable[i].finished then
                                finished = finished + 1
                            end
                        end

                        if finished ~= 0 then
                            -- calculate position

                            gGlobalSyncTable.level = gGlobalSyncTable.level + 1
                            if gGlobalSyncTable.level > FLOOD_LEVEL_COUNT then
                                gGlobalSyncTable.level = 1
                            end
                        end
                    end
                end
            end
        end
    elseif gGlobalSyncTable.roundState == ROUND_STATE_INACTIVE then
        if network_player_connected_count() > 1 and gGlobalSyncTable.autoMode == true then
            if gGlobalSyncTable.timer > 0 then
                gGlobalSyncTable.timer = gGlobalSyncTable.timer - 1

                if gGlobalSyncTable.timer == 30 or gGlobalSyncTable.timer == 60 or gGlobalSyncTable.timer == 90 then
                    play_sound(SOUND_MENU_CHANGE_SELECT, gMarioStates[0].marioObj.header.gfx.cameraToObject)
                elseif gGlobalSyncTable.timer == 11 then
                    play_sound(SOUND_GENERAL_RACE_GUN_SHOT, gMarioStates[0].marioObj.header.gfx.cameraToObject)
                end
            end

            if gGlobalSyncTable.timer == 1 then
                if gGlobalSyncTable.mapMode == MAPMODE_NORMAL then
                    round_start()
                elseif gGlobalSyncTable.mapMode == MAPMODE_RANDOM then
                    gGlobalSyncTable.level = math.random(#gLevels)
                    round_start()
                elseif gGlobalSyncTable.mapMode == MAPMODE_VOTING then
                    host_init_voting_timer()
                end
            end
        end
    elseif gGlobalSyncTable.roundState == ROUND_STATE_END then
        if gGlobalSyncTable.timer > 0 then
            gGlobalSyncTable.timer = gGlobalSyncTable.timer - 1
        else
            gGlobalSyncTable.timer = ROUND_COOLDOWN
            gGlobalSyncTable.roundState = ROUND_STATE_INACTIVE
        end
    end
end

function speedrun_mode(mode)
    if mode == nil then
        return speedrunner > 0
    else
        return speedrunner == mode
    end
end

-- runs serverside

local function get_dest_act()
    return gLevels[gGlobalSyncTable.level].act ~= nil and gLevels[gGlobalSyncTable.level].act or 99
end

function level_restart()
    round_start()
    init_single_mario(gMarioStates[0])
    mario_set_full_health(gMarioStates[0])
    gPlayerSyncTable[0].time = 0
    warp_to_flood_level(gLevels[gGlobalSyncTable.level].level, gLevels[gGlobalSyncTable.level].area, get_dest_act())
    customCoinCounter = 0
    gPlayerSyncTable[0].finished = false
    gGlobalSyncTable.timer = 100
    if network_is_server() then
        gGlobalSyncTable.totalRoundRestarts = gGlobalSyncTable.totalRoundRestarts + 1
        gGlobalSyncTable.alpha = 0
    end

    if gGlobalSyncTable.modif_capless == false then
        gMarioStates[0].flags = MARIO_HAS_DEFAULT_CAP_ON
    end
end

function round_skip()
    network_send(true, { restart = true })
    if gGlobalSyncTable.level < FLOOD_LEVEL_COUNT then
        gGlobalSyncTable.level = gGlobalSyncTable.level + 1
        network_send(true, { restart = true })
        level_restart()
        gGlobalSyncTable.totalRoundRestarts = 0
    else
        network_send(true, { restart = true })
        level_restart()
        gGlobalSyncTable.level = 1
        gGlobalSyncTable.totalRoundRestarts = 0
	end
end

local function update()
    if network_is_server() then server_update() end

    if gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then
        obj_mark_for_deletion(pursuer)

        if (table.contains(modifiers, "Winboost") or table.contains(modifiers, "Flash Flood")) == true then
            gGlobalSyncTable.speedMultiplier = 1
        end

        if gNetworkPlayers[0].currLevelNum ~= gLobbies[gGlobalSyncTable.lobby].level or gNetworkPlayers[0].currActNum ~= 0 then
            if speedrun_mode() then
                level_restart()
            end

            warp_to_flood_level(gLobbies[gGlobalSyncTable.lobby].level, gLobbies[gGlobalSyncTable.lobby].area, 0)

            gServerSettings.playerInteractions = PLAYER_INTERACTIONS_PVP
        end
    elseif gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        local act = get_dest_act()

        if gNetworkPlayers[0].currLevelNum ~= gLevels[gGlobalSyncTable.level].level or gNetworkPlayers[0].currActNum ~= act then
            mario_set_full_health(gMarioStates[0])
            gPlayerSyncTable[0].time = 0
            gPlayerSyncTable[0].finished = false
            warp_to_flood_level(gLevels[gGlobalSyncTable.level].level, gLevels[gGlobalSyncTable.level].area, act)
        end
        return checker()
    end

    -- stops the star spawn cutscenes from happening
    local m = gMarioStates[0]
    if m.area ~= nil and m.area.camera ~= nil and (m.area.camera.cutscene == CUTSCENE_STAR_SPAWN or m.area.camera.cutscene == CUTSCENE_RED_COIN_STAR_SPAWN) then
        m.area.camera.cutscene = 0
        m.freeze = 0
        disable_time_stop_including_mario()
    end
end

--- @param m MarioState
local function before_mario_update(m)
    if network_is_server() then
        if m.playerIndex ~= 0 then return end

        if gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE and gGlobalSyncTable.startShortcut then
            if  m.controller.buttonDown & gGlobalSyncTable.startBind ~= 0
            and m.controller.buttonDown & START_BUTTON ~= 0 then
                if gGlobalSyncTable.mapMode == MAPMODE_NORMAL then
                    round_start()
                elseif gGlobalSyncTable.mapMode == MAPMODE_RANDOM then
                    gGlobalSyncTable.level = math.random(#gLevels)
                    round_start()
                end
                m.controller.buttonPressed = 0
            end
        end
    end

    if gGlobalSyncTable.modif_bbc then
        m.controller.buttonPressed = m.controller.buttonPressed & ~B_BUTTON
        m.controller.buttonDown = m.controller.buttonDown & ~B_BUTTON
    end

    if gGlobalSyncTable.modif_zbc then
        m.controller.buttonPressed = m.controller.buttonPressed & ~Z_TRIG
        m.controller.buttonDown = m.controller.buttonDown & ~Z_TRIG
    end

    -- BLJ modifier (Credits to Sunk)
    if gGlobalSyncTable.modif_blj then
        if (m.action == ACT_LONG_JUMP)
        and (m.controller.buttonDown & Z_TRIG) ~= 0
        and m.forwardVel < -15 then
            m.vel.y = -30
        end
    end

    if gGlobalSyncTable.modif_inverted then
        m.controller.stickX = -m.controller.stickX
        m.controller.stickY = -m.controller.stickY
    end
end

local normalFloors = {
    [SURFACE_BURNING] = true,
    [SURFACE_QUICKSAND] = true,
    [SURFACE_MOVING_QUICKSAND] = true,
    [SURFACE_DEEP_QUICKSAND] = true,
    [SURFACE_DEEP_MOVING_QUICKSAND] = true,
    [SURFACE_INSTANT_MOVING_QUICKSAND] = true,
    [SURFACE_DEATH_PLANE] = true,
}

local function on_set_mario_action(m)
    if gGlobalSyncTable.modif_firsties then
        if m.prevAction == ACT_AIR_HIT_WALL then m.prevAction = ACT_FREEFALL
        end
    end
end

--- @param m MarioState
local function mario_update(m)
    -- sets the location override
    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        network_player_set_override_location(gNetworkPlayers[m.playerIndex], name_of_level(gLevels[gGlobalSyncTable.level].level, gLevels[gGlobalSyncTable.level].area, gLevels[gGlobalSyncTable.level].name, gLevels[gGlobalSyncTable.level]))
    else
        network_player_set_override_location(gNetworkPlayers[m.playerIndex], "Lobby")
    end

    -- checks the player's status
    if m.health > 0xff and not gPlayerSyncTable[m.playerIndex].finished then
        network_player_set_description(gNetworkPlayers[m.playerIndex], "Alive", 75, 255, 75, 255)
    elseif m.health > 0xff then
        network_player_set_description(gNetworkPlayers[m.playerIndex], "Finished", 255, 215, 0, 255)
    else
        network_player_set_description(gNetworkPlayers[m.playerIndex], "Dead", 255, 75, 75, 255)
    end

    -- removes deathplanes in certain romhacks
    if game == GAME_ZTAR_ATTACK_2 or game == GAME_SOME_KIND_OF_A_CRASH_GAME then
        if m.floor and m.floor.type == SURFACE_DEATH_PLANE and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
            m.floor.type = SURFACE_DEFAULT
        end
    end

    -- if instakill is on, check if mario's gotten hurt, if so, kill him instantly
    if table.contains(modifiers, "Instakill") then
        if m.hurtCounter > 1 then
            m.health = 0xff
        end
    end

    -- tripping modifier
    if table.contains(modifiers, "Tripping") == true then
        if m.action == ACT_WALKING and math.random(0, 70) == 5 then
            set_mario_action(m, ACT_HARD_FORWARD_GROUND_KB, 0)
        end
    end

    -- if round state is active, increase the timer by 1
    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then timer = timer + 1 end

    if gGlobalSyncTable.modif_flashflood == true and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        if outcomeTimer <= 0 and gPlayerSyncTable[0].time >= (10 * 30) then
            if network_is_server() then
                gGlobalSyncTable.speedMultiplier = speedOutcomes[math.random(1, #speedOutcomes)]
            end
            outcomeTimer = 3000
        else
            outcomeTimer = outcomeTimer - 1
        end
    end

    if gGlobalSyncTable.modif_capless then
        m.flags = m.flags & ~MARIO_CAP_ON_HEAD
    end

    if gGlobalSyncTable.modif_fly then
        m.flags = m.flags | MARIO_WING_CAP
    end

    if gGlobalSyncTable.modif_slippery then
        if m.floor ~= nil then
            if not normalFloors[m.floor.type] then
                m.floor.type = SURFACE_SLIPPERY
            end
        end
    end

    if gGlobalSyncTable.modif_hard then
        if m.floor ~= nil then
            if not normalFloors[m.floor.type] then
                m.floor.type = SURFACE_HARD_NOT_SLIPPERY
            end
        end
    end

    if holidayEvent == HOLIDAY_EVENT_APRIL_FOOLS then
        gLevels[gGlobalSyncTable.level].type = FLOOD_BUP
        gNetworkPlayers[0].overrideModelIndex = 2
    end

    if gGlobalSyncTable.roundState == ROUND_STATE_INACTIVE then
        timer = 0
        dead = 0
    end

    if m.playerIndex ~= 0 then return end

    -- action specific modifications
    if gGlobalSyncTable.slopejumps == true then
        if m.action == ACT_STEEP_JUMP then
            m.action = ACT_JUMP
        end
    end

    -- spawn random objects in lobby (Credits to TOÑO)
	if gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE and gGlobalSyncTable.lobbyPowerups then
        local rando = math.random(775)
        if rando == 1 then
            spawn_sync_object(id_bhvMetalCap, E_MODEL_MARIOS_METAL_CAP, m.pos.x + math.random(1000), m.pos.y + math.random(1000), m.pos.z + math.random(1000), nil)
        end

        if rando == 2 then
            spawn_sync_object(id_bhvWingCap, E_MODEL_MARIOS_WING_CAP, m.pos.x + math.random(1000), m.pos.y + math.random(1000), m.pos.z + math.random(1000), nil)
        end

        if rando == 3 then
            spawn_sync_object(id_bhvVanishCap, E_MODEL_MARIOS_CAP, m.pos.x + math.random(1000), m.pos.y + math.random(1000), m.pos.z + math.random(1000), nil)
        end

        if rando == 4 then
            spawn_sync_object(id_bhvKoopaShell, E_MODEL_KOOPA_SHELL, m.pos.x + math.random(1000), m.pos.y + math.random(1000), m.pos.z + math.random(1000), nil)
        end
    end

        -- spawn tornadoes if the modifier is on
	if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and gGlobalSyncTable.modif_tornadoes then
        local rando = math.random(150)
        if rando == 1 then
            spawn_sync_object(id_bhvTweester, E_MODEL_TWEESTER, m.pos.x + math.random(1500), math.random(1500), m.pos.z + math.random(1500), nil)
        end
    end

    -- disable instant warps
    if m.floor ~= nil and (m.floor.type == SURFACE_WARP or (m.floor.type >= SURFACE_PAINTING_WARP_D3 and m.floor.type <= SURFACE_PAINTING_WARP_FC) or (m.floor.type >= SURFACE_INSTANT_WARP_1B and m.floor.type <= SURFACE_INSTANT_WARP_1E)) then
        m.floor.type = SURFACE_DEFAULT
    end

    -- disable insta kills
    if gGlobalSyncTable.quicksand == false then
        if m.floor ~= nil and (m.floor.type == SURFACE_INSTANT_QUICKSAND or m.floor.type == SURFACE_INSTANT_MOVING_QUICKSAND) then
            m.floor.type = SURFACE_BURNING
        end
    end

    -- caps mario's health at 5 if hard mode is enabled and enable quicksand and slopejumps
    if gGlobalSyncTable.hardMode then
        if m.health > 0x400 then
            m.health = 0x400
        end
        gGlobalSyncTable.quicksand = true
        gGlobalSyncTable.slopejumps = false
    end

    -- server settings on menu
    if gServerSettings.playerKnockbackStrength == 0 then
        gGlobalSyncTable.playerKnockbackStrength = 0
    elseif gServerSettings.playerKnockbackStrength == 1 then
        gGlobalSyncTable.playerKnockbackStrength = 1
    elseif gServerSettings.playerKnockbackStrength == 2 then
        gGlobalSyncTable.playerKnockbackStrength = 2
    end

    if gServerSettings.pvpType == 0 then
        gGlobalSyncTable.pvpType = 1
    elseif gServerSettings.pvpType == 1 then
        gGlobalSyncTable.pvpType = 1
    end

    if gServerSettings.bouncyLevelBounds == 0 then
        gGlobalSyncTable.bouncyLevelBounds = 0
    elseif gServerSettings.bouncyLevelBounds == 1 then
        gGlobalSyncTable.bouncyLevelBounds = 1
    elseif gServerSettings.bouncyLevelBounds == 2 then
        gGlobalSyncTable.bouncyLevelBounds = 2
    end

    if gGlobalSyncTable.pauseAnywhere == true then
        gServerSettings.pauseAnywhere = 1
    else
        gServerSettings.pauseAnywhere = 0
    end

    if gGlobalSyncTable.bubbleDeath == true then
        gServerSettings.bubbleDeath = 1
    else
        gServerSettings.bubbleDeath = 0
    end

    if gGlobalSyncTable.nametags == true then
        gServerSettings.nametags = 1
    else
        gServerSettings.nametags = 0
    end

    if gGlobalSyncTable.enablePlayersInLevelDisplay == true then
        gServerSettings.enablePlayersInLevelDisplay = 1
    else
        gServerSettings.enablePlayersInLevelDisplay = 0
    end

    if gGlobalSyncTable.enablePlayerList == true then
        gServerSettings.enablePlayerList = 1
    else
        gServerSettings.enablePlayerList = 0
    end

    -- Slippery/Non-slippery Levels (Credits to EmeraldLockdown)
    if gNetworkPlayers[0].currLevelNum == LEVEL_SA and
    game == GAME_STAR_ROAD and
    m.floor ~= nil and (m.floor.type == 19) then
        m.floor.type = SURFACE_HARD_NOT_SLIPPERY
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_THI and
    game == GAME_SM64_THE_GREEN_STARS and
    m.floor ~= nil and (m.floor.type == 19) then
        m.floor.type = SURFACE_HARD_NOT_SLIPPERY
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_PSS and
    game == GAME_SERVUS_64 and
    m.floor ~= nil and (m.floor.type == 19) then
        m.floor.type = SURFACE_HARD_NOT_SLIPPERY
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_PSS and
    game == GAME_SM64_SAPPHIRE and
    m.floor ~= nil and (m.floor.type == 19) then
        m.floor.type = SURFACE_HARD_NOT_SLIPPERY
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_PSS and
    game == GAME_GRAND_STAR and
    m.floor ~= nil and (m.floor.type == SURFACE_DEFAULT) then
        m.floor.type = SURFACE_HARD_NOT_SLIPPERY
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_JRB and
    game == GAME_STAR_REVENGE_5 and
    m.floor ~= nil and (m.floor.type == 19) then
        m.floor.type = SURFACE_HARD_NOT_SLIPPERY
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_PSS and
    game == GAME_STAR_REVENGE_1_5 and
    m.floor ~= nil and (m.floor.type == 19) then
        m.floor.type = SURFACE_HARD_NOT_SLIPPERY
    elseif (gNetworkPlayers[0].currLevelNum == LEVEL_JRB and gNetworkPlayers[0].currAreaIndex == 2) or (gNetworkPlayers[0].currLevelNum == LEVEL_JRB and gLevels[gGlobalSyncTable.level].name == "jrb2") then
        if game == GAME_VANILLA and
        m.floor ~= nil and (m.floor.type == SURFACE_DEFAULT) then
            m.area.terrainType = TERRAIN_SLIDE
        end
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_CCM and gNetworkPlayers[0].currAreaIndex == 2 and
    game == GAME_DREAM64 and
    m.floor ~= nil and (m.floor.type == 19) then
        m.floor.type = SURFACE_HARD_NOT_SLIPPERY
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_SSL and gNetworkPlayers[0].currAreaIndex == 2 and
    game == GAME_LAST_IMPACT and
    m.floor ~= nil and (m.floor.type == 46) then
        m.floor.type = SURFACE_HARD_NOT_SLIPPERY
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_TTM and gNetworkPlayers[0].currAreaIndex == 2 and
    game == GAME_LAND94 and
    m.floor ~= nil and (m.floor.type == 19) then
        m.floor.type = SURFACE_HARD_NOT_SLIPPERY
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_CCM and
    game == GAME_LUIGI_THE_VIOLET_STARS and
    m.floor ~= nil and (m.floor.type == 19) then
        m.floor.type = SURFACE_HARD_NOT_SLIPPERY
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_DDD and gNetworkPlayers[0].currAreaIndex == 2 and
    game == GAME_DESPAIR_MARIOS_GAMBIT and
    m.floor ~= nil and (m.floor.type == 19) then
        m.floor.type = SURFACE_HARD_NOT_SLIPPERY
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_DDD and gNetworkPlayers[0].currAreaIndex == 1 and
    game == GAME_THE_MUSHROOM_CUP and
    m.floor ~= nil and (m.floor.type == 19) then
        m.floor.type = SURFACE_HARD_NOT_SLIPPERY
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_SNS and
    m.floor ~= nil and (m.floor.type == SURFACE_DEFAULT) then
        m.floor.type = SURFACE_HARD_NOT_SLIPPERY
    end

    -- disable damage in lobby
    if gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then
        mario_set_full_health(m)
        m.peakHeight = m.pos.y
    end

    -- special triple jump modifier
    if gGlobalSyncTable.modif_stj then
        m.specialTripleJump = 1
    else
        m.specialTripleJump = 0
    end

    -- earthquake modifier
    if gGlobalSyncTable.modif_earthquake then
        set_camera_shake_from_hit(SHAKE_ENV_FALLING_BITS_PLAT)
    end

    -- cinematic camera
    if cinematicCamera then
        set_camera_shake_from_hit(SHAKE_ENV_PYRAMID_EXPLODE)
    end

    -- dialog boxes
    if (m.action == ACT_SPAWN_NO_SPIN_AIRBORNE or m.action == ACT_SPAWN_NO_SPIN_LANDING or m.action == ACT_SPAWN_SPIN_AIRBORNE or m.action == ACT_SPAWN_SPIN_LANDING) and m.pos.y < m.floorHeight + 10 then
        set_mario_action(m, ACT_FREEFALL, 0)
    end

    -- Sparkles!!
    if capSparkles then
        if (m.action == ACT_FLYING) or m.flags & MARIO_METAL_CAP ~= 0 then
            set_mario_particle_flags(m, PARTICLE_SPARKLES, 0)
        end
    end

    if warpSparkles then
        if (m.action == ACT_SPAWN_SPIN_AIRBORNE or m.action == ACT_SPAWN_NO_SPIN_AIRBORNE) then
            set_mario_particle_flags(m, PARTICLE_SPARKLES, 0)
        end
    end

    -- Unwanted behaviors (Credits to EmeraldLockdown, the goat)
    if gLevels[gGlobalSyncTable.level].unwantedBhvs ~= nil then
        for _, bhv in pairs(gLevels[gGlobalSyncTable.level].unwantedBhvs) do
            obj_mark_for_deletion(obj_get_first_with_behavior_id(bhv))
        end
    end

    if gLobbies[gGlobalSyncTable.lobby].unwantedBhvs ~= nil then
        for _, bhv in pairs(gLobbies[gGlobalSyncTable.lobby].unwantedBhvs) do
            obj_mark_for_deletion(obj_get_first_with_behavior_id(bhv))
        end
    end

    if gLobbies[gGlobalSyncTable.lobby].deathHeight ~= nil and gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then
        if m.pos.y < gLobbies[gGlobalSyncTable.lobby].deathHeight then
        vec3f_set(m.pos, gLobbies[gGlobalSyncTable.lobby].spawn.x, gLobbies[gGlobalSyncTable.lobby].spawn.y + 750, gLobbies[gGlobalSyncTable.lobby].spawn.z)
        m.faceAngle.y = gLobbies[gGlobalSyncTable.lobby].spawn.yaw
        set_mario_action(m, ACT_SPAWN_NO_SPIN_AIRBORNE, 0)
        m.vel.y = 0
        m.flags = m.flags | MARIO_VANISH_CAP
        m.capTimer = 60
        end
    end

	-- flood interactions
    if gGlobalSyncTable.floodInteractions then
        if m.pos.y < gGlobalSyncTable.floodLevel and m.action ~= ACT_SPECTATOR and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
 	        if lavaFloods[gLevels[gGlobalSyncTable.level].type] then
                drop_and_set_mario_action(m, ACT_LAVA_BOOST, 0)
	            if m.flags & MARIO_METAL_CAP == 0 then
	         	    m.hurtCounter = 12
		        end
		    elseif sandFloods[gLevels[gGlobalSyncTable.level].type] then
	        	if gGlobalSyncTable.quicksand == true then
                    set_mario_action(m, ACT_QUICKSAND_DEATH, 0)
                else
                    set_mario_action(m, ACT_LAVA_BOOST, 0)
      	            if m.flags & MARIO_METAL_CAP == 0 then
	         	        m.hurtCounter = 12
	                end
	        	end
            end
        end
	end

    if newSeq > 0 then
        tempo = sequence_player_get_tempo(SEQ_PLAYER_LEVEL)
        newSeq = newSeq - 1
    end

    -- Slow music for being under the flood
    -- Check if the player is under the flood level
    if m.pos.y < gGlobalSyncTable.floodLevel and m.health > 0xff and not gPlayerSyncTable[0].finished then
        -- Only adjust the tempo once when the player enters the flood
        if not wasUnderFlood then
            sequence_player_set_tempo(SEQ_PLAYER_LEVEL, tempo + (25 * 48))
            wasUnderFlood = true  -- Mark that the player is now under the flood
        end
    else
        -- Only reset the tempo once when the player exits the flood
        if wasUnderFlood then
            sequence_player_set_tempo(SEQ_PLAYER_LEVEL, tempo)
            wasUnderFlood = false  -- Mark that the player is no longer under the flood
        end
    end

    if gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then
        gGlobalSyncTable.placementPosition = 0
    end

    -- check if the player has reached the end of the level
    if gNetworkPlayers[0].currLevelNum == gLevels[gGlobalSyncTable.level].level and not gPlayerSyncTable[0].finished and ((gLevels[gGlobalSyncTable.level].flagPos.hitbox ~= false and m.pos.y == m.floorHeight)
    or ((speedrun_mode(SPEEDRUN_MODE_MARATHON) == true)) or (m.action & ACT_FLAG_ON_POLE) ~= 0)
    and vec3f_dist(m.pos, gLevels[gGlobalSyncTable.level].flagPos) < 755
    and m.health > 0xFF then
        if m.playerIndex ~= 0 then return end

        gPlayerSyncTable[0].finished = true
        gGlobalSyncTable.placementPosition = gGlobalSyncTable.placementPosition + 1

        if gGlobalSyncTable.popups == true and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
            djui_popup_create_global(network_get_player_text_color_string(0) .. gNetworkPlayers[0].name .. "\\#dcdcdc\\ has finished in\n " .. get_placement_text_colored(gGlobalSyncTable.placementPosition) .. "\\#dcdcdc\\ Place. Time: \\#00ff00\\" .. string.format("%.3f", gPlayerSyncTable[0].time / 30), 2)
        end

        if table.contains(modifiers, "Winboost") then
            gGlobalSyncTable.speedMultiplier = gGlobalSyncTable.speedMultiplier + 0.25
        end

        local string = ""
        if not (game == GAME_STAR_ROAD and gNetworkPlayers[0].currLevelNum == LEVEL_RR) then
            string = string .. "\\#00ff00\\You escaped the flood!\n"
            play_race_fanfare()
        else
            if speedrun_mode(SPEEDRUN_MODE_MARATHON) then
                string = string .. "\\#00ff00\\You escaped the \\#ffff00\\final\\#00ff00\\ flood.. If only it wasn't Marathon Mode!\n"
            else
                string = string .. "\\#00ff00\\You escaped the \\#ffff00\\final\\#00ff00\\ flood! Congratulations!\n"
                play_race_fanfare()
            end
        end
        string = string .. "\\#ffffff\\Time: " .. string.format("%.3f", gPlayerSyncTable[0].time / 30)
    end

    -- update spectator if finished, manage other things if not
    if gPlayerSyncTable[0].finished then
        mario_set_full_health(m)
        if network_player_connected_count() > 1
        and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and gGlobalSyncTable.nospectator == false then
            set_mario_spectator(m)
        end
    else
        if m.pos.y + 40 < gGlobalSyncTable.floodLevel then
            if table.contains(modifiers, "Instakill") == true then
                if (m.flags & MARIO_METAL_CAP) ~= 0 then

                elseif (m.flags & MARIO_VANISH_CAP ) ~= 0 then
                    m.health = m.health - 512
                else
                    m.health = m.health - 512
                end
            else
                if (m.flags & MARIO_METAL_CAP) ~= 0 then
                    if gGlobalSyncTable.hardMode then
                        m.health = m.health - 16 * gGlobalSyncTable.difficulty
                    end
                elseif (m.flags & MARIO_VANISH_CAP ) ~= 0 then
                    if gGlobalSyncTable.hardMode then
                        m.health = m.health - 32 * gGlobalSyncTable.difficulty
                    else
                        m.health = m.health - 8 * gGlobalSyncTable.difficulty
                    end
                elseif gGlobalSyncTable.hardMode then
                    m.health = m.health - 64 * gGlobalSyncTable.difficulty
                else
                    m.health = m.health - 32 * gGlobalSyncTable.difficulty
                end
            end
        end

        if m.action == ACT_QUICKSAND_DEATH then
            m.health = 0xff
        end

        if m.health <= 0xff then
            if network_player_connected_count() > 1
            and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
                m.area.camera.cutscene = 0
                set_mario_spectator(m)
            end
        else
            gPlayerSyncTable[0].time = gPlayerSyncTable[0].time + 1
        end
    end
end

local function on_hud_render()
    local m = gMarioStates[0]
    if gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then
        set_lighting_dir(1,0)
    end

    djui_hud_set_resolution(RESOLUTION_N64)
    djui_hud_set_font(FONT_TINY)

    local level = gLevels[gGlobalSyncTable.level]
    if level ~= nil then
        local out = { x = 0, y = 0, z = 0 }
        djui_hud_world_pos_to_screen_pos(level.flagPos, out)
        local dX = clampf(out.x - 0, 0, djui_hud_get_screen_width())
        local dY = clampf(out.y - 0, 0, djui_hud_get_screen_height())

        if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
            local f_pos = gLevels[gGlobalSyncTable.level].flagPos

            local rgb_transform = function(x, max_value)
                local midpoint = (1200 + max_value) / 2
                local red = (x > midpoint) and 255 or math.max(0, math.min(255, (x - 500) * 255 / (midpoint - 500)))
                local green = (x < midpoint) and 255 or math.max(0, math.min(255, 255 - (x - midpoint) * 255 / (max_value - midpoint)))
                local alpha = (x < 100) and 0 or ((x <= 1200) and (255 - (1200 - x) * 255 / 1100)) or 255

                return {r = math.floor(red), g = math.floor(green), b = 0, a = math.floor(alpha)}
            end

            if f_pos then
                local distance_to_flag = dist_between_object_and_point(gMarioStates[0].marioObj, f_pos.x, f_pos.y, f_pos.z)
                if distance_to_flag then
                    djui_hud_set_color(rgb_transform(distance_to_flag, 7500).r, rgb_transform(distance_to_flag, 7500).g, rgb_transform(distance_to_flag, 7500).b, rgb_transform(distance_to_flag, 7500).a)
                end
            end

            if eHudVariables.flagRadar then
                djui_hud_render_texture_interpolated(FLAG_RADAR, flagIconPrevPos.x - 8, flagIconPrevPos.y - 8, 1, 1, dX - 8, dY - 8, 1, 1)
            end
        end

        djui_hud_set_adjusted_color(255, 255, 255, 255)

        flagIconPrevPos.x = dX
        flagIconPrevPos.y = dY
    end

    local text = if_then_else(gGlobalSyncTable.roundState == ROUND_STATE_INACTIVE, gGlobalSyncTable.startShortcut == true and "Type '/start' or press [Start] + [".. startBinds[gGlobalSyncTable.startBind] .. "] to begin a round" or "Type '/start' or press [Start] + [".. startBinds[gGlobalSyncTable.startBind] .. "] to begin a round", "0.000 seconds")
    if gNetworkPlayers[0].currAreaSyncValid then
        if gGlobalSyncTable.roundState == ROUND_STATE_INACTIVE then
            if gGlobalSyncTable.mapMode == MAPMODE_VOTING then
                if gGlobalSyncTable.autoMode then
                    if network_player_connected_count() > 1 then
                        text = if_then_else(network_player_connected_count() > 1, "Voting begins in " .. tostring(math.floor(gGlobalSyncTable.timer / 30)), gGlobalSyncTable.startShortcut == true and "Type '/start' or press [Start] + [".. startBinds[gGlobalSyncTable.startBind] .. "] to begin a round")
                    end
                end
            else
                if network_player_connected_count() > 1 then
                    if gGlobalSyncTable.autoMode == true then
                        text = if_then_else(network_player_connected_count() > 1, "A round will start in " .. tostring(math.floor(gGlobalSyncTable.timer / 30)), gGlobalSyncTable.startShortcut == true and "Type '/start' or press [Start] + [".. startBinds[gGlobalSyncTable.startBind] .. "] to begin a round")
                    else
                        text = "Waiting for Host..."
                    end
                end
            end
        elseif gGlobalSyncTable.roundState == ROUND_STATE_END then
            text = "The Round is Ending"
        elseif gNetworkPlayers[0].currLevelNum == gLevels[gGlobalSyncTable.level].level then
            text = tostring(string.format("%.3f", gPlayerSyncTable[0].time / 30)) .. " seconds"
        end
    end

    local theme = get_selected_theme()
    local scale = 1
    local width = djui_hud_measure_text(text) * scale
    local x = (djui_hud_get_screen_width() - width) * 0.5

    if eHudVariables.timeDisplay then
        djui_hud_set_adjusted_color(theme.rect.r, theme.rect.g, theme.rect.b, theme.rect.a)
        if eHudVariables.outlines then
            djui_hud_render_rect_rounded_outlined(x - 6, 0, width + 12, 16, theme.rectOutline.r, theme.rectOutline.g, theme.rectOutline.b, 1)
        else
            djui_hud_render_rect(x - 6, 0, width + 12, 16)
        end
        djui_hud_set_adjusted_color(theme.text.r, theme.text.g, theme.text.b, 255)
        djui_hud_print_text(text, x, 0, scale)
    end

    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and eHudVariables.typeDisplay then
        djui_hud_set_color(225, 225, 225, alpha);
        djui_hud_print_text("Flood Type: " .. typeNames[gLevels[gGlobalSyncTable.level].type], djui_hud_get_screen_width() / 100 - 0, 224.5, 0.8)
    end

    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and eHudVariables.healthMeter then
        djui_hud_set_adjusted_color(255, 255, 255, 255)
        hud_render_power_meter(gMarioStates[0].health, djui_hud_get_screen_width() - 64, 0, 64, 64)
    end

    if eHudVariables.timeDisplay then
        if gGlobalSyncTable.speedMultiplier ~= 1 and table.contains(modifiers, "Flash Flood") == false then
            local speedtex = string.format("Flood Speed: " .. "%.2fx", gGlobalSyncTable.speedMultiplier)
            local widthtex2 = djui_hud_measure_text(speedtex) * 0.55
            djui_hud_set_adjusted_color(theme.rect.r, theme.rect.g, theme.rect.b, theme.rect.a)
            if eHudVariables.outlines then
                djui_hud_render_rect((djui_hud_get_screen_width() * 0.55) - widthtex2, 17, widthtex2 + 11, 10)
            else
                djui_hud_render_rect((djui_hud_get_screen_width() * 0.55) - widthtex2, 16, widthtex2 + 11, 10)
            end
            djui_hud_set_adjusted_color(theme.text.r, theme.text.g, theme.text.b, 255)
            if eHudVariables.outlines then
                djui_hud_print_text(speedtex, (djui_hud_get_screen_width() * 0.55 - (widthtex2 - 2)), 17, 0.6)
            else
                djui_hud_print_text(speedtex, (djui_hud_get_screen_width() * 0.55 - (widthtex2 - 2)), 16, 0.6)
            end
        elseif gGlobalSyncTable.modif_flashflood == true and gPlayerSyncTable[0].time >= (10 * 30) and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and floodConditions[gGlobalSyncTable.speedMultiplier] ~= nil then
            local speedtex = string.format("Flood Conditions: " .. floodConditions[gGlobalSyncTable.speedMultiplier])
            local widthtex2 = djui_hud_measure_text(speedtex) * 0.55
            local speedScale = 0.6
            local screenWidth = djui_hud_get_screen_width()
            local speedWidth = djui_hud_measure_text(speedtex) * speedScale
            djui_hud_set_adjusted_color(theme.rect.r, theme.rect.g, theme.rect.b, theme.rect.a)
            if eHudVariables.outlines then
                djui_hud_render_rect((screenWidth - speedWidth) / 2, 17, widthtex2 + 11, 10)
            else
                djui_hud_render_rect((djui_hud_get_screen_width() * 0.55) - widthtex2, 16, widthtex2 + 11, 10)
            end
            djui_hud_set_adjusted_color(theme.text.r, theme.text.g, theme.text.b, 255)
            if eHudVariables.outlines then
                djui_hud_print_text(speedtex, (screenWidth - speedWidth) / 2, 17, 0.6)
            else
                djui_hud_print_text(speedtex, (djui_hud_get_screen_width() * 0.55 - (widthtex2 - 2)), 16, 0.6)
            end
        end
    end

    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        textlv1 = name_of_level(gLevels[gGlobalSyncTable.level].level, gLevels[gGlobalSyncTable.level].area, gLevels[gGlobalSyncTable.level].name, gLevels[gGlobalSyncTable.level])
        textlv2 = gLevels[gGlobalSyncTable.level].author
    else
        textlv1 = " "
        textlv2 = " "
	end

    djui_hud_set_font(FONT_HUD)

    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and eHudVariables.coinCounter then
        djui_hud_set_adjusted_color(255, 255, 255, 255)
        djui_hud_render_texture(gTextures.coin, djui_hud_get_screen_width() - 120, 5, 1, 1)
        djui_hud_print_text(">", djui_hud_get_screen_width() - 105, 5, 1)
        djui_hud_print_text(tostring(hud_get_value(HUD_DISPLAY_COINS)), djui_hud_get_screen_width() - 90, 5, 1)
    end

    djui_hud_set_resolution(RESOLUTION_N64);
    djui_hud_set_font(eHudVariables.font)

    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and eHudVariables.levelDisplay then
        djui_hud_set_adjusted_color(255, 255, 255, 255)
        djui_hud_print_text(textlv1, 16, 8, eHudVariables.levelScale)
    end

    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and eHudVariables.authorDisplay then
        djui_hud_print_text(eHudVariables.levelDisplay == false and "By " or "by ", 16, eHudVariables.levelDisplay == false and 8 or 18, eHudVariables.authorScale)
        switch(gLevels[gGlobalSyncTable.level].author, authorColors)

        if textlv2 then
            djui_hud_print_colored_text("    " .. textlv2, eHudVariables.font == FONT_HUD and 12 or eHudVariables.font == FONT_CUSTOM_HUD and 12 or eHudVariables.font == FONT_RECOLOR_HUD and 12 or eHudVariables.font == FONT_ALIASED and 18 or eHudVariables.font == FONT_NORMAL and 14 or 16, eHudVariables.levelDisplay == false and 8 or 18, eHudVariables.authorScale)
        end
        djui_hud_set_adjusted_color(255, 255, 255, 255)
    end


    local displayText = "Modifiers: " .. table.concat(modifiers, ", ")
    local wrappedText = wrap_text(displayText, djui_hud_get_screen_width() - 380)
    local y = (eHudVariables.levelDisplay and eHudVariables.authorDisplay == false and 11) or (eHudVariables.levelDisplay == false and eHudVariables.authorDisplay == true and 9) or (eHudVariables.levelDisplay == false and eHudVariables.authorDisplay == false and 1) or (eHudVariables.levelDisplay and eHudVariables.authorDisplay and 19)

    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and eHudVariables.modifiersDisplay and #modifiers ~= 0 then
        for _, modifText in ipairs(wrappedText) do
            y = y + 7
            djui_hud_print_text(modifText, 16, y, eHudVariables.authorScale)
        end
    end

    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE
    and eHudVariables.gamemodeText
    and (gGlobalSyncTable.gamemode ~= GAMEMODE_NORMAL or gGlobalSyncTable.hardMode) then
        local text = (gGlobalSyncTable.hardMode and gGlobalSyncTable.gamemode == GAMEMODE_NORMAL) and "\\#ff0000\\Hard Mode" or (gGlobalSyncTable.hardMode and gGlobalSyncTable.gamemode ~= GAMEMODE_NORMAL) and gamemodes[gGlobalSyncTable.gamemode].name .. " + \\#ff0000\\Hard Mode" or tostring(gamemodes[gGlobalSyncTable.gamemode].name)
        if gamemodes[gGlobalSyncTable.gamemode].color then
            djui_hud_set_color(gamemodes[gGlobalSyncTable.gamemode].color.r, gamemodes[gGlobalSyncTable.gamemode].color.g, gamemodes[gGlobalSyncTable.gamemode].color.b, 255)
        end
        djui_hud_print_colored_text(text, (djui_hud_get_screen_width() - djui_hud_measure_text(string_without_hex(text)) * 0.20) / 2, 228, 0.20)
    end

    hud_hide()

    if m.action == ACT_FOLLOW_SPECTATOR then
        djui_hud_set_font(eHudVariables.font)
        scale = 0.2
        text = "< " .. string_without_hex(gNetworkPlayers[targetPlayer].name) .. " >"
        local measureText = djui_hud_measure_text(text)
        x = (djui_hud_get_screen_width() - measureText * scale) / 2
        y = djui_hud_get_screen_height() - 100 * scale
        djui_hud_set_adjusted_color(220, 220, 220, 255)
        djui_hud_print_text(text, x, y, scale)
    end

    if cinematicBorders then
        local screenWidth  = djui_hud_get_screen_width() + 1
        local screenHeight = djui_hud_get_screen_height()
        
        djui_hud_set_color(0, 0, 0, 255)
        
        local borderThickness = math.floor(screenHeight * 0.10)

        djui_hud_render_rect(0, 0, screenWidth, borderThickness)
        djui_hud_render_rect(0, screenHeight - borderThickness, screenWidth, borderThickness)
    end
end

-- sets the flood speed
local function on_speed_command(msg)
    local speed = tonumber(msg)

    if speed ~= nil then
        speed = clampf(speed, -100, 100)
        djui_chat_message_create("Flood speed set to " .. speed)
        gGlobalSyncTable.speedMultiplier = speed

        if gGlobalSyncTable.popups == true then
            djui_popup_create_global("Flood Speed changed to " .. speed .. "x", 1)
        end

        return true
    end
    djui_chat_message_create("/speed \\#2BC3FF\\[number]\\#ffffff\\\nSets the speed multiplier of the flood")
    return true
end

-- shows the info of Flood +
local function on_info_command(msg)
    djui_chat_message_create("\\#2BC3FF\\Flood \\#00ff00\\+ \\#dcdcdc\\Information")
    djui_chat_message_create("\\#dcdcdc\\Version: \\#2BC3FF\\[v1.0]")
    djui_chat_message_create("\\#dcdcdc\\Total Romhacks: \\#2BC3FF\\" .. totalRomhacks)
    djui_chat_message_create("\\#dcdcdc\\Total Levels: \\#00ff00\\" .. FLOOD_LEVEL_COUNT)
    if gGlobalSyncTable.mapMode == MAPMODE_RANDOM then
        djui_chat_message_create("\\#dcdcdc\\Mapmode: \\#00ff00\\Random")
    else
        djui_chat_message_create("\\#dcdcdc\\Mapmode: \\#00ff00\\Default")
    end
    if table.contains(modifiers, "Power-Ups") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Power-Ups")
    end
    if table.contains(modifiers, "Instakill") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Instakill")
    end
    if table.contains(modifiers, "Pursuit") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Pursuit")
    end
    if table.contains(modifiers, "PvP") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\PvP")
    end
    if table.contains(modifiers, "Deathcoin") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Deathcoin")
    end
    if table.contains(modifiers, "Winboost") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Winboost")
    end
    if table.contains(modifiers, "Speed") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Speed")
    end
    if table.contains(modifiers, "B Button Challenge") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\B Button Challenge")
    end
    if table.contains(modifiers, "Z Button Challenge") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Z Button Challenge")
    end
    if table.contains(modifiers, "Coin Rush") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Coin Rush")
    end
    if table.contains(modifiers, "Tripping") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Tripping")
    end
    if table.contains(modifiers, "Low Gravity") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Low Gravity")
    end
    if table.contains(modifiers, "High Gravity") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\High Gravity")
    end
    if table.contains(modifiers, "Flash Flood") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Flash Flood")
    end
    if table.contains(modifiers, "BLJ") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\BLJ")
    end
    if table.contains(modifiers, "Capless") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Capless")
    end
    if table.contains(modifiers, "Fly") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Fly")
    end
    if table.contains(modifiers, "Slippery Floors") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Slippery")
    end
    if table.contains(modifiers, "Hard Floors") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Hard")
    end
    if table.contains(modifiers, "Fog") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Fly")
    end
    if table.contains(modifiers, "Inverted") == true then
        djui_chat_message_create("\\#dcdcdc\\Modifier: \\#00ff00\\Inverted")
    end
    if table.contains(modifiers, "Power-Ups") == true then
        djui_chat_message_create("\\#dcdcdc\\Coincount: \\#00ff00\\" .. tostring(gGlobalSyncTable.coinCount))
    end
    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        djui_chat_message_create("\\#dcdcdc\\Level Name: \\#00ff00\\" .. textlv1)
        djui_chat_message_create("\\#dcdcdc\\Author: \\#00ff00\\" .. textlv2)
    end
    --djui_chat_message_create("            \\#354d7a\\debug: " .. table.concat(times, ", "))
    if gGlobalSyncTable.roundState ~= 0 then
        djui_chat_message_create("\\#dcdcdc\\Roundstate: \\#00ff00\\Active")
    else
        djui_chat_message_create("\\#dcdcdc\\Roundstate: \\#00ff00\\Inactive")
    end
    djui_chat_message_create("\\#dcdcdc\\Flood Speed: \\#00ff00\\" .. tostring(gGlobalSyncTable.speedMultiplier .. "x"))
    djui_chat_message_create("\\#dcdcdc\\Difficulty: \\#00ff00\\" .. tonumber(gGlobalSyncTable.difficulty))
    if #modifiers ~= 0 then
        djui_chat_message_create("\\#dcdcdc\\Modifiers: \\#00ff00\\" .. table.concat(modifiers, ", "))
    end
    return true
end

local function on_level_init()
    -- if the round state is active, set specific save flags
    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then

        save_file_set_flags(SAVE_FLAG_HAVE_METAL_CAP)
        save_file_set_flags(SAVE_FLAG_HAVE_VANISH_CAP)
        save_file_set_flags(SAVE_FLAG_HAVE_WING_CAP)
        save_file_set_flags(SAVE_FLAG_MOAT_DRAINED)
        save_file_set_flags(SAVE_FLAG_UNLOCKED_UPSTAIRS_DOOR)

        local file = get_current_save_file_num() - 1
        for i = COURSE_NONE - 6, 6 do
            save_file_set_star_flags(file, i, 255)
        end

        if network_is_server() then
            local start = gLevels[gGlobalSyncTable.level].startPos
            local floodHeight = gLevels[gGlobalSyncTable.level].floodHeight
            if start ~= nil and floodHeight == nil then
                gGlobalSyncTable.floodLevel = find_floor_height(start.x, start.y, start.z) - 1200
            else
                -- only sub areas have a weird issue where this function appears to always return the floor lower limit on level init
                -- Hey, emeraldlockdown here putting in some insight. If mario's standing on an object, that's probably why. Don't think the area is relevant
                gGlobalSyncTable.floodLevel = if_then_else(gLevels[gGlobalSyncTable.level].area == 1, find_floor_height(gMarioStates[0].pos.x, gMarioStates[0].pos.y, gMarioStates[0].pos.z), gMarioStates[0].pos.y) - 1200
            end
            if floodHeight ~= nil then
                gGlobalSyncTable.floodLevel = floodHeight
            end
        end

        --pursuer spawn
        local m = gMarioStates[0]
        if table.contains(modifiers, "Pursuit") == true then
            if pursuerSkinData[eTrollProperties.skin] ~= nil then
                pursuer = spawn_non_sync_object(id_bhvPursuer, pursuerSkinData[eTrollProperties.skin].skin, m.pos.x, m.pos.y + 800, m.pos.z, nil)
            else
                pursuer = spawn_non_sync_object(id_bhvPursuer, eTrollProperties.skin, m.pos.x, m.pos.y + 800, m.pos.z, nil)
            end
        end
		
        -- spawn blocks around levels 
        if gLevels[gGlobalSyncTable.level].blocks then
            for _, block in pairs(gLevels[gGlobalSyncTable.level].blocks) do
            spawn_non_sync_object(id_bhvBlock, E_MODEL_METAL_BOX, block.x, block.y, block.z, function (o)
            o.oFaceAngleYaw = block.yaw
                end)
            end
        end		

        spawn_non_sync_object(
            id_bhvFlood,
            E_MODEL_FLOOD,
            0, gGlobalSyncTable.floodLevel, 0,
            nil
        )
    end

    if gLevels[gGlobalSyncTable.level].startPos ~= nil then
        spawnPosX, spawnPosY, spawnPosZ, spawnFaceAngle = gLevels[gGlobalSyncTable.level].startPos.x, gLevels[gGlobalSyncTable.level].startPos.y, gLevels[gGlobalSyncTable.level].startPos.z, gLevels[gGlobalSyncTable.level].startPos.yaw
    else
        spawnPosX, spawnPosY, spawnPosZ, spawnFaceAngle = gMarioStates[0].pos.x, gMarioStates[0].pos.y, gMarioStates[0].pos.z, gMarioStates[0].faceAngle.y
    end

    local pos = gLevels[gGlobalSyncTable.level].flagPos
    if pos == nil then return end

    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        if gLevels[gGlobalSyncTable.level].flagBase == true then
            spawn_non_sync_object(
            id_bhvFloodFlag,
                E_MODEL_KOOPA_FLAG,
                pos.x, pos.y + 85, pos.z,
                --- @param o Object
                function(o)
                    o.oFaceAnglePitch = 0
                    o.oFaceAngleYaw = pos.yaw
                    o.oFaceAngleRoll = 0
            end
            )
            spawn_non_sync_object(
                id_bhvBasePlatform,
                E_MODEL_BASE,
                pos.x, pos.y, pos.z,
                --- @param o Object
                function(o)
                    o.oFaceAnglePitch = 0
                    o.oFaceAngleYaw = 0
                    o.oFaceAngleRoll = 0
                end
            )
            return true
        else
            spawn_non_sync_object(
                id_bhvFloodFlag,
                E_MODEL_KOOPA_FLAG,
                pos.x, pos.y, pos.z,
                --- @param o Object
                function(o)
                    o.oFaceAnglePitch = 0
                    o.oFaceAngleYaw = pos.yaw
                    o.oFaceAngleRoll = 0
                end
            )
            return true
        end
    end
end

local function on_warp()
    --- @type MarioState
    local m = gMarioStates[0]

    if table.contains(modifiers, "PvP") == true then
        gServerSettings.playerInteractions = PLAYER_INTERACTIONS_PVP

        if gGlobalSyncTable.roundState ~= ROUND_STATE_END then
            m.flags = m.flags | MARIO_VANISH_CAP
            m.capTimer = 90 -- 3 seconds in-game
        end
    else
        gServerSettings.playerInteractions = PLAYER_INTERACTIONS_NONE
    end

    if gLevels[gGlobalSyncTable.level].capTimer ~= nil and table.contains(modifiers, "PvP") == false then
        m.capTimer = gLevels[gGlobalSyncTable.level].capTimer
    end

    if game == GAME_B3313 and gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then
	    m.capTimer = 1
    end

    -- sets caps for levels
	if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
	    if gLevels[gGlobalSyncTable.level].powerUp == "metal" then
            m.flags = m.flags | MARIO_METAL_CAP
	    elseif gLevels[gGlobalSyncTable.level].powerUp == "wing" then
            m.flags = m.flags | MARIO_WING_CAP
	    elseif gLevels[gGlobalSyncTable.level].powerUp == "vanish" then
            m.flags = m.flags | MARIO_VANISH_CAP
        end
    end

    if gGlobalSyncTable.roundState == ROUND_STATE_END then
        if gPlayerSyncTable[0].finished then
            play_sound(winSoundEffects[math.random(#winSoundEffects)], gGlobalSoundSource)
        else
            play_sound(loseSoundEffects[math.random(#loseSoundEffects)], gGlobalSoundSource)
        end
    end

    local startPos = gLevels[gGlobalSyncTable.level].startPos

    if startPos ~= nil and gPlayerSyncTable[0].time <= 30 then
        spin = if_then_else(startPos.spin == false, ACT_SPAWN_NO_SPIN_AIRBORNE, ACT_SPAWN_SPIN_AIRBORNE)
        vec3f_set(m.pos, startPos.x, startPos.y + 100, startPos.z)
        set_mario_action(m, spin, 0)
        m.faceAngle.y = startPos.yaw
        if startPos.airborne == false then
            vec3f_set(m.pos, startPos.x, startPos.y, startPos.z)
        else
            vec3f_set(m.pos, startPos.x, startPos.y + 1000, startPos.z)
        end
        if startPos.fading == true and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        set_mario_action(m, ACT_TELEPORT_FADE_IN, 0)
        startPos.airborne = false
        end
        if startPos.pipe == true and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
            play_sound(SOUND_MENU_EXIT_PIPE, m.pos)
            set_mario_action(m, ACT_EMERGE_FROM_PIPE, 0)
            startPos.airborne = false
            spawn_non_sync_object(id_bhvStartPosPipe, E_MODEL_BITS_WARP_PIPE, startPos.x, startPos.y, startPos.z, function (o)
            o.oBehParams2ndByte = startPos.yaw
            end)
        end
    end

    if gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then
        local spawn = gLobbies[gGlobalSyncTable.lobby].spawn

        if spawn then
            vec3f_set(m.pos, spawn.x, spawn.y, spawn.z)
            m.faceAngle.y = spawn.yaw

            set_mario_action(m, ACT_SPAWN_SPIN_AIRBORNE, 0)
        end
    end
end

---@param m MarioState
local function on_player_connected(m)
    if network_is_server()
    and gGlobalSyncTable.roundState == ROUND_STATE_INACTIVE
    and m.playerIndex == 0 then
        gGlobalSyncTable.timer = ROUND_COOLDOWN
    end
end

local function on_start_command(msg)
    if msg == "random" then
        gGlobalSyncTable.level = math.random(#gLevels)
        round_start()
    else
        local override = tonumber(msg)
        if override ~= nil then
            override = clamp(math.floor(override), 1, FLOOD_LEVEL_COUNT)
            gGlobalSyncTable.level = override
        else
            for k, v in pairs(gLevels) do
                if msg ~= nil and msg:lower() == v.name then
                    gGlobalSyncTable.level = k
                end
            end
        end
    end
    if_then_else(
        gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE,
        { network_send(true, { restart = true } ),
        level_restart() }, { round_start(), gGlobalSyncTable.totalRoundRestarts == 0 }
    )
    return true
end

local function on_skip_command(msg)
    round_skip()
    return true
end

local function on_stop_command(msg)
    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        round_end()
    else
        play_sound(SOUND_MENU_CAMERA_BUZZ, gMarioStates[0].pos)
        djui_chat_message_create("You can't stop a round when there isn't an active round!")
    end
    return true
end

local function on_ttc_speed_command(msg)
    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        djui_chat_message_create("\\#ff3030\\You can only change the TTC speed before the round starts!")
        return true
    end

    msg = msg:lower()
    if msg == "fast" then
        set_ttc_speed_setting(TTC_SPEED_FAST)
        djui_popup_create_global("TTC speed set to fast", 1)
        return true
    elseif msg == "slow" then
        set_ttc_speed_setting(TTC_SPEED_SLOW)
        djui_popup_create_global("TTC speed set to slow", 1)
        return true
    elseif msg == "random" then
        set_ttc_speed_setting(TTC_SPEED_RANDOM)
        djui_popup_create_global("TTC speed set to random", 1)
        return true
    elseif msg == "stopped" then
        set_ttc_speed_setting(TTC_SPEED_STOPPED)
        djui_popup_create_global("TTC speed stopped", 1)
        return true
    end

    djui_chat_message_create("/ttc-speed \\#2BC3FF\\[fast|slow|random|stopped]\\#ffffff\\\nChanges the speed of TTC")
    return true
end

-- power-up roulette for the Power-Ups modifier
local function powerup_roulette()
    local m = gMarioStates[0]
    local randomfc = math.random(5)
    if randomfc == 1 then
        spawn_sync_object(id_bhvMetalCap, E_MODEL_MARIOS_METAL_CAP, m.pos.x, m.pos.y + 445, m.pos.z, nil)
    end
    if randomfc == 2 then
        spawn_sync_object(id_bhvWingCap, E_MODEL_MARIOS_WING_CAP, m.pos.x, m.pos.y + 445, m.pos.z, nil)
    end
    if randomfc == 3 then
        spawn_sync_object(id_bhvVanishCap, E_MODEL_MARIOS_CAP, m.pos.x, m.pos.y + 445, m.pos.z, nil)
    end
    if randomfc == 4 then
        spawn_sync_object(id_bhv1upRunningAway, E_MODEL_1UP, m.pos.x, m.pos.y + 445, m.pos.z, nil)
    end
    if randomfc == 5 then
        spawn_sync_object(id_bhvKoopaShell, E_MODEL_KOOPA_SHELL, m.pos.x, m.pos.y + 445, m.pos.z, nil)
    end
end

-- speed, coin rush and low gravity modifier
local function before_phys_step(m)
    if gGlobalSyncTable.floodInteractions and m.pos.y < gGlobalSyncTable.floodLevel and m.action ~= ACT_SPECTATOR and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and gLevels[gGlobalSyncTable.level].type == FLOOD_SNOW then
        m.vel.x = m.vel.x / 1.5
        m.vel.z = m.vel.z / 1.5
    end

    if table.contains(modifiers, "Speed") == true then
        m.vel.x = m.vel.x * 2
        m.vel.z = m.vel.z * 2
    end
    if table.contains(modifiers, "Coin Rush") == true then
        m.vel.x = m.vel.x * (1.0 + customCoinCounter)
        m.vel.z = m.vel.z * (1.0 + customCoinCounter)
    end
    if table.contains(modifiers, "Low Gravity") == true then
        if m.vel.y > 0 then
            if  m.action ~= ACT_TWIRLING
            and m.action ~= ACT_GETTING_BLOWN
            and m.action ~= ACT_FLYING_TRIPLE_JUMP
            and m.action ~= ACT_SHOT_FROM_CANNON
            and m.action ~= ACT_LAVA_BOOST then
                m.vel.y = m.vel.y * 1.035
            end
        else
            if m.action == ACT_GROUND_POUND then
                m.vel.y = m.vel.y / 1.0
            else
                m.vel.y = m.vel.y / 1.05
            end
        end
    end
    if table.contains(modifiers, "High Gravity") == true then
        if m.vel.y > 0 then
            m.vel.y = m.vel.y / 1.02
        else
            m.vel.y = m.vel.y * 1.02
        end
    end
end

-- modifier toggle command
local function on_modifiers_switch(msg)
    msg = msg:lower()
    if msg == "powerups" then
        if table.contains(modifiers, "Power-Ups") == false then
            djui_chat_message_create("Power-Ups Modifier has been applied.")
            table.insert(modifiers, "Power-Ups")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Power-Ups Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_powerups = true
        else
            djui_chat_message_create("Power-Ups Modifier removed.")
            local pos = table.poselement(modifiers, "Power-Ups")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Power-Ups Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_powerups = false
        end
    elseif msg == "instakill" then
        if table.contains(modifiers, "Instakill") == false then
            djui_chat_message_create("Insta-Kill Modifier has been applied.")
            table.insert(modifiers, "Instakill")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Insta-Kill Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_instakill = true
        else
            djui_chat_message_create("Insta-Kill Modifier removed.")
            local pos = table.poselement(modifiers, "Instakill")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Insta-Kill Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_instakill = false
        end
    elseif msg == "pursuit" then
        if table.contains(modifiers, "Pursuit") == false then
            djui_chat_message_create("Pursuit Modifier has been applied.")
            table.insert(modifiers, "Pursuit")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Pursuit Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_pursuit = true
        else
            djui_chat_message_create("Pursuit Modifier removed.")
            local pos = table.poselement(modifiers, "Pursuit")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Pursuit Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_pursuit = false
        end
    elseif msg == "pvp" then
        if table.contains(modifiers, "PvP") == false then
            djui_chat_message_create("PvP Modifier has been applied.")
            table.insert(modifiers, "PvP")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("PvP Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_pvp = true
        else
            djui_chat_message_create("PvP Modifier removed.")
            local pos = table.poselement(modifiers, "PvP")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("PvP Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_pvp = false
        end
    elseif msg == "deathcoin" then
        if table.contains(modifiers, "Deathcoin") == false then
            djui_chat_message_create("Deathcoin Modifier has been applied.")
            table.insert(modifiers, "Deathcoin")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Deathcoin Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_deathcoin = true
        else
            djui_chat_message_create("Deathcoin Modifier removed.")
            local pos = table.poselement(modifiers, "Deathcoin")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Deathcoin Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_deathcoin = false
        end
    elseif msg == "winboost" then
        if table.contains(modifiers, "Winboost") == false then
            djui_chat_message_create("Winboost Modifier has been applied.")
            table.insert(modifiers, "Winboost")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Winboost Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_winboost = true
        else
            djui_chat_message_create("Winboost Modifier removed.")
            local pos = table.poselement(modifiers, "Winboost")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Winboost Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_winboost = false
        end
    elseif msg == "speed" then
        if table.contains(modifiers, "Speed") == false then
            djui_chat_message_create("Speed Modifier has been applied.")
            table.insert(modifiers, "Speed")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Speed Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_speed = true
        else
            djui_chat_message_create("Speed Modifier removed.")
            local pos = table.poselement(modifiers, "Speed")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Speed Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_speed = false
        end
    elseif msg == "bbc" then
        if table.contains(modifiers, "B Button Challenge") == false then
            djui_chat_message_create("B Button Challenge Modifier has been applied.")
            table.insert(modifiers, "B Button Challenge")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("B Button Challenge Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_bbc = true
        else
            djui_chat_message_create("B Button Challenge Modifier removed.")
            local pos = table.poselement(modifiers, "B Button Challenge")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("B Button Challenge Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_bbc = false
        end
    elseif msg == "zbc" then
        if table.contains(modifiers, "Z Button Challenge") == false then
            djui_chat_message_create("Z Button Challenge Modifier has been applied.")
            table.insert(modifiers, "Z Button Challenge")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Z Button Challenge Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_zbc = true
        else
            djui_chat_message_create("Z Button Challenge Modifier removed.")
            local pos = table.poselement(modifiers, "Z Button Challenge")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Z Button Challenge Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_zbc = false
        end
    elseif msg == "coinrush" then
        if table.contains(modifiers, "Coin Rush") == false then
            djui_chat_message_create("Coin Rush Modifier has been applied.")
            table.insert(modifiers, "Coin Rush")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Coin Rush Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_coinrush = true
        else
            djui_chat_message_create("Coin Rush Modifier removed.")
            local pos = table.poselement(modifiers, "Coin Rush")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Coin Rush Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_coinrush = false
        end
    elseif msg == "tripping" then
        if table.contains(modifiers, "Tripping") == false then
            djui_chat_message_create("Tripping Modifier has been applied.")
            table.insert(modifiers, "Tripping")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Tripping Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_tripping = true
        else
            djui_chat_message_create("Tripping Modifier removed.")
            local pos = table.poselement(modifiers, "Tripping")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Tripping Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_tripping = false
        end
    elseif msg == "lowgravity" then
        if table.contains(modifiers, "Low Gravity") == false then
            djui_chat_message_create("Low Gravity Modifier has been applied.")
            table.insert(modifiers, "Low Gravity")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Low Gravity Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_lowgravity = true
        else
            djui_chat_message_create("Low Gravity Modifier removed.")
            local pos = table.poselement(modifiers, "Low Gravity")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Low Gravity Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_lowgravity = false
        end
    elseif msg == "highgravity" then
        if table.contains(modifiers, "High Gravity") == false then
            djui_chat_message_create("High Gravity Modifier has been applied.")
            table.insert(modifiers, "High Gravity")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("High Gravity Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_highgravity = true
        else
            djui_chat_message_create("High Gravity Modifier removed.")
            local pos = table.poselement(modifiers, "High Gravity")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("High Gravity Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_highgravity = false
        end
    elseif msg == "flashflood" then
        if table.contains(modifiers, "Flash Flood") == false then
            djui_chat_message_create("Flash Flood Modifier has been applied.")
            table.insert(modifiers, "Flash Flood")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Flash Flood Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_flashflood = true
        else
            djui_chat_message_create("Flashflood Modifier removed.")
            local pos = table.poselement(modifiers, "Flash Flood")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Flash Flood Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_flashflood = false
        end
    elseif msg == "blj" then
        if table.contains(modifiers, "BLJ") == false then
            djui_chat_message_create("BLJ Modifier has been applied.")
            table.insert(modifiers, "BLJ")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("BLJ Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_blj = true
        else
            djui_chat_message_create("BLJ Modifier removed.")
            local pos = table.poselement(modifiers, "BLJ")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("BLJ Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_blj = false
        end
    elseif msg == "capless" then
        if table.contains(modifiers, "Capless") == false then
            djui_chat_message_create("Capless Modifier has been applied.")
            table.insert(modifiers, "Capless")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Capless Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_capless = true
        else
            djui_chat_message_create("Capless Modifier removed.")
            local pos = table.poselement(modifiers, "Capless")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Capless Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_capless = false
        end
    elseif msg == "fly" then
        if table.contains(modifiers, "Fly") == false then
            djui_chat_message_create("Fly Modifier has been applied.")
            table.insert(modifiers, "Fly")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Fly Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_fly = true
        else
            djui_chat_message_create("Fly Modifier removed.")
            local pos = table.poselement(modifiers, "Fly")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Fly Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_fly = false
        end
    elseif msg == "slippery" then
        if table.contains(modifiers, "Slippery Floors") == false then
            djui_chat_message_create("Slippery Floors Modifier has been applied.")
            table.insert(modifiers, "Slippery Floors")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Slippery Floors Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_slippery = true
        else
            djui_chat_message_create("Slippery Floors Modifier removed.")
            local pos = table.poselement(modifiers, "Slippery Floors")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Slippery Floors Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_slippery = false
        end
    elseif msg == "hard" then
        if table.contains(modifiers, "Hard Floors") == false then
            djui_chat_message_create("Hard Floors Modifier has been applied.")
            table.insert(modifiers, "Hard Floors")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Hard Floors Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_hard = true
        else
            djui_chat_message_create("Hard Floors Modifier removed.")
            local pos = table.poselement(modifiers, "Hard Floors")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Hard Floors Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_hard = false
        end
    elseif msg == "fog" then
        if table.contains(modifiers, "Fog") == false then
            djui_chat_message_create("Fog Modifier has been applied.")
            table.insert(modifiers, "Fog")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Fog Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_fog = true
        else
            djui_chat_message_create("Fog Modifier removed.")
            local pos = table.poselement(modifiers, "Fog")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Fog Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_fog = false
        end
    elseif msg == "inverted" then
        if table.contains(modifiers, "Inverted") == false then
            djui_chat_message_create("Inverted Controls Modifier has been applied.")
            table.insert(modifiers, "Inverted")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Inverted Controls modifier applied.", 1)
            end
            gGlobalSyncTable.modif_inverted = true
        else
            djui_chat_message_create("Inverted Controls Modifier removed.")
            local pos = table.poselement(modifiers, "Inverted")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Inverted Controls Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_inverted = false
        end
    elseif msg == "Tornadoes" then
        if table.contains(modifiers, "Tornadoes") == false then
            djui_chat_message_create("Tornadoes Modifier has been applied.")
            table.insert(modifiers, "Tornadoes")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Tornadoes Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_tornadoes = true
        else
            djui_chat_message_create("Tornadoes Modifier removed.")
            local pos = table.poselement(modifiers, "Tornadoes")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Tornadoes Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_tornadoes = false
        end
    elseif msg == "Firsties" then
        if table.contains(modifiers, "Firsties") == false then
            djui_chat_message_create("Firsties Modifier has been applied.")
            table.insert(modifiers, "Firsties")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Firsties Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_firsties = true
        else
            djui_chat_message_create("Firsties Modifier removed.")
            local pos = table.poselement(modifiers, "Firsties")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Firsties Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_firsties = false
        end
    elseif msg == "stj" then
        if table.contains(modifiers, "Special Triple Jump") == false then
            djui_chat_message_create("Special Triple Jump Modifier has been applied.")
            table.insert(modifiers, "Special Triple Jump")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Special Triple Jump Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_stj = true
        else
            djui_chat_message_create("Special Triple Jump Modifier removed.")
            local pos = table.poselement(modifiers, "Special Triple Jump")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Special Triple Jump Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_stj = false
        end
    elseif msg == "earthquake" then
        if table.contains(modifiers, "Earthquake") == false then
            djui_chat_message_create("Earthquake Modifier has been applied.")
            table.insert(modifiers, "Earthquake")

            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Earthquake Modifier applied.", 1)
            end
            gGlobalSyncTable.modif_earthquake = true
        else
            djui_chat_message_create("Earthquake Modifier removed.")
            local pos = table.poselement(modifiers, "Earthquake")
            table.remove(modifiers, pos)
            if gGlobalSyncTable.popups == true then
                djui_popup_create_global("Earthquake Modifier removed.", 1)
            end
            gGlobalSyncTable.modif_earthquake = false
        end
    else
        djui_chat_message_create("\\#ff3030\\Incorrect usage, \\#dcdcdc\\List of modifiers [Power-Ups, Instakill, Pursuit, PvP, Deathcoin, Winboost, Speed, B Button Challenge [bbc], Z Button Challenge [zbc], Coin Rush [coinrush], Tripping, Low Gravity [lowgravity], High Gravity [highgravity], Flash Flood [flashflood], BLJ, Capless, Fly, Slippery Floors [slippery], Hard Floors [hard], Fog, Inverted Controls [inverted], Tornadoes, Firsties, Special Triple Jump [stj], Earthquake]")
    end
    return true
end

-- coincount command
local function on_coinc_command(msg)
    if tonumber(msg) == nil then
        djui_chat_message_create("\\#ff3030\\You need to put a number of any kind for this command to work. Right now the Coin Count is set to " .. gGlobalSyncTable.coinCount)
        return true
    end
    if tonumber(msg) < 1 then
        djui_chat_message_create("\\#ff3030\\You can't disable powerups in this modifier, you can remove this modifier if you want to disable powerups.")
        return true
    end
    if tonumber(msg) == gGlobalSyncTable.coinCount then
        djui_chat_message_create("\\#ff3030\\It's already set it to " .. gGlobalSyncTable.coinCount .. " try a different number.")
        return true
    end
    if tonumber(msg) ~= nil then
        gGlobalSyncTable.coinCount = tonumber(msg)
        djui_chat_message_create("Coin Count changed to " .. gGlobalSyncTable.coinCount)
        if gGlobalSyncTable.popups == true then
            djui_popup_create_global("Coin Count changed to " .. msg, 1)
        end
        return true
    else
        djui_chat_message_create('\\#ff3030\\The character you provided needs to have a number to change how many coins to collect.')
    end
end

-- difficulty command
local function on_difc_command(msg)
	if tonumber(msg) == nil then
	    djui_chat_message_create("\\#ff3030\\You need to put a number between [0 - 10] for this command to work. Right now the Difficulty is set to " .. gGlobalSyncTable.difficulty)
	    return true
	end
	if tonumber(msg) == gGlobalSyncTable.difficulty then
	    djui_chat_message_create("\\#ff3030\\It's already set it to " .. gGlobalSyncTable.difficulty .. " try a different number.")
	    return true
	end
    if gGlobalSyncTable.difficulty ~= nil then
        msg = clampf(tonumber(msg), 0, 10)
        gGlobalSyncTable.difficulty = msg
		djui_chat_message_create("Difficulty changed to " .. msg .. "x")
        if gGlobalSyncTable.popups == true then
            djui_popup_create_global("Difficulty changed to " .. msg .. "x", 1)
        end
        return true
	end
    return true
end

-- round cooldown command
local function on_roundc_command(msg)

    if tonumber(msg) == nil then
	    djui_chat_message_create("\\#ff3030\\You need to put a number between [0 - 32] for this command to work.")
	    return true
	end
    if ROUND_COOLDOWN ~= nil then
        ROUND_COOLDOWN = clampf(tonumber(msg), 0, 32) * 30
        djui_chat_message_create("Round cooldown changed to " .. tostring(clampf(tonumber(msg), 0, 32)))
        return true
    end
    return true
end

-- flood command
local function on_flood_command(msg)
    if requestingThemeName ~= nil then
        if msg:find("-", 1, true) or msg:find("_", 1, true) or msg:find("?", 1, true) or msg:find(".", 1, true) then
            djui_chat_message_create("Invalid characters found in name! Please do not use -, _, ?, or .")
            requestingThemeName = nil
            return true
        end
        floodThemes[requestingThemeName].name = msg
        requestingThemeName = nil
        return true
    end

    if requestingThemeHex then
        if not hex_valid(msg) then
            djui_chat_message_create("Invalid hex code provided. An example hexcode is \"#FFFFFF\"")
            requestingThemeHex = false
            return true
        end
        requestingThemeHexCallback = msg
        requestingThemeHex = false
        return true
    end

    showSettings = not showSettings
    play_sound(SOUND_MENU_PAUSE, gMarioStates[0].pos)
    return true
end

local function coin_update(m, o, interactType)
    if table.contains(modifiers, "Coin Rush") == true and interactType == INTERACT_COIN then
        customCoinCounter = customCoinCounter + 0.1
    end

    if table.contains(modifiers, "Power-Ups") == true then
        if m.playerIndex ~= 0 then return end
        if interactType == INTERACT_COIN then
            customCoinCounter = customCoinCounter + 1
        end
        if ( customCoinCounter == gGlobalSyncTable.coinCount) then
            customCoinCounter = customCoinCounter - gGlobalSyncTable.coinCount
            play_sound(SOUND_MENU_EXIT_PIPE, m.pos)

            return powerup_roulette()
        end
    end
end

local function on_object_unload(o, interactType)
    local m = gMarioStates[0]
    if table.contains(modifiers, "Deathcoin") == true and obj_check_hitbox_overlap(o, m.marioObj) and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and o.oInteractType == INTERACT_COIN then
        m.health = 0xff
    end
end

gServerSettings.skipIntro = 1
gServerSettings.stayInLevelAfterStar = 2

gLevelValues.floorLowerLimit = -20000
gLevelValues.floorLowerLimitMisc = -20000 + 1000
gLevelValues.floorLowerLimitShadow = -20000 + 1000.0
gLevelValues.fixCollisionBugs = 1
gLevelValues.fixCollisionBugsRoundedCorners = 0

hud_hide()

hook_event(HOOK_ON_OBJECT_UNLOAD, on_object_unload)
hook_event(HOOK_ON_INTERACT, coin_update)
hook_event(HOOK_BEFORE_PHYS_STEP, before_phys_step)
hook_event(HOOK_UPDATE, update)
hook_event(HOOK_ON_SET_MARIO_ACTION, on_set_mario_action)
hook_event(HOOK_MARIO_UPDATE, mario_update)
hook_event(HOOK_BEFORE_MARIO_UPDATE, before_mario_update)
hook_event(HOOK_ON_HUD_RENDER, on_hud_render)
hook_event(HOOK_ON_LEVEL_INIT, on_level_init)
hook_event(HOOK_ON_WARP, on_warp)
hook_event(HOOK_ON_PLAYER_CONNECTED, on_player_connected)
hook_event(HOOK_ON_PACKET_RECEIVE, function (dataTable) if dataTable.lobby then gGlobalSyncTable.lobby = dataTable.lobby end end)
hook_event(HOOK_ON_DIALOG, function () return false end)
hook_event(HOOK_ON_SEQ_LOAD, function (player, seqId)
    if player == SEQ_PLAYER_LEVEL then
        newSeq = 30
    end
end)

if network_is_server() or network_is_moderator() then
    hook_chat_command("start", "\\#2BC3FF\\[name|random]\\#dcdcdc\\\nStarts a round in a random or specific level, you can also leave it empty for normal progression", on_start_command)
    hook_chat_command("skip", "\nSkips the current level and moves on to the next", on_skip_command)
    hook_chat_command("stop", "\nStops the current round and returns to lobby", on_stop_command)
    hook_chat_command("modifiers", "\\#2BC3FF\\[Power-Ups|instakill|pursuit|deathcoin|winboost|speed|bbc|zbc|coinrush|tripping|lowgravity|highgravity]\\#dcdcdc\\\nEnables or Disables a modifier", on_modifiers_switch)
    hook_chat_command("speed", "\\#2BC3FF\\[number]\\#dcdcdc\\\nSets the speed multiplier of the Flood", on_speed_command)
    hook_chat_command("difficulty", "\\#2BC3FF\\[number]\\#dcdcdc\\\nSets the speed the Flood kills you at", on_difc_command)
    hook_chat_command("round-cooldown", "\\#2BC3FF\\[number]\\#dcdcdc\\\nSets the round cooldown for when a match ends", on_roundc_command)
    hook_chat_command("ttc-speed", "\\#2BC3FF\\[fast|slow|random|stopped]\\#dcdcdc\\\nChanges the speed of the Tick Tock Clock Moving Objects", on_ttc_speed_command)
    hook_chat_command("coincount", "\\#2BC3FF\\[number]\\#dcdcdc\\\nSets the amount of coins needed to get a Power-Up for the Power-Ups modifier", on_coinc_command)
end

hook_chat_command("flood", "\nOpens the Flood + Menu/Set a theme name", on_flood_command)
hook_chat_command("info", "\nGets the current information of Flood +", on_info_command)
