if unsupported then return end

GAMEMODE_NORMAL = 0
GAMEMODE_LIFELINK = 1

gGlobalSyncTable.gamemode = GAMEMODE_NORMAL

gamemodes = {
    [GAMEMODE_NORMAL] = {
        name = "Normal",
        description = "Standard Flood Gameplay, good for those who don't want anything special",
    },
    [GAMEMODE_LIFELINK] = {
        name = "Lifelink",
        description = "In this Gamemode, every player shares a special life link, which means that if anybody dies, anybody who hasn't reached the flag in time will face the consequences.",
        hooks = { [HOOK_MARIO_UPDATE] = function (m)
                if m.health <= 0xFF and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
                    round_end()
                end
            end
        },
        color = { r = 15, g = 100, b = 230 }
    }
}


for gamemode in pairs(gamemodes) do
    if gamemodes[gamemode].hooks then
        for hook, func in pairs(gamemodes[gamemode].hooks) do
            hook_event(hook, function (param1, param2, param3, param4, param5)
                if gGlobalSyncTable.gamemode == gamemode then
                    func(param1, param2, param3, param4, param5)
                end
            end)
        end
    end
end