-- name: Object Spawner \\#10FF10\\V3.6+
-- description: Basically object spawner \\#10FF10\\edited!, \\#FF0505\\!!WARNING!! crash can happen, basically on mobile.

-- gServerSettings.stayInLevelAfterStar = true -- added to avoid softlocks
gLevelValues.metalCapDuration = 2700
gLevelValues.wingCapDuration = 2700
gLevelValues.vanishCapDuration = 2700
gLevelValues.metalCapDurationCotmc = 1800
gLevelValues.wingCapDurationTotwc = 1800
gLevelValues.vanishCapDurationVcutm = 1800

E_MODEL_SR_SHYGUY = smlua_model_util_get_id("sr_shyguy_geo")
E_MODEL_PIRATE_SHIP = smlua_model_util_get_id("pirate_ship_geo")
E_MODEL_SUNKEN_SHIP = smlua_model_util_get_id("sunken_ship_geo")
E_MODEL_YOSHI_NEST = smlua_model_util_get_id("yoshi_nest_geo")
E_MODEL_SNOWMAN_BOTTOM = smlua_model_util_get_id("snowmans_bottom_geo")
E_MODEL_SKELETON = smlua_model_util_get_id("skeleton_geo")
E_MODEL_BLUE_PIPE = smlua_model_util_get_id("blue_pipe_geo")
E_MODEL_RED_PIPE = smlua_model_util_get_id("red_pipe_geo")
E_MODEL_YELLOW_PIPE = smlua_model_util_get_id("yellow_pipe_geo")
E_MODEL_PURPLE_PIPE = smlua_model_util_get_id("purple_pipe_geo")
E_MODEL_MARIO_MUG = smlua_model_util_get_id("mario_mug_geo")
E_MODEL_MCD_CRATE = smlua_model_util_get_id("mcd_crate_geo")
E_MODEL_COFFIN_DOOR = smlua_model_util_get_id("coffin_door_geo")
E_MODEL_UNUSED_WOODEN_DOOR = smlua_model_util_get_id("unused_wooden_door_geo")
E_MODEL_KART = smlua_model_util_get_id("kart_geo")
E_MODEL_WF_TOWER = smlua_model_util_get_id("wf_tower_geo")
E_MODEL_BULLET_BILL_CANNON = smlua_model_util_get_id("bullet_bill_cannon_geo")
E_MODEL_GIANT_POLE = smlua_model_util_get_id("wf_giant_pole_geo")
E_MODEL_LARGE_BOMP = smlua_model_util_get_id("wf_large_bomp_geo")
E_MODEL_SMALL_BOMP = smlua_model_util_get_id("wf_small_bomp_geo")
E_MODEL_ROTATING_WOODEN_PLATFORM = smlua_model_util_get_id("wf_rotating_wooden_platform_geo")
E_MODEL_LAUNCHPAD = smlua_model_util_get_id("launchpad_geo")
-- E_MODEL_SHADOW_MARIO = smlua_model_util_get_id("shadowmario_geo")
E_MODEL_TADC_EXIT_DOOR = smlua_model_util_get_id("exit_door_geo")
E_MODEL_TOAD2 = smlua_model_util_get_id("toad2_geo")

-- Shadow Mario Behavior.

---@param o Object
function sm_init(o)
        o.oInteractionSubtype = INT_SUBTYPE_BIG_KNOCKBACK
        o.oInteractType = INTERACT_DAMAGE
        o.oFlags = (OBJ_FLAG_COMPUTE_DIST_TO_MARIO | OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE)
        o.oIntangibleTimer = 0
        o.hitboxHeight = 113
        o.hitboxRadius = 65
        o.hitboxDownOffset = 0
        o.oGravity = 0
        o.oFriction = 0.8
        o.oBuoyancy = 1.3
        o.oGraphYOffset = o.oGraphYOffset + 35
        timer = 0
        play_sound(SOUND_MARIO_WAAAOOOW, gMarioStates[0].pos)
end
---@param o Object
function sm_loop(o)
        obj_set_billboard(o)
        o.oFaceAngleYaw = atan2s(gMarioStates[0].pos.z-o.oPosZ,gMarioStates[0].pos.x-o.oPosX)
        o.oForwardVel = 25 -- speed
        object_step()
        if gMarioStates[0].pos.y > o.oPosY then
           local offset = o.oPosY - gMarioStates[0].pos.y
           o.oPosY = o.oPosY + (offset/4)
           o.oPosY = math.floor(o.oPosY)
        end -- a bunch of checks
        if gMarioStates[0].action == ACT_STAR_DANCE_EXIT then
           obj_mark_for_deletion(o)
        end
        -- if (dist_between_objects(o, gMarioStates[0].marioObj)) <= 2000 then
        --    shadowtextinit = true
        -- else
        --    shadowtextinit = false
        -- end
end

id_bhvShadowMario2 = hook_behavior(nil, OBJ_LIST_LEVEL, true, sm_init, sm_loop, "shadowMario")

local objects = {
    {name = "1UP", model = E_MODEL_1UP, behavior = id_bhv1Up},
    {name = "1UP_JUMP_ON_APPROACH", model = E_MODEL_1UP, behavior = id_bhv1upJumpOnApproach},
    {name = "1UP_RUNNING_AWAY", model = E_MODEL_1UP, behavior = id_bhv1upRunningAway},
    {name = "1UP_SLIDING", model = E_MODEL_1UP, behavior = id_bhv1upSliding},
    {name = "1UP_WALKING", model = E_MODEL_1UP, behavior = id_bhv1upWalking},
    {name = "BITS_ARROW_PLATFORM", model = E_MODEL_BITS_ARROW_PLATFORM, behavior = id_bhvActivatedBackAndForthPlatform},
    {name = "BITFS_ELEVATOR", model = E_MODEL_BITFS_ELEVATOR, behavior = id_bhvActivatedBackAndForthPlatform},
    {name = "ALPHA_BOO_KEY", model = E_MODEL_BETA_BOO_KEY, behavior = id_bhvAlphaBooKey},
    {name = "ANIMATED_TEXTURE", model = E_MODEL_SPARKLES_ANIMATION, behavior = id_bhvAnimatedTexture},
    {name = "YOSHI_EGG", model = E_MODEL_YOSHI_EGG, behavior = id_bhvAnimatedTexture},
    {name = "BITS_STAIRCASE", model = E_MODEL_BITS_STAIRCASE, behavior = id_bhvAnimatesOnFloorSwitchPress},
    {name = "BIG_BOO_CAGE", model = E_MODEL_BOO, behavior = id_bhvBooWithCage},
    {name = "BALCONY_BIG_BOO", model = E_MODEL_BOO, behavior = id_bhvBalconyBigBoo},
    {name = "BBH_TILTING_TRAP", model = E_MODEL_BBH_TILTING_FLOOR_PLATFORM, behavior = id_bhvBbhTiltingTrapPlatform},
    {name = "BBH_TUMBLING_PLATFORM", model = E_MODEL_BBH_TUMBLING_PLATFORM, behavior = id_bhvBbhTumblingBridge},
    {name = "BEGINNING_PEACH", model = E_MODEL_PEACH, behavior = id_bhvBeginningPeach},
    {name = "BETA_BOO_KEY", model = E_MODEL_BETA_BOO_KEY, behavior = id_bhvBeginningPeach},
    {name = "BETA_BOWSER_ANCHOR", model = E_MODEL_STAR, behavior = id_bhvBetaBowserAnchor},
    {name = "BETA_CHEST_BOTTOM", model = E_MODEL_TREASURE_CHEST_BASE, behavior = id_bhvBetaChestBottom},
    {name = "BETA_CHEST_LID", model = E_MODEL_TREASURE_CHEST_LID, behavior = id_bhvBetaChestLid},
    {name = "BETA_FISH_SPLASH_SPAWNER", model = E_MODEL_STAR, behavior = id_bhvBetaFishSplashSpawner},
    {name = "BETA_HOLDABLE_OBJECT", model = E_MODEL_STAR, behavior = id_bhvBetaHoldableObject},
    {name = "BETA_MOVING_FLAME", model = E_MODEL_RED_FLAME, behavior = id_bhvBetaMovingFlames},
    {name = "BETA_MOVING_FLAMES", model = E_MODEL_RED_FLAME, behavior = id_bhvBetaMovingFlamesSpawn},
    {name = "BETA_TRAMPOLINE_TOP", model = E_MODEL_TRAMPOLINE, behavior = id_bhvBetaTrampolineTop},
    {name = "BIG_BOULDER", model = E_MODEL_HMC_ROLLING_ROCK, behavior = id_bhvBigBoulder},
    {name = "BIG_BOULDER_GENERATOR", model = E_MODEL_STAR, behavior = id_bhvBigBoulderGenerator},
    {name = "BIG_BULLY", model = E_MODEL_BULLY_BOSS, behavior = id_bhvBigBully},
    {name = "BIG_CHILL_BULLY", model = E_MODEL_BIG_CHILL_BULLY, behavior = id_bhvBigChillBully},
    {name = "BIRD", model = E_MODEL_BIRDS, behavior = id_bhvBird},
    {name = "BIRD_SOUNDS", model = E_MODEL_STAR, behavior = id_bhvBirdsSoundLoop},
    {name = "BITFS_SINKING_CAGE", model = E_MODEL_BITFS_SINKING_CAGE_PLATFORM, behavior = id_bhvBitfsSinkingCagePlatform},
    {name = "BITFS_SINKING_PLATFORMS", model = E_MODEL_BITFS_SINKING_PLATFORMS, behavior = id_bhvBitfsSinkingPlatforms},
    {name = "BITFS_TILTING_PYRAMID", model = E_MODEL_BITFS_TILTING_SQUARE_PLATFORM, behavior = id_bhvBitfsTiltingInvertedPyramid},
    {name = "BOWSER_BLACK_SMOKE", model = E_MODEL_BOWSER_SMOKE, behavior = id_bhvBlackSmokeBowser},
    {name = "MARIO_BLACK_SMOKE", model = E_MODEL_BURN_SMOKE, behavior = id_bhvBlackSmokeMario},
    {name = "UPWARD_BLACK_SMOKE", model = E_MODEL_BURN_SMOKE, behavior = id_bhvBlackSmokeUpward},
    {name = "UNUSED_BLACK_SMOKE", model = E_MODEL_BURN_SMOKE_UNUSED, behavior = id_bhvBlackSmokeMario},
    {name = "BLUE_BOWSER_FLAME", model = E_MODEL_BLUE_FLAME, behavior = id_bhvBlueBowserFlame},
    {name = "BLUE_COIN_JUMPING", model = E_MODEL_BLUE_COIN, behavior = id_bhvBlueCoinJumping},
    {name = "BLUE_COIN_SLIDING", model = E_MODEL_BLUE_COIN, behavior = id_bhvBlueCoinSliding},
    {name = "BLUE_COIN_SWITCH", model = E_MODEL_BLUE_COIN_SWITCH, behavior = id_bhvBlueCoinSwitch},
    {name = "BLUE_FISH", model = E_MODEL_FISH, behavior = id_bhvBlueFish},
    {name = "BLUE_FLAME_GROUP", model = E_MODEL_BLUE_FLAME, behavior = id_bhvBlueFlamesGroup},
    {name = "BOB_BOWLING_BALL_SPAWNER", model = E_MODEL_STAR, behavior = id_bhvBobBowlingBallSpawner},
    {name = "BOBOMB", model = E_MODEL_BLACK_BOBOMB, behavior = id_bhvBobomb},
    {name = "BOBOMB_ANCHOR_MARIO", model = E_MODEL_STAR, behavior = id_bhvBobombAnchorMario},
    {name = "BOBOMB_BUDDY", model = E_MODEL_BOBOMB_BUDDY, behavior = id_bhvBobombBuddy},
    {name = "CANNON_BOBOMB_BUDDY", model = E_MODEL_BOBOMB_BUDDY, behavior = id_bhvBobombBuddyOpensCannon},
    {name = "BOBOMB_BULLY_DEATH_SMOKE", model = E_MODEL_SMOKE, behavior = id_bhvBobombBullyDeathSmoke},
    {name = "BOBOMB_FUSE_SMOKE", model = E_MODEL_SMOKE, behavior = id_bhvBobombFuseSmoke},
    {name = "BOO", model = E_MODEL_BOO, behavior = id_bhvBoo},
    {name = "BBH_STAIRCASE_STEP", model = E_MODEL_BBH_STAIRCASE_STEP, behavior = id_bhvBooBossSpawnedBridge},
    {name = "BOO_IN_CASTLE", model = E_MODEL_BOO_CASTLE, behavior = id_bhvBooInCastle},
    {name = "BOUNCING_FIREBALL", model = E_MODEL_RED_FLAME, behavior = id_bhvBouncingFireball},
    {name = "BOUNCING_FIREBALL_FLAME", model = E_MODEL_RED_FLAME, behavior = id_bhvBouncingFireballFlame},
    {name = "BOWLING_BALL", model = E_MODEL_BOWLING_BALL, behavior = id_bhvBowlingBall},
    {name = "BOWSER", model = E_MODEL_BOWSER, behavior = id_bhvBowser},
    {name = "BOWSER2", model = E_MODEL_BOWSER2, behavior = id_bhvBowser},
    {name = "BOWSER_BODY_ANCHOR", model = E_MODEL_STAR, behavior = id_bhvBowserBodyAnchor},
    {name = "BOWSER_BOMB", model = E_MODEL_BOWSER_BOMB, behavior = id_bhvBowserBomb},
    {name = "BOWSER_BOMB_EXPLOSION", model = E_MODEL_BOWSER_FLAMES, behavior = id_bhvBowserBombExplosion},
    {name = "BOWSER_KEY", model = E_MODEL_BOWSER_KEY, behavior = id_bhvBowserKey},
    {name = "BOWSER_KEY_COURSE_EXIT", model = E_MODEL_BOWSER_KEY_CUTSCENE, behavior = id_bhvBowserKeyCourseExit},
    {name = "BOWSER_KEY_UNLOCK_DOOR", model = E_MODEL_BOWSER_KEY_CUTSCENE, behavior = id_bhvBowserKeyUnlockDoor},
    {name = "BOWSER_SHOCKWAVE", model = E_MODEL_BOWSER_WAVE, behavior = id_bhvBowserShockWave},
    {name = "BOWSER_SUB", model = E_MODEL_DDD_BOWSER_SUB, behavior = id_bhvBowsersSub},
    {name = "BOWSER_SUB_DOOR", model = E_MODEL_DDD_BOWSER_SUB_DOOR, behavior = id_bhvBowserSubDoor},
    {name = "BOWSER_TAIL_ANCHOR", model = E_MODEL_STAR, behavior = id_bhvBowserTailAnchor},
    {name = "BREAKABLE_BOX", model = E_MODEL_BREAKABLE_BOX, behavior = id_bhvBreakableBox},
    {name = "ERROR", model = E_MODEL_ERROR_MODEL, behavior = id_bhvBreakableBox},
    {name = "SMALL_BREAKABLE_BOX", model = E_MODEL_BREAKABLE_BOX_SMALL, behavior = id_bhvBreakableBoxSmall},
    {name = "BREATH_PARTICLE_SPAWNER", model = E_MODEL_STAR, behavior = id_bhvBreathParticleSpawner},
    {name = "BUB", model = E_MODEL_BUB, behavior = id_bhvBub},
    {name = "BUBBA", model = E_MODEL_BUBBA, behavior = id_bhvBubba},
    {name = "BULLET_BILL", model = E_MODEL_BULLET_BILL, behavior = id_bhvBulletBill},
    {name = "BULLET_BILL_CANNON", model = E_MODEL_BULLET_BILL_CANNON, behavior = id_bhvBulletBillCannon},
    {name = "BUTTERFLY", model = E_MODEL_BUTTERFLY, behavior = id_bhvButterfly},
    {name = "CAMERA_LAKITU", model = E_MODEL_LAKITU, behavior = id_bhvCameraLakitu},
    {name = "CANNON", model = E_MODEL_CANNON_BASE, behavior = id_bhvCannon},
    {name = "CANNON_BARREL", model = E_MODEL_CANNON_BARREL, behavior = id_bhvCannonBarrel},
    {name = "CANNON_CLOSED", model = E_MODEL_DL_CANNON_LID, behavior = id_bhvCannonClosed},
    {name = "CAP_SWITCH", model = E_MODEL_CAP_SWITCH, behavior = id_bhvCapSwitch},
    {name = "CAP_SWITCH_EXCLAMATION", model = E_MODEL_CAP_SWITCH_EXCLAMATION, behavior = id_bhvCapSwitch},
    {name = "CAP_SWITCH_BASE", model = E_MODEL_CAP_SWITCH_BASE, behavior = id_bhvCapSwitchBase},
    {name = "CASTLE_FLAG", model = E_MODEL_CASTLE_GROUNDS_FLAG, behavior = id_bhvCastleFlagWaving},
    {name = "CASTLE_FLOOR_TRAP", model = E_MODEL_CASTLE_BOWSER_TRAP, behavior = id_bhvCastleFloorTrap},
    {name = "CHAIN_CHOMP", model = E_MODEL_CHAIN_CHOMP, behavior = id_bhvChainChomp},
    {name = "CHAIN_CHOMP_GATE", model = E_MODEL_BOB_CHAIN_CHOMP_GATE, behavior = id_bhvChainChompGate},
    {name = "CHECKERBOARD_ELEVATOR", model = E_MODEL_CHECKERBOARD_PLATFORM, behavior = id_bhvCheckerboardElevatorGroup},
    {name = "CHUCKYA", model = E_MODEL_CHUCKYA, behavior = id_bhvChuckya},
    {name = "CHUCKYA_ANCHOR_MARIO", model = E_MODEL_STAR, behavior = id_bhvChuckyaAnchorMario},
    {name = "CIRCLING_AMP", model = E_MODEL_AMP, behavior = id_bhvCirclingAmp},
    {name = "CLAM_SHELL", model = E_MODEL_CLAM_SHELL, behavior = id_bhvClamShell},
    {name = "CLOCK_HOUR_HAND", model = E_MODEL_CASTLE_CLOCK_HOUR_HAND, behavior = id_bhvClockHourHand},
    {name = "CLOCK_MINUTE_HAND", model = E_MODEL_CASTLE_CLOCK_MINUTE_HAND, behavior = id_bhvClockMinuteHand},
    {name = "CLOUD", model = E_MODEL_FWOOSH, behavior = id_bhvCloud},
    {name = "COFFIN", model = E_MODEL_BBH_WOODEN_TOMB, behavior = id_bhvCoffin},
    {name = "COFFIN_SPAWNER", model = E_MODEL_STAR, behavior = id_bhvCoffinSpawner},
    {name = "COIN_FORMATION", model = E_MODEL_STAR, behavior = id_bhvCoinFormation},
    {name = "CONTROLLABLE_PLATFORM", model = E_MODEL_HMC_METAL_PLATFORM, behavior = id_bhvControllablePlatform},
    {name = "DDD_MOVING_POLE", model = E_MODEL_DDD_POLE, behavior = id_bhvDddMovingPole},
    {name = "CLOCK_PENDULUM", model = E_MODEL_CASTLE_CLOCK_PENDULUM, behavior = id_bhvDecorativePendulum},
    {name = "DIRT_PARTICLE", model = E_MODEL_DIRT_ANIMATION, behavior = id_bhvDirtParticleSpawner},
    {name = "DONUT_PLATFORM", model = E_MODEL_RR_DONUT_PLATFORM, behavior = id_bhvDonutPlatform},
    {name = "CASTLE_DOOR", model = E_MODEL_CASTLE_CASTLE_DOOR, behavior = id_bhvDoor},
    {name = "BBH_DOOR", model = E_MODEL_BBH_HAUNTED_DOOR, behavior = id_bhvDoor},
    {name = "HMC_WOODEN_DOOR", model = E_MODEL_HMC_WOODEN_DOOR, behavior = id_bhvDoor},
    {name = "HMC_METAL_DOOR", model = E_MODEL_HMC_METAL_DOOR, behavior = id_bhvDoor},
    {name = "HMC_HAZY_MAZE_DOOR", model = E_MODEL_HMC_HAZY_MAZE_DOOR, behavior = id_bhvDoor},
    {name = "CCM_CABIN_DOOR", model = E_MODEL_CCM_CABIN_DOOR, behavior = id_bhvDoor},
    {name = "CASTLE_METAL_DOOR", model = E_MODEL_CASTLE_METAL_DOOR, behavior = id_bhvDoor},
    {name = "CASTLE_DOOR_0_STARS", model = E_MODEL_CASTLE_DOOR_0_STARS, behavior = id_bhvDoor},
    {name = "CASTLE_DOOR_1_STARS", model = E_MODEL_CASTLE_DOOR_1_STAR, behavior = id_bhvDoor},
    {name = "CASTLE_DOOR_3_STARS", model = E_MODEL_CASTLE_DOOR_3_STARS, behavior = id_bhvDoor},
    {name = "CASTLE_KEY_DOOR", model = E_MODEL_CASTLE_KEY_DOOR, behavior = id_bhvDoor},
    {name = "CASTLE_KEY_DOOR_WARP", model = E_MODEL_CASTLE_KEY_DOOR, behavior = id_bhvDoorWarp},
    {name = "DORRIE", model = E_MODEL_DORRIE, behavior = id_bhvDorrie},
    {name = "ENEMY_LAKITU", model = E_MODEL_ENEMY_LAKITU, behavior = id_bhvEnemyLakitu},
    {name = "CAP_BOX", model = E_MODEL_EXCLAMATION_BOX, behavior = id_bhvExclamationBox},
    {name = "CAP_BOX_OUTLINE", model = E_MODEL_EXCLAMATION_BOX_OUTLINE, behavior = id_bhvExclamationBox},
    {name = "CAP_BOX_POINT", model = E_MODEL_EXCLAMATION_POINT, behavior = id_bhvRotatingExclamationMark},
    {name = "END_PEACH", model = E_MODEL_PEACH, behavior = id_bhvEndPeach},
    {name = "EXPLOSION", model = E_MODEL_EXPLOSION, behavior = id_bhvExplosion},
    {name = "EYEROK_BOSS", model = E_MODEL_STAR, behavior = id_bhvEyerokBoss},
    {name = "EYEROK_LEFT_HAND", model = E_MODEL_EYEROK_LEFT_HAND, behavior = id_bhvEyerokHand},
    {name = "EYEROK_RIGHT_HAND", model = E_MODEL_EYEROK_RIGHT_HAND, behavior = id_bhvEyerokHand},
    {name = "FALLING_BOWSER_PLATFORM_1", model = E_MODEL_BOWSER_3_FALLING_PLATFORM_1, behavior = id_bhvFallingBowserPlatform},
    {name = "FALLING_BOWSER_PLATFORM_2", model = E_MODEL_BOWSER_3_FALLING_PLATFORM_2, behavior = id_bhvFallingBowserPlatform},
    {name = "FALLING_BOWSER_PLATFORM_3", model = E_MODEL_BOWSER_3_FALLING_PLATFORM_3, behavior = id_bhvFallingBowserPlatform},
    {name = "FALLING_BOWSER_PLATFORM_4", model = E_MODEL_BOWSER_3_FALLING_PLATFORM_4, behavior = id_bhvFallingBowserPlatform},
    {name = "FALLING_BOWSER_PLATFORM_5", model = E_MODEL_BOWSER_3_FALLING_PLATFORM_5, behavior = id_bhvFallingBowserPlatform},
    {name = "FALLING_BOWSER_PLATFORM_6", model = E_MODEL_BOWSER_3_FALLING_PLATFORM_6, behavior = id_bhvFallingBowserPlatform},
    {name = "FALLING_BOWSER_PLATFORM_7", model = E_MODEL_BOWSER_3_FALLING_PLATFORM_7, behavior = id_bhvFallingBowserPlatform},
    {name = "FALLING_BOWSER_PLATFORM_8", model = E_MODEL_BOWSER_3_FALLING_PLATFORM_8, behavior = id_bhvFallingBowserPlatform},
    {name = "FALLING_BOWSER_PLATFORM_9", model = E_MODEL_BOWSER_3_FALLING_PLATFORM_9, behavior = id_bhvFallingBowserPlatform},
    {name = "FALLING_BOWSER_PLATFORM_10", model = E_MODEL_BOWSER_3_FALLING_PLATFORM_10, behavior = id_bhvFallingBowserPlatform},
    {name = "FALLING_PILLAR", model = E_MODEL_JRB_FALLING_PILLAR, behavior = id_bhvFallingPillar},
    {name = "BITS_FERRIS_WHEEL_AXLE", model = E_MODEL_BITS_FERRIS_WHEEL_AXLE, behavior = id_bhvFerrisWheelAxle},
    {name = "BITDW_FERRIS_WHEEL_AXLE", model = E_MODEL_BITDW_FERRIS_WHEEL_AXLE, behavior = id_bhvFerrisWheelAxle},
    {name = "FEW_BLUE_FISH_SPAWNER", model = E_MODEL_STAR, behavior = id_bhvFewBlueFishSpawner},
    {name = "FIRE_PIRANHA_PLANT", model = E_MODEL_PIRANHA_PLANT, behavior = id_bhvFirePiranhaPlant},
    {name = "FIRE_SPITTER", model = E_MODEL_BOWLING_BALL, behavior = id_bhvFireSpitter},
    {name = "FISH_SPAWNER", model = E_MODEL_STAR, behavior = id_bhvFishSpawner},
    {name = "FLAME", model = E_MODEL_RED_FLAME, behavior = id_bhvFlame},
    {name = "BLUE_FLAME", model = E_MODEL_BLUE_FLAME, behavior = id_bhvFlame},
    {name = "FLAME_BOUNCING", model = E_MODEL_RED_FLAME, behavior = id_bhvFlameBouncing},
    {name = "FLAME_BOWSER", model = E_MODEL_BLUE_FLAME, behavior = id_bhvFlameBowser},
    {name = "LARGE_FLAME_BURNING_OUT", model = E_MODEL_RED_FLAME, behavior = id_bhvFlameLargeBurningOut},
    {name = "MOVING_FLAME_FORWARD_GROWING", model = E_MODEL_RED_FLAME, behavior = id_bhvFlameMovingForwardGrowing},
    {name = "FLAMETHROWER", model = E_MODEL_STAR, behavior = id_bhvFlamethrower},
    {name = "FLOOR_SWITCH_ANIMATES_OBJECT", model = E_MODEL_PURPLE_SWITCH, behavior = id_bhvFloorSwitchAnimatesObject},
    {name = "FLOOR_SWITCH_GRILLS", model = E_MODEL_PURPLE_SWITCH, behavior = id_bhvFloorSwitchGrills},
    {name = "FLOOR_SWITCH_HARDCODED_MODEL", model = E_MODEL_PURPLE_SWITCH, behavior = id_bhvFloorSwitchHardcodedModel},
    {name = "FLOOR_SWITCH_HIDDEN_OBJECTS", model = E_MODEL_PURPLE_SWITCH, behavior = id_bhvFloorSwitchHiddenObjects},
    {name = "FLOOR_TRAP_IN_CASTLE", model = E_MODEL_CASTLE_BOWSER_TRAP, behavior = id_bhvFloorTrapInCastle},
    {name = "FLY_GUY", model = E_MODEL_FLYGUY, behavior = id_bhvFlyGuy},
    {name = "FLYING_BOOK", model = E_MODEL_BOOKEND, behavior = id_bhvFlyingBookend},
    {name = "FREE_BOWLING_BALL", model = E_MODEL_BOWLING_BALL, behavior = id_bhvFreeBowlingBall},
    {name = "GHOST_HUNT_BIG_BOO", model = E_MODEL_BOO, behavior = id_bhvGhostHuntBigBoo},
    {name = "GHOST_HUNT_BOO", model = E_MODEL_BOO, behavior = id_bhvGhostHuntBoo},
    {name = "GIANT_POLE", model = E_MODEL_GIANT_POLE, behavior = id_bhvGiantPole},
    {name = "GOOMBA", model = E_MODEL_GOOMBA, behavior = id_bhvGoomba},
    {name = "GOOMBA_TRIPLET_SPAWNER", model = E_MODEL_STAR, behavior = id_bhvGoombaTripletSpawner},
    {name = "GRAND_STAR", model = E_MODEL_STAR, behavior = id_bhvGrandStar},
    {name = "GRINDEL", model = E_MODEL_SSL_GRINDEL, behavior = id_bhvGrindel},
    {name = "HAUNTED_BOOKSHELF", model = E_MODEL_BBH_MOVING_BOOKSHELF, behavior = id_bhvHauntedBookshelf},
    {name = "HAUNTED_CHAIR", model = E_MODEL_HAUNTED_CHAIR, behavior = id_bhvHauntedChair},
    {name = "HEAVE_HO", model = E_MODEL_HEAVE_HO, behavior = id_bhvHeaveHo},
    {name = "HIDDEN_1UP", model = E_MODEL_1UP, behavior = id_bhvHidden1up},
    {name = "HIDDEN_1UP_IN_POLE", model = E_MODEL_1UP, behavior = id_bhvHidden1upInPole},
    {name = "HIDDEN_1UP_IN_POLE_SPAWNER", model = E_MODEL_1UP, behavior = id_bhvHidden1upInPoleSpawner},
    {name = "HIDDEN_1UP_IN_POLE_TRIGGER", model = E_MODEL_1UP, behavior = id_bhvHidden1upInPoleTrigger},
    {name = "HIDDEN_1UP_TRIGGER", model = E_MODEL_1UP, behavior = id_bhvHidden1upTrigger},
    {name = "HIDDEN_AT_120_STARS", model = E_MODEL_CASTLE_GROUNDS_CANNON_GRILL, behavior = id_bhvHiddenAt120Stars},
    {name = "HIDDEN_BLUE_COIN", model = E_MODEL_BLUE_COIN, behavior = id_bhvHiddenBlueCoin},
    {name = "HIDDEN_OBJECT", model = E_MODEL_BREAKABLE_BOX, behavior = id_bhvHiddenObject},
    {name = "HIDDEN_RED_COIN_STAR", model = E_MODEL_STAR, behavior = id_bhvHiddenRedCoinStar},
    {name = "HIDDEN_STAIRCASE_STEP", model = E_MODEL_BBH_STAIRCASE_STEP, behavior = id_bhvHiddenStaircaseStep},
    {name = "HIDDEN_STAR", model = E_MODEL_STAR, behavior = id_bhvHiddenStar},
    {name = "HIDDEN_STAR_TRIGGER", model = E_MODEL_STAR, behavior = id_bhvHiddenStarTrigger},
    {name = "HMC_ELEVATOR", model = E_MODEL_HMC_ELEVATOR_PLATFORM, behavior = id_bhvHmcElevatorPlatform},
    {name = "HOMING_AMP", model = E_MODEL_AMP, behavior = id_bhvHomingAmp},
    {name = "HOOT", model = E_MODEL_HOOT, behavior = id_bhvHoot},
    {name = "HORIZONTAL_GRINDEL", model = E_MODEL_SSL_GRINDEL, behavior = id_bhvHorizontalGrindel},
    {name = "IDLE_WATER_WAVE", model = E_MODEL_IDLE_WATER_WAVE, behavior = id_bhvIdleWaterWave},
    {name = "INITIALIZE_CHANGING_WATER_LEVEL", model = E_MODEL_STAR, behavior = id_bhvInitializeChangingWaterLevel},
    {name = "IN_SUNKEN_SHIP_1", model = E_MODEL_STAR, behavior = id_bhvInSunkenShip},
    {name = "IN_SUNKEN_SHIP_2", model = E_MODEL_STAR, behavior = id_bhvInSunkenShip2},
    {name = "IN_SUNKEN_SHIP_3", model = E_MODEL_STAR, behavior = id_bhvInSunkenShip3},
    {name = "JET_STREAM", model = E_MODEL_STAR, behavior = id_bhvJetStream},
    {name = "JET_STREAM_RING_SPAWNER", model = E_MODEL_STAR, behavior = id_bhvJetStreamRingSpawner},
    {name = "JET_STREAM_WATER_RING", model = E_MODEL_WATER_RING, behavior = id_bhvJetStreamWaterRing},
    {name = "JRB_FLOATING_PLATFORM", model = E_MODEL_JRB_FLOATING_PLATFORM, behavior = id_bhvJrbFloatingPlatform},
    {name = "JRB_SLIDING_BOX", model = E_MODEL_JRB_SLIDING_BOX, behavior = id_bhvJrbSlidingBox},
    {name = "JRB_FLOATING_BOX", model = E_MODEL_JRB_SLIDING_BOX, behavior = id_bhvJrbFloatingBox},
    {name = "JUMPING_BOX", model = E_MODEL_BREAKABLE_BOX_SMALL, behavior = id_bhvJumpingBox},
    {name = "KICKABLE_BOARD", model = E_MODEL_WF_KICKABLE_BOARD, behavior = id_bhvKickableBoard},
    {name = "KING_BOBOMB", model = E_MODEL_KING_BOBOMB, behavior = id_bhvKingBobomb},
    {name = "KLEPTO", model = E_MODEL_KLEPTO, behavior = id_bhvKlepto},
    {name = "KOOPA", model = E_MODEL_KOOPA_WITH_SHELL, behavior = id_bhvKoopa},
    {name = "KOOPA_WITHOUT_SHELL", model = E_MODEL_KOOPA_WITHOUT_SHELL, behavior = id_bhvKoopa},
    {name = "KOOPA_FLAG", model = E_MODEL_KOOPA_FLAG, behavior = id_bhvKoopaFlag},
    {name = "KOOPA_RACE_ENDPOINT", model = E_MODEL_KOOPA_FLAG, behavior = id_bhvKoopaRaceEndpoint},
    {name = "KOOPA_SHELL", model = E_MODEL_KOOPA_SHELL, behavior = id_bhvKoopaShell},
    {name = "KOOPA_SHELL_UNDERWATER", model = E_MODEL_KOOPA_SHELL, behavior = id_bhvKoopaShellUnderwater},
    {name = "LARGE_BOMP", model = E_MODEL_LARGE_BOMP, behavior = id_bhvLargeBomp},
    {name = "LLL_BOWSER_PUZZLE", model = E_MODEL_STAR, behavior = id_bhvLllBowserPuzzle},
    {name = "LLL_DRAWBRIDGE", model = E_MODEL_LLL_DRAWBRIDGE_PART, behavior = id_bhvLllDrawbridge},
    {name = "LLL_WOOD_BRIDGE", model = E_MODEL_LLL_WOOD_BRIDGE, behavior = id_bhvLllFloatingWoodBridge},
    {name = "LLL_OCTAGON", model = E_MODEL_LLL_MOVING_OCTAGONAL_MESH_PLATFORM, behavior = id_bhvLllMovingOctagonalMeshPlatform},
    {name = "LLL_ROLLING_LOG", model = E_MODEL_LLL_ROLLING_LOG, behavior = id_bhvLllRollingLog},
    {name = "LLL_ROTATING_FIRE_BLOCK", model = E_MODEL_LLL_ROTATING_BLOCK_FIRE_BARS, behavior = id_bhvLllRotatingBlockWithFireBars},
    {name = "LLL_ROTATING_HEXAGON_PLATFORM", model = E_MODEL_STAR, behavior = id_bhvLllRotatingHexagonalPlatform},
    {name = "LLL_ROTATING_HEXAGON", model = E_MODEL_LLL_ROTATING_HEXAGONAL_RING, behavior = id_bhvLllRotatingHexagonalRing},
    {name = "LLL_SINKING_RECTANGLE", model = E_MODEL_LLL_SINKING_RECTANGULAR_PLATFORM, behavior = id_bhvLllSinkingRectangularPlatform},
    {name = "LLL_SINKING_ROCK", model = E_MODEL_LLL_SINKING_ROCK_BLOCK, behavior = id_bhvLllSinkingRockBlock},
    {name = "LLL_SINKING_SQUARES", model = E_MODEL_LLL_SINKING_SQUARE_PLATFORMS, behavior = id_bhvLllSinkingSquarePlatforms},
    {name = "LLL_TILTING_PYRAMID", model = E_MODEL_LLL_TILTING_SQUARE_PLATFORM, behavior = id_bhvLllTiltingInvertedPyramid},
    {name = "LLL_TUMBLING_BRIDGE", model = E_MODEL_LLL_LARGE_FALLING_PLATFORM, behavior = id_bhvLllTumblingBridge},
    {name = "LLL_VOLCANO_FALLING_TRAP", model = E_MODEL_LLL_VOLCANO_FALLING_TRAP, behavior = id_bhvLllVolcanoFallingTrap},
    {name = "MACRO_UKIKI", model = E_MODEL_UKIKI, behavior = id_bhvMacroUkiki},
    {name = "MAD_PIANO", model = E_MODEL_MAD_PIANO, behavior = id_bhvMadPiano},
    {name = "MANTA_RAY", model = E_MODEL_MANTA_RAY, behavior = id_bhvMantaRay},
    {name = "MANTA_RAY_RING", model = E_MODEL_WATER_RING, behavior = id_bhvMantaRayWaterRing},
    {name = "MANY_BLUE_FISH_SPAWNER", model = E_MODEL_STAR, behavior = id_bhvManyBlueFishSpawner},
    {name = "MERRY_GO_ROUND", model = E_MODEL_BBH_MERRY_GO_ROUND, behavior = id_bhvMerryGoRound},
    {name = "MERRY_GO_ROUND_BIG_BOO", model = E_MODEL_BOO, behavior = id_bhvMerryGoRoundBigBoo},
    {name = "MERRY_GO_ROUND_BOO", model = E_MODEL_BOO, behavior = id_bhvMerryGoRoundBoo},
    {name = "BBH_MESH_ELEVATOR", model = E_MODEL_BBH_MESH_ELEVATOR, behavior = id_bhvMeshElevator},
    {name = "SIGN", model = E_MODEL_WOODEN_SIGNPOST, behavior = id_bhvMessagePanel},
    {name = "METAL_CAP", model = E_MODEL_MARIOS_METAL_CAP, behavior = id_bhvMetalCap},
    {name = "MIPS", model = E_MODEL_MIPS, behavior = id_bhvMips},
    {name = "MOVING_BLUE_COIN", model = E_MODEL_BLUE_COIN, behavior = id_bhvMovingBlueCoin},
    {name = "MOVING_YELLOW_COIN", model = E_MODEL_YELLOW_COIN, behavior = id_bhvMovingYellowCoin},
    {name = "MR_BLIZZARD", model = E_MODEL_MR_BLIZZARD, behavior = id_bhvMrBlizzard},
    {name = "MR_I", model = E_MODEL_MR_I, behavior = id_bhvMrI},
    {name = "NORMAL_CAP", model = E_MODEL_MARIOS_CAP, behavior = id_bhvNormalCap},
    {name = "BITS_ROTATING_OCTAGON", model = E_MODEL_BITS_OCTAGONAL_PLATFORM, behavior = id_bhvOctagonalPlatformRotating},
    {name = "ONE_COIN", model = E_MODEL_YELLOW_COIN, behavior = id_bhvOneCoin},
    {name = "OPENABLE_GRILL", model = E_MODEL_BOB_BARS_GRILLS, behavior = id_bhvOpenableGrill},
    {name = "ORANGE_NUMBER", model = E_MODEL_NUMBER, behavior = id_bhvOrangeNumber},
    {name = "WEIRD_BABY_PENGUIN", model = E_MODEL_PENGUIN, behavior = id_bhvPenguinBaby},
    {name = "PIRANHA_PLANT", model = E_MODEL_PIRANHA_PLANT, behavior = id_bhvPiranhaPlant},
    {name = "PIT_BOWLING_BALL", model = E_MODEL_BOWLING_BALL, behavior = id_bhvPitBowlingBall},
    {name = "BITFS_PLATFORM_ON_TRACK", model = E_MODEL_BITFS_PLATFORM_ON_TRACK, behavior = id_bhvPlatformOnTrack},
    {name = "CCM_PLATFORM_ON_TRACK", model = E_MODEL_CCM_ROPEWAY_LIFT, behavior = id_bhvPlatformOnTrack},
    {name = "CHECKERBOARD_PLATFORM_ON_TRACK", model = E_MODEL_CHECKERBOARD_PLATFORM, behavior = id_bhvPlatformOnTrack},
    {name = "RR_FLYING_CARPET", model = E_MODEL_RR_FLYING_CARPET, behavior = id_bhvPlatformOnTrack},
    {name = "PLAYS_MUSIC_WHEN_TOUCHED", model = E_MODEL_STAR, behavior = id_bhvPlaysMusicTrackWhenTouched},
    {name = "POKEY", model = E_MODEL_POKEY_HEAD, behavior = id_bhvPokey},
    {name = "PURPLE_SWITCH_HIDDEN_BOXES", model = E_MODEL_PURPLE_SWITCH, behavior = id_bhvPurpleSwitchHiddenBoxes},
    {name = "PUSHABLE_METAL_BOX", model = E_MODEL_METAL_BOX, behavior = id_bhvPushableMetalBox},
    {name = "PYRAMID_ELEVATOR", model = E_MODEL_SSL_PYRAMID_ELEVATOR, behavior = id_bhvPyramidElevator},
    {name = "PYRAMID_TOP", model = E_MODEL_SSL_PYRAMID_TOP, behavior = id_bhvPyramidTop},
    {name = "RECOVERY_HEART", model = E_MODEL_HEART, behavior = id_bhvRecoveryHeart},
    {name = "RED_COIN", model = E_MODEL_RED_COIN, behavior = id_bhvRedCoin},
    {name = "JRB_ROCK", model = E_MODEL_JRB_ROCK, behavior = id_bhvRockSolid},
    {name = "RR_CRUISER_WING", model = E_MODEL_RR_CRUISER_WING, behavior = id_bhvRrCruiserWing},
    {name = "RR_ELEVATOR", model = E_MODEL_RR_ELEVATOR_PLATFORM, behavior = id_bhvRrElevatorPlatform},
    {name = "RR_ROTATING_BRIDGE", model = E_MODEL_RR_ROTATING_BRIDGE_PLATFORM, behavior = id_bhvRrRotatingBridgePlatform},
    {name = "SAND_SOUND_LOOP", model = E_MODEL_STAR, behavior = id_bhvSandSoundLoop},
    {name = "SCUTTLEBUG", model = E_MODEL_SCUTTLEBUG, behavior = id_bhvScuttlebug},
    {name = "SEAWEED", model = E_MODEL_SEAWEED, behavior = id_bhvSeaweed},
    {name = "RR_SEESAW", model = E_MODEL_RR_SEESAW_PLATFORM, behavior = id_bhvSeesawPlatform},
    {name = "BOB_SEESAW", model = E_MODEL_BOB_SEESAW_PLATFORM, behavior = id_bhvSeesawPlatform},
    {name = "BITS_SEESAW", model = E_MODEL_BITS_SEESAW_PLATFORM, behavior = id_bhvSeesawPlatform},
    {name = "BITDW_SEESAW", model = E_MODEL_BITDW_SEESAW_PLATFORM, behavior = id_bhvSeesawPlatform},
    {name = "BITFS_SEESAW", model = E_MODEL_BITFS_SEESAW_PLATFORM, behavior = id_bhvSeesawPlatform},
    {name = "SKEETER", model = E_MODEL_SKEETER, behavior = id_bhvSkeeter},
    {name = "BITS_SLIDING_PLATFORM", model = E_MODEL_BITS_SLIDING_PLATFORM, behavior = id_bhvSlidingPlatform2},
    {name = "RR_SLIDING_PLATFORM", model = E_MODEL_RR_SLIDING_PLATFORM, behavior = id_bhvSlidingPlatform2},
    {name = "SL_SNOW_TRIANGLE", model = E_MODEL_SL_SNOW_TRIANGLE, behavior = id_bhvSlidingSnowMound},
    {name = "SL_SNOWMAN_WIND", model = E_MODEL_STAR, behavior = id_bhvSLSnowmanWind},
    {name = "SL_WALKING_PENGUIN", model = E_MODEL_PENGUIN, behavior = id_bhvSLWalkingPenguin},
    {name = "SMALL_BOMP", model = E_MODEL_SMALL_BOMP, behavior = id_bhvSmallBomp},
    {name = "BABY_PENGUIN", model = E_MODEL_PENGUIN, behavior = id_bhvSmallPenguin},
    {name = "BULLY", model = E_MODEL_BULLY, behavior = id_bhvSmallBully},
    {name = "CHILL_BULLY", model = E_MODEL_CHILL_BULLY, behavior = id_bhvSmallChillBully},
    {name = "WHOMP", model = E_MODEL_WHOMP, behavior = id_bhvSmallWhomp},
    {name = "SMOKE", model = E_MODEL_SMOKE, behavior = id_bhvSmoke},
    {name = "SNOWMANS_BOTTOM", model = E_MODEL_SNOWMAN_BOTTOM, behavior = id_bhvSnowmansBottom},
    {name = "SNOWMANS_BASE", model = E_MODEL_CCM_SNOWMAN_HEAD, behavior = id_bhvSnowmansHead},
    {name = "SNOW_MOUND_SPAWNER", model = E_MODEL_STAR, behavior = id_bhvSnowMoundSpawn},
    {name = "SNUFIT", model = E_MODEL_SNUFIT, behavior = id_bhvSnufit},
    {name = "SPARKLE", model = E_MODEL_SPARKLES, behavior = id_bhvSparkle},
    {name = "SPAWNED_STAR", model = E_MODEL_STAR, behavior = id_bhvSpawnedStar},
    {name = "SPINDEL", model = E_MODEL_SSL_SPINDEL, behavior = id_bhvSpindel},
    {name = "SPINDRIFT", model = E_MODEL_SPINDRIFT, behavior = id_bhvSpindrift},
    {name = "SPINY", model = E_MODEL_SPINY, behavior = id_bhvSpiny},
    {name = "BITDW_MOVING_SQUARE", model = E_MODEL_BITDW_SQUARE_PLATFORM, behavior = id_bhvSquarishPathMoving},
    {name = "BITDW_MOVING_SQUARES", model = E_MODEL_BITDW_SQUARE_PLATFORM, behavior = id_bhvSquarishPathParent},
    {name = "BITFS_STRETCHING_PLATFORM", model = E_MODEL_BITFS_STRETCHING_PLATFORMS, behavior = id_bhvSquishablePlatform},
    {name = "SSL_MOVING_WALL", model = E_MODEL_SSL_MOVING_PYRAMID_WALL, behavior = id_bhvSslMovingPyramidWall},
    {name = "STAR", model = E_MODEL_STAR, behavior = id_bhvStar},
    {name = "TRANSPARENT_STAR", model = E_MODEL_TRANSPARENT_STAR, behavior = id_bhvStar},
    {name = "STAR_DOOR", model = E_MODEL_CASTLE_STAR_DOOR_8_STARS, behavior = id_bhvStarDoor},
    {name = "STATIC_CHECKERED_PLATFORM", model = E_MODEL_CHECKERBOARD_PLATFORM, behavior = id_bhvStaticCheckeredPlatform},
    {name = "HMC_RED_GRILLS", model = E_MODEL_HMC_RED_GRILLS, behavior = id_bhvStaticObject},
    {name = "PURPLE_MARBLE", model = E_MODEL_PURPLE_MARBLE, behavior = id_bhvStaticObject},
    {name = "SPINY_BALL", model = E_MODEL_SPINY_BALL, behavior = id_bhvStaticObject},
    {name = "WIGGLER_HEAD", model = E_MODEL_WIGGLER_HEAD, behavior = id_bhvStaticObject},
    {name = "WIGGLER_BODY", model = E_MODEL_WIGGLER_BODY, behavior = id_bhvStaticObject},
    {name = "CYAN_FISH", model = E_MODEL_CYAN_FISH, behavior = id_bhvStaticObject},
    {name = "WATER_MINE", model = E_MODEL_WATER_MINE, behavior = id_bhvBowserBomb},
    {name = "PIPE", model = E_MODEL_BITS_WARP_PIPE, behavior = id_bhvWarpPipe},
    {name = "HAUNTED_CAGE", model = E_MODEL_HAUNTED_CAGE, behavior = id_bhvBooCage},
    {name = "BLARGG", model = E_MODEL_BLARGG, behavior = id_bhvStaticObject},
    {name = "EYEROK_LEFT_HAND", model = E_MODEL_EYEROK_LEFT_HAND, behavior = id_bhvStaticObject},
    {name = "TTM_BLUE_SMILEY", model = E_MODEL_TTM_BLUE_SMILEY, behavior = id_bhvStaticObject},
    {name = "TTM_YELLOW_SMILEY", model = E_MODEL_TTM_YELLOW_SMILEY, behavior = id_bhvStaticObject},
    {name = "TTM_STAR_SMILEY", model = E_MODEL_TTM_STAR_SMILEY, behavior = id_bhvStaticObject},
    {name = "TTM_MOON_SMILEY", model = E_MODEL_TTM_MOON_SMILEY, behavior = id_bhvStaticObject},
    {name = "JRB_SUNKEN_SHIP", model = E_MODEL_JRB_SUNKEN_SHIP, behavior = id_bhvSunkenShipPart},
    {name = "JRB_SUNKEN_SHIP_BACK", model = E_MODEL_JRB_SUNKEN_SHIP_BACK, behavior = id_bhvSunkenShipPart},
    {name = "JRB_SHIP_LEFT_HALF", model = E_MODEL_JRB_SHIP_LEFT_HALF_PART, behavior = id_bhvShipPart3},
    {name = "JRB_SHIP_BACK_LEFT", model = E_MODEL_JRB_SHIP_BACK_LEFT_PART, behavior = id_bhvShipPart3},
    {name = "JRB_SHIP_RIGHT_HALF", model = E_MODEL_JRB_SHIP_RIGHT_HALF_PART, behavior = id_bhvShipPart3},
    {name = "JRB_SHIP_BACK_RIGHT", model = E_MODEL_JRB_SHIP_BACK_RIGHT_PART, behavior = id_bhvShipPart3},
    {name = "SUNKEN_SHIP_SET_ROTATION", model = E_MODEL_STAR, behavior = id_bhvSunkenShipSetRotation},
    {name = "SUSHI_SHARK", model = E_MODEL_SUSHI, behavior = id_bhvSushiShark},
    {name = "RR_SWING", model = E_MODEL_RR_SWINGING_PLATFORM, behavior = id_bhvSwingPlatform},
    {name = "SWOOP", model = E_MODEL_SWOOP, behavior = id_bhvSwoop},
    {name = "TANK_FISH_GROUP", model = E_MODEL_STAR, behavior = id_bhvTankFishGroup},
    {name = "TEMPORARY_YELLOW_COIN", model = E_MODEL_YELLOW_COIN, behavior = id_bhvTemporaryYellowCoin},
    {name = "TEN_COINS_SPAWN", model = E_MODEL_STAR, behavior = id_bhvTenCoinsSpawn},
    {name = "THI_BOWLING_BALL_SPAWNER", model = E_MODEL_STAR, behavior = id_bhvThiBowlingBallSpawner},
    {name = "THI_HUGE_ISLAND_TOP", model = E_MODEL_THI_HUGE_ISLAND_TOP, behavior = id_bhvThiHugeIslandTop},
    {name = "THI_TINY_ISLAND_TOP", model = E_MODEL_THI_TINY_ISLAND_TOP, behavior = id_bhvThiTinyIslandTop},
    {name = "THWOMP", model = E_MODEL_THWOMP, behavior = id_bhvThwomp},
    {name = "THWOMP_2", model = E_MODEL_THWOMP, behavior = id_bhvThwomp2},
    {name = "BOWSER_2_ARENA", model = E_MODEL_BOWSER_2_TILTING_ARENA, behavior = id_bhvTiltingBowserLavaPlatform},
    {name = "BUP", model = E_MODEL_TOAD, behavior = id_bhvToadMessage},
    {name = "END_TOAD", model = E_MODEL_TOAD, behavior = id_bhvEndToad},
    {name = "WF_ROTATING_WOODEN_PLATFORM", model = E_MODEL_ROTATING_WOODEN_PLATFORM, behavior = id_bhvWfRotatingWoodenPlatform},
    {name = "WF_TOWER", model = E_MODEL_WF_TOWER, behavior = id_bhvTower},
    {name = "WF_TOWER_DOOR", model = E_MODEL_WF_TOWER_DOOR, behavior = id_bhvTowerDoor},
    {name = "WF_TOWER_PLATFORM_GROUP", model = E_MODEL_STAR, behavior = id_bhvTowerPlatformGroup},
    {name = "TOX_BOX", model = E_MODEL_SSL_TOX_BOX, behavior = id_bhvToxBox},
    {name = "TRACK_BALL", model = E_MODEL_BOWLING_BALL, behavior = id_bhvTrackBall},
    {name = "TREASURE_CHEST_BOTTOM", model = E_MODEL_TREASURE_CHEST_BASE, behavior = id_bhvTreasureChestBottom},
    {name = "TREASURE_CHESTS", model = E_MODEL_STAR, behavior = id_bhvTreasureChests},
    {name = "JRB_TREASURE_CHESTS", model = E_MODEL_STAR, behavior = id_bhvTreasureChestsJrb},
    {name = "SHIP_TREASURE_CHESTS", model = E_MODEL_STAR, behavior = id_bhvTreasureChestsShip},
    {name = "TREASURE_CHEST_TOP", model = E_MODEL_TREASURE_CHEST_LID, behavior = id_bhvTreasureChestTop},
    {name = "TREE", model = E_MODEL_BUBBLY_TREE, behavior = id_bhvTree},
    {name = "PALM_TREE", model = E_MODEL_PALM_TREE, behavior = id_bhvTree},
    {name = "SNOW_TREE", model = E_MODEL_SNOW_TREE, behavior = id_bhvTree},
    {name = "SPIKY_TREE", model = E_MODEL_COURTYARD_SPIKY_TREE, behavior = id_bhvTree},
    {name = "TRIPLET_BUTTERFLY", model = E_MODEL_BUTTERFLY, behavior = id_bhvTripletButterfly},
    {name = "TTC_CLOCK_HAND", model = E_MODEL_TTC_CLOCK_HAND, behavior = id_bhvTTC2DRotator},
    {name = "TTC_ROTATING_HEXAGON", model = E_MODEL_TTC_ROTATING_HEXAGON, behavior = id_bhvTTCCog},
    {name = "TTC_ELEVATOR", model = E_MODEL_TTC_ELEVATOR_PLATFORM, behavior = id_bhvTTCElevator},
    {name = "TTC_PUSH_BLOCK", model = E_MODEL_TTC_PUSH_BLOCK, behavior = id_bhvTTCMovingBar},
    {name = "TTC_PENDULUM", model = E_MODEL_TTC_PENDULUM, behavior = id_bhvTTCPendulum},
    {name = "TTC_PIT_BLOCK", model = E_MODEL_TTC_PIT_BLOCK, behavior = id_bhvTTCPitBlock},
    {name = "TTC_ROTATING_CUBE", model = E_MODEL_TTC_ROTATING_CUBE, behavior = id_bhvTTCRotatingSolid},
    {name = "TTC_SPINNER", model = E_MODEL_TTC_SPINNER, behavior = id_bhvTTCSpinner},
    {name = "TTC_TREADMILL", model = E_MODEL_TTC_LARGE_TREADMILL, behavior = id_bhvTTCTreadmill},
    {name = "TTM_BOWLING_BALL_SPAWNER", model = E_MODEL_STAR, behavior = id_bhvTtmBowlingBallSpawner},
    {name = "TTM_ROLLING_LOG", model = E_MODEL_TTM_ROLLING_LOG, behavior = id_bhvTtmRollingLog},
    {name = "PENGUIN_MOTHER", model = E_MODEL_PENGUIN, behavior = id_bhvTuxiesMother},
    {name = "TWEESTER", model = E_MODEL_TWEESTER, behavior = id_bhvTweester},
    {name = "UKIKI", model = E_MODEL_UKIKI, behavior = id_bhvUkiki},
    {name = "UKIKI_CAGE", model = E_MODEL_TTM_STAR_CAGE, behavior = id_bhvUkikiCage},
    {name = "UNAGI", model = E_MODEL_UNAGI, behavior = id_bhvUnagi},
    {name = "UNLOCK_DOOR_STAR", model = E_MODEL_STAR, behavior = id_bhvUnlockDoorStar},
    {name = "UNUSED_FAKE_STAR", model = E_MODEL_CARTOON_STAR, behavior = id_bhvUnusedFakeStar},
    {name = "UNUSED_PENGUIN", model = E_MODEL_PENGUIN, behavior = id_bhvUnused20E0},
    {name = "UNUSED_POUNDABLE_PLATFORM", model = E_MODEL_STAR, behavior = id_bhvUnusedPoundablePlatform},
    {name = "VANISH_CAP", model = E_MODEL_MARIOS_CAP, behavior = id_bhvVanishCap},
    {name = "VOLCANO_SOUND_LOOP", model = E_MODEL_STAR, behavior = id_bhvVolcanoSoundLoop},
    {name = "WATER_AIR_BUBBLE", model = E_MODEL_BUBBLE, behavior = id_bhvWaterAirBubble},
    {name = "WATER_BOMB", model = E_MODEL_WATER_BOMB, behavior = id_bhvWaterBomb},
    {name = "WATER_BOMB_CANNON", model = E_MODEL_CANNON_BARREL, behavior = id_bhvWaterBombCannon},
    {name = "WATER_BOMB_SPAWNER", model = E_MODEL_STAR, behavior = id_bhvWaterBombSpawner},
    {name = "WATERFALL_SOUND_LOOP", model = E_MODEL_STAR, behavior = id_bhvWaterfallSoundLoop},
    {name = "WATER_LEVEL_DIAMOND", model = E_MODEL_WDW_WATER_LEVEL_DIAMOND, behavior = id_bhvWaterLevelDiamond},
    {name = "WATER_LEVEL_PILLAR", model = E_MODEL_CASTLE_WATER_LEVEL_PILLAR, behavior = id_bhvWaterLevelPillar},
    {name = "WARP", model = E_MODEL_STAR, behavior = id_bhvWarp},
    {name = "WDW_EXPRESS_ELEVATOR", model = E_MODEL_WDW_EXPRESS_ELEVATOR, behavior = id_bhvWdwExpressElevator},
    {name = "WDW_RECTANGLE_PLATFORM", model = E_MODEL_WDW_RECTANGULAR_FLOATING_PLATFORM, behavior = id_bhvWdwRectangularFloatingPlatform},
    {name = "WDW_SQUARE_PLATFORM", model = E_MODEL_WDW_SQUARE_FLOATING_PLATFORM, behavior = id_bhvWdwSquareFloatingPlatform},
    {name = "WF_BREAKABLE_WALL_LEFT", model = E_MODEL_WF_BREAKABLE_WALL_LEFT, behavior = id_bhvWfBreakableWallLeft},
    {name = "WF_BREAKABLE_WALL_RIGHT", model = E_MODEL_WF_BREAKABLE_WALL_RIGHT, behavior = id_bhvWfBreakableWallRight},
    {name = "WHIRLPOOL", model = E_MODEL_DL_WHIRLPOOL, behavior = id_bhvWhirlpool},
    {name = "WHOMP_KING", model = E_MODEL_WHOMP, behavior = id_bhvWhompKingBoss},
    -- {name = "WIGGLER", model = E_MODEL_WIGGLER_HEAD, behavior = id_bhvWigglerHead},
    {name = "WING_CAP", model = E_MODEL_MARIOS_WING_CAP, behavior = id_bhvWingCap},
    {name = "WOODEN_POST", model = E_MODEL_WOODEN_POST, behavior = id_bhvWoodenPost},
    {name = "YELLOW_BALL", model = E_MODEL_YELLOW_SPHERE, behavior = id_bhvYellowBall},
    {name = "YELLOW_COIN", model = E_MODEL_YELLOW_COIN, behavior = id_bhvYellowCoin},
    {name = "YOSHI", model = E_MODEL_YOSHI, behavior = id_bhvYoshi},
    -- ARENA --
    {name = "SPRING", model = E_MODEL_STAR, behavior = id_bhvArenaSpring},
    -- STAR ROAD --
    {name = "SR_SHYGUY", model = E_MODEL_SR_SHYGUY, behavior = id_bhvGoomba},
    -- GUN MOD --
    {name = "BONER", model = E_MODEL_SKELETON, behavior = id_bhvBreakableBoxSmall},
    {name = "LAUNCHPAD", model = E_MODEL_LAUNCHPAD, behavior = id_bhvLaunchpad},
    -- MARIO'S NIGHTMARE 64 --
    {name = "BUP2", model = E_MODEL_TOAD2, behavior = id_bhvToadMessage},
    -- RIDEABLE YOSHI --
    {name = "RIDEABLE_YOSHI", model = E_MODEL_YOSHI, behavior = id_bhvYoshiRideable},
    {name = "RYOSHI_EGG", model = E_MODEL_YOSHI_EGG, behavior = id_bhvYoshiSpawnEgg},
    {name = "YOSHI_NEST", model = E_MODEL_YOSHI_NEST, behavior = id_bhvYoshiNest},
    -- CUSTOM --
    {name = "PIRATE_SHIP", model = E_MODEL_PIRATE_SHIP, behavior = id_bhvInSunkenShip3},
    {name = "SUNKEN_SHIP", model = E_MODEL_SUNKEN_SHIP, behavior = id_bhvInSunkenShip3},
    {name = "BLUE_PIPE", model = E_MODEL_BLUE_PIPE, behavior = id_bhvWarpPipe},
    {name = "RED_PIPE", model = E_MODEL_RED_PIPE, behavior = id_bhvWarpPipe},
    {name = "YELLOW_PIPE", model = E_MODEL_YELLOW_PIPE, behavior = id_bhvWarpPipe},
    {name = "PURPLE_PIPE", model = E_MODEL_PURPLE_PIPE, behavior = id_bhvWarpPipe},
    {name = "PLAYER", model = E_MODEL_MARIO, behavior = id_bhvStaticObject},
    {name = "PLAYER_LUIGI", model = E_MODEL_LUIGI, behavior = id_bhvStaticObject},
    {name = "PLAYER_TOAD", model = E_MODEL_TOAD_PLAYER, behavior = id_bhvStaticObject},
    {name = "PLAYER_WALUIGI", model = E_MODEL_WALUIGI, behavior = id_bhvStaticObject},
    {name = "PLAYER_WARIO", model = E_MODEL_WARIO, behavior = id_bhvStaticObject},
    {name = "MARIO_MUG", model = E_MODEL_MARIO_MUG, behavior = id_bhvWarpPipe},
    {name = "MCD_CRATE", model = E_MODEL_MCD_CRATE, behavior = id_bhvBreakableBox},
    {name = "COFFIN_DOOR", model = E_MODEL_COFFIN_DOOR, behavior = id_bhvDoor},
    {name = "UNUSED_DOOR", model = E_MODEL_UNUSED_WOODEN_DOOR, behavior = id_bhvDoor},
    {name = "KART", model = E_MODEL_KART, behavior = id_bhvStaticObject},
    -- {name = "SHADOW", model = E_MODEL_SHADOW_MARIO, behavior = id_bhvShadowMario2},
    {name = "EXIT_DOOR", model = E_MODEL_TADC_EXIT_DOOR, behavior = id_bhvDoor},
    {name = "GENERATOR", model = E_MODEL_STAR, behavior = id_bhvGenerator},
    {name = "FAKE_STAR", model = E_MODEL_STAR, behavior = id_bhvFakeStar},
    {name = "CUSTOM", model = E_MODEL_BOBOMB_BUDDY, behavior = id_bhvBobomb}
}
gGlobalSyncTable.spawnedObjectsPopup = true
local objectStuff = {
    spawningAnObject = false,
    objectToSpawn = nil,
    pos = {x = 0, y = 0, z = 0},
    custom = {model = "BOBOMB_BUDDY", bhv = "BOBOMB"},
    params = {param1 = 0, param2 = 0},
    mushroom = {mushroombehavior = 0},
    speed = 10
}

local function find_object_index_from_name(name)
    for i, v in pairs(objects) do
        if v.name == name then
            return i
        end
    end
end

local function bhv_unspawned_object_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
end

local function bhv_unspawned_object_loop(o)
    o.oPosX = objectStuff.pos.x
    o.oPosY = objectStuff.pos.y
    o.oPosZ = objectStuff.pos.z
    o.oFaceAngleYaw = gMarioStates[0].faceAngle.y
    if not objectStuff.spawningAnObject then
        obj_mark_for_deletion(o)
    end
end

id_bhvUnspawnedObject = hook_behavior(id_bhvUnspawnedObject, OBJ_LIST_DEFAULT, true, bhv_unspawned_object_init, bhv_unspawned_object_loop)

local function local_mario_update(m)
    if m.playerIndex ~= 0 then return end
    if objectStuff.spawningAnObject then
        if (m.controller.buttonDown & L_TRIG) ~= 0 then
            vec3f_set(objectStuff.pos, gMarioStates[0].pos.x, gMarioStates[0].pos.y, gMarioStates[0].pos.z)
        end

        if (m.controller.buttonDown & U_JPAD) ~= 0 then
            objectStuff.pos.z = objectStuff.pos.z - objectStuff.speed
        elseif (m.controller.buttonDown & D_JPAD) ~= 0 then
            objectStuff.pos.z = objectStuff.pos.z + objectStuff.speed
        end

        if (m.controller.buttonDown & R_JPAD) ~= 0 then
            objectStuff.pos.x = objectStuff.pos.x + objectStuff.speed
        elseif (m.controller.buttonDown & L_JPAD) ~= 0 then
            objectStuff.pos.x = objectStuff.pos.x - objectStuff.speed
        end

        if (m.controller.buttonDown & A_BUTTON) ~= 0 then
            objectStuff.pos.y = objectStuff.pos.y + objectStuff.speed
        elseif (m.controller.buttonDown & Z_TRIG) ~= 0 then
            objectStuff.pos.y = objectStuff.pos.y - objectStuff.speed
        end

        if (m.controller.buttonPressed & B_BUTTON) ~= 0 then
            spawn_sync_object(objects[objectStuff.objectToSpawn].behavior, objects[objectStuff.objectToSpawn].model, objectStuff.pos.x, objectStuff.pos.y, objectStuff.pos.z, function (o)
                o.oBehParams = objectStuff.params.param1
                o.oBehParams2ndByte = objectStuff.params.param2
                mushroombehavior = objectStuff.mushroom.mushroombehavior
            end)
            if gGlobalSyncTable.spawnedObjectsPopup then
                if objects[objectStuff.objectToSpawn].name == "CUSTOM" then
                    djui_popup_create_global(network_get_player_text_color_string(0)..gNetworkPlayers[0].name.."\\#dcdcdc\\ spawned CUSTOM \\#10FF10\\("..objectStuff.custom.model.." "..objectStuff.custom.bhv..") ("..tostring(objectStuff.params.param1).." "..tostring(objectStuff.params.param2)..")", 2)
                else
                    djui_popup_create_global(network_get_player_text_color_string(0)..gNetworkPlayers[0].name.."\\#dcdcdc\\ spawned \\#10FF10\\"..objects[objectStuff.objectToSpawn].name.." ("..tostring(objectStuff.params.param1).." "..tostring(objectStuff.params.param2)..")", 2)
                end
            end
            objectStuff.spawningAnObject = false
        end
    end
end

local function obj_command(msg)
    msg = string.upper(msg)
    local args = {}
    for argument in msg:gmatch("%S+") do table.insert(args, argument) end

    if args[1] == "SPAWN" then
        if not objectStuff.spawningAnObject then
            if gGlobalSyncTable.objectSpawnerHostOnly and not network_is_server() then djui_chat_message_create("Only the \\#ffff00\\host\\#ffffff\\ can use this command.") return true end
            if find_object_index_from_name(args[2]) ~= nil then
                objectStuff.objectToSpawn = find_object_index_from_name(args[2])
                objectStuff.spawningAnObject = true
                spawn_non_sync_object(id_bhvUnspawnedObject, objects[find_object_index_from_name(args[2])].model, 0, 0, 0, nil)
                djui_chat_message_create("You are now \\#ffff00\\spawning\\#ffffff\\ \\#10FF10\\"..args[2]..".")
            else
                djui_chat_message_create("Object \\#ff0000\\not found.")
            end
        else
            djui_chat_message_create("You are already \\#ffff00\\spawning\\#ffffff\\ an \\#ffff00\\object!")
        end
    elseif args[1] == "CUSTOM" then
        if find_object_index_from_name(args[2]) ~= nil and find_object_index_from_name(args[3]) ~= nil then
            if args[2] ~= "CUSTOM" or args[3] ~= "CUSTOM" then
                objects[#objects].model = objects[find_object_index_from_name(args[2])].model
                objects[#objects].behavior = objects[find_object_index_from_name(args[3])].behavior
                objectStuff.custom.model = args[2]
                objectStuff.custom.bhv = args[3]
                djui_chat_message_create("Custom \\#ffff00\\object! \\#ffffff\\set to: \\#10FF10\\"..objectStuff.custom.model.." "..objectStuff.custom.bhv)
            end
        else
            djui_chat_message_create("Usage of command: \\#ffff00\\/obj spawn objectModel objectBehavior")
        end
    elseif args[1] == "SPEED" then
        if tonumber(args[2]) ~= nil then
            objectStuff.speed = tonumber(args[2])
            djui_chat_message_create("\\#ffff00\\Speed \\#ffffff\\set to: \\#10FF10\\"..args[2])
        else
            djui_chat_message_create("Usage of command: \\#ffff00\\/obj speed number")
        end
    elseif args[1] == "PARAMS" then
        if tonumber(args[2]) ~= nil and tonumber(args[3]) ~= nil then
            objectStuff.params.param1 = tonumber(args[2])
            objectStuff.params.param2 = tonumber(args[3])
            djui_chat_message_create("Object \\#ffff00\\Params \\#ffffff\\set to: \\#10FF10\\"..args[2].." "..args[3])
        else
            djui_chat_message_create("Usage of command: \\#ffff00\\/obj params number number")
        end
    elseif args[1] == "SEARCH" and args[2] ~= nil then
        for i, v in pairs(objects) do
            if string.find(v.name, args[2]) then
                djui_chat_message_create(v.name)
            end
        end
    elseif args[1] == "POSITION" then
        if tonumber(args[2]) ~= nil and tonumber(args[3]) ~= nil and tonumber(args[4]) ~= nil then
            vec3f_set(objectStuff.pos, tonumber(args[2]), tonumber(args[3]), tonumber(args[4]))
        else
            djui_chat_message_create("Usage of command: \\#ffff00\\/obj position x y z")
        end
    elseif args[1] == "HOST_ONLY" then
        if network_is_server() then
            if args[2] == "ON" then
                gGlobalSyncTable.objectSpawnerHostOnly = true
                djui_popup_create_global("Spawning objects is now \\#ffff00\\host only.", 1)
            elseif args[2] == "OFF" then
                gGlobalSyncTable.objectSpawnerHostOnly = false
                djui_popup_create_global("Spawning objects is no longer \\#ffff00\\host only.", 1)
            else
                djui_chat_message_create("Usage of command: \\#ffff00\\/obj host_only \\#00ff00\\on\\#ffffff\\|\\#ff0000\\off")
            end
        else
            djui_chat_message_create("Only the \\#ffff00\\host \\#ffffff\\can use this command.")
        end
    elseif args[1] == "POP_UPS" then
        if network_is_server() then
            if args[2] == "ON" then
                gGlobalSyncTable.spawnedObjectsPopup = true
                djui_chat_message_create("Spawn \\#ffff00\\pop-ups \\#ffffff\\will \\#10FF10\\now show up.")
            elseif args[2] == "OFF" then
                gGlobalSyncTable.spawnedObjectsPopup = false
                djui_chat_message_create("Spawn \\#ffff00\\pop-ups \\#ffffff\\will \\#ff0000\\no longer show up.")
            else
                djui_chat_message_create("Usage of command: \\#ffff00\\/obj pop_ups \\#00ff00\\on\\#ffffff\\|\\#ff0000\\off")
            end
        else
            djui_chat_message_create("Only the \\#ffff00\\host \\#ffffff\\can use this command.")
        end
    elseif args[1] == "MUSHROOM" then
        if tonumber(args[2]) ~= nil then
            objectStuff.mushroom.mushroombehavior = tonumber(args[2])
            djui_chat_message_create("Object \\#ffff00\\Mushroom\\#ffffff\\ set to: \\#10FF10\\"..args[2])
        else
            djui_chat_message_create("Usage of command: \\#ffff00\\/obj mushroom number")
        end
    end
    return true
end    

function mushroom_surprise(unloadedObj)
    nearest = nearest_mario_state_to_object(unloadedObj)
    if (get_id_from_behavior(unloadedObj.behavior) == id_bhvHidden1upInPole and nearest.playerIndex == 0) then
        --1UP mushroom behaviors:
        --0 = None
        --1 = GREEN DEMON (Death)
        --2 = Cheeseburger (health refill)
        --3 = Caps Powers (Caps)

        if (mushroombehavior) == 0 then --NONE
        end
        if (mushroombehavior) == 1 then --GREEN DEMON
        play_character_sound(m, CHAR_SOUND_ATTACKED)
        obj_explode_and_spawn_coins(0,0)
        isCOIN = true
        bhv_explosion_init()
        set_environmental_camera_shake(SHAKE_ENV_EXPLOSION)
        spawn_mist_particles()
        spawn_mist_particles()
        spawn_mist_particles()
        spawn_mist_particles()
        spawn_mist_particles()
        --set_mario_action(gMarioStates[0], ACT_DISAPPEARED, 0)
        gMarioStates[0].health = 0xff
        end
        if (mushroombehavior) == 2 then --Cheeseburger
            --add health to Mario
            play_character_sound(m, CHAR_SOUND_HERE_WE_GO)
            gMarioStates[0].numLives = gMarioStates[0].numLives + 10
            gMarioStates[0].health = gMarioStates[0].health + 256
            gMarioStates[0].numCoins = gMarioStates[0].numCoins + 20
        end
        if (mushroombehavior) == 3 then --Caps Powers
            --add caps powers to Mario
            play_character_sound(m, CHAR_SOUND_HERE_WE_GO)
            gMarioStates[0].numLives = gMarioStates[0].numLives - 1
            isCAPS = true
        end


    end
end

hook_event(HOOK_MARIO_UPDATE, local_mario_update)
hook_event(HOOK_ON_OBJECT_UNLOAD, mushroom_surprise)
hook_chat_command("obj", "[spawn|custom|speed|params|search|position|pop_ups|mushroom|host_only]", obj_command)