﻿//=============================================================================
// AltMenuScreen3.js
//=============================================================================
 
/*:
 * @plugindesc Yet Another menu screen layout.
 * @author Sasuke KANNAZUKI, Yoji Ojima
 *
 * @default
 * @param bgBitmapMenu
 * @desc background bitmap file at menu scene. put at img/pictures.
 * @default
 *
 * @param bgBitmapItem
 * @desc background bitmap file at item scene. put at img/pictures.
 * @default
 *
 * @param bgBitmapSkill
 * @desc background bitmap file at skill scene. put at img/pictures.
 * @default
 *
 * @param bgBitmapEquip
 * @desc background bitmap file at equip scene. put at img/pictures.
 * @default
 *
 * @param bgBitmapStatus
 * @desc background bitmap file at status scene. put at img/pictures.
 * @default
 *
 * @param bgBitmapOptions
 * @desc background bitmap file at option scene. put at img/pictures.
 * @default
 *
 * @param bgBitmapFile
 * @desc background bitmap file at save/load scene. put at img/pictures.
 * @default
 *
 * @param bgBitmapGameEnd
 * @desc background bitmap file at gameEnd scene. put at img/pictures.
 * @default
 *
 * @param maxColsMenu
 * @desc max column at menu window
 * @default 4
 *
 * @param commandRows
 * @desc number of visible rows at command window
 * @default 2
 *
 * @param isDisplayStatus
 * @desc whether display status or not. (1 = yes, 0 = no)
 * @default 1
 *
 * @help This plugin does not provide plugin commands.
 *  The differences with AltMenuscreen are follows:
 *   - windows are transparent at all menu scene.
 *   - it can set the background bitmap for each scenes at menu.
 *   - picture is actors' original
 *
 * Actor' note:
 * <stand_picture:filename> set actor's standing picture at menu.
 *   put file at img/pictures.
 *
 * preferred size of actor's picture:
 * width: 174px(maxColsMenu=4), 240px(maxColsMenu=3)
 * height: 408px(commandRows=2), 444px(commandRows=1)
 */
 
/*:ja
 * @plugindesc レイアウトの異なるメニュー画面
 * @author &#31070;無月サスケ, Yoji Ojima
 *
 * @param bgBitmapMenu
 * @desc ニュー背景にするビットマップファイルです。
 * img/pictures &#12395;置いてください。
 * @default
 *
 * @param bgBitmapItem
 * @desc &#12450;イテム画面背景にするビットマップファイルです。
 * img/pictures &#12395;置いてください。
 * @default
 *
 * @param bgBitmapSkill
 * @desc &#12473;キル画面背景にするビットマップファイルです。
 * img/pictures &#12395;置いてください。
 * @default
 *
 * @param bgBitmapEquip
 * @desc &#35013;備画面背景にするビットマップファイルです。
 * img/pictures &#12395;置いてください。
 * @default
 *
 * @param bgBitmapStatus
 * @desc &#12473;テータス画面背景にするビットマップファイルです。
 * img/pictures &#12395;置いてください。
 * @default
 *
 * @param bgBitmapOptions
 * @desc &#12458;プション画面背景にするビットマップファイルです。
 * img/pictures &#12395;置いてください。
 * @default
 *
 * @param bgBitmapFile
 * @desc &#12475;ーブ／ロード画面背景にするビットマップファイルです。
 * img/pictures &#12395;置いてください。
 * @default
 *
 * @param bgBitmapGameEnd
 * @desc &#12466;ーム終了画面背景にするビットマップファイルです。
 * img/pictures &#12395;置いてください。
 * @default
 *
 * @param maxColsMenu
 * @desc &#12450;クターを表示するウィンドウの1画面の登録最大数です。
 * @default 2
 *
 * @param commandRows
 * @desc &#12467;マンドウィンドウの行数です。
 * @default 3
 *
 * @param isDisplayStatus
 * @desc &#12473;テータスを表示するかしないかを選びます。(1 = yes, 0 = no)
 * @default 1
 *
 * @help &#12371;のプラグインには、プラグインコマンドはありません。
 *
 *  AltMenuscreen &#12392;の違いは以下です:
 *  - ニュー画面すべてのウィンドウが透明です
 *  - ニューそれぞれのシーンに背景ビットマップを付けることが出来ます。
 *  - &#12450;クターに立ち絵を利用します。
 *
 * &#12450;クターのメモに以下のように書いてください:
 * <stand_picture:&#12501;ァイル名> ファイル名が、そのアクターの立ち絵になります。
 *   &#12501;ァイルは img/pictures に置いてください。
 *
 * 望ましいアクター立ち絵のサイズ：
 * 幅：3列:240px, 4列：174px
 * 高さ： コマンドウィンドウ 1行:444px 2行:408px
 *
 */
 
(function() {
 
    // set parameters
    var parameters = PluginManager.parameters('AltMenuScreen3');
    var bgBitmapMenu = parameters['bgBitmapMenu'] || '';
    var bgBitmapItem = parameters['bgBitmapItem'] || '';
    var bgBitmapSkill = parameters['bgBitmapSkill'] || '';
    var bgBitmapEquip = parameters['bgBitmapEquip'] || '';
    var bgBitmapStatus = parameters['bgBitmapStatus'] || '';
    var bgBitmapOptions = parameters['bgBitmapOptions'] || '';
    var bgBitmapFile = parameters['bgBitmapFile'] || '';
    var bgBitmapGameEnd = parameters['bgBitmapGameEnd'] || '';
    var maxColsMenuWnd = Number(parameters['maxColsMenu'] || 2);
    var rowsCommandWnd = Number(parameters['commandRows'] || 2);
    var isDisplayStatus = !!Number(parameters['isDisplayStatus']);
 
   //
   // make transparent windows for each scenes in menu.
   //
    var _Scene_Menu_create = Scene_Menu.prototype.create;
    Scene_Menu.prototype.create = function() {
        _Scene_Menu_create.call(this);
        this._statusWindow.x = 0;
        this._statusWindow.y = 1000;
        this._goldWindow.x = Graphics.boxWidth - this._goldWindow.width;
        // make transparent for all windows at menu scene.
        this._statusWindow.opacity = 0;
        this._goldWindow.opacity = 0;
        this._commandWindow.opacity = 0;
        this._commandWindow.x = 420;
        this._commandWindow.y = 90;
    };
 
    var _Scene_Item_create = Scene_Item.prototype.create;
    Scene_Item.prototype.create = function() {
        _Scene_Item_create.call(this);
        this._helpWindow.opacity = 0;
        this._categoryWindow.opacity = 0;
        this._itemWindow.opacity = 0;
        this._actorWindow.opacity = 0;
    };
 
    var _Scene_Skill_create = Scene_Skill.prototype.create;
    Scene_Skill.prototype.create = function() {
        _Scene_Skill_create.call(this);
        this._helpWindow.opacity = 0;
        this._skillTypeWindow.opacity = 0;
        this._statusWindow.opacity = 0;
        this._itemWindow.opacity = 0;
        this._actorWindow.opacity = 0;
    };
 
    var _Scene_Equip_create = Scene_Equip.prototype.create;
    Scene_Equip.prototype.create = function() {
        _Scene_Equip_create.call(this);
        this._helpWindow.opacity = 0;
        this._statusWindow.opacity = 0;
        this._commandWindow.opacity = 0;
        this._slotWindow.opacity = 0;
        this._itemWindow.opacity = 0;
    };
 
    var _Scene_Status_create = Scene_Status.prototype.create;
    Scene_Status.prototype.create = function() {
        _Scene_Status_create.call(this);
        this._statusWindow.opacity = 0;
    };
 
    var _Scene_Options_create = Scene_Options.prototype.create;
    Scene_Options.prototype.create = function() {
        _Scene_Options_create.call(this);
        this._optionsWindow.opacity = 0;
    };
 
    var _Scene_File_create = Scene_File.prototype.create;
    Scene_File.prototype.create = function() {
        _Scene_File_create.call(this);
        this._helpWindow.opacity = 0;
        this._listWindow.opacity = 0;
    };
 
    var _Scene_GameEnd_create = Scene_GameEnd.prototype.create;
    Scene_GameEnd.prototype.create = function() {
        _Scene_GameEnd_create.call(this);
        this._commandWindow.opacity = 0;
    };
 
    //
    // load bitmap that set in plugin parameter
    //
    var _Scene_Menu_createBackground = Scene_Menu.prototype.createBackground;
    Scene_Menu.prototype.createBackground = function(){
        _Scene_Menu_createBackground.call(this);
        if(bgBitmapMenu){
            this._backgroundSprite2 = new Sprite();
            this._backgroundSprite2.bitmap =
             ImageManager.loadPicture(bgBitmapMenu);
            this.addChild(this._backgroundSprite2);
        }
    };
 
    var _Scene_Item_createBackground = Scene_Item.prototype.createBackground;
    Scene_Item.prototype.createBackground = function(){
        _Scene_Item_createBackground.call(this);
        if(bgBitmapItem){
            this._backgroundSprite2 = new Sprite();
            this._backgroundSprite2.bitmap =
             ImageManager.loadPicture(bgBitmapItem);
            this.addChild(this._backgroundSprite2);
        }
    };
 
    var _Scene_Skill_createBackground = Scene_Skill.prototype.createBackground;
    Scene_Skill.prototype.createBackground = function(){
        _Scene_Skill_createBackground.call(this);
        if(bgBitmapSkill){
            this._backgroundSprite2 = new Sprite();
            this._backgroundSprite2.bitmap =
             ImageManager.loadPicture(bgBitmapSkill);
            this.addChild(this._backgroundSprite2);
            return;
        }
    };
 
    var _Scene_Equip_createBackground = Scene_Equip.prototype.createBackground;
    Scene_Equip.prototype.createBackground = function(){
        _Scene_Equip_createBackground.call(this);
        if(bgBitmapEquip){
            this._backgroundSprite2 = new Sprite();
            this._backgroundSprite2.bitmap =
             ImageManager.loadPicture(bgBitmapEquip);
            this.addChild(this._backgroundSprite2);
            return;
        }
    };
 
    var _Scene_Status_createBackground =
     Scene_Status.prototype.createBackground;
    Scene_Status.prototype.createBackground = function(){
        _Scene_Status_createBackground.call(this);
        if(bgBitmapStatus){
            this._backgroundSprite2 = new Sprite();
            this._backgroundSprite2.bitmap =
             ImageManager.loadPicture(bgBitmapStatus);
            this.addChild(this._backgroundSprite2);
            return;
        }
    };
 
    var _Scene_Options_createBackground =
     Scene_Options.prototype.createBackground;
    Scene_Options.prototype.createBackground = function(){
        _Scene_Options_createBackground.call(this);
        if(bgBitmapOptions){
            this._backgroundSprite2 = new Sprite();
            this._backgroundSprite2.bitmap =
             ImageManager.loadPicture(bgBitmapOptions);
            this.addChild(this._backgroundSprite2);
            return;
        }
    };
 
    var _Scene_File_createBackground = Scene_File.prototype.createBackground;
    Scene_File.prototype.createBackground = function(){
        _Scene_File_createBackground.call(this);
        if(bgBitmapFile){
            this._backgroundSprite2 = new Sprite();
            this._backgroundSprite2.bitmap =
             ImageManager.loadPicture(bgBitmapFile);
            this.addChild(this._backgroundSprite2);
            return;
        }
    };
 
    var _Scene_GameEnd_createBackground =
     Scene_GameEnd.prototype.createBackground;
    Scene_GameEnd.prototype.createBackground = function(){
        _Scene_GameEnd_createBackground.call(this);
        if(bgBitmapGameEnd){
            this._backgroundSprite2 = new Sprite();
            this._backgroundSprite2.bitmap =
             ImageManager.loadPicture(bgBitmapGameEnd);
            this.addChild(this._backgroundSprite2);
            return;
        }
    };
 
    //
    // alt menu screen processes
    //

    //◆メニューコマンドの幅
    Window_MenuCommand.prototype.windowWidth = function() {
        return 120;
    };
 
    Window_MenuCommand.prototype.maxCols = function() {
        return 1;
    };
 
    Window_MenuCommand.prototype.numVisibleRows = function() {
        return rowsCommandWnd;
    };
 
    Window_MenuStatus.prototype.windowWidth = function() {
        return  Graphics.boxWidth;
    };

    Window_MenuCommand.prototype.standardPadding = function() {
        return 20;
    };
 
    Window_MenuStatus.prototype.windowHeight = function() {
        var h1 = this.fittingHeight(1);
        var h2 = this.fittingHeight(rowsCommandWnd);
        return Graphics.boxHeight - h1 - h2;
    };
 
    Window_MenuStatus.prototype.maxCols = function() {
        return maxColsMenuWnd;
    };
 
    Window_MenuStatus.prototype.numVisibleRows = function() {
        return 1;
    };
 
    Window_MenuStatus.prototype.drawItemImage = function(index) {
        var actor = $gameParty.members()[index];
        var rect = this.itemRectForText(index);
        // load stand_picture
        var bitmapName = $dataActors[actor.actorId()].meta.stand_picture;
        var bitmap = bitmapName ? ImageManager.loadPicture(bitmapName) : null;
        var w = Math.min(rect.width, (bitmapName ? bitmap.width : 144));
        var h = Math.min(rect.height, (bitmapName ? bitmap.height : 144));
        var lineHeight = this.lineHeight();
        this.changePaintOpacity(actor.isBattleMember());
        if(bitmap){
            var sx = (bitmap.width > w) ? (bitmap.width - w) / 2 : 0;
            var sy = (bitmap.height > h) ? (bitmap.height - h) / 2 : 0;
            var dx = (bitmap.width > rect.width) ? rect.x :
                rect.x + (rect.width - bitmap.width) / 2;
            var dy = (bitmap.height > rect.height) ? rect.y :
                rect.y + (rect.height - bitmap.height) / 2;
            this.contents.blt(bitmap, sx, sy, w, h, dx, dy);
        } else { // when bitmap is not set, do the original process.
            this.drawActorFace(actor, rect.x, rect.y + lineHeight * 2.5, w, h);
        }
        this.changePaintOpacity(true);
    };
 
    Window_MenuStatus.prototype.drawItemStatus = function(index) {
        if(!isDisplayStatus){
            return;
        }
        var actor = $gameParty.members()[index];
        var rect = this.itemRectForText(index);
        var x = rect.x;
        var y = rect.y;
        var width = rect.width;
        var bottom = y + rect.height;
        var lineHeight = this.lineHeight();
        this.drawActorName(actor, x, y + lineHeight * 0, width);
        this.drawActorLevel(actor, x, y + lineHeight * 1, width);
        this.drawActorClass(actor, x, bottom - lineHeight * 4, width);
        this.drawActorHp(actor, x, bottom - lineHeight * 3, width);
        this.drawActorMp(actor, x, bottom - lineHeight * 2, width);
        this.drawActorIcons(actor, x, bottom - lineHeight * 1, width);
    };
 
    var _Window_MenuActor_initialize = Window_MenuActor.prototype.initialize;
    Window_MenuActor.prototype.initialize = function() {
        _Window_MenuActor_initialize.call(this);
        this.y = this.fittingHeight(2);
    };
 
})();