<?php

include_once("config.php");
global $pPath;
include_once($pPath . "/bsw/utils.php");

function insertSlotValue($qname, $slotQName, $value, $label, $lang){
	$valueStr = formatValueStr($value, $label, $lang);
	if (strlen($valueStr) == 0){
		if (strlen($label) > 0)
			return "The requested element does not exist";
		else
			return "There was an error inserting the value";
	}
	$query = "<$qname> <$slotQName> $valueStr";
	$results = insertNTripples($query);
	return $results;
}

function editSlotValue($qname, $slotQName, $newValue, $newLabel, $lang, $oldValue, $oldLabel){
	if (strlen($oldLabel) > 0){
		$oldValue = label2QName($oldLabel);
	}
	deleteSlotValue($qname, $slotQName, $oldValue, "", $lang);
	return insertSlotValue($qname, $slotQName, $newValue, $newLabel, $lang);
}

function deleteSlotValue($qname, $slotQName, $value, $label, $lang){
	//echo "$qname, $slotQName, $value, $label, $lang";
	$valueStr = formatValueStr($value, $label, $lang);
	//echo $valueStr;
	$results = deleteNTripples("<$qname> <$slotQName> $valueStr");
	return $results;
}

function removeSlot($qname, $slotQName){
	
	// NOTE: removing slot from a concept removes also 

	// the values that were given by instances to this slot
	
	$query = "select ?sp ?s ?v";
	$query .= " where { 
					?sp iv:direct-property <$slotQName> .
					?sp rdfs:domain <$qname> .
					?sp ?s ?v .
				}";
	$query = buildBasicSparql($query);
	$json = executeSparqlOnService($query, "ont");
	//print_r($json);
	foreach ($json['results']['bindings'] as $value){
		$sp = $value['sp']['value'];
		$s = $value['s']['value'];
		$v = $value['v']['value'];
		$str = "<$sp> <$s> ";
		if ($value['v']['type'] == "uri")
			$str .= "<$v>";
		else 
			$str .= "\"$v\"";
		$results = deleteNTripples($str);
	}
	$results = deleteNTripples("<$slotQName> rdfs:domain <$qname>");
	
	$query = "select ?i ?v ?vl where {
					?i rdf:type <$qname> .
					?i <$slotQName> ?v .
					OPTIONAL{
						?v rdfs:label ?vl .
					}
				}";
	$query = buildBasicSparql($query);
	$json = executeSparqlOnService($query, "ont");
	//print_r($json);
	foreach ($json['results']['bindings'] as $value){
		$i = $value['i']['value'];
		$v = $value['v']['value'];
		if (isset($value['v']['lang']))
			$l = $value['v']['lang'];
		if ($value['v']['type'] == "uri")
			$vl = $value['vl']['value'];
		deleteSlotValue($i, $slotQName, $v, $vl, $l);
	}
	return $results;
}

function insertNewType($qname, $typeQName){
	$query = "<$qname> rdf:type <$typeQName> .\n";
	$query .= "<$qname> iv:direct-type <$typeQName>\n";
	$results = insertNTripples($query);		  
	return $results;
}

function deleteType($qname, $type){
	$results = deleteNTripples("<$qname> rdf:type <$type>");
	$results = deleteNTripples("<$qname> iv:direct-type <$type>");
	return $results;
}

function deleteElement($qname){
	global $rdfstoreMode;
	if ($rdfstoreMode == "regular")
		$results = deleteNTripplesWithLabel("<$qname> ?s ?v");
	else if ($rdfstoreMode == "combined")
		$results = deleteNTripplesWithLabel("<$qname> ?s ?v", $qname);
	$results = deleteNTripples("?e <$qname> ?v");
	$results = deleteNTripples("?e ?s <$qname>");
	return $results;
}

function insertLexiconEntry($desc, $inst, $package, $lang){
	$id = getNextLexId();
	$qname = "http://www.intuview.com/lexicon#lex" . $id;
	$results = insertNTripples("<$qname> rdf:type ivlex:IVLexEntry .");
	$results = insertNTripples("<$qname> ivlex:package '$package' .");
	$results = insertNTripples("<$qname> ivlex:section '$lang' .");
	$results = insertNTripples("<$qname> ivlex:description '$desc' .");
	$results = insertNTripples("<$qname> ivlex:default-instance <$inst>");
	return $results;
}

function editLexiconEntryDescription($qname, $desc){
	deleteNTripples("<$qname> ivlex:description ?d");
	$results = insertNTripples("<$qname> ivlex:description '$desc'");
	return $results;
}

function insertElement($elementType, $typeLabel, $label, $package){
	global $rdfstoreMode;
	$existing = label2Qname($label);
	if (strlen($existing) > 0){
		return "Failed to insert element: label name is occupied"; 
	}
	$typeQname = label2QName($typeLabel);
	if (strlen($typeQname) == 0)
		return "Failed to insert element: could not find the concept " . $typeLabel;
	$id = getNextOntId();
	$qname = "http://www.intuview.com/ontology#iv" . $id;
	$qname = trim($qname);
	if ($elementType == "instance"){
	//	$results = insertNTripples("<$qname> rdf:type rdf:Description .");
		$results = insertNTripples("<$qname> rdf:type <$typeQname> .");
		$results = insertNTripples("<$qname> iv:direct-type <$typeQname> .");
	}else{
		$results = insertNTripples("<$qname> rdf:type rdfs:Class .");
		$results = insertNTripples("<$qname> rdf:subClassOf <$typeQname> .");
		$results = insertNTripples("<$qname> iv:direct-supertype <$typeQname> .");
	}
	$results = insertNTripples("<$qname> rdfs:label '$label' .");
	if ($rdfstoreMode == "combined"){
		indexLabel($qname, $label);	
	}
	$results = insertNTripples("<$qname> iv:package '$package' .");
	return $results;
}

function insertPackage($label){
	// check if package exists
	
	if (isPackageExist($label)){
		return "Failed to insert package: " . $label . " already exists";
	}
	$results = insertNTripples("iv:packages iv:package '$label' .");
	return $results;
}

function formatValueStr($value, $label, $lang){
	$valueStr = "";
	if (is_bool($value)){
		$valueStr = (string)$value;
	}
	else if (is_int($value)){
		$valueStr = (string)$value;
	}
	else if (strlen($label) > 0){
		$val = label2QName($label);
		if (strlen($val) > 0){
			$valueStr = "<" . $val . ">";
		}
	}
	else if (isQualified($value) && $value[0] != '<'){
		$valueStr = "<" . $value . ">";
	}
	else{
		$valueStr = "'" . $value . "'";
		if (strlen($lang) > 0){
			$valueStr .= "@" . $lang;
		}
	}
	return $valueStr;
}

function getNextLexId(){
	$query = "select ?d where {
				iv:metadata iv:lexid ?d . }";
	$query = buildBasicSparql($query);
	$json = executeSparqlOnService($query, "ont");
	foreach ($json[results][bindings] as $value){
		$id = $value[d][value];
		break;
	};
	//echo $id . "<br>";
	deleteNTripples("iv:metadata iv:lexid ?d .");
	//echo (int)$id . "<br>";
	$newId = (int)$id + 1;
	//echo $newId . "<br>";
	insertNTripples("iv:metadata iv:lexid " . (string)$newId );
	return $newId;
}

function getNextOntId(){
	$query = "select ?d where {
				iv:metadata iv:ontid ?d . }";
	$query = buildBasicSparql($query);
	$json = executeSparqlOnService($query, "ont");
	foreach ($json[results][bindings] as $value){
		$id = $value[d][value];
		break;
	};
	//echo $id . "<br>";
	deleteNTripples("iv:metadata iv:ontid ?d .");
	//echo (int)$id . "<br>";
	$newId = (int)$id + 1;
	//echo $newId . "<br>";
	insertNTripples("iv:metadata iv:ontid " . (string)$newId );
	return $newId;
}

function publish($servers){
	global $intuScanServers;
	$serversStr = "";
	foreach ($servers["servers"] as $s){
		$serversStr .= "[ip:" . $intuScanServers[$s]["ip"] . ",";
		$serversStr .= "port:" . $intuScanServers[$s]["port"] . "]";	
	}
	$results = updateQuery("export:" . $serversStr);
	return $results;
}

?>