<?php

$CURRENT_SOURCE_FOLDER = dirname(__FILE__);

require_once("$CURRENT_SOURCE_FOLDER/../config.php");
set_include_path("$CURRENT_SOURCE_FOLDER/../extern/easyrdf-0.6.2/lib/");
require_once "$CURRENT_SOURCE_FOLDER/../extern/easyrdf-0.6.2/lib/EasyRdf.php";
require_once "$CURRENT_SOURCE_FOLDER/../extern/easyrdf-0.6.2/examples/html_tag_helpers.php";

$RDF_IV_NS = "http://www.intuview.com/ontology#";
$RDF_IVLEX_NS = "http://www.intuview.com/lexicon#";

function executeSparql($sparql){
	$tmp = executeSparqlOnService($sparql, NULL);
	return $tmp;
}

function executeSparqlOnService($sparql, $service){
	global $rdfstoreUrl;
	if(is_null($service))
		$service = "ont";
  	$url = $rdfstoreUrl . "/" . $service;
	$fields = array(
		'query'=>urlencode($sparql),
		'output'=>urlencode('json')
    );
	foreach($fields as $key=>$value) {
		$fields_string .= $key.'='.$value.'&';
	}
	rtrim($fields_string,'&');

	$ch = curl_init();
	curl_setopt($ch,CURLOPT_RETURNTRANSFER,TRUE);
	curl_setopt($ch,CURLOPT_URL,$url);
	curl_setopt($ch,CURLOPT_POST,count($fields));
	curl_setopt($ch,CURLOPT_POSTFIELDS,$fields_string);
	$results = curl_exec($ch);
	curl_close($ch);
  	$results = iconv("ISO-8859-1", "utf-8", $results);
  	//echo $results;
  	$json_a=json_decode($results,true);
  	//print_r($json_a);
  	return $json_a;
}

function executeSqlSparqlOnService($sparql, $sql, $limit, $offset){
	global $rdfstoreUrl;
	if(is_null($service))
		$service = "ont";
  	$url = $rdfstoreUrl . "/" . $service;
	$fields = array(
		'query'=>urlencode($sparql),
		'labelQuery'=>urlencode($sql),
		'limit'=>$limit,
		'offset'=>$offset,
		'output'=>urlencode('json')
    );
	foreach($fields as $key=>$value) {
		$fields_string .= $key.'='.$value.'&';
	}
	rtrim($fields_string,'&');

	$ch = curl_init();
	curl_setopt($ch,CURLOPT_RETURNTRANSFER,TRUE);
	curl_setopt($ch,CURLOPT_URL,$url);
	curl_setopt($ch,CURLOPT_POST,count($fields));
	curl_setopt($ch,CURLOPT_POSTFIELDS,$fields_string);
	$results = curl_exec($ch);
	curl_close($ch);
  	$results = iconv("ISO-8859-1", "utf-8", $results);
  	//echo $results;
  	$json_a=json_decode($results,true);
  	//print_r($json_a);
  	return $json_a;
}

function executeSqlSparqlOnURL($sparql, $url){
	global $rdfstoreUrl;
	if(is_null($url))
		$url = $rdfstoreUrl;
  	$fields = array(
		'query'=>urlencode($sparql),
		'output'=>urlencode('json')
    );
    $fields_string = "";
	foreach($fields as $key=>$value) {
		$fields_string .= $key.'='.$value.'&';
	}
	rtrim($fields_string,'&');

	$ch = curl_init();
	curl_setopt($ch,CURLOPT_RETURNTRANSFER,TRUE);
	curl_setopt($ch,CURLOPT_URL,$url);
	curl_setopt($ch,CURLOPT_POST,count($fields));
	curl_setopt($ch,CURLOPT_POSTFIELDS,$fields_string);
	$results = curl_exec($ch);
	curl_close($ch);

  	$json_a=json_decode($results,true);
  	//print_r($json_a);
  	return $json_a;
}

function buildBasicSparql($selectWhereStr){
	$sparql = "PREFIX iv:   <http://www.intuview.com/ontology#>
  			   PREFIX ivlex:   <http://www.intuview.com/lexicon#>
			   PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
			   PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \n" . $selectWhereStr;
	return $sparql;
}

function unqualifyName($resourceName){
	$pos = stripos($resourceName, "#");
  	if($pos != FALSE){
  		$resourceName = substr($resourceName, $pos + 1);
  	}
  	else{
  		$pos = strrpos($resourceName, "/");
  		if($pos != FALSE){
  			$resourceName = substr($resourceName, $pos + 1);
  		}
  	}
	return $resourceName;
}

function isQualified($inst){
	$pos = stripos($inst, "#");
  	return ($pos != FALSE);
}

function insertRDF($content){
	$graph = new EasyRdf_Graph();
	$graph->parse($content->wholeText, "guess", "http://www.intuview.com/ontology#");
	$ntriples = $graph->serialise("ntriples");
	//echo $ntriples;
	$tarr = explode("\n", $ntriples);
	$ttmp = "";
	for($i = 0; $i < count($tarr) ; $i++){
		$ttmp .= $tarr[$i] . "\r\n";
		if($i % 70 == 0 && $i > 0){

			$sparql = "PREFIX iv:   <http://www.intuview.com/ontology#>
			  PREFIX ivlex:   <http://www.intuview.com/lexicon#>
   			  PREFIX rdf: 	<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
   			  INSERT { " . $ttmp . "}
   			  WHERE { }";
			updateQuery($sparql);
			$ttmp = "";
		}
	}
	if($i % 70 > 0){
	$sparql = "PREFIX iv:   <http://www.intuview.com/ontology#>
			PREFIX ivlex:   <http://www.intuview.com/lexicon#>
   			  PREFIX rdf: 	<http://www.w3.org/1999/02/22-rdf-syntax-ns#>
   			  INSERT { " . $ttmp . "}
   			  WHERE { }";
			updateQuery($sparql);
			$ttmp = "";
	}
}

function insertNTripples($ntriples){
	$tarr = explode("\n", $ntriples);
	$ttmp = "";
	for($i = 0; $i < count($tarr) ; $i++){
		$ttmp .= $tarr[$i] . "\r\n";
		if($i % 70 == 0 && $i > 0){

			$sparql = buildBasicSparql("INSERT { " . $ttmp . "}
   			  WHERE { }");
			$results = updateQuery($sparql);
			$ttmp = "";
		}
	}
	if($i % 70 > 0){
		$sparql = buildBasicSparql("INSERT { " . $ttmp . "}
   			  WHERE { }");
		$results = updateQuery($sparql);
		$ttmp = "";
	}
	return $results;
}

function indexLabel($qname, $label){
	// for combined mode
	// indesxing the label of an instance in the SQL table
	
	$sqlQuery = buildInsertLabelSql($qname, $label);
	$results = updateSQLQuery($sqlQuery);
	return $results;
}

function deleteNTripples($ntriples){
	$tarr = explode("\n", $ntriples);
	$ttmp = "";
	for($i = 0; $i < count($tarr) ; $i++){
		$ttmp .= $tarr[$i] . "\r\n";
		if($i % 70 == 0 && $i > 0){
			$sparql = buildBasicSparql("DELETE { " . $ttmp . "} WHERE { " . $ttmp . " }");
			//$sparql = buildBasicSparql("DELETE DATA FROM <http://example.org/name1> { iv:x iv:y iv:z }");
			$results = updateQuery($sparql);
			$ttmp = "";
		}
	}
	if($i % 70 > 0){
		$sparql = buildBasicSparql("DELETE { " . $ttmp . "} WHERE { " . $ttmp . " }");
		//$sparql = buildBasicSparql("DELETE DATA FROM <http://example.org/name1> { iv:x iv:y iv:z }");
		$results = updateQuery($sparql);
		$ttmp = "";
	}
	return $results;
}

function deleteNTripplesWithLabel($ntriples, $element){
	deleteNTripples($ntriples);
	$sqlQuery = buildDeleteLabelSql($element);
	$results = updateSQLQuery($sqlQuery);
	return $results;
}

function updateQuery($query){
	//echo $query;
	global $rdfstoreUrl;
	$url = $rdfstoreUrl . "/update/service";
	$fields = array(
		'request'=>urlencode($query)
    );
    foreach($fields as $key=>$value) {
		$fields_string .= $key.'='.$value.'&';
	}
	rtrim($fields_string,'&');
	$ch = curl_init();
	curl_setopt($ch,CURLOPT_URL,$url);
	curl_setopt($ch,CURLOPT_POST,count($fields));
	curl_setopt($ch,CURLOPT_POSTFIELDS,$fields_string);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$results = curl_exec($ch);
	curl_close($ch);
	return $results;
}

function updateSQLQuery($query){
	//echo $query;
	global $rdfstoreUrl;
	$url = $rdfstoreUrl . "/update/service";
	$fields = array(
		'labelQuery'=>urlencode($query)
    );
    foreach($fields as $key=>$value) {
		$fields_string .= $key.'='.$value.'&';
	}
	rtrim($fields_string,'&');
	$ch = curl_init();
	curl_setopt($ch,CURLOPT_URL,$url);
	curl_setopt($ch,CURLOPT_POST,count($fields));
	curl_setopt($ch,CURLOPT_POSTFIELDS,$fields_string);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$results = curl_exec($ch);
	curl_close($ch);
	return $results;
}



?>