<?php
	/*
		UserCake Version: 1.4
		http://usercake.com
		
		Developed by: Adam Davis
	*/
	require_once("userCake/models/config.php");
	
	//Prevent the user visiting the logged in page if he/she is already logged in
	if(isUserLoggedIn()) { header("Location: account.php"); die(); }
?>

<?php
	/* 
		Below is a very simple example of how to process a new user.
		 Some simple validation (ideally more is needed).
		
		The first goal is to check for empty / null data, to reduce workload here
		we let the user class perform it's own internal checks, just in case they are missed.
	*/

//Forms posted
if(!empty($_POST))
{
		$errors = array();
		$email = trim($_POST["email"]);
		$username = trim($_POST["username"]);
		$password = trim($_POST["password"]);
		$confirm_pass = trim($_POST["passwordc"]);
	
		//Perform some validation
		//Feel free to edit / change as required
		
		if(minMaxRange(5,25,$username))
		{
			$errors[] = lang("ACCOUNT_USER_CHAR_LIMIT",array(5,25));
		}
		if(minMaxRange(8,50,$password) && minMaxRange(8,50,$confirm_pass))
		{
			$errors[] = lang("ACCOUNT_PASS_CHAR_LIMIT",array(8,50));
		}
		else if($password != $confirm_pass)
		{
			$errors[] = lang("ACCOUNT_PASS_MISMATCH");
		}
		if(!isValidEmail($email))
		{
			$errors[] = lang("ACCOUNT_INVALID_EMAIL");
		}
		//End data validation
		if(count($errors) == 0)
		{	
				//Construct a user object
				$user = new User($username,$password,$email);
				
				//Checking this flag tells us whether there were any errors such as possible data duplication occured
				if(!$user->status)
				{
					if($user->username_taken) $errors[] = lang("ACCOUNT_USERNAME_IN_USE",array($username));
					if($user->email_taken) 	  $errors[] = lang("ACCOUNT_EMAIL_IN_USE",array($email));		
				}
				else
				{
					//Attempt to add the user to the database, carry out finishing  tasks like emailing the user (if required)
					if(!$user->userCakeAddUser())
					{
						if($user->mail_failure) $errors[] = lang("MAIL_ERROR");
						if($user->sql_failure)  $errors[] = lang("SQL_ERROR");
					}
				}
		}
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Registration</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link href="style.css" rel="stylesheet" type="text/css" />

<script type="text/javascript" src="js/jquery-1.3.2.min.js"></script>
<script type="text/javascript" src="js/script.js"></script>
<!-- CuFon: Enables smooth pretty custom font rendering. 100% SEO friendly. To disable, remove this section -->
<!--<script type="text/javascript" src="js/cufon-yui.js"></script>
<script type="text/javascript" src="js/arial.js"></script>
<script type="text/javascript" src="js/cuf_run.js"></script>-->

 <script src="jquery/jquery.js" type="text/javascript"></script>
  <script src="jquery/jquery-ui.custom.js" type="text/javascript"></script>
  <script src="jquery/jquery.cookie.js" type="text/javascript"></script>
  <script src="jquery-ui/development-bundle/ui/jquery.ui.tabs.js"></script>
  <script src="jquery-ui/development-bundle/ui/jquery.effects.core.js"></script>
<script src="jquery-ui/development-bundle/ui/jquery.effects.blind.js"></script>

<link type="text/css" href="jquery-ui/css/ui-lightness/jquery-ui-1.8.17.custom.css" rel="stylesheet" />
<script type="text/javascript" src="jquery-ui/js/jquery-1.7.1.min.js"></script>
<script type="text/javascript" src="jquery-ui/js/jquery-ui-1.8.17.custom.min.js"></script>
		
  <link href="src/skin/ui.dynatree.css" rel="stylesheet" type="text/css" id="skinSheet">
  <script src="src/jquery.dynatree.js" type="text/javascript"></script>
  <style>
 td {
	border-right: 0px solid #C1DAD7;
	border-bottom: 0px solid #C1DAD7;
	background: #fff;
	padding: 6px 6px 6px 12px;
	color: #4f6b72;
}
.filestdhd{
	color:gray; 
	font-weight:bold;
	background:lightgray;
}
.filestdev{
	color:white; 
	background:#e58a42;
}
.filestdod{
	color:white; 
	background:#e58a42;
}

  </style>


</head>
<body onunload="">

<div class="main">
	 <div class="top-banner">
	 <a href="home.php"><img style="padding:5px 5px 5px 5px; border:0px 0px 0px 0px;" src="images/contentm-logo-ffffff.png"/></a>
	 <p style="padding:0 10px 10px 10px; float:right;"><b>version 1</b></p>
	 <p style="padding:0 10px 10px 10px; float:right;">Hi, <?php echo $_SESSION["username"] ?></p>
	 <p style="padding:0 10px 10px 10px; float:right;"><a style="color:red;" href="logoff.php">logoff</a></p>
 </div>
  <div class="header">
    <div class="header_block">

      <div class="clr"></div>
    </div>
    <div class="clr"></div>
  </div>
  <div class="content">
      <div class="mainbar">
        <div class="article">
        <h2>Register New User</h2>
		<?php
        	if(!empty($_POST)){
        		if(count($errors) > 0){
        ?>
        			<div>
        			<?php
        				echo "<p style=\"color: red; font-weight:bold;\">" . $errors[0] . "</p>";
        			?>
        			</div>     
        <?php
        		}
        		else{
        		
        			echo "<h2>Registration completed successfully. Click <a href=\"login.php\">here</a> to login</h2>";
        			die();
        		}
        		
        	}
        ?> 
        
                <form name="newUser" id="newUser" action="<?php echo $_SERVER['PHP_SELF'] ?>" method="post">
                	<table align="center">
                		<tr>
                			<td>
                				Username
                			</td>
                			<td>
                				<?php
                					echo "<input type=\"text\" name=\"username\" value=\"" . $username . "\"/>";
                				?>
                			</td>
                		</tr>
                		<tr>
                			<td>
                				Password
                			</td>
                			<td>
                				<input type="password" name="password" />
                			</td>
                		</tr>
                		<tr>
                			<td>
                				Confirm Password
                			</td>
                			<td>
                				<input type="password" name="passwordc" />
                			</td>
                		</tr>
                		<tr>
                			<td>
                				Email
                			</td>
                			<td>
                				<input type="text" name="email" />
                			</td>
                		</tr>
                		<tr>
                			<td></td>
                			<td>
                				<a href="javascript:document.forms['newUser'].submit();"><img src="images/submit.gif" alt="submit"></a>
                			</td>
                		</tr>
                	</table>
                </form>
			</div>
		</div>
      <div class="clr"></div>
  </div>
</div>
<div class="footer">
    <div class="footer_resize">
    	      <div class="clr"></div>
    </div>
  </div>
</body>


