<?php
session_start();
include("config.php");
include("loginCheckPoint.php");
include("sem/queries.php");

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; Charset=UTF-8"  /> 
<title>Content Manager - Publish</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="js/jquery-ui/development-bundle/themes/base/jquery.ui.all.css">
<link href="style.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="js/jquery-1.3.2.min.js"></script>
<script type="text/javascript" src="js/script.js"></script>
<script src="js/jquery/jquery.js" type="text/javascript"></script>
<script src="js/jquery/jquery-ui.custom.js" type="text/javascript"></script>
<script src="js/jquery/jquery.cookie.js" type="text/javascript"></script>
<link rel="stylesheet" href="css/jquery.ui.autocomplete.css">
<script src="js/jquery/jquery.js" type="text/javascript"></script>
<script src="js/jquery/jquery-ui.custom.js" type="text/javascript"></script>
<script src="js/jquery/jquery.cookie.js" type="text/javascript"></script>
<script type="text/javascript" src="js/jquery-ui/js/jquery-1.7.1.min.js"></script>
<script type="text/javascript" src="js/jquery-ui/js/jquery-ui-1.8.17.custom.min.js"></script>
<script src="js/jquery-ui/development-bundle/ui/jquery.ui.autocomplete.js"></script>
<script src="js/jquery-ui/development-bundle/ui/jquery.effects.core.js"></script>
<script src="js/jquery-ui/development-bundle/ui/jquery.effects.blind.js"></script>
<script type="text/javascript">
var ajax_load = "<p align=center><img src='images/loader.gif' alt='loading...' /><b><i><font color='red'>please do not refresh the page</font></i></b></p>";
var serverIds = new Array();
<?php
	global $intuScanServers;
	foreach ($intuScanServers as $id=>$server){
		echo "serverIds.push('$id');";
	}
?>

$(function(){
  
	// top messages
	hideAllMessages();
		 
	$('.message').click(function(){			  
		$(this).animate({top: -$(this).outerHeight()}, 500);
	});

	setInterval(function(){ checkStatus();},10000);  
});

function checkStatus(){
	$.ajax({
		url: "queryEng.php?queryType=getserversstatus" ,
		success: function(data) {
			var obj = jQuery.parseJSON(data);
			for (var servId in obj){
				if (obj[servId]){
					$("#status_" + servId).html("<img style=\"vertical-align:middle;\" src=\"images/ok.gif\" title=\"Alive\"/>");
					$("#check_" + servId).removeAttr("disabled");
				}
				else{
					$("#status_" + servId).html("<img style=\"vertical-align:middle;\" src=\"images/cancel.gif\" title=\"Shutdown\"/>");
					$("#check_" + servId).attr("disabled", true);
					$("#check_" + servId).attr('checked', false);
				}
			}
  		}
  	});
}

function tryPublish(){
	showConfirmBoard("publish();", "Are you sure?");	
}

function publish(){
	// building servers json
	var json = "";
	json = "{\"servers\":[";
	var counter = 0;
	for (var i = 0, len = serverIds.length; i < len; i++){	
		if ($("#check_" + serverIds[i]).is(':checked')){
			json += "\"" + serverIds[i] + "\"";
			json += ",";
			counter++;
		}
	}
	if (counter == 0){
		updateMessageBoard("There should be at least one server selected for publishing the knowledge base", "error");
		return;
	}
	json = json.substr(0, json.length - 1); 
	json += "]}";
	$("#butDiv").html(ajax_load);
	$.ajax({
		url: "updateEng.php?queryType=publish&servers=" + encodeURIComponent(json) ,
		success: function(data) {
			if (data == 1){
				updateMessageBoard("The knowledge base was successfully sent to the server for publish", "success");
			}
			else{
				updateMessageBoard("The system could not execute your request! Please check the server log (for administrator)", "error");
			}
			$("#butDiv").html("<a href=\"javascript:tryPublish();\"><img style=\"vertical-align:middle;\" src=\"images/search-but.png\" onmouseover=\"this.src='images/search-but-light.png'\" onmouseout=\"this.src='images/search-but.png'\" id=\"publishBut\" title=\"Publish\"/></a>");
  		}
  	});
}

// messages
// updating message board
function updateMessageBoard(msg, type){
	showMessage(msg, type);
};

// showing the confirmation board for deleting the entire element 
function showConfirmBoard(yesActions, msg){
	var tmp = '<div class="article" id="confirmBoard" style="font-color: white;">' + msg +
  			'<button type="button" onclick="' + yesActions + '">Yes</button>' +
			'<button type="button" onclick="hideAllMessagesWithAnimation();">No</button>' +
      	'</div>';
	showInputYesNoMessage(tmp, "info");
};

var myMessages = ['info','warning','error','success'];
function hideAllMessages() {
	var messagesHeights = new Array();
	for (i=0; i<myMessages.length; i++){
		messagesHeights[i] = $('.' + myMessages[i]).outerHeight(); // fill array
		$('.' + myMessages[i]).css('top', -messagesHeights[i]); //move element outside viewport	  
	}
}

function showMessage(msg, type){
	hideAllMessages();
	$('.'+type).html(msg);
	setTimeout("hideAllMessagesWithAnimation();",3000);
	$('.'+type).animate({top:"0"}, 500);	
}

function showInputYesNoMessage(msg, type){
	hideAllMessages();
	$('.'+type).html(msg);
	$('.'+type).animate({top:"0"}, 500);	
}

function hideAllMessagesWithAnimation(){
	for (i=0; i<myMessages.length; i++){
		$('.' + myMessages[i]).animate({top: -$('.' + myMessages[i]).outerHeight()}, 500);	  
	}
}

</script>

</head>


<body>
<div class="info message"></div>
<div class="error message"></div>
<div class="warning message"></div>
<div class="success message"></div>

<div class="main">
 <div class="top-banner">
	 <a href="home.php"><img style="padding:5px 5px 5px 5px; border:0px 0px 0px 0px;" src="images/contentm-logo-ffffff.png"/></a>
	 <p style="padding:0 10px 10px 10px; float:right;"><b>version 1</b></p>
	 <p style="padding:0 10px 10px 10px; float:right;">Hi, <?php echo $_SESSION["username"] ?></p>
	 <p style="padding:0 10px 10px 10px; float:right;"><a style="color:red;" href="logoff.php">logoff</a></p>
 </div>
  <div class="header">
    <div class="header_block">
     
      <div class="clr"></div>
      
      <?php include('general-toolbar.php'); 
      ?>
      <div class="clr"></div>
    </div>
    <div class="clr"></div>
  </div>
  <div class="content">
      <div class="mainbar">
        <div class="article">
        	<h2>Publish</h2>
			Here you can publish the current knowledge-base to the configured servers.
			<b>Please note: this procedure will reboot the selected server.</b>
        </div>
        <div class="article">
        	<h2>Servers</h2>
			<p>Select the servers you want to share the knowledge-base with:</p>
			<table>
				<tr>
					<th></th>
					<th>Name</th>
					<th>IP</th>
					<th>port</th>
					<th>Status</th>
				</tr>
			<?php
				global $intuScanServers;
				
				foreach ($intuScanServers as $id=>$server){
					$status = isServerAlive($id);
					echo "<tr>";
					echo "<td><input type=\"checkbox\"";
					if ($status == false)
						echo " disabled ";
					echo "id=\"check_$id\"/>";
					echo "<td>" . $server["name"] . "</td>";
					echo "<td>" . $server["ip"] . "</td>";
					echo "<td>" . $server["port"] . "</td>";
					echo "<td id=\"status_$id\">";
					if ($status){
						echo "<img style=\"vertical-align:middle;\" src=\"images/ok.gif\" title=\"Alive\"/>";
					}
					else{
						echo "<img style=\"vertical-align:middle;\" src=\"images/cancel.gif\" title=\"Shutdown\"/>";
					}
					echo "</td>";
					echo "</tr>";
				}
				
			?>
			</table>
			<div id="butDiv" style="position:relative; left:150px;">
				<a href="javascript:tryPublish();"><img style="vertical-align:middle;" src="images/search-but.png" onmouseover="this.src='images/search-but-light.png'"
          								onmouseout="this.src='images/search-but.png'" id="publishBut" title="Publish"/></a>
			</div>
        </div>
      </div>
      <div class="sidebar">
        <div class="gadget">

        </div>
      </div>
      <div class="clr"></div>
  </div>
  
</div>
<div class="footer">
    <div class="footer_resize">
            <p class="lf">Version 1.0</p>
      <p class="rf">IVContent Manager</a></p>
      <div class="clr"></div>
    </div>
  </div>
</body>
</html>