<?php
	session_start();

	include("bsw/utils.php");
require_once("userCake/models/config.php");

if(!empty($_POST))
{
		$errors = array();
		$username = trim($_POST["username"]);
		$password = trim($_POST["password"]);

		//Perform some validation
		//Feel free to edit / change as required
		if($username == "")
		{
			$errors[] = lang("ACCOUNT_SPECIFY_USERNAME");
		}
		if($password == "")
		{
			$errors[] = lang("ACCOUNT_SPECIFY_PASSWORD");
		}

		//End data validation
		if(count($errors) == 0)
		{
			//A security note here, never tell the user which credential was incorrect
			if(!usernameExists($username))
			{
				$errors[] = lang("ACCOUNT_USER_OR_PASS_INVALID");
			}
			else
			{
				$userdetails = fetchUserDetails($username);

				//See if the user's account is activation
				if($userdetails["Active"]==0)
				{
					$errors[] = lang("ACCOUNT_INACTIVE");
				}
				else
				{
					//Hash the password and use the salt from the database to compare the password.
					$entered_pass = generateHash($password,$userdetails["Password"]);

					if($entered_pass != $userdetails["Password"])
					{
						//Again, we know the password is at fault here, but lets not give away the combination incase of someone bruteforcing
						$errors[] = lang("ACCOUNT_USER_OR_PASS_INVALID");
					}
					else
					{
						//Passwords match! we're good to go'

						//Construct a new logged in user object
						//Transfer some db data to the session object
						$loggedInUser = new loggedInUser();
						$loggedInUser->email = $userdetails["Email"];
						$loggedInUser->user_id = $userdetails["User_ID"];
						$loggedInUser->hash_pw = $userdetails["Password"];
						$loggedInUser->display_username = $userdetails["Username"];
						$loggedInUser->clean_username = $userdetails["Username_Clean"];

						//Update last sign in
						$loggedInUser->updateLastSignIn();

						//loadUserData($userdetails["Username"]);
						$_SESSION["loggedIn"] = "yes";
						$_SESSION["username"] = $userdetails["Username"];
						$_SESSION["user"] = $loggedInUser;
						header("Location: home.php");
						//die();
					}
				}
			}
		}
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>IntuScan - Document Analysis View</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link href="style.css" rel="stylesheet" type="text/css" />

<script type="text/javascript" src="js/jquery-1.3.2.min.js"></script>
<!-- CuFon: Enables smooth pretty custom font rendering. 100% SEO friendly. To disable, remove this section -->
<!--<script type="text/javascript" src="js/cufon-yui.js"></script>
<script type="text/javascript" src="js/arial.js"></script>
<script type="text/javascript" src="js/cuf_run.js"></script>-->

 <script src="jquery/jquery.js" type="text/javascript"></script>
  <script src="jquery/jquery-ui.custom.js" type="text/javascript"></script>
  <script src="jquery/jquery.cookie.js" type="text/javascript"></script>
  <script src="jquery-ui/development-bundle/ui/jquery.ui.tabs.js"></script>
  <script src="jquery-ui/development-bundle/ui/jquery.effects.core.js"></script>
<script src="jquery-ui/development-bundle/ui/jquery.effects.blind.js"></script>

<link type="text/css" href="jquery-ui/css/ui-lightness/jquery-ui-1.8.17.custom.css" rel="stylesheet" />
<script type="text/javascript" src="jquery-ui/js/jquery-1.7.1.min.js"></script>
<script type="text/javascript" src="jquery-ui/js/jquery-ui-1.8.17.custom.min.js"></script>

  <link href="src/skin/ui.dynatree.css" rel="stylesheet" type="text/css" id="skinSheet">
  <script src="src/jquery.dynatree.js" type="text/javascript"></script>
  <script type="text/javascript">
  document.onkeydown = function(e)
{
  var keyCode = document.all ? event.keyCode : e.which;
  if(keyCode == 13) document.forms['newUser'].submit();
}
  </script>
  <style>
 td {
	border-right: 0px solid #C1DAD7;
	border-bottom: 0px solid #C1DAD7;
	background: #fff;
	padding: 6px 6px 6px 12px;
	color: #4f6b72;
}
.filestdhd{
	color:gray;
	font-weight:bold;
	background:lightgray;
}
.filestdev{
	color:white;
	background:#e58a42;
}
.filestdod{
	color:white;
	background:#e58a42;
}

  </style>


</head>
<body onunload="">
<div class="main">
  <div class="header">
 	    <img src="images/contentm-logo-2e83ff.png"/>

    <div class="clr"></div>
  </div>
  <div class="content">
      <div class="mainbar">
        <div class="article">
		<?php
        	if(!empty($_POST)){
        		if(count($errors) > 0){
        ?>
        			<div>
        			<?php
        				echo "<p style=\"color: red; font-weight:bold;\">" . $errors[0] . "</p>";
        			?>
        			</div>
        <?php
        		}
        	}
        ?>

                <form name="newUser" id="newUser" action="<?php echo $_SERVER['PHP_SELF'] ?>" method="post">
                	<table align="center">
                		<tr>
                			<td>
                				Username
                			</td>
                			<td>
                				<?php
                					echo "<input type=\"text\" name=\"username\" value=\"" . $username . "\"/>";
                				?>
                			</td>
                		</tr>
                		<tr>
                			<td>
                				Password
                			</td>
                			<td>
                				<input type="password" name="password" />
                			</td>
                		</tr>
                		<tr>
                			<td></td>
                			<td>
                				<a href="javascript:document.forms['newUser'].submit();"><img src="images/submit.gif" alt="submit"></a>
                			</td>
                		</tr>
                	</table>
                </form>
			</div>
		</div>
      <div class="clr"></div>
  </div>
</div>
<div class="footer">
    <div class="footer_resize">
    	<!--<p class="lf">© Copyright <a href="#">www.intuview.com</a></p>-->
      <div class="clr"></div>
    </div>
  </div>
</body>
</html>