﻿<?php

$folderName = $argv[1];
if (empty($folderName))
	die("missing folder name");
$outputFile = $argv[2];
if (empty($outputFile))
	die("missing output file");

file_put_contents($outputFile, "File name\tCategory Name\tCategory Value\r\n");

try{
$client = new SoapClient("http://demo.intuview.com/AllInOneWeb/IntuViewWS.wsdl", array('encoding'=>'UTF-8'));
} catch (Exception $e) {
    echo 'Caught exception in new SoapClient: ',  $e->getMessage(), "\n";
}

foreach (scandir ($folderName) as $file)
{
	unset($result);
	unset($request);
	$fullPath = $folderName . "/" . $file;
	if (!is_file($fullPath))
		continue;
	
	echo "analyzing $file\r\n";
	
	$request = new stdClass();
	$request->Request = new StdClass();
	$request->Request->username = "Samsung";
	$request->Request->password = "5g@#sNST^aNsd";
	
	$request->Request->text = file_get_contents($fullPath);
	$request->Request->fileName = $file;
	
	try{
		$result = $client->__soapCall("AnalyzeFileAsRDF", array($request));
	} catch (Exception $e) {
	    echo 'Caught exception: ',  $e->getMessage(), "\n";
	}
	echo "RDF result length: " . strlen($result->Result) . "r\rn";
	if ($result->Error)
		echo "Error: " . $result->Error . "\r\n";

	//parsing the result
	$xml = new DOMDocument();
	$loadRes = $xml->loadXml(utf8_encode($result->Result));
	if (!$loadRes)
	{
		echo "Error: failed to load result as xml\r\n";
		continue;
	}
	
	$tripples = $xml->getElementsByTagName("FileTriples")->item(0);
	$rdfContent = $tripples->getElementsByTagName("DigestRDF")->item(0)->firstChild->wholeText;
	//parsing digest RDF
	$xmlDom = new DOMDocument();
	$xmlDom->loadXML($rdfContent);
	$iv = "http://www.intuview.com/ontology#";
	$xpathDom = new DOMXpath($xmlDom);
	//fetching document model
	$docModel = $xpathDom->evaluate("/rdf:RDF/rdf:Description[rdf:type/@rdf:resource='{$iv}Document-model']")->item(0);
	//iterating topic and domain
	foreach (array("document-topic", "domain") as $category)
	{
		$elements = $docModel->getElementsByTagName($category);
		if (!$elements || ! $elements->length)
		{
			echo "no elements for $category\r\n";
			continue;
		}
		//creating array - if not already multiple results
		$element = $elements->item(0);
		if ($element->hasChildNodes())
			$valueElements = $element->firstChild->childNodes;
		else
			$valueElements = array($element);

		//iterating value elements array
		foreach ($valueElements as $valElem)
		{
			$value = $valElem->getAttribute("rdf:resource");
			if (!$value) echo "Error: value is empty for $category\r\n";
			
			//beautifying value
			$value = str_replace($iv, "", $value);
			$value = str_replace("-topic-concept", "", $value);
			$value = str_replace("-domain-parameter", "", $value);
			//saving results to output file
			file_put_contents($outputFile, "$file\t$category\t$value\r\n", FILE_APPEND);
		}
	}
}

?>
