<?php
require_once 'demosettings.php';
require_once 'write_log.php';
require_once 'sqlUtils.php';

//class flavor
class Users{
    private $mysqli = "";
    
    public function __construct($mysqli) {   
        $this->mysqli = $mysqli;
    }
    
    /**
     * restore_user to default
     * @param unknown $this->mysqli
     * @param unknown $username
     */
    function getAllUsers(){
        $resulsts = array();
        $sql = "SELECT Username, Email, Group_ID  FROM userCake_Users";
        $res = sqlQuery($this->mysqli,$sql);
        while($res && $row = $res->fetch_object()){
            $inner_res = [];
            $inner_res["username"] = $row->Username;
            $inner_res["email"] = $row->Email;
            $inner_res["role"] = $row->Group_ID;
            $resulsts[] = $inner_res;
            
        }
        return $resulsts;
        
    }
    
    
    /**
     *
     * @param unknown $mysqli
     * @return string[]|mixed[]
     */
    function addUser(){
        $requestPayload = file_get_contents('php://input');
        $user_info = json_decode($requestPayload, true);
        require_once 'sqlTable.php';
        $email = trim($user_info["email"]);
        $username = trim($user_info["username"]);
        $password = trim($user_info["password"]);
        $confirm_pass = trim($user_info["passwordc"]);
        $roleSelect = trim($user_info["RoleSelect"]);
        $return = registerNewUser($this->mysqli, $username, $password, $confirm_pass, $email, $roleSelect);
        if(empty($return)){
            $return = array("success"=>"Added the user");
        }
        return $return;
        
    }
    
    /**
     * restore_user to default 
     * @param unknown $this->mysqli
     * @param unknown $username
     */
    function restore_user($username){
        require_once 'sqlTable.php';
        $this->remove_user($username);
        addNewUser($this->mysqli, $username);
        
    }
    
    
    /**
     *remove the user from the relevant places
     * @param unknown $this->mysqli
     * @param unknown $username
     */
    function remove_user($username, $include_usercake = false){
        //A - remove all rows from search & savedsearchid & savedsearch
        $removeUserSQL = "DELETE FROM search WHERE username='$username'";
        sqlQuery($this->mysqli,$removeUserSQL);
        
        $removeUserSQL = "DELETE FROM savedsearchid WHERE id IN(SELECT id FROM savedsearch WHERE username='$username')";
        $res = sqlQuery($this->mysqli,$removeUserSQL);
        
        $removeUserSQL = "DELETE FROM savedsearch WHERE username='$username'";
        $res = sqlQuery($this->mysqli,$removeUserSQL);
        
        //B - update foldertree rows to "Admin"
        $sql = "(SELECT id FROM foldertree WHERE username='admin' AND Name='removed_users')";
        $res = sqlQuery($this->mysqli,$sql);
        $row = $res->fetch_object();
        
        $sql = "UPDATE foldertree  SET NAME = CONCAT(NAME,'_$username'), ParentId = $row->id WHERE username='$username'";
        $res = sqlQuery($this->mysqli,$sql);
        
        //C - remove from dashboard & dashboard Panles the relevant rows
        $removeUserSQL = "DELETE FROM dashboard WHERE username='$username'";
        sqlQuery($this->mysqli,$removeUserSQL);
        $sql = "DELETE FROM dashboard_panels WHERE username='$username'";
        $res = sqlQuery($this->mysqli, $sql);
        
        //D - remove from user_status the rows
        $sql = "DELETE FROM user_status WHERE username='$username'";
        $res = sqlQuery($this->mysqli, $sql);
        
        //E - remove from locked files
        $sql = "DELETE FROM lockedfiles WHERE user='$username'";
        $res = sqlQuery($this->mysqli, $sql);
        
        //F - remove the Tags
        $tag_class = new Tags($this->mysqli, $username);
        $tag_class->removeFromTree();
        
        //G - update aggergation to admin
        $sql = "UPDATE entitiesmanage SET username='admin' WHERE username='$username' ";
        $res = sqlQuery($this->mysqli,$sql);
        
        //H - upremove user from usercake (not for restoring user)
        if($include_usercake){
            $sql = "DELETE FROM userCake_Users WHERE Username='$username'";
            $res = sqlQuery($this->mysqli,$sql);
        }
    }
    
    
}