<?php
if(!isset($_SESSION)) session_start();
require_once("demosettings.php");
require_once("EmailAddressParser.php");
require_once("loginCheckPoint.php");
include_once 'write_log.php';
require_once 'sparql.php';
require_once 'parseUtils.php';
include 'analayzeFile.php';

//Write session data and end session
session_write_close();

function insertFile($mysqli, $contents,$filePath,$file_name,$port,$type,$username, $dest_folder = null, $dest_folder_id = null){
    global $CURRENT_SOURCE_FOLDER,$PHP_FOLDER, $isLangOverride;	
    $intuscanHost = getSystemSettingsProp($mysqli, "intuscanHost");
    $getmetadata = $_REQUEST["getmetadata"] ?? false;
	$contents = appendHackingWords($contents, $filePath);
	write_to_log("INFO", "senddocEngAjx - analyze type - $type file - " . $filePath . DIRECTORY_SEPARATOR . $file_name);
	$arr = analayzeFile($mysqli, $contents,$file_name,"" , null, null, null, $type, null, null, $_REQUEST['timeoutSec'] ?? null, $dest_folder_id);	
	dumpDbg("analayzeFile_result", $arr);
	if ($arr === false || empty($arr) || $arr === "timeout" || !is_array($arr) || !array_key_exists("docId",$arr)){		
		write_to_log("ERROR", "senddocEngAjx - problem analyze type - $type file - " . $arr);
		return;
	}elseif (0 > ($arr["docId"])){
		write_to_log("ERROR", "senddocEngAjx - problem analyze type - $type file - docId");
		return;
	}
	else{	
	    $pBacks = asyncRequst::getInstance()->backgroundAsync($arr, $getmetadata); 
	   write_to_log("INFO", "senddocEngAjx started backgroundAsync: " . print_r($pBacks, true));
	}	
	$sql = "UPDATE files SET results=\"\""; 			
	$timeStamp = microtime();
	$sql = "UPDATE files
	    SET timeStamp = '$timeStamp _ $intuscanHost'   
	    WHERE id=" . $arr["docId"];
	   
	$res = sqlQuery($mysqli, $sql);
	if($res != TRUE){
		sleep(1);
		write_to_log("WARNING", "senddocEngAjx Update timeStamp failed");
		$res = sqlQuery($mysqli, $sql);
		if($res != TRUE){
			write_to_log("ERROR", "senddocEngAjx Update timeStamp failed");			
		}
	}			
	$defaultLanguage = null;
	addMoreData($mysqli,$arr["docId"],null,"NULL",$file_name,$username, $defaultLanguage);
	
	

	//if $dest_folder_id defined return him
	if (!empty($_REQUEST["Angular"]) || !empty($_REQUEST["v2"])){
	    $response["fname"] =  $dest_folder ?? null;
	    $response["filename"] =  $file_name ?? null;
	    
	    $response["dcid"] = $response["docId"] =  $arr["docId"];
	    ob_clean();
	    return $response;
	}else{
	    header("Location: PageLoader.php?PageName=document&dcid=" . $arr['docId'] );
	}
	    
}

//return true if insertUniqueDocToDB
function addMoreData($mysqli,$id,$dateValue,$emailId,$line,$username, &$defaultLanguage){
    global $skipDuplicate, $supported_formats;
	//Add file type and file format (extention)
	$file_format = null;						
	if ($emailId == "NULL"){
		$file_type = "file";
		$file_format = pathinfo($line);
		//write_to_log("ERROR", "path info of $line is:" . print_r($file_format, true));
		$file_format = in_array(strtolower($file_format['extension']), $supported_formats)? strtolower($file_format['extension']) : "unsupported format";
	}else{
		if (isFileNameEmailBody($line)){
			$file_type = "Message";
		}elseif (isFileNameEmailMessage($line)){
			$file_type = "Body";
		}else{
			$file_type = "Attachment";
			$file_format = pathinfo($line);
			$file_format = strtolower($file_format['extension']);
		}							
	}
	if (empty($file_format)) {
            $file_format = "txt";
        }

	
	$query = "INSERT INTO file_format (docId,value)
			  VALUES (\"$id\",\"$file_format\")";
	sqlQuery($mysqli, $query);
	$query = "INSERT INTO file_type (docId,value)
			  VALUES (\"$id\",\"$file_type\")";
	sqlQuery($mysqli, $query);	
	//write_to_log("TRACE", "updating file format - $file_format and file type - $file_type for doc id $id: $sqlString");
	//sqlQuery($mysqli, $sqlString);				

	
	//update duplicate
	$isDuplicate = updateSHA1($mysqli, $id, $emailId);
	
	if ($isDuplicate != false && $skipDuplicate === true){
		updateUniqueDocToDB($mysqli, $isDuplicate);
		return false;
	}else{
       insertUniqueDocToDB($mysqli, $id, $dateValue, $username);
        return true;
	}
}


/**
 * V2 ONLY - Upload files process (text url files and folder)
 */

function uploadFilesProcess($mysqli, $isAdmin){
    global $UPLOADS_PATH;
    $username = $_SESSION['username'];
    
    if (!is_dir($UPLOADS_PATH)){
        mkdir($UPLOADS_PATH);
    }
    
    $data = file_get_contents('php://input');
// $data = "{\"text\":\"this is america\",\"attach\":[{\"id\":\"Refer to management\",\"name\":\"Refer to management\",\"exclusive\":true,\"children\":[{\"id\":\"Refer\",\"name\":\"Refer\",\"checked\":false},{\"id\":\"Do not refer\",\"name\":\"Do not refer\",\"checked\":false}]},{\"id\":\"Priority\",\"name\":\"Priority\",\"exclusive\":true,\"children\":[{\"id\":\"High\",\"name\":\"High\",\"checked\":false},{\"id\":\"Medium\",\"name\":\"Medium\",\"checked\":false},{\"id\":\"Low\",\"name\":\"Low\",\"checked\":true}]},{\"id\":\"Review\",\"name\":\"Review\",\"exclusive\":false,\"children\":[{\"id\":\"Reviewed\",\"name\":\"Reviewed\",\"checked\":false}]},{\"id\":\"Projects\",\"name\":\"Projects\",\"exclusive\":false,\"children\":[{\"id\":\"Project A\",\"name\":\"Project A\",\"checked\":true},{\"id\":\"Project B\",\"name\":\"Project B\",\"checked\":false},{\"id\":\"Project C\",\"name\":\"Project C\",\"checked\":false}]},{\"id\":\"Follow up\",\"name\":\"Follow up\",\"exclusive\":false,\"children\":[{\"id\":\"Team A\",\"name\":\"Team A\",\"checked\":false},{\"id\":\"Team B\",\"name\":\"Team B\",\"checked\":false},{\"id\":\"Team C\",\"name\":\"Team C\",\"checked\":false}]},{\"id\":\"Topics\",\"name\":\"Topics\",\"exclusive\":false,\"children\":[{\"id\":\"Economy\",\"name\":\"Economy\",\"checked\":false},{\"id\":\"Politics\",\"name\":\"Politics\",\"checked\":false},{\"id\":\"Terrorism\",\"name\":\"Terrorism\",\"checked\":false}]},{\"id\":\"Food\",\"name\":\"Food\",\"exclusive\":false,\"children\":[{\"id\":\"Water\",\"name\":\"Water\",\"checked\":false}]},{\"id\":\"System\",\"name\":\"System\",\"children\":[{\"id\":\"upload_text\",\"name\":\"upload_text\",\"checked\":true}]}]}";    

    $data = preg_replace("!\r?\n!", "   ", $data);
    
    $sent_data = json_decode($data,1); //data from request payload from the UI
    $_REQUEST['isEmail'] = $sent_data['emailCorrespondences'];
    
    //send the attach over the Session for further setup
    if(!empty($sent_data['attach'])){
        $_SESSION['attach'] = $sent_data['attach'];
    }
    if(!empty($sent_data['getmetadata'])){
        $_REQUEST['getmetadata'] = $sent_data['getmetadata'];
    }
    
    $analyse_text_ref = $sent_data["text"] ?? null;
    $analyse_url_ref = $sent_data["url"] ?? null;
    $files_ref_bool = isset($sent_data['fileContent']);
    
    if(!empty($analyse_text_ref)){
        $response = analyseText($mysqli, $UPLOADS_PATH, $analyse_text_ref,$username);
    }
    elseif(!empty($analyse_url_ref)){
        $response = analyseURL($mysqli, $UPLOADS_PATH, $analyse_url_ref,$username);
    }
    elseif($files_ref_bool){
        $response = analyseSingleFile($mysqli, $sent_data, $username, $isAdmin);
    }

    if(isset($_REQUEST['getmetadata']) && $_REQUEST['getmetadata']){
        $sql = "SELECT metadata FROM metadata WHERE docid=$response[dcid]";
        $res = sqlQuery($mysqli, $sql);
        $obj = $res->fetch_object();
        $results_decoded = base64_decode($obj->metadata);
        $results_decompressed = gzuncompress($results_decoded);
//         $results_arr = json_decode($results_decompressed, true);
        
        $response["metadata"] = $results_decompressed;
    }
    return $response;
    
}

/**
 * analyseText
 * @param unknown $mysqli
 * @param unknown $UPLOADS_PATH
 * @param unknown $analyse_text_ref
 */
function analyseText($mysqli, $UPLOADS_PATH, $analyse_text_ref,$username){
    global $port, $UPLOADS_PATH;
    $file_path = $UPLOADS_PATH;
    
    $file_name = date("YmdHis") . ".txt";
    
    if (!is_dir($file_path)){
        mkdir($file_path);
    }
    
    //save the file with UTF8 BOM - for giving IntuScan a hint of the encoding
    $content = UTF8_BOM . $analyse_text_ref;
    file_put_contents($file_path. DIRECTORY_SEPARATOR . $file_name, $content);
    write_to_log("INFO", "senddocEngAjx line 209 - analyze file - $file_name");
    $res = insertFile($mysqli, $content,$file_path,$file_name,$port,"textBox",$username);
    return $res;
}
	
/**
 * analyseURL
 * @param unknown $mysqli
 * @param unknown $UPLOADS_PATH
 * @param unknown $analyse_url_ref
 */
function analyseURL($mysqli, $UPLOADS_PATH, $analyse_url_ref,$username){
    global $port, $UPLOADS_PATH;
    
	$file_path = $UPLOADS_PATH;
	$file_name = date("YmdHis") . ".html";
	
	if (!is_dir($file_path)){
	    mkdir($file_path);
	}
	
	$url = $analyse_url_ref;		
	
	$data = file_get_contents($url);
	
	file_put_contents($file_path. DIRECTORY_SEPARATOR . $file_name, $data);	
	$res = insertFile($mysqli, $data,$file_path,$file_name,$port,"url",$username);
    return $res;
}
	
/**
 * analyseSingleFile
 * @param unknown $mysqli
 * @param unknown $sent_data
 * @param unknown $username
 */
function analyseSingleFile($mysqli, $sent_data, $username, $isAdmin){
    global $port, $UPLOADS_PATH;
    
    //create dest_folder for single upload files batch and add it to folder tree & create dir if not exists
    $dest_folder = $_REQUEST["folder"];
//     $seconds = $mil / 1000;
    if(empty($dest_folder)){
        $dest_folder = date("d_m_Y_H_i_s", time()).'_'.$username;
    }
//     $dest_folder = $username.'_'.$date;
    
    $res = sqlQuery($mysqli, "SELECT id FROM foldertree WHERE name='uploadedFiles' AND username='$username'");
    $row = $res->fetch_object();
    $parent_id = $row->id;
    
    $res = sqlQuery($mysqli, "INSERT INTO foldertree(Name, ParentId, username) VALUES('$dest_folder', $parent_id, '$username') ON DUPLICATE KEY UPDATE id=id");
    
    $UPLOADS_PATH_FOLDER = $UPLOADS_PATH .DIRECTORY_SEPARATOR . $dest_folder;
    
    if (!is_dir($UPLOADS_PATH_FOLDER)){
        mkdir($UPLOADS_PATH_FOLDER);
    }
    
    //fetch the last f_id of v2 folder
    $res = sqlQuery($mysqli, "SELECT max(id) as id FROM foldertree WHERE name='$dest_folder' AND username='$username'");
    $row = $res->fetch_object();
    $dest_folder_id = $row->id;
    
    //fetch the incoming data from new UI
    $file_name =  $sent_data["fileContent"]["fileData"]["name"];
    $contents = base64_decode($sent_data["fileContent"]["content"]);
    $filePath = $dest_folder . DIRECTORY_SEPARATOR . $file_name;
    $split =   $sent_data['split'] ?? null;
    
 
    $ext = pathinfo($filePath, PATHINFO_EXTENSION);
    $file_path = $UPLOADS_PATH_FOLDER;
    $full_folder_file_name = $UPLOADS_PATH_FOLDER . DIRECTORY_SEPARATOR . $file_name;
    $full_file_name = $UPLOADS_PATH . DIRECTORY_SEPARATOR . $file_name;
    
    placeFileUploadData($full_folder_file_name, $ext, $contents);
    placeFileUploadData($full_file_name, $ext, $contents);
	
	//special care for split PDF checkbox
	if($split && $ext == 'pdf'){
	    $res = splitFilesDocProcess($mysqli, $isAdmin, $UPLOADS_PATH, $file_name, $filePath, $dest_folder);
	}
	else{
	    $res = insertFile($mysqli, $contents,$file_path,$filePath,$port ?? null,"uploadedFiles",$username, $dest_folder, $dest_folder_id ?? null);
	}
	
    return $res;
} 

function placeFileUploadData($full_file_name, $ext, $contents){
    global $UPLOADS_PATH;
    if (file_exists($full_file_name)) {
        $success = false;
    }
    else {
        $success = file_put_contents($full_file_name, $contents);
    }
    
    //if failed retry using date as filename (can happend if file already exists, or other failure such as filename contains unicode characters)
    if ($success === false)
    {
        $file_name = date("YmdHis") . ".$ext";
        $full_file_name = $UPLOADS_PATH . DIRECTORY_SEPARATOR . $file_name;
        file_put_contents($full_file_name, $contents);
    }
}

function splitFilesDocProcess($mysqli, $isAdmin,  $UPLOADS_PATH, $file_name, $filePath, $dest_folder){
    global $uploadedFilesPath;
    require_once 'sendFolder_v2.php';
    require_once '..'.DIRECTORY_SEPARATOR.'pdfTools.php';
    $pdf_class = new PDFTools();
    
    $pdf_class->split_pdf($UPLOADS_PATH.DIRECTORY_SEPARATOR.$file_name, 'split/');
    rename($UPLOADS_PATH.DIRECTORY_SEPARATOR.$file_name, $UPLOADS_PATH.DIRECTORY_SEPARATOR.$file_name.".original");
    
    $newDirName = $dest_folder.'_'.basename($filePath);
    rename($UPLOADS_PATH, $uploadedFilesPath.DIRECTORY_SEPARATOR.$newDirName);
    
    $attach = json_encode($_SESSION["attach"],true);
    
    $manual_data = "{\"folder\":\"$newDirName\",\"emailCorrespondences\":\"\",\"attach\":$attach}";
    $res = sendFolderProcess($mysqli , $isAdmin, $manual_data);
    return $res;
}

?>