<?php

require_once 'globalArr.php';
require_once 'slotToCaption.php';
require_once 'concept.php';
require_once 'demosettings.php';

require_once 'allConceptsData.php';
 
 /**
  * register - for v2 - new action to register user
  * @param unknown $mysqli
  */
 function register($mysqli){
     require_once 'sqlTable.php';  
     $input = file_get_contents('php://input');
     $sent_data = json_decode($input,1); //json_decode($input,1);    
     $email = trim($sent_data["email"]);
     $username = trim($sent_data["username"]);
     $password = trim($sent_data["password"]);
     $confirm_pass = trim($sent_data["passwordc"]);
     $roleSelect = trim($sent_data["RoleSelect"]);
     $errors = registerNewUser($mysqli, $username, $password, $confirm_pass, $email, $roleSelect);
     if(empty($errors)){
         $errors = array("success" => "Registered User $username successfully");
     }
     return $errors;
 }
 
 function savePanelConfiguration($mysqli, $username)
 {
     require_once 'sqlUtils.php';

     $requestPayload = file_get_contents('php://input');
//      $requestPayload = "{\"id\":\"11\",\"name\":\"Organisations\",\"tab\":\"dashboard\",\"visibility\":true,\"collapsed\":true,\"panelSize\":\"3\",\"panelHeight\":1,\"entity\":\"organizational_identity\",\"chartType\":\"pie\",\"selectedSortBy\":\"amount\",\"maxItems\":\"20\",\"legend\":false,\"search_field\":\"searchOrganization\",
// \"details\": {\"name\": \"Organisations\", \"table\": \"organizational_identity\", \"slices\": 20, \"sort_by\": 0, \"searchField\": \"searchOrganization\", \"display_type\": 0},
// \"sort\":\"1\",\"username\":\"admin\",\"config_panel\":null,\"custom\":null,\"entityId\":\"organizational_identity\",\"panelType\":\"Organisations\",\"searchType\":\"smart\",\"icon\":\"fas fa-sitemap\",\"color\":\"#0764e7\",\"borderColor\":\"#455665\"}";
     $panelConfiguration = json_decode($requestPayload, true);
     
     if($panelConfiguration['tab'] == 'search'){
         return ["error" => "Cant save panel configuration in search view"];
     }
     $where_cond = "id = ".(int)$panelConfiguration['id'];
     if(empty($panelConfiguration['id'])){
         $where_cond = "name=\"overview\"";
     }
     $query = "UPDATE dashboard_panels SET tab = '" . $mysqli->real_escape_string($panelConfiguration['tab']) . 
                "', visibility = " .  (int)$panelConfiguration['visibility'] . 
                ", collapsed = " .  (int)$panelConfiguration['collapsed'] .             
                ", panelSize = " . (int)$panelConfiguration['panelSize'] . 
                ", panelHeight = " . (int)$panelConfiguration['panelHeight'] . 
                ", chartType = '" . $mysqli->real_escape_string($panelConfiguration['chartType']) . 
                "', selectedSortBy = '" . $mysqli->real_escape_string($panelConfiguration['selectedSortBy']) . 
                "', maxItems = " .  (int)$panelConfiguration['maxItems'] . 
                ", legend = " . (int)$panelConfiguration['legend'] . 
                ", sort = " .  (int)$panelConfiguration['sort'] . 
                ", filtered_view = " .  (int)$panelConfiguration['filtered_view'] .
                " WHERE " .  $where_cond . " and username='" . $username . "'";
     $res = sqlQuery($mysqli, $query);

     $json_return['status'] = "ok";
     return $json_return;
}


function showSearchPanels($mysqli,$username){
    $sql = "UPDATE dashboard_panels SET collapsed= NOT collapsed
    WHERE username=\"$username\" AND tab='search'";
    $res = sqlQuery($mysqli, $sql);
    return $res;
    
}

function getPanelsConfiguration ($mysqli,$username, $tab, $visibility = 1)
{
    require_once 'sqlUtils.php';
    
    
    $sql = "SELECT * FROM dashboard_panels WHERE username='" . $username .
    "' and visibility= " . (int)$visibility .
    " and tab= '" . $tab .
                    "' order by sort";
    
    $res = sqlQuery($mysqli, $sql);

    return array("panelsConfiguration" => $res->fetch_all(MYSQLI_ASSOC));
}

function getOverViewConfiguration ($mysqli,$username = 'admin')
{
    require_once 'sqlUtils.php';
    
    
    $sql = "SELECT * FROM dashboard_panels WHERE username='" . $username . "' AND name=\"overview\"";
    
    $res = sqlQuery($mysqli, $sql);
    
    return array("panelsConfiguration" => $res->fetch_all(MYSQLI_ASSOC));
}

function restorePanels($mysqli,$username)
{
    require_once 'sqlUtils.php';
  

    $requestPayload = file_get_contents('php://input');
    $panelConfiguration = json_decode($requestPayload, true);

    $ids = implode(',',$panelConfiguration);

    $query = "UPDATE dashboard_panels SET visibility = 1 WHERE id in (" .  $ids . ") and username='" . $username . "'";

    $res = sqlQuery($mysqli, $query);
    foreach($panelConfiguration as $id){
        $query = "SELECT name FROM dashboard_panels WHERE id = $id";
        
        $res = sqlQuery($mysqli, $query);
        $obj = $res->fetch_object();
        $table = $obj->name;
        CacheEng::refreshPie($mysqli, $username, $table);
    }
  
    $json_return['status'] = "ok";
    return $json_return;
}

function sortPanels($mysqli, $username)
{
    require_once 'sqlUtils.php';


    $requestPayload = file_get_contents('php://input');
    $panelConfiguration = json_decode($requestPayload, true);

    foreach ($panelConfiguration as $key => $value) {
        $query = "UPDATE dashboard_panels SET sort = " . (int)$key . "  WHERE id = " . (int)$value['id'] . " and username='" . $username . "'";
        sqlQuery($mysqli, $query);
    }

    $json_return['status'] = "ok";
    return $json_return;
}

/**
 * getPersonConceptArr - sub function for getSmartSearch - gets person-object matches - via the EM
 * @param unknown $mysqli
 * @param unknown $tables
 * @param unknown $limit_tables
 * @param unknown $value
 * @return string[][]|NULL[][]|mixed[][]|string[]|NULL[]|mixed[]
 */
function getPersonConceptArr($mysqli, $tables, $limit_tables, $value){
    $i = 0;
    $conceptArr = array("id"=> $value, "name" => $value);
    
    $names_arr = [];
    
    global $databaseName;
    $databaseName = strtolower($databaseName);
    $_REQUEST["relationMatching"] = true;
    
    $WLclass = new CompareWLClass($mysqli,"name");
    $response = $WLclass->searchPersonInList($value, "wl_$databaseName", true);
    
    foreach($response as $na){
        if(!empty($na["matching_results"])){
            foreach ($na["matching_results"] as $rule=>$arr){
                $rule_str = ucwords(str_replace('_', ' ', $rule));
                $i++;
                foreach($arr as $data){
                    $inner_name = $data["Name"];
                    if(!in_array($inner_name,$names_arr[$rule_str] ?? [])){
                        if(!array_key_exists($rule_str, $names_arr)){
                            $names_arr[$rule_str] = [];
                        }
                        
                        $names_arr[$rule_str][] = $inner_name;
                    }
                }
                
            }
        }
    }
    
    foreach($names_arr as $rule=>$data){
        $rule_str = ucwords(str_replace('_', ' ', $rule));
        
        $inner_caption = array("name"=>$rule_str,  "id"=>$rule_str.'_'.$i);
        foreach($data as $inner_name){
            $inner_caption['children'][] = array("name"=>$inner_name,  "id"=>$inner_name.'_'.$i);
        }
        $caption[] = $inner_caption;
        
        $i++;
    }
    
    if (! empty($caption)) {
        $element = array();
        $element["id"] = "person_object";
        $table_res = array_search("person_object",$tables);
        if(empty($table_res)){
            $table_res = array_search("person_object",$tables);
        }
        $element["name"] = tableNameToPretty(array_search("person_object",$tables));
        $element["children"] = sortPersonObjectCaptions($caption); //$value_arr
  
    }
  
    return $element ?? null;
}

/**
 * getSmartSearch_v2($mysqli, $table, $value, $limit_tables_id = null)
 * @param unknown $mysqli
 * @param unknown $table
 * @param unknown $value
 * @param unknown $limit_tables_id
 * @return unknown[]|array|string[]|NULL[]|mixed[]|array|string[]|NULL[]|mixed[]|unknown[]|array|string[]|NULL[]|mixed[]|array[][]|string[][][]|NULL[][][]|unknown[][][]
 */
function getSmartSearch_v2($mysqli, $table, $value, $limit_tables_id = null){
    require_once 'sqlUtils.php';
    //$parameters["value"] = "hamas^shlomi";
    global $dropdownArr;
    global $relation_exceptions;
    session_write_close();
    

    if(!empty($limit_tables_id) && $limit_tables_id != 'undefined'){
        $limit_tables = array();
        $limit_tables_ids_arr = empty($limit_tables_id) ? null : explode(',', $limit_tables_id);
        $concept_id_arr = getConceptsIds($mysqli, $limit_tables_ids_arr);
        foreach($concept_id_arr as $element){
            $limit_tables[] = $element['concept'];
        }
    }
    $tables = getTablesSearch($mysqli, $dropdownArr);
    
    //=======================================
    $conceptArr = array("id"=> $value, "name" => $value);
    
    $person_indicator = false; //indicates if we already get person_object getSmartSearch
    
    //handle person object if its in the limit tables (if exists)
    //if(!empty($limit_tables) && in_array('person_object', $limit_tables)){
    //    $person_indicator = true;
        
    //    $element = getPersonConceptArr($mysqli, $tables, $limit_tables, $value);
    //    if(!empty($element)){
    //        $conceptArr["children"][] = $element;
    //    }
        
        //check if this is the only filter - if so - continue
    //    if(!empty($limit_tables) && count($limit_tables) == 1 && $limit_tables[0]=='person_object'){
    //        return $conceptArr;
    //    }    
    //}
    
    //search in manageEntities
    if ($table == "saved")
    {
        $val = $mysqli->real_escape_string($value);
        $sql = "SELECT aggregatedName FROM entitiesmanage WHERE name=\"$val\" AND entity='smart'";
        $res = sqlQuery($mysqli, $sql);
        $conceptArr = $conceptArr ?? array();
        if (!empty($res)){
            $obj = $res->fetch_object();
            $conceptArr = json_decode($obj->aggregatedName, true);
        }
        return $conceptArr;
    }
    
    
    $e = explode("^",$value);
    $i = 0;
    foreach ($e as $searchConcept){
        if (strlen($searchConcept) > 0){
            if (strlen($table) > 0){
                //we don't need to find the table
                $c["concept"][$table] = $table;
                $c["caption"][$searchConcept] = $searchConcept;
            }else{
                //get analyze word
                $c = analyzeWord($searchConcept);
            }
                if (empty($c) || $c == null){
                    $c=array();
                    $c["caption"][$searchConcept] = $searchConcept;
                    $c["concept"] = array("person_object","organizational_identity","place_object","event");
                    write_to_log("ERROR", "getSmartSearch - analyze word return empty ". date('H:i:s'.substr((string)microtime(), 1, 8)));
                }
                if (!array_key_exists(strtolower($searchConcept), $c["caption"] ?? [])){
                    $c["caption"][$searchConcept] = $searchConcept;
                    $c["concept"]["concept"] = "concept";
                }
                $val = implode("','", $c["caption"]);
                foreach ($c["concept"] as $k) {
                    if(!empty($limit_tables) && !in_array($k, $limit_tables)){
                        continue;
                    }
                    $caption = array();
                    if (in_array($k, $tables)){      
                        //if($k=="person_object"){
                        //    if($person_indicator){
                        //        continue;                             
                        //    }
                        //    else{
                        //        $element = getPersonConceptArr($mysqli, $tables, $limit_tables, $value);
                        //        if(!empty($element)){
                        //            $conceptArr["children"][] = $element;
                        //        }
                        //    }
                        //}
                        if ($k == "person_object" || $k == "organizational_identity" || $k == "place_object" || $k == "event" || $k =='abstract_idea_entity'){
                            foreach ($c["caption"] as $c_v){
                                global $entitiesArray;
                                $gArr = getMangeEntities($mysqli, $entitiesArray[$k], $c_v, false, true);
                                $inner_caption = array("name"=>$c_v,  "id"=>$c_v.'_'.$i);
                                $i++;
                                
                                if (sizeof($gArr["rows"]) > 0){
                                    
                                    foreach($gArr["rows"] as $item){
                                        $inner_caption['children'][] = array("name"=>$item, "id"=>$item.'_'.$i);
                                        $i++;
                                    }
                                    $caption[] = $inner_caption;
                                }   
                            }
                        }
                        else{
                            //not relevant for person-object
                            //if($k=="person_object"){
                            //    continue;
                            //}
                            //check if value exsist on table
                            foreach ($c["caption"] as $v){
                                
                                $inner_caption = array();
                                $val = $mysqli->real_escape_string($v);
                                
                                $name = array_key_exists($k, $dropdownArr) ? "value" : 'name';
                                
                                $query = "";
                                if($k == "concept"){
                                    $query = "SELECT DISTINCT docId, dockey FROM $k WHERE $name IN ('$val') OR orgText IN ('$val') LIMIT 1";     
                                }
                                elseif($k == "topic"){
                                    continue;
                                }
                                else{
                                    $query = "SELECT DISTINCT docId, dockey FROM $k WHERE $name IN ('$val') LIMIT 1";
                                }
                                
                                $res = sqlQuery($mysqli, $query);
                                if (!empty($res)){
                                    $obj = $res->fetch_object();
                                    if (!empty($obj) && $obj->docId > 0){
                                        $inner_caption = array("name"=>$v,  "id"=>$v.'_'.$i);
                                        $i++;
                                        $inner_caption['children'][] = array("name"=>$v, "id"=>$v.'_'.$i);
                                        $i++;
                                        //Add related results without general concept
                                        if ($k != "concept" && !array_key_exists(strtolower($k),$relation_exceptions)){
                                            //if the concept is a city - get the city province/state if exists
                                            if($k == "city" || $k=='province'){                                
                                                $inner_caption['children'] = array_merge($inner_caption['children'], handleCityProvince_v2($mysqli, $k, $v, $val, $i));                          
                                            }
                                            else{
                                                
                                                $query = "SELECT * FROM (SELECT DISTINCT name,dockey FROM $k GROUP BY name) AS t ORDER BY name ASC  limit 50";
                                                $res = sqlQuery($mysqli, $query);
                                                if (!empty($res)){
                                                    while ($obj = $res->fetch_object()){
                                                        if ($obj->name != $val){
                                                            $inner_caption["children"] =  array_merge($inner_caption['children'], array(array("name"=>$obj->name, "id"=>$obj->docKey, "related" => true)));
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                if(!empty($inner_caption)){
                                    $caption[] = $inner_caption;
                                }
                                
                            }
                        }
                        if (! empty($caption)) {
                            $element = array();
                            $element["id"] = $k;
                            $table_res = array_search($k,$tables);
                            if(empty($table_res)){
                                $table_res = array_search($k,$tables);
                            }
                            $element["name"] = tableNameToPretty(array_search($k,$tables));
                            $element["children"] = $caption; //$value_arr
                            $conceptArr["children"][] = $element;
                            
                        }
                    }
                }
        }
    }
    
    return $conceptArr;
}

//simple function to place "possible same person" first
function sortPersonObjectCaptions($arr){
    $key = array_search("Possible Same Person", array_column($arr, 'name'));
    
    if(is_bool($key) && $key == false){
        return $arr;
    }
    $possible_same_person_data = [$arr[$key]];
    unset($arr[$key]);
    $res = array_merge($possible_same_person_data, $arr);
    return $res;
}

function handleCityProvince_v2($mysqli, $table, $searchVal, $val, &$counter){
    $ind_name = "";
    $ind_val = "";
    $caption = array();
    $province_arr = $country_arr = [];
    //first - get the province and/or the country that are related to this city/province
    $query = "SELECT * FROM $table WHERE name = '$searchVal' AND (province IS NOT NULL OR country IS NOT NULL)";
    $res = sqlQuery($mysqli, $query);
    if (!empty($res)){
        while ($obj = $res->fetch_object()){
            $province = $obj->province ?? $province;
            $country = $obj->country ?? $country;
            if(!empty($province)){
                if(!in_array($province, $province_arr)){
                    $province_arr[] = $province;
                }
            }
            if(!empty($country)){
                if(!in_array($country, $country_arr)){
                    $country_arr[] = $country;                   
                }
            }
        }
    }
    
    //more accurate - choose province as indicator
    if(!empty($province_arr)){
        $ind_name='province';
        $ind_val = $province_arr;
    }
    else{
        $ind_name = 'country';
        $ind_val = $country_arr;
    }
    
    //fetch results based on the indicator
    $caption = getRelatedPlaces($mysqli, $val, $ind_name, $ind_val, $counter, $table, $searchVal);
    
    //in case no other city in province - get me the coutry level
    if(empty($caption) && $ind_name=="province" && !empty($country)){
        $ind_name = "country";
        $ind_val = $country;
        $caption = getRelatedPlaces($mysqli, $val, $ind_name, $ind_val, $counter, $table, $searchVal);
        
    }
    
    return $caption;
}

function getRelatedPlaces($mysqli, $val, $ind_name, $ind_val, &$counter, $k, $searchVal){
    $caption = [];
    $found_arr = [];
    foreach($ind_val as $val){
        $query = "SELECT * FROM (SELECT DISTINCT name,dockey FROM $k WHERE $ind_name='$val' GROUP BY name limit 50) as t ORDER BY t.name ASC ";
        $res = sqlQuery($mysqli, $query);
        if (!empty($res)){
            while ($obj = $res->fetch_object()){
                if ($obj->name != $searchVal){
                    if(!in_array($obj->name, $found_arr)){
                        $found_arr[] = $obj->name;
                        $caption[] = array("name"=>$obj->name, "id"=>$obj->dockey ?? $k.'_'.$counter, "related" => true);
                        $counter++;
                    }
                    
                }
            }
        }
    }
    
    return $caption;
}

/**
 * delete savedsearch by name - get the id first
 * @param unknown $mysqli
 * @param unknown $username
 * @param unknown $name
 */
function deleteSavedSearch($mysqli, $username, $isAdmin, $name){   
    $id = getFolderIdFromName($mysqli, $name, $username, $isAdmin, true);   
    $response = deleteDirectory($mysqli, $id);
}

/**
 * 
 * @param unknown $mysqli
 */
function SaveRedactionMarks($mysqli){
   $input = file_get_contents('php://input');
   $sent_data = json_decode($input,1); //json_decode($input,1);
   $id = $sent_data['docId'];
   $json = json_encode($sent_data['redactionBoxs'],true);;
    
   $query = "UPDATE files SET redactedJson= '$json' WHERE id=$id";
    
    $res = sqlQuery($mysqli, $query);
    if (!empty($res)){
        return "OK";
    }
    return null;
}

/**
 *
 * @param unknown $mysqli
 */
function getRedactionMarks($mysqli, $docid){
    $query = "SELECT redactedJson FROM files WHERE id=$docid";
    
    $res = sqlQuery($mysqli, $query);
    if (!empty($res)){
        $obj = $res->fetch_object();
        return json_decode($obj->redactedJson);
    }
    return null;
}


/**
 * 
 * @param unknown $mysqli
 * @param string $limit_ids - if you want to fetch ids of specific id and get concept+id format
 * @param unknown $specific_table - if you want to get one id of one table
 * @return unknown|array|unknown
 */
function getConceptsIds($mysqli, $limit_ids = false, $specific_table = null){
    $results = $array =  $res = array();
    
    $specific_table = !empty($specific_table) ? " concept = '$specific_table'" : " TRUE ";
 
    $limit_ids = !empty($limit_ids) ? "id IN ('" . join("','", $limit_ids) . "')" : " TRUE ";
    
    $sql = "SELECT * FROM `concepts_indexes` WHERE $limit_ids AND $specific_table ORDER BY concept";
    
    
    $res = sqlQuery($mysqli,$sql);
    $array  = $res->fetch_all(MYSQLI_ASSOC);
    if(empty($limit_tables)){
        return $array;
    }
    foreach($array as $concept_val){
        $results[$concept_val['id']] = $concept_val["concept"];
    }
    
    return $results;
    
}



function getKeywordTables_v2($mysqli, $allConceptsData)
{
    require_once 'parseUtils.php';
    $default_filters = [];
    foreach($allConceptsData as $element){
        $default_filters[] = TablesInformation::getTableName($element["name"]);
    }
    $results = array();
    $t = getTables($mysqli);
    foreach($t as $filter){
        $filter = TablesInformation::getTableName($filter);
        $id = getidFromConcept($mysqli, $filter);
        
        $results[]= array("name" => $filter, 'id'=> $id, "checked" => in_array($filter, $default_filters) ? 1 : 0);
    }
    return $results;
}

function getRelationsType($mysqli, $username, $merged = false){
    require_once 'parseUtils.php';
    require_once 'settings.php';
    $settings_class =  new Settings($mysqli, $username);
    $allConceptArrDB = $settings_class->getAllConceptsArr();
    $concept_class = new AllConceptsData($mysqli, $allConceptArrDB, null, $username);
    $merged_data = $concept_class::getFlavorDataArr($mysqli, true);
    
    $results = array();
    
    $subject_sql = "SELECT subject_table FROM `inter_entity_relationship` WHERE subject_table <> '' group by subject_table";
    $res = sqlQuery($mysqli,$subject_sql);
    while ($obj = $res->fetch_object()){
        $pretty_name = TablesInformation::getConceptPresentName($obj->subject_table);
        $label = $merged_data[$pretty_name]["digestCaption"] ?? str_replace('-', ' ',$pretty_name);
        $results[$obj->subject_table] = array("id" => $obj->subject_table, "label" => $label);
    }
    
    //return also the object tables, return merged array
    if($merged){
        $object_sql = "SELECT object_table FROM `inter_entity_relationship` WHERE object_table <> ''  group by object_table";
        $res = sqlQuery($mysqli,$object_sql);
        while ($obj = $res->fetch_object()){
            if(array_key_exists($obj->object_table, $results)){
                continue;
            }
            $pretty_name = TablesInformation::getConceptPresentName($obj->object_table);
            $label = $merged_data[$pretty_name]["digestCaption"] ?? str_replace('-', ' ',$pretty_name);
            $results[$obj->object_table] = array("id" => $obj->object_table, "label" => $label);
        }
    }
    return array_values($results);
}

/**
 * 
 * @param unknown $mysqli
 * @param unknown $type - subject_table/object_table
 * @param unknown $type_name
 */
function getRelationsTypesMatch($mysqli, $username, $type, $type_name){
    require_once 'parseUtils.php';
    require_once 'settings.php';
    $settings_class =  new Settings($mysqli, $username);
    $allConceptArrDB = $settings_class->getAllConceptsArr();
    
    $concept_class = new AllConceptsData($mysqli, $allConceptArrDB, null, $username);
    $merged_data = $concept_class::getFlavorDataArr($mysqli, true);
    
    $other_type = $type == "subject_table" ? "object_table" : "subject_table";
    $results = array();
    $subject_sql = "SELECT $other_type FROM `inter_entity_relationship` WHERE $other_type <> '' AND $type = '$type_name' group by $other_type";
    $res = sqlQuery($mysqli,$subject_sql);
    while ($obj = $res->fetch_object()){
        $pretty_name = TablesInformation::getConceptPresentName($obj->$other_type);
        $label = $merged_data[$pretty_name]["digestCaption"] ?? str_replace('-', ' ',$pretty_name);;
        $results[] = array("id" => $obj->$other_type, "label" => $label);

    }
    return $results;
}

function getDropDownTables($tables){
    global $dropdownArr;
    foreach ($dropdownArr as $k=>$v){
        $tables[$v] = $k;
    }
    return $tables;
}

function getDetailsForSmartSearch_v2_old($mysqli, $username, $param_json){
    global  $all_search_pies, $scale_fields, $phones_accounts, $dropdownArr;
    $isOrgText = getSystemSettingsProp($mysqli, "isOrgText");
    
    //for saving data to manageEntities
    $tables = getTables($mysqli);
    $tables = getDropDownTables($tables);
    $param = json_decode($param_json, true);
    
    
    $regular = array();
    $tab_i = 0;
    $entityParmeters = [];
    foreach ($param as $tab => $arr){
        
        if(isset($arr["regular"])){
            foreach ((array)$arr["regular"] as $t => $n){
                //if string as value
                
                if (!is_array($n) && strlen($n) > 0 || array_key_exists($t, $all_search_pies)){
                    $table = $t; //just for the savedsearch values
                    $table_info = $t;
                    $value_info = $n;
                    if($t=="searchOther"){
                        $concept_val = explode('=', $n);
                        $table_info = $concept_val[0];
                        $value_info = $concept_val[1];
                    }
                    $entityParmeters[$table_info][$value_info] = $value_info;
                    
                    if ($t == "searchSentiment"){
                        $e = explode("^", $n);
                        $type = $e[1];
                        $value = $e[2];
                        $entityParmeters[$type][$value] = $value;
                    }
                    
                    //for savedSearch alone only!
                    if(array_key_exists($t, $regular)){
                        $searchParameters[$tab_i]["regular"][$t] .= "&$n";
                    }
                    else {
                        $searchParameters[$tab_i]["regular"][$t] = "$n";
                    }
                }
                elseif(!empty($t) && empty($n)){
                    die("Empty search values for $t - stopping");
                }
                //if array as value
                elseif (sizeof($n) > 0){
                    if ( in_array($t,array_merge($scale_fields, $phones_accounts, array("searchOther", "searchRelation", "searchSlots", "searchSentiment")))){
                        $searchParameters[$tab_i]["regular"][$t] = $n;
                    }
                }
            }
        }
        $arrName = array();
        if(isset($arr["smart"])){
            foreach ((array)$arr["smart"] as $k_n => $v_n){
                $first_union = true;
                foreach ($v_n as $k => $v){
                    $name =  (array_key_exists($k, $dropdownArr)) ? "value" : "name";
                    
                    if (strlen($v) > 0){
                        $entityParmeters[$k][$k_n] = $v;
                        if ($first_union){
                            $first_union = false;
                        }
                        
                        $v = explode("^",$v);
                        $val = "";
                        $f = false;
                        $saveVal = array();
                        foreach ($v as $vv){
                            if (strlen($vv) > 0){
                                if ($f)
                                    $val .= ",";
                                    else{
                                        $f = true;
                                    }
                                    $val .= "'" . $mysqli->real_escape_string($vv) . "'";
                                    $saveVal[] = $vv;
                            }
                        }
                        $tableAndCaption[][$k] = $val;
                        $arrName[$k_n][$k] = $saveVal;
                    }
                    $name_pred = !empty($val) ? "$name IN ($val)" : 'TRUE';
                    if($name=="name" && $isOrgText && !empty($val)){
                        $name_pred .= " OR orgText IN($val)";
                    }
                    if($k == "group_trend"){
                        $name_pred .= " AND username='". $_SESSION["username"]."'";
                    }
                    $searchParameters[$tab_i]["smart"][] = " SELECT DISTINCT docId FROM $k WHERE $name_pred";
                    
                }
                //insert search to manageentities table
                if (sizeof($arrName) > 0){
                    foreach ($arrName as $name => $v){
                        $name = $mysqli->real_escape_string($name);
                        
                        //delete old one
                        $res = $mysqli->query("DELETE FROM entitiesmanage WHERE name=\"$name\" AND entity='smart'");
                        $conceptArr = array();
                        foreach ($v as $k => $vv){
                            $conceptArr[$name][$k]["key"] = $k;
                            
                            $conceptArr[$name][$k]["value"][$name] = $vv;
                            
                            $caption = array_search($k,$tables);
                            if (strlen($caption) < 1)
                                $caption = str_replace("_"," ",$k);
                                $conceptArr[$name][$k]["caption"] = $caption;
                        }
                        $json = json_encode($conceptArr);
                        $val = $mysqli->real_escape_string($json);
                        $sql = "INSERT INTO entitiesmanage (entity,name,aggregatedName)
                        VALUES (\"smart\",\"$name\",\"$val\")";
                        $res = $mysqli->query($sql);
                    }
                }
            }
        }
        
        if(!empty($arr["not"])){
            $searchParameters[$tab_i]["not"] = true;
        }
        $tab_i++;
    }
    
    $entityParmetersArr = array();
    foreach ($entityParmeters as $t => $arr_n){
        foreach ($arr_n as $k => $v){
            $entityParmetersArr[$t][] = $v;
        }
    }
    
    $ret["searchParameters"] = $searchParameters ?? null;
    $ret["entityParmetersArr"] = $entityParmetersArr ?? null;
    $ret["tableAndCaption"] = $tableAndCaption ?? null;
    $ret["savedSearchName"] = $savedSearchName ?? null;
    
    return $ret;
}


function getDetailsForSmartSearch_v2($mysqli, $username, &$param_json){
    global  $all_search_pies, $scale_fields, $phones_accounts, $dropdownArr;
    $isOrgText = getSystemSettingsProp($mysqli, "isOrgText");
    
    //for saving data to manageEntities
    $tables = getTables($mysqli);
    $tables = getDropDownTables($tables);
    $param = json_decode($param_json, true);
    
    
    $regular = array();
    $tab_i = 0;
    $entityParmeters = [];
    $savedSearchMerge = []; // if we have savedsearch as parameter - take this & merge with new
    foreach ($param as $tab => $arr){
        
        if(isset($arr["regular"])){
            foreach ((array)$arr["regular"] as $t => $n){
                
                //if we encounter with searchSavesearch - keep the parameters of the search in $savedSearchMerge
                //unset the param so it wont be count after 
                if ($t == "searchSavesearch" && $n !== "Last search"){  
                    $info = getSavedSearch($mysqli, false, $n);
                    $savedSearchMerge = getDetailsForSmartSearch_v2($mysqli, $username, $info[0]["parameters"]);                    
                    unset($param[$tab]);
                    $param_json = json_encode($param, true);
                    continue;
                }
                
                if (!is_array($n) && strlen($n) > 0 || array_key_exists($t, $all_search_pies)){
                    $table = $t; //just for the savedsearch values
                    $table_info = $t;
                    $value_info = $n;
                    if($t=="searchOther"){
                        $concept_val = explode('=', $n);
                        $table_info = $concept_val[0];
                        $value_info = $concept_val[1];
                    }
                    $entityParmeters[$table_info][$value_info] = $value_info;
                    
                    if ($t == "searchSentiment"){
                        $e = explode("^", $n);
                        $type = $e[1];
                        $value = $e[2];
                        $entityParmeters[$type][$value] = $value;
                    }
                    
                    //for savedSearch alone only!
                    if(array_key_exists($t, $regular)){
                        $searchParameters[$tab_i]["regular"][$t] .= "&$n";
                    }
                    else {
                        $searchParameters[$tab_i]["regular"][$t] = "$n";
                    }
                }
                elseif(!empty($t) && empty($n)){
                    die("Empty search values for $t - stopping");
                }
                    //if array as value
                elseif (sizeof($n) > 0){
                    if ( in_array($t,array_merge($scale_fields, $phones_accounts, array("searchOther", "searchRelation", "searchSlots", "searchSentiment")))){
                        $searchParameters[$tab_i]["regular"][$t] = $n;
                    }
                }
            }
        }
        $arrName = array();
        if(isset($arr["smart"])){
            foreach ((array)$arr["smart"] as $k_n => $v_n){
                $first_union = true;
                foreach ($v_n as $k => $v){
                    $name =  (array_key_exists($k, $dropdownArr)) ? "value" : "name";
                   
                    if (strlen($v) > 0){
                        $entityParmeters[$k][$k_n] = $v;  
                        if ($first_union){
                            $first_union = false;
                        }
                            
                        $v = explode("^",$v);
                        $val = "";
                        $f = false;
                        $saveVal = array();
                        foreach ($v as $vv){
                            if (strlen($vv) > 0){
                                if ($f)
                                    $val .= ",";
                                    else{
                                        $f = true;
                                    }
                                    $val .= "'" . $mysqli->real_escape_string($vv) . "'";
                                    $saveVal[] = $vv;
                            }
                        }
                        $tableAndCaption[][$k] = $val;
                        $arrName[$k_n][$k] = $saveVal;
                    }
                    $name_pred = !empty($val) ? "$name IN ($val)" : 'TRUE';
                    if($name=="name" && $isOrgText && !empty($val)){
                        $name_pred .= " OR orgText IN($val)";
                    }
                    if($k == "group_trend"){
                        $name_pred .= " AND username='". $_SESSION["username"]."'";
                    }
                    $searchParameters[$tab_i]["smart"][] = " SELECT DISTINCT docId FROM $k WHERE $name_pred";
                    
                }
                //insert search to manageentities table
                if (sizeof($arrName) > 0){
                    foreach ($arrName as $name => $v){
                        $name = $mysqli->real_escape_string($name);
                        
                        //delete old one
                        $res = $mysqli->query("DELETE FROM entitiesmanage WHERE name=\"$name\" AND entity='smart'");
                        $conceptArr = array();
                        foreach ($v as $k => $vv){
                            $conceptArr[$name][$k]["key"] = $k;
                            
                            $conceptArr[$name][$k]["value"][$name] = $vv;
                            
                            $caption = array_search($k,$tables);
                            if (strlen($caption) < 1)
                                $caption = str_replace("_"," ",$k);
                                $conceptArr[$name][$k]["caption"] = $caption;
                        }
                        $json = json_encode($conceptArr);
                        $val = $mysqli->real_escape_string($json);
                        $sql = "INSERT INTO entitiesmanage (entity,name,aggregatedName)
                        VALUES (\"smart\",\"$name\",\"$val\")";
                        $res = $mysqli->query($sql);
                    }
                }
            }
        }
        
        if(!empty($arr["not"])){
            $searchParameters[$tab_i]["not"] = true;
        }
        $tab_i++;
    }
    
    $entityParmetersArr = array();
    foreach ($entityParmeters as $t => $arr_n){
        if($t=="searchSavesearch"){
            continue;
        }
        foreach ($arr_n as $k => $v){
            $entityParmetersArr[$t][] = $v;
         }            
    }
    
    //if we encounter erlier in $savedSearchMerge - merge the params from $savedSearchMerge in the current params
    if(!empty($savedSearchMerge)){

        $ret["searchParameters"] = 
        array_merge($savedSearchMerge["searchParameters"] ?? [], $searchParameters ?? []);
        $ret["entityParmetersArr"] = 
        array_merge($savedSearchMerge["entityParmetersArr"]?? [], $entityParmetersArr ?? []);
        $ret["tableAndCaption"] = 
        array_merge($savedSearchMerge["tableAndCaption"]?? [], $tableAndCaption ?? []);
        foreach($savedSearchMerge["orgInput"] as $k=>$v){           
            $param[] = $v;
        }
        $param_json = json_encode($param,true); //upadate hte param_json to have the new value
    }
    else{
        $ret["searchParameters"] = $searchParameters ?? null;
        $ret["entityParmetersArr"] = $entityParmetersArr ?? null;
        $ret["tableAndCaption"] = $tableAndCaption ?? null;
        $ret["orgInput"] = $param ?? null;
    }

    
    
    return $ret;
}

function applySmartSearch_v2($mysqli, $username, $param, $ignore_limit=null, $numberToFetch=null, $offset=null){
    //     $param = "{\"0\":{\"smart\":{\"Steve Mosko\":{\"person_object\":\"Steve Mosko\"}}}}";    
    write_to_log("INFO", "$username: search query: $param");
    session_write_close();
    
    $res = getDetailsForSmartSearch_v2($mysqli, $username, $param);
    $_REQUEST["search_function"] = true;
    //1 - if it's a download csv with all files (more than 500 limit) action
    if($ignore_limit){
        searchWithoutLimit($mysqli, $res);
    }
    else
    {
        require_once 'searchEng.php';
        //2 - if it's an numberToFetch offset request search (for scrolling down results)
        if(isset($offset) && isset($numberToFetch)){
            die(search($mysqli,  $res["savedSearchName"] ?? null, $res["searchParameters"], $res["entityParmetersArr"], $res["tableAndCaption"], $param, false, $numberToFetch, $offset));
        }
        //3 -  if it's a regular search action
        else{
            die(search($mysqli, $res["savedSearchName"] ?? null, $res["searchParameters"], $res["entityParmetersArr"], $res["tableAndCaption"], $param));
        }
    }
}

//API for clickhtru
function clickThruFunc_v2($mysqli, $username, $params){
    $params = json_decode($params, true);
    $savedSearch = getSavedsearchClickThru($mysqli, $params) ?? "Last Search";
    $params[] = array("regular"=>array("searchSavesearch"=>$savedSearch));
    
    $params = json_encode($params, JSON_FORCE_OBJECT);
    return applySmartSearch_v2($mysqli, $username, $params);
}

function fetchMoreSearchResults_v2($mysqli, $username){
    $param = get_Params($mysqli, $_SESSION['username']);
    $numberToFetch = $_REQUEST['numberToFetch'];
    $offset = $_REQUEST['offset'];
    return applySmartSearch_v2($mysqli, $username, $param,false, $numberToFetch, $offset);
}

function getFolderMetaData($mysqli, $username, $fid, $intuview_info = false){
    global $UPLOADS_PATH;
    
    global $sharedFolder;
    $date = date('m_d_Y_h_i_s', time());
    $outputpath = $sharedFolder . DIRECTORY_SEPARATOR . 'exported_files' . DIRECTORY_SEPARATOR . $date;
    
    mkdir($outputpath);
    
    $sql = "SELECT docid,metadata FROM metadata WHERE docid IN(SELECT id FROM files WHERE parentFolderId=$fid AND username=\"$username\")";
    $res = sqlQuery($mysqli,$sql);
    $results_arr = array();
    
    $zip = new ZipArchive();
    $filename = "myzipfile.zip";
    
    if ($zip->open($filename, ZipArchive::CREATE)!==TRUE) {
        exit("cannot open <$filename>\n");
    }
 
    while ($obj = $res->fetch_object()){
        $results_decoded = base64_decode($obj->metadata);
        $results_decompressed = gzuncompress($results_decoded);
        $results_arr = json_decode($results_decompressed, true);
        if($intuview_info){
            $results_arr = $results_arr["intuview_data"] ?? [];
        }   
        $data = json_encode($results_arr,true);
        file_put_contents($outputpath.DIRECTORY_SEPARATOR.$obj->docid.".json", $data);
    }
   
    saveTozZip($outputpath);

    return true;
}

/**
 * 
 * @param unknown $mysqli
 * @param unknown $docid
 * @return mixed
 */
function getMetadataFromDB($mysqli, $docid, $intuview_info = false){
    $sql = "SELECT metadata FROM metadata WHERE docid=$docid";
    $res = sqlQuery($mysqli,$sql);
    $results_arr = array();
    if ($obj = $res->fetch_object()){
        $results = $obj->metadata;
        $results_decoded = base64_decode($results);
        $results_decompressed = gzuncompress($results_decoded);
        $results_arr = json_decode($results_decompressed, true);
    }
    if(empty($results_arr)){
        $results_arr = array("error" => "File doesnt have metadata in the database yet - please refresh the page in few minutes");
    }
    $results_arr['key_data'] = filterKeyData($results_arr);
    if($intuview_info){
        $results_arr = $results_arr["intuview_data"] ?? [];
    }
    
    
    return $results_arr;
}

//filter from the key-data components we wish to hide (as terrorism)
function filterKeyData($results_arr){
    global $showIslamicKeyData;
    if(!$showIslamicKeyData){
        $results_arr["key_data"] = json_decode($results_arr["key_data"], true);
        unset($results_arr["key_data"]["Terrorism"]);
    }
    $results_arr["key_data"]['subject']['subject'] = $results_arr["intuview_data"]["intuview_subject_str"] ?? "";   
    return json_encode($results_arr["key_data"], true);
}
/**
 * saveGraph - save the graph to the dashboard/search - params from UI
 * @param unknown $mysqli
 * @return string[]|mixed[]
 */
function saveGraph($mysqli, $username){
    $requestPayload = file_get_contents('php://input');
//     $requestPayload = "{\"name\":\"Astronomic Place Object\",\"tab\":\"dashboard\",\"visibility\":true,\"panelSize\":3,\"panelHeight\":2,\"chartType\":\"pie\",\"selectedSortBy\":\"amount\",\"maxItems\":100,\"legend\":true,\"search_field\":\"astronomic_place_object\",\"entityId\":\"astronomic_place_object\",\"entity\":\"astronomic_place_object\",\"panelType\":\"astronomic_place_object\",\"searchType\":\"smart\",\"icon\":\"fas fa-cube\",\"custom\":true}";
    
    $graph_info = json_decode($requestPayload, true);
    $name = $graph_info["name"];
    $tab = $graph_info["tab"];
    $visibility = $graph_info["visibility"];
    $panelSize = $graph_info["panelSize"];
    $panelHeight = $graph_info["panelHeight"];
    $entity = $graph_info["entity"];
    $chartType = "wordList";//$graph_info["chartType"];
    $selectedSortBy = $graph_info["selectedSortBy"];
    $maxItems = $graph_info["maxItems"];
    $legend = $graph_info["legend"];
    $search_field = $graph_info["search_field"];
    $details = $graph_info["details"];
    $sort = $graph_info["sort"] ?? 3;
    $config_panel = $graph_info["config_panel"];
    
//     $panel_sql = "insert  into dashboard_panels(name, tab,visibility,panelSize,panelHeight,entity,chartType,selectedSortBy,maxItems,legend, search_field, sort,username, custom) values
//     ('$name', '$tab',$visibility,$panelSize,$panelHeight,'$entity','$chartType','$selectedSortBy',$maxItems,$legend,'$search_field',$sort,'$username',1)";
    $panel_dash_sql = "insert  into dashboard_panels(name, tab,visibility,panelSize,panelHeight,entity,chartType,selectedSortBy,maxItems,legend, search_field, sort,username, custom, collapsed) values
    ('$name', 'dashboard',$visibility,$panelSize,$panelHeight,'$entity','$chartType','$selectedSortBy',$maxItems,$legend,'$search_field',$sort,'$username',1, 0)";
    $res = sqlQuery($mysqli,$panel_dash_sql);
    
    $panel_search_sql = "insert  into dashboard_panels(name, tab,visibility,panelSize,panelHeight,entity,chartType,selectedSortBy,maxItems,legend, search_field, sort,username, custom, collapsed) values
    ('$name', 'search',$visibility,$panelSize,$panelHeight,'$entity','$chartType','$selectedSortBy',$maxItems,$legend,'$search_field',$sort,'$username',1, 1)";
    $res = sqlQuery($mysqli,$panel_search_sql);
    
    saveOldDashboard($mysqli, $entity, $maxItems, $name, true, "pie");

    CacheEng::refreshPie($mysqli, $username, $name); //save the graph to the dashboard
    
    $ret = empty($res) ? array("Error"=>"Error inserting the graph to dashboard") : array("success" => "successfully added the graph");
    return $ret;
    
}

function saveOldDashboard($mysqli, $table, $slices, $name, $isPie, $trendType){
    $_REQUEST["table"] = $table;
    $_REQUEST["slices"] = $slices;
    $_REQUEST["name"] = $name;
    $_REQUEST["isPie"] = $isPie;
    $_REQUEST["trendType"] = $trendType;
    saveTrendData($mysqli);
}

/**
 * removing one panel from the UI (only custom = 1)
 * @param unknown $mysqli
 * @param unknown $username
 * @param unknown $id
 */
function removePanel($mysqli, $username, $id_str){
    $id_arr = explode(',', $id_str);
    foreach($id_arr as $id){
        $sql = "DELETE FROM dashboard_panels WHERE username='$username' AND id=$id AND custom=1";
        $res = sqlQuery($mysqli, $sql);
        if(empty($res)){
            write_to_log("TRACE", "Error removing Panel $id");  
            $ret = "error";
        }
    }
    if(empty($ret)){
        write_to_log("TRACE", "successfully Removed Panel $id");
        $ret = array("success" => "successfully Removed Panels. ids: $id_str");
    }
    else{
        $ret = array("Error"=>"Error removing panel (or panels)");   
    }
    return $ret;
}

function getFieldValueFromSolr($mysqli, $username, $isAdmin, $docId, $field){
    $useSolr = getSystemSettingsProp($mysqli, "useSolr");
    if(empty($useSolr)){
        return "no solr service";
    }
    global $SOLR_SERVER_HOSTNAME, $SOLR_SERVER_PORT, $SOLR_COLLECTION;
    $solrQuery = "http://$SOLR_SERVER_HOSTNAME:$SOLR_SERVER_PORT/solr/$SOLR_COLLECTION/select?q=id%3A$docId&fl=content_txt&wt=json&indent=true";
    if (!$isAdmin){
        $solrQuery .= "&fq=username:$username";
    }
    $solrJson = file_get_contents($solrQuery);
    if(empty($solrJson)){
        return null;
    }
    write_to_log("TRACE", "solrQuery:$solrQuery");
    $solrResponse = json_decode($solrJson);
    write_to_log("TRACE", "solrResponse:$solrJson");
//     $solr_query = "//http://localhost:8983/solr/galgalanda_db/select?q=$docId%3A1&fl=content_txt&wt=json&indent=true";
    $value = $solrResponse->response->docs[0];
    if(empty($value->$field)){
        return "no solr response";
    }
    return $value->$field;
}

function getRelationsData($mysqli){
    require_once 'StatisticPageEng.php';
    return getPie($mysqli, true);
}

/**
 * refreshOverview - refresh the panles (overview+pies) + manage entities
 * @param unknown $mysqli
 * @param unknown $username
 */
function refreshOverview($mysqli, $isAdmin, $username){
    session_write_close();
    
    require_once 'cacheEng.php';
    require_once 'ManageEntitiesEng.php';
    
//     write_to_log("INFO", "Refresh manage-entities");
//     $response = refreshManageEntities($mysqli, $username);
//     write_to_log("INFO", "Refresh manage-entities - Done");
    
    write_to_log("INFO", "Refresh Overivew");
    $response = CacheEng::refreshOverview($mysqli, $isAdmin, $username);
    write_to_log("INFO", "Refresh Overivew - Done");

    write_to_log("INFO", "Refresh Dashboard");  
    $response = CacheEng::rereshDashboard($mysqli, $isAdmin, $username);
    write_to_log("INFO", "Refresh Dashboard - Done");
    return "Sucess";
    
}

function getFolders($mysqli, $username, $isAdmin)
{
    require_once 'sqlUtils.php';
    $user_sql = $isAdmin ? " TRUE " : " username=\"$username\" ";
    $res = sqlQuery($mysqli, "SELECT DISTINCT origfolder as f FROM files WHERE $user_sql AND username <> \"crawler\" ORDER BY date DESC");
    $response = array();
    if ($res != false){
        while ($row = $res->fetch_object()){
            $response[] = $row->f;        
        }
    }
    return $response;
}

/**
 * gets slotdata from table per specific caption&table&docid (for explorer view)
 * @param unknown $mysqli
 * @param unknown $username
 * @param unknown $docid
 * @param unknown $table
 * @param unknown $tag
 * @return unknown[]
 */
function getSlotInfoPerTag($mysqli, $username, $docid, $table, $tag){
    global $slotToCaption, $entitiesTypeToTable;
    $response = [];

    if(array_key_exists($table, $entitiesTypeToTable)){
        $table = $entitiesTypeToTable[$table];
    }
    $sql = "SELECT * FROM slotdata WHERE docid=$docid AND caption=\"$tag\" AND conceptName=\"$table\"";
    $res = sqlQuery($mysqli, $sql);
    if ($res != false){
       $arr = $res->fetch_object();
       if(!empty($arr)){
           foreach($arr as $key=>$val){
               $key_alt = str_replace('_', '-', $key);
               if(!(array_key_exists($key, $slotToCaption) || array_key_exists($key_alt, $slotToCaption)) || empty($val)){
                   continue;
               }
               $slotArr = $slotToCaption[$key] ?? $slotToCaption[$key_alt];
               $order = $slotArr['order'];
               $label = $slotArr['label'];
               $response[] = ['label'=>$label, 'order'=> $order, "value"=> $val];
           }  
        }
    }
    return $response;
}


function getDistinctGroupValsFromSlotData($mysqli, $conceptname, $prefix = null){
    $input = file_get_contents( 'php://input');
    $arr = json_decode($input,1);
    $key_cond = " TRUE ";
    $ret_val = [];
    if(!empty($conceptname) && strtolower($conceptname) !== "any"){
        global $entitiesTypeToTable;
        $conceptname = strtolower($conceptname);
        $conceptname = array_key_exists($conceptname, $entitiesTypeToTable) ? $entitiesTypeToTable[$conceptname] :
        $conceptname;
        $concepts = [$conceptname];
        $sql = "SELECT DISTINCT sub_concept_name FROM `sub_tables` WHERE concept_name ='".ucfirst(str_replace('_', '-', $conceptname))."' LIMIT 500";
        $res = sqlQuery($mysqli, $sql);
        if(!empty($res)){
            while( ($row = $res->fetch_object()) != null){
                $concepts[] = strtolower(str_replace('-', '_', $row->sub_concept_name));
            }
        }
        $concepts_str = implode("','", $concepts);
        $key_cond = " conceptName IN ('$concepts_str')";
    }
    
    
    foreach($arr as $col){
        $col = str_replace('-', '_', $col["name"]);
        if(!TablesInformation::isColumnExists($mysqli, 'slotdata',$col)){
            continue;
        }
        $prefix_sql = empty($prefix) ? " TRUE " : " $col LIKE ('$prefix%')";
        $query = "SELECT DISTINCT $col as col FROM slotdata WHERE $key_cond AND $col <> '' AND $prefix_sql";
        $res = sqlQuery($mysqli, $query);
        if(!empty($res)){
            while( ($row = $res->fetch_object()) != null){
                if(strpos($row->col, ',') !== false){
                    $arr = explode(',', $row->col);
                    foreach($arr as $col){
                        $ret_val[trim($col)] = ["label"=> trim($col), "multi" => true];
                    }
                }
                else{
                    if(array_key_exists($row->col, $ret_val)){
                        continue;
                    }
                    $ret_val[trim($row->col)] =  ["label"=> trim($row->col), "multi" => false];
                }
            }
        }
    }
    sort($ret_val);
    $ret_val = array_slice($ret_val, 0, 500); //limit the results
    return $ret_val;
}

function getCaptionsPerSlot($mysqli, $prefix = null){
    $input = file_get_contents( 'php://input');
    $arr = json_decode($input,1);
    $regex = $arr["regex"];
    $col = $arr["col"];
    
    $key_cond = " TRUE ";
    $ret_val = [];
    
    if($col == "slot"){
        $conceptname = $arr["concept"];
        $val = $arr["value"]["label"];       
        if(!empty($conceptname)){
            global $entitiesTypeToTable;
            $conceptname = strtolower($conceptname);
            $conceptname = array_key_exists($conceptname, $entitiesTypeToTable) ? $entitiesTypeToTable[$conceptname] :
            $conceptname;
            $concepts = [$conceptname];
            $sql = "SELECT DISTINCT sub_concept_name FROM `sub_tables` WHERE concept_name ='".ucfirst(str_replace('_', '-', $conceptname))."' LIMIT 500";
            $res = sqlQuery($mysqli, $sql);
            if(!empty($res)){
                while( ($row = $res->fetch_object()) != null){
                    $concepts[] = strtolower(str_replace('-', '_', $row->sub_concept_name));
                }
            }
            $concepts_str = implode("','", $concepts);
            $key_cond = " conceptName IN ('$concepts_str')";
        }
        
        foreach($arr['cols'] as $col){
            $col = str_replace('-', '_', $col["name"]);
                   
            $prefix_sql = empty($prefix) ? " TRUE " : " caption LIKE ('$prefix%')";
            
            $col_val_cond = $regex ? "$col LIKE \"%$val%\"" : "$col = \"$val\"";
            $query = "SELECT DISTINCT caption as c FROM slotdata WHERE $key_cond AND $col_val_cond AND caption <>'' AND $prefix_sql ORDER BY c ASC LIMIT 500";
            $res = sqlQuery($mysqli, $query);
            if(!empty($res)){
                while( ($row = $res->fetch_object()) != null){
                    $ret_val[] = ["label"=>$row->c, "selected"=>false];
                }
            }   
        }
    }
    elseif($col == "bank"){
        $country_cond = !empty($arr["value"]["country"]) && !in_array($arr["value"]["country"],["Any","NULL"]) ? " place_referred_to  = '". $arr["value"]["country"]. "'" : " TRUE ";
        $number = $arr["value"]["number"];
        $number_cond = !empty($number) ? " number_value LIKE \"$number%\"" : " TRUE ";
        $sql = "SELECT DISTINCT number_value as c FROM slotdata WHERE  $country_cond AND $number_cond AND conceptName=\"iban_account\" LIMIT 500";
        $res = sqlQuery($mysqli, $sql);
        if(!empty($res)){
            while( ($row = $res->fetch_object()) != null){
                $num = filter_var($row->c, FILTER_SANITIZE_NUMBER_INT); 
                $ret_val[] = ["label"=>$num, "selected"=>false];
            }
        }
    }
    elseif($col == "telephone_number"){

        $country_cond = !empty($arr["value"]["name"]) && !in_array($arr["value"]["name"],["Any","NULL"]) ? " referred_place  = '". $arr["value"]["name"]. "'" : " TRUE ";   
//         if(!empty($arr["value"]["area"])){
//             $arr["value"]["area"] = ltrim($arr["value"]["area"], '0');
//         }
        
        $area_cond = !empty($arr["value"]["area"]) ? " phone_area_code  = '". $arr["value"]["area"]. "'" : " TRUE ";
        $number_cond = !empty($arr["value"]["number"]) ? " phone_number  LIKE '". $arr["value"]["number"]. "%'" : " TRUE ";
        $sql = "SELECT DISTINCT(CONCAT_WS('-',phone_country_code,phone_area_code,phone_number)) AS c  FROM slotdata  WHERE phone_number <> '' AND $country_cond AND $area_cond AND $number_cond AND conceptName=\"telephone_number\" LIMIT 500";
        $res = sqlQuery($mysqli, $sql);
        if(!empty($res)){
            while( ($row = $res->fetch_object()) != null){
//                 $num = filter_var($row->c, FILTER_SANITIZE_NUMBER_INT);
                $ret_val[] = ["label"=>$row->c, "selected"=>false];
            }
        }
    }
    elseif($col == "full_address"){
        $house_number_cond = !empty($arr["value"]["house_number"])  && $arr["value"]["house_number"] !== "NULL" ? "house_number='".$arr["value"]["house_number"]."'" : " TRUE ";     
        $street_cond = !empty($arr["value"]["street"])  && $arr["value"]["street"] !== "NULL" ? "street='".$arr["value"]["street"]."'" : " TRUE ";
        $city_cond = !empty($arr["value"]["city"])  && $arr["value"]["city"] !== "NULL" ? "city='".$arr["value"]["city"]."'" : " TRUE ";
        $state_cond = !empty($arr["value"]["state"])  && $arr["value"]["state"] !== "NULL" ? "state_or_province='".$arr["value"]["state"]."'" : " TRUE ";
        $postal_code_cond = !empty($arr["value"]["postal_code"])  && $arr["value"]["postal_code"] !== "NULL" ? "postBox='".$arr["value"]["postal_code"]."'" : " TRUE ";   
        $country_cond = !empty($arr["value"]["country"])  && !in_array($arr["value"]["country"],["Any","NULL"]) ? "country='".$arr["value"]["country"]."'" : " TRUE ";
        
      
        $sql = "SELECT  DISTINCT(CONCAT_WS(', ',house_number,street,city,state_or_province,postBox,country)) AS c FROM slotdata WHERE $country_cond AND $state_cond AND $city_cond AND $street_cond AND $house_number_cond AND $postal_code_cond
            AND conceptName=\"full_address\" LIMIT 500";
        $res = sqlQuery($mysqli, $sql);
        if(!empty($res)){
            while( ($row = $res->fetch_object()) != null){
                $ret_val[] = ["label"=>$row->c, "selected"=>false];
            }
        }
    }
    
    $ret_val = array_slice($ret_val, 0, 500); //limit the results
    return $ret_val;
    
}

function getSlotDetailsBank($mysqli){
    $bank_data = [];
    
    $sql = "SELECT DISTINCT place_referred_to,number_value FROM slotdata WHERE  conceptName='iban_account' LIMIT 100000";
    $res = sqlQuery($mysqli, $sql);
    if(!empty($res)){
        while( ($row = $res->fetch_object()) != null){
            $place_referred_to = $row->place_referred_to;
            $number_value = $row->number_value;
            if(!array_key_exists($place_referred_to, $bank_data)){
                $bank_data[$place_referred_to] = [];
            }
            if(!in_array($number_value, $bank_data[$place_referred_to])){
                $bank_data[$place_referred_to][] = $number_value;
            }
        }
    }
    return $bank_data;
}

function getSlotDetailsPhone($mysqli){
    $phone_data = [];
    
    $sql = "SELECT DISTINCT phone_country_code, referred_place, phone_area_code,phone_number FROM slotdata WHERE  conceptName='telephone_number' LIMIT 100000";
    $res = sqlQuery($mysqli, $sql);
    if(!empty($res)){
        while( ($row = $res->fetch_object()) != null){
            $phone_country_code = $row->phone_country_code ?? "NULL";
            $referred_place = $row->referred_place  ?? "NULL";
            $phone_area_code = $row->phone_area_code ?? "NULL";
            $phone_number = $row->phone_number ?? "NULL";
            
            if(!array_key_exists($referred_place, $phone_data)){
                $phone_data[$referred_place] = [];
            }
            if(!array_key_exists($phone_area_code, $phone_data[$referred_place])){
                $phone_data[$referred_place][$phone_area_code] = [];
            }
            if(!in_array($phone_number, $phone_data[$referred_place][$phone_area_code])){
                $phone_data[$referred_place][$phone_area_code][] = $phone_number;
            }
            
        }
    }
    return $phone_data;
}

function getSlotsDetailsAdderss($mysqli){
   $adresses_data = [];
   $sql = "SELECT  DISTINCT house_number,street,city,state_or_province,postBox,country  FROM slotdata WHERE conceptName=\"full_address\" LIMIT 500";
   $res = sqlQuery($mysqli, $sql);
   
   if(!empty($res)){
       while( ($row = $res->fetch_object()) != null){
           $country = $row->country ?? "NULL";
           $state = $row->state_or_province ?? "NULL";
           $city = $row->city ?? "NULL";
           $street = $row->street ?? "NULL";
           $house_number = $row->house_number ?? "NULL";
           $postbox = $row->postBox ?? "NULL";
           
           
           if(!array_key_exists($country, $adresses_data)){
               $adresses_data[$country] = [];
           }
           if(!array_key_exists($state, $adresses_data[$country])){
               $adresses_data[$country][$state] = [];
           }
           if(!array_key_exists($city, $adresses_data[$country][$state])){
               $adresses_data[$country][$state][$city] = [];
           }
           if(!array_key_exists($street, $adresses_data[$country][$state][$city])){
               $adresses_data[$country][$state][$city][$street] = [];
           }
           $adresses_data[$country][$state][$city][$street][] = ["house_number"=>$house_number, "postbox"=>$postbox];
       }
   }
   return $adresses_data;
}

/**
 * get all hirarchy of slots bank phone address
 * @param unknown $mysqli
 * @param unknown $section
 * @return unknown[]|array[]|array[][]|string[]
 */
function getSlotsDetails($mysqli, $section){
    $data = [];
    switch ($section){
        case "phone":
            $data = getSlotDetailsPhone($mysqli);
            break;
        case "address":
            $data =  getSlotsDetailsAdderss($mysqli);
            break;
        case "bankAccount":
            $data = getSlotDetailsBank($mysqli);
            break;
        default:
            die("not supported");
    }
    return $data;
}
/**
 * getFolderParentsList - get list of folder parents ids of folder id
 * @param unknown $mysqli
 * @param unknown $fid
 * @return array|unknown[]
 */
function getFolderParentsList($mysqli, $fid){
    $response = [];
    $sql = "SELECT parentId FROM foldertree WHERE id=$fid";
    $res = sqlQuery($mysqli,$sql);
    if($obj = $res->fetch_object()){
        $parentId = $obj->parentId;
        if($parentId > 0){
            $response[] = $parentId;
            $response = array_merge($response, getFolderParentsList($mysqli,$parentId));
        }
    }
    else{
        $response = [];
    }
    sort($response);
    return $response;   
}

function getRelationHirarchy($connection){
    $sql = "SELECT DISTINCT relation_type_inst FROM inter_entity_relationship";
    $res = sqlQuery($connection, $sql);
//     $obj = $res->fetch_object();
    $exists_relations = [];
    
    while($obj = $res->fetch_object()) {
        $rel = $obj->relation_type_inst;
        $exists_relations[] = $rel;
    }
    
    $path =  './files/relations.json';
    $string = file_get_contents($path);
    $final_relations = json_decode($string, true);
    
    checkExistsRelations($final_relations,$exists_relations);
        
    $final_relations = filterEmpty($final_relations);
    $final_relations["children"] = array_values($final_relations["children"]);
    return $final_relations;
    
}

function checkExistsRelations(&$element,$exists_relations){
   
    if(array_key_exists("children", $element)){
        $exists = false; //indicates if to keep this node
        $element["exists"] = in_array($element["id"], $exists_relations) ? true : false;
        foreach($element["children"] as &$child){
            $temp_exists = checkExistsRelations($child,$exists_relations);
            if(!$element["exists"]){
                $element["exists"] = $temp_exists;
            }
            $element["selected"] = false;
            
        }   
        $element["exists"] = $element["exists"] ?? $exists;
        if(empty($element["exists"])){
            unset($element);
        }
        $element["selected"] = false;
        
        return $element["exists"] ?? $exists;;
    }
    else{
        $id_str = preg_replace('/\d/', '', $element["id"] );
        
        $element["exists"] = in_array($id_str, $exists_relations) ? true : false;
        if(empty($element["exists"])){
            unset($element);
            return false;
        }
        return $element["exists"];
        
    }
}

function filterEmpty($final_relations){
    $count_1 = count($final_relations["children"]);
    for($i = 0; $i < $count_1; $i++){
        $child = $final_relations["children"][$i];
        if(!$child["exists"]){
            unset($final_relations["children"][$i]);
            continue;
        }
        if(array_key_exists("children", $child)){
            $count_2 = count($child["children"]);
            for($j = 0; $j < $count_2; $j++){
                $grand_child = $child["children"][$j];
                if(!$grand_child["exists"]){
                    unset($final_relations["children"][$i]["children"][$j]);
                    continue;
                }
                if(array_key_exists("children", $grand_child)){
                    $count_3 = count($grand_child["children"]);
                    for($k = 0; $k < $count_3; $k++){
                        $grand_grand_child = $grand_child["children"][$k];
                        if(!$grand_grand_child["exists"]){
                            unset($final_relations["children"][$i]["children"][$j]["children"][$k]);
                            continue;
                        }
                        if(array_key_exists("children", $grand_grand_child)){
                            $count_3 = count($grand_grand_child["children"]);
                            for($l = 0; $l < $count_3; $l++){
                                $grand_grand_grand_child = $grand_grand_child["children"][$l];
                                if(!$grand_grand_grand_child["exists"]){
                                    unset($final_relations["children"][$i]["children"][$j]["children"][$k]["children"][$l]);
                                    continue;
                                }
                            }
                            $final_relations["children"][$i]["children"][$j]["children"][$k]["children"] = array_values($final_relations["children"][$i]["children"][$j]["children"][$k]["children"]);
                            
                        }
                    }
                    $final_relations["children"][$i]["children"][$j]["children"] = array_values($final_relations["children"][$i]["children"][$j]["children"]);
                }
                else{
                    if(!$grand_child["exists"]){
                        unset($final_relations["children"][$i]["children"][$j]);
                        continue;
                        
                    }
                }
            }
        }
        else{
            if(!$child["exists"]){
                unset($final_relations["children"][$i]);
                continue;
                
            }
            
        }
        if(array_key_exists("children", $final_relations) && array_key_exists($i, $final_relations["children"]) && 
                array_key_exists("children", $final_relations["children"][$i])){
            $final_relations["children"][$i]["children"] = array_values($final_relations["children"][$i]["children"]);
            
        }
        
    }
    return $final_relations;
    
}

/**
 * 
 */
function getAlerts($mysqli, $username, $isAdmin){
    $user_sql = $isAdmin ? " TRUE " : "username=\"$username\"";
    $sql = "SELECT * FROM alerts WHERE $user_sql";
    $res = sqlQuery($mysqli, $sql);
    $alerts_arr = [];
    
    while($obj = $res->fetch_object()) {
        $entities_alerts_decoded = base64_decode($obj->entities_alerts);
        $entities_alerts_decompressed = !empty($entities_alerts_decoded) ? gzuncompress($entities_alerts_decoded) : "";
        $obj->entities_alerts = !empty($entities_alerts_decompressed) ? $entities_alerts_decompressed : "{}";
        
        $concepts_alerts_decoded = base64_decode($obj->concepts_alerts);
        $concepts_alerts_decompressed = !empty($concepts_alerts_decoded) ? gzuncompress($concepts_alerts_decoded) : "";
        $obj->concepts_alerts = !empty($concepts_alerts_decompressed) ? $concepts_alerts_decompressed : "{}";
        
        $instances_alerts_decoded = base64_decode($obj->instances_alerts);
        $instances_alerts_decompressed = !empty($instances_alerts_decoded) ? gzuncompress($instances_alerts_decoded) : "";
        $obj->instances_alerts = !empty($instances_alerts_decompressed) ? $instances_alerts_decompressed : "{}";
        
        $keywords_alerts_decoded = base64_decode($obj->keywords_alerts);
        $keywords_alerts_decompressed = !empty($keywords_alerts_decoded) ? gzuncompress($keywords_alerts_decoded) : "";
        $obj->keywords_alerts = !empty($keywords_alerts_decompressed) ? $keywords_alerts_decompressed : "{}";
        
        $obj->reviewed = $obj->reviewed==0 ? false : true;
        $alerts_arr[] = $obj;
    }
    
    $sql = "UPDATE alerts SET reviewed=1";
    $res = sqlQuery($mysqli, $sql);
    
    return $alerts_arr;
}

function checkAlerts($mysqli, $username, $isAdmin){
    $checkAlerts = getSystemSettingsProp($mysqli, "checkAlerts");
    if($checkAlerts){
        return 30000;//hard coded - move to conf
    }
    return false;
    
}

function getAlertsStatus($mysqli, $username, $isAdmin){
    $user_sql = $isAdmin ? " TRUE " : "username=\"$username\"";
    $sql = "SELECT count(docid) AS c FROM alerts WHERE $user_sql AND reviewed=0";
    $res = sqlQuery($mysqli, $sql);
    $obj = $res->fetch_object();
    $result = $obj->c;
    return $result;
}

function addToAlert($mysqli, $username){
    $input = file_get_contents('php://input');
    $sent_data = json_decode($input,1); //json_decode($input,1);   
    $settings_class =  new Settings($mysqli, $username);
    $response = $settings_class->setSettingsConceptInstaces($sent_data);
    return $response;
}

function stopTwitterCrawler($mysqli){
    $res = sqlQuery($mysqli, "UPDATE crawler_settings SET isRunning=0 ");
    if(!empty($res)){
        return true;
    }
    return false;
}

function stopFilter($mysqli){
    $res = sqlQuery($mysqli, "UPDATE filter_settings SET isRunning=0 ");
    if(!empty($res)){
        return true;
    }
    return false;
    
}

function getDocUrls($mysqli, $docid, $regex = null){
    $urls = [];
    $regex_sql = !empty($regex) ? "name LIKE \"%$regex%\"" : " TRUE ";
    $sql = "SELECT name FROM `url` WHERE $regex_sql AND docid = $docid";
    $res = sqlQuery($mysqli, $sql);
    if(!empty($res)){
        while( ($row = $res->fetch_object()) != null){
            $urls[] = $row->name;
        }
    }
    return $urls;
}

/**
 * analyseLinkedinProfile - fetch linkedin profile, send it to analyse and connection it to docid as source file
 * @param unknown $mysqli
 * @param unknown $username
 * @param unknown $data
 * @return boolean
 */
function analyseLinkedinProfile($mysqli, $username, $data){
    global $UPLOADS_PATH;
    require_once 'v2'.DIRECTORY_SEPARATOR.'senddocEngAjx_v2.php';
    $res = false;
    $profile_url = $data['url'];
    $uniq_name= basename($profile_url);
    $docId = $data['docId'];
    $file_path = $UPLOADS_PATH;
    $file_name = "linkedin_data_$uniq_name.json";
    $full_file_name = $UPLOADS_PATH . DIRECTORY_SEPARATOR . $file_name;

    $intuscanHost = getSystemSettingsProp($mysqli, "intuscanHost");
    $intuscanPort = getSystemSettingsProp($mysqli, "intuscanPort");
    
    $data = getLinkedinData($mysqli, $docId, $profile_url, $full_file_name);
    if(array_key_exists("error", $data)){
        return $data;
    }

    if(!empty($data)){        
        placeFileUploadData($full_file_name, 'json', $data);     
        $_SESSION['attach'] = '[{"id":"document_type","name":"document_type","children":[{"id":"linkedin","name":"linkedin","checked":true}]}]';
        $res = insertFile($mysqli, $data,$file_path,$file_name,"6000","uploadedFiles",$username); 
    }
    return $res;
    
    
}

function dateArrToStr($arr){
    if(empty($arr)){
        return "..";
    }
    return "$arr[day].$arr[month].$arr[year]";
}

function getLinkedinData($mysqli, $docId, $profile_url, $full_file_name){
    global $proxyCurlApiKey;
    if(file_exists($full_file_name)){
        //first check if we have the related file already - if yes - return notification - not - analyse the file data
        $related = getRelatedFiles($mysqli, $docId);
        $key = array_search(basename($full_file_name), array_column($related, 'name'));
        
        if($key === false){
            $data = file_get_contents($full_file_name); 
            return $data;
        }
        else{
            return ["error" => "profile data already exists for $full_file_name"];    
        }
    }
    if(empty($proxyCurlApiKey)){
        return ["error" => "no api key configured in config.php"];
    }
    $profile_url = urlencode($profile_url);
    $res = [];
    $res["t_parent_id"] = $docId;
//     $author = getAuthorArr($mysqli, $docId);
//     if(!empty($author)){
//         $res["user_screen_name"] = $author;
//     }
    
    $ch = curl_init();
    
    curl_setopt($ch, CURLOPT_URL, 'https://nubela.co/proxycurl/api/v2/linkedin?url='.$profile_url.'%2F&fallback_to_cache=on-error&use_cache=if-present&skills=include&inferred_salary=include&personal_email=include&personal_contact_number=include&twitter_profile_id=include&facebook_profile_id=include&github_profile_id=include&extra=include');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
    
    
    $headers = array();
    $headers[] = 'Authorization: Bearer '.$proxyCurlApiKey;
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    
    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }
    curl_close($ch);

    $result = json_decode($result, true);

    
//    $result = array_filter(json_decode(file_get_contents("./files/response_linkedin.json"),true)); //sample
    
    
    foreach($result as $k=>$v){
        if(is_array($v)){
            if(in_array($k, ['experiences', 'education'])){
                foreach($v as $vv){
                    if($k=='experiences'){
                        $res['l_experiences_companies'][] = $vv['company'];
                        $res['l_experiences_titles'][] = $vv['title'];
                        $res['l_experiences'][] = $vv['title'] . "; " . $vv['company'] . "; ".dateArrToStr($vv['starts_at']) . " to " . dateArrToStr($vv['ends_at']);

                    }
                    elseif($k=='education'){
                        $res['l_education_degree_name'][] = $vv['degree_name'];
                        $res['l_education_school'][] = $vv['field_of_study'];
                        $res['l_education_field_of_study'][] = $vv['school'];
                        $res['l_education'][] = $vv['degree_name'] . "; " . $vv['field_of_study'] . "; " . $vv['school'] . "; " .dateArrToStr($vv['starts_at']) . " to " . dateArrToStr($vv['ends_at']);
                    }
                }
            }
        }
        if(empty($res["l_$k"])){
            $res["l_$k"] =  $v;
        }
    }
//     $res["l_full_name"] = $profile_url;

    $res["text"] = $res["l_summary"] ?? $res['l_full_name'] . "- " . $res['l_occupation'];

    return json_encode($res,true);

}

function addToFilterView($mysqli, $username){
    $input = file_get_contents('php://input');
    $sent_data = json_decode($input,1); //json_decode($input,1);   
    $response = $sent_data;
    $name = $mysqli->real_escape_string($sent_data['entityName']);
    $entity = $sent_data['entityType'];
    $sql ="UPDATE dashboard_panels SET selected_instances = CONCAT(COALESCE(`selected_instances`,''),'^','$name') WHERE username='$username'
               AND entity='$entity'";
    $res = sqlQuery($mysqli, $sql);
    if(!empty($res)){
        $res = ["success" => "added to filtered panel"];
    }
    return false;
}

function getFilteredItems($mysqli, $username){
    $arr = "";
    $entity = $_REQUEST["name"];
    $sql ="SELECT DISTINCT selected_instances FROM dashboard_panels WHERE username='$username' AND entity='$entity'";
    $res = sqlQuery($mysqli, $sql);
    if(!empty($res)){
        $obj = $res->fetch_object();
        if(!empty($obj)){
            $arr = array_filter(explode("^", $obj->selected_instances ?? ""));
        }
    }
    return $arr;
}

function resetFilterView($mysqli, $username){
    $sql ="UPDATE dashboard_panels SET selected_instances = NULL, filtered_view=0 WHERE username='$username'";
    $res = sqlQuery($mysqli, $sql);
    return "success";
}


function getNlpConfig($path){
//     $path = "data\rep\std_sum.xml"; 
    $socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
    $result = socket_connect($socket, "127.0.0.1", 6000);
    
    $out = "<IVEnvelope>
	<Request id=\"9\">
		<GetConfigData>
		<FilePath>$path</FilePath>
		</GetConfigData>
	</Request>
</IVEnvelope>";
    
    
    socket_write($socket, $out, strlen($out));
    
    if ($result === false)
    {
        $errorcode = socket_last_error();
        $errormsg = socket_strerror($errorcode);
        return false;
    }
    
    $rval = socket_set_option($socket,SOL_SOCKET, SO_RCVTIMEO, array("sec"=>30, "usec"=>0));
    $output="";
    $numRetries = 0;
    while ($numRetries++ < 500){
        set_time_limit(40); //extend the time limit
        $read = socket_read($socket, 1024);
        if ($read === false)
        {
            $errorcode = socket_last_error($socket);
            if ($errorcode == ETIMEDOUT || $errorcode == 10060)
                continue;
                
                $errormsg = socket_strerror($errorcode);
                return false;
        }
        $output = $output . $read;
        
        $ending = strpos($output, "</IVEnvelope>");
        if ($ending !== false){ //|| strlen($output) == 0)
            
            break;
        }
    }
    
    socket_close($socket);
    
    //    $simpleXml = checkEncodingAndOutput($output);
    $simpleXml = simplexml_load_string($output);
    
    // Convert SimpleXMLElement to JSON and then to an array
    $json = json_encode($simpleXml);
    $array = json_decode($json, true);
    return $array;
}

