<?php
require_once '../cowitter/cli_filter_application.php';

$ont = $argv[1];
$interval = $argv[2];
$path = $argv[3];
getLocationData($ont, $interval, $path);


function getLocationData($regex, $interval = 15, $path){
    global $sharedFolder,$ivProjectName;
    if(empty($path)){
        $msg = "No ouput path for getLocationData";
        write_to_log("ERROR", $msg);
        echo "$msg\n";
        return ["ERROR"=>$msg];
    }
    $curr_date = "";
    
    while(true){
        //fetch date & output file path
        $date = date('m_d_Y', time());
        $hour = date('h_i_s', time());
        $date_str = $date.'_'.$hour;
//         $path_dir = $sharedFolder . DIRECTORY_SEPARATOR . 'exported_files';
        $path_dir = $path;
        $path_str = $path_dir . DIRECTORY_SEPARATOR . $date_str . ".json";
        
        //check if the curr_date is empty - assign the date to it
        //else - if its different from the date - means its seperate date - perform action
        if(empty($curr_date)){
            $curr_date = $date;
        }
//         elseif($curr_date !== $date){
//             echo "New Day - compress files to $curr_date.7z";
//             write_to_log("INFO", "New Day - compress files to $curr_date.7z");
//             compressDayFiles($path_dir,  $curr_date);
//         }
        $mysqli_c = null;
        createStreamConnection($mysqli_c);
        
        $mysqli = sqlCreateConnection("getLocationData");
        
        //fetching the max date of the last analysed post - as time indicator
        $sql_time = "select max(date) as max from files";
        $res_time = sqlQuery($mysqli, $sql_time);
        $obj_time = $res_time->fetch_object();
        
        $max_time = $obj_time->max;
        
       if (!is_dir(dirname($path))) {
            mkdir_full(dirname($path), 0777, true);
        }
        $regex_str = !empty($regex) ? "ontName LIKE \"$regex\""  : "";
        $sql = "SELECT NAME, ontName, group_concat(distinct docId) as docIds FROM place_object WHERE  
                $regex_str
                AND docid IN( SELECT id FROM files 
                    WHERE (DATE BETWEEN ('$max_time' - INTERVAL $interval MINUTE)  AND '$max_time'))
                    GROUP BY NAME,ontName";
        $res = sqlQuery($mysqli, $sql);
        
        $final_res = [];
        while($obj = $res->fetch_object()){
            write_to_log("TRACE", "found documents for $obj->name - checking if they are fit the cretiria");
            echo "found documents for $obj->name - checking if they are fit the cretiria\n";
            
            $name = $obj->name;
            $ont = $obj->ontName;
            $coordinates = getCoordinates($mysqli, $ont);
            
            $docIds = trim($obj->docIds,',');
            $doc_array = explode(',', $docIds);
     
            $location_docs = [];
            foreach($doc_array as $doc_id){
                $raw_json = getRawStreamJson($mysqli,$mysqli_c,$doc_id);
//                 $raw_json["intuview_data"] = getIntuviewData($mysqli, $doc_id) ?? null;
                
                if(!empty($raw_json["intuview_data"])){
                    $location_docs[] = $raw_json;
                }
                else{
                    write_to_log("TRACE", "No intuview data for the post $doc_id");
                }
                
    
            }
            if(!empty($location_docs)){
                write_to_log("TRACE", "found documents for $obj->name - updating");
                echo "found documents for $obj->name - updating\n";
                $final_res[$name]["coordinates"] = $coordinates;
                $final_res[$name]["docs"] = $location_docs;
            }       
        }
        if(!empty($final_res)){
            file_put_contents($path_str, json_encode($final_res,true));
        }
        $timeout = getSystemSettingsProp($mysqli, 'crawler_timeout');
        
        sqlClose($mysqli, "sleeping closing mysql");
        sqlClose($mysqli_c, "sleeping closing mysqlC");
        
        echo "sleeping $timeout seconds\n";
        sleep_with_prompt($timeout);
    }
}

// function getIntuviewData($mysqli,$doc_id){
//     $intuview_data = [];
//     $sql_military = "SELECT GROUP_CONCAT(DISTINCT NAME) AS item FROM `military_topic` WHERE docId = $doc_id GROUP BY docId";
//     $res_military = sqlQuery($mysqli, $sql_military);
//     $obj_military = $res_military->fetch_object();
    
//     $sql_person = "SELECT GROUP_CONCAT(DISTINCT NAME) AS item FROM `person_object` WHERE docId = $doc_id GROUP BY docId";
//     $res_person = sqlQuery($mysqli, $sql_person);
//     $obj_person = $res_person->fetch_object();
    
//     $sql_place = "SELECT GROUP_CONCAT(DISTINCT NAME) AS item FROM `place_object` WHERE docId = $doc_id GROUP BY docId";
//     $res_place = sqlQuery($mysqli, $sql_place);
//     $obj_place = $res_place->fetch_object();
    
//     $sql_org = "SELECT GROUP_CONCAT(DISTINCT NAME) AS item FROM `organizational_identity` WHERE docId = $doc_id GROUP BY docId";
//     $res_org = sqlQuery($mysqli, $sql_org);
//     $obj_org = $res_org->fetch_object();
    
//     $sql_event = "SELECT GROUP_CONCAT(DISTINCT NAME) AS item FROM `event` WHERE docId = $doc_id GROUP BY docId";
//     $res_event = sqlQuery($mysqli, $sql_event);
//     $obj_event = $res_event->fetch_object();
    
    
//     if(!empty($obj_military)){
//         $intuview_data['military'] = explode(',', $obj_military->item?? "");
//         $intuview_data['persons'] = explode(',', $obj_person->item ?? "");
//         $intuview_data['places'] = explode(',', $obj_place->item?? "");
//         $intuview_data['organizations'] = explode(',', $obj_org->item?? "");
//         $intuview_data['events'] = explode(',', $obj_event->item?? "");
//     }
//     return $intuview_data;
// }

function compressDayFiles($dir, $curr_date){
    if(!is_dir($dir.DIRECTORY_SEPARATOR."compressed")){
        mkdir_full($dir.DIRECTORY_SEPARATOR."compressed", 0777);
    }
    $zip_path = $dir.DIRECTORY_SEPARATOR."compressed".DIRECTORY_SEPARATOR."$curr_date.7z";
    $zip = new ZipArchive();
    $res = $zip->open($zip_path, ZIPARCHIVE::CREATE | ZIPARCHIVE::OVERWRITE);
    
    if ($res !== TRUE) {
        die ("An error occurred creating your ZIP file.");
    }
    foreach(scandir($dir) as $f){
        $file_parts = pathinfo($f);
        
        if(is_dir($f) || $f == '.' || $f == '..' || endsWith($f, '.7z')){
            continue;
        }
        if(strpos($f, $curr_date) === 0){
            $zip->addFile($dir.DIRECTORY_SEPARATOR.$f,$f);
            $remove_files[] = $dir.DIRECTORY_SEPARATOR.$f;
        }
        
    }
    $res = $zip->close();
    //unlink files only if zip success
    if($res){
        foreach($remove_files as $f){
            unlink($f);
        }
    }
}


// function endsWith( $haystack, $needle ) {
//     $length = strlen( $needle );
//     if( !$length ) {
//         return true;
//     }
//     return substr( $haystack, -$length ) === $needle;
// }



function getRawStreamJson($mysqli, $mysqli_c, $id){
    $results = [];
    $sql = "SELECT value FROM t_id WHERE docId=$id";
    $res = sqlQuery($mysqli, $sql);
    $obj = $res->fetch_object();
    if(!empty($obj)){
        $elmenet_id = $obj->value;
        $sql = "SELECT data FROM raw_stream_data WHERE element_id='$elmenet_id'";
        $res = sqlQuery($mysqli_c, $sql);
        $obj = $res->fetch_object();
        if(!empty($obj)){
            $results =json_decode($obj->data,true); 
        }
    }
        
    return $results;
}

// function getCoordinates($mysqli, $ont = null){
//     $coords = "";
//     $ont_sql = !empty($ont) ? "location = \"$ont\"" : "true";
//     $sql = "SELECT location,coordinates FROM coordinates WHERE $ont_sql";
//     $res = sqlQuery($mysqli, $sql);
//     while(    $obj =  $res->fetch_object()){
//         $coords[$obj->location] = trim($obj->coordinates);
//     }
    
//     return $coords;
// }
