<?php

////// REQUEST GENERATION TOOLS //////
/**
 * @param string $nodeId
 * @param string $edgeName
 * @param array $fieldsArr
 * @param array $subFieldsArr
 * @return string
 */
function build_request_string($nodeId, $edgeName, $fieldsArr, $subFieldsArr){
    $request_str = "/" . $nodeId;
    if (!empty($edgeName) && is_string($edgeName)){
        $request_str .= "/" . $edgeName;
    }
    if (!empty($fieldsArr) && is_array($fieldsArr) && count($fieldsArr) > 0){
        $fields_arr_string = join(",", $fieldsArr);
        $request_str .= "?fields=" . $fields_arr_string;
    }
    if (!empty($subFieldsArr) && is_array($subFieldsArr) && count($subFieldsArr) > 0){
        $sub_fields_arr_string = join(",", $subFieldsArr);
        $request_str .= "{" . $sub_fields_arr_string . "}";
    }
    return $request_str;
};
////// end REQUEST GENERATION TOOLS //////