<?php
require_once '../cowitter/cli_filter_application.php';
require_once 'config.php';
require_once '../../clusterConfig.php';
global $api_key;
$sources = '\"wsl_instagram\",\"wsl_twitter\"';
$query = $argv[1]; // "query": "** AND enrichment.language:ru AND content.published:[2022-03-05T00:00:00.727Z TO 2022-03-07T00:00:00.481Z]",

streamData($api_key,$query);

function streamData($api_key, $query){
    require_once '..\..\sqlUtils.php';
    $mysqli_crawler= null;
    
    createCrawlerConnection($mysqli_crawler);
    
//     require_once '..\..\sqlUtils.php';
    require_once('..\..\vendor/autoload.php');
    try {
    $curl = curl_init();
    
   
    
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.platform.datastreamer.io/api/search',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{
  "query": {
    "from": 0,
    "size": 10,
    "query":"'.$query.'",
    "data_sources": [
         "wsl_instagram","wsl_twitter"
    ]
  }
}',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'apikey: '.$api_key
        ),
    ));
    
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    $content = curl_exec($curl);
    if ($content === false) {
        throw new Exception(curl_error($curl), curl_errno($curl));
    }
    }
    catch(Exception $e) {
        
        trigger_error(sprintf(
            'Curl failed with error #%d: %s',
            $e->getCode(), $e->getMessage()),
            E_USER_ERROR);
        
    } finally {
        // Close curl handle unless it failed to initialize
        if (is_resource($curl)) {
            curl_close($curl);
        }
        $data = json_decode($content, true);
        foreach($data['results'] as $post){
            $post['text'] = $post['content']['body'];
            $post['user_name'] = $post['author']['url'];
            $post['created_at'] = $post['content']['found'];
            $source_id = $post['data_source'] == 'wsl_instagram' ? 4 : 1; //instegram or twitter
            $post_str = json_encode($post,true);
            $value = $mysqli_crawler->real_escape_string($post_str);
            $uuid = $post["id"];
            $post["id_str"] = $post['id'];
            $query = "INSERT into raw_stream_data(element_id, source, data) VALUES(\"$uuid\", $source_id, '$value') ON DUPLICATE KEY UPDATE id=id"; //source is 3  for webhose
            $raw_parent_res = sqlQuery($mysqli_crawler, $query);
        }
    }
    
    /**
     * {
	"id": "1644506191495800007-artemis",
	"data_source": "wsl_instagram",
	"source": {
		"link": "https://instagram.com/p/CZy-sR2sT7H/?comment-id=17934819334939976"
	},
	"content": {
		"body": "Ukraine",
		"found": "2022-02-10T15:16:31Z",
		"published": "2022-02-10T12:25:40Z",
		"favorites": 0,
		"followers": 0,
		"following": 0
	},
	"author": {
		"bio": "Mr Fatty Floppa",
		"profile_image_source": "https://instagram.flwo2-1.fna.fbcdn.net/v/t51.2885-19/s150x150/243019840_307239764503370_7861506220040070300_n.jpg?_nc_ht=instagram.flwo2-1.fna.fbcdn.net&_nc_cat=102&_nc_ohc=NhxNX3_m_lsAX8Tbkyi&edm=AABBvjUBAAAA&ccb=7-4&oh=00_AT9wKtTH9demLxnDp9azi8iQVzXoNJVxJA-5OwLsND5aLg&oe=620CAF8D&_nc_sid=83d603",
		"gender": "UNKNOWN",
		"url": "https://www.instagram.com/mr_fatty_floppa/",
		"handle": "dastardly_doc"
	},
	"enrichment": {
		"language": "U"
	},
	"instagram": {
		"content_type": "COMMENT"
	}
}
     */
    
}